/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.user.OrgUserApi;
import com.xforceplus.api.model.user.OrgUserModel;
import com.xforceplus.bo.user.OrgUserBO;
import com.xforceplus.bo.user.OrgUserComplexBO;
import com.xforceplus.business.tenant.service.OrgUserService;
import com.xforceplus.dto.user.OrgUserDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u7ec4\u7ec7\u7528\u6237\u67e5\u8be2")
@RestController
public class OrgUserController
implements OrgUserApi {
    private static final Logger log = LoggerFactory.getLogger(OrgUserController.class);
    private final OrgUserService orgUserService;

    public OrgUserController(OrgUserService orgUserService) {
        this.orgUserService = orgUserService;
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u4ef6(ID\u3001Code\u3001\u540d\u79f0)\u591a\u6761\u4ef6\u5206\u9875\u67e5\u8be2\u7528\u6237\u5217\u8868")
    public ResponseEntity<Page<OrgUserModel.OrgUserResponse>> pageComplex(@Valid OrgUserModel.OrgUserComplexRequest request, Pageable pageable) {
        Assert.isTrue((pageable.getPageSize() <= 100 ? 1 : 0) != 0, (String)"\u6bcf\u9875\u8bb0\u5f55\u6570\u4e0d\u80fd\u5927\u4e8e100\u6761");
        pageable = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.unsorted());
        this.checkQueryType(request);
        if (null == request.getRangeType()) {
            request.setRangeType(Integer.valueOf(0));
        }
        log.info("OrgUserRequest.request:{},page:{}", (Object)request, (Object)pageable);
        this.checkCreatedTimeBeginEnd(request);
        OrgUserComplexBO orgUserBO = new OrgUserComplexBO();
        BeanUtils.copyProperties((Object)request, (Object)orgUserBO);
        Page<OrgUserDTO> page = 0 == request.getRangeType() ? this.orgUserService.pageByCurrentOrgQueryType(pageable, orgUserBO) : this.orgUserService.pageByBelongOrgQueryType(pageable, orgUserBO);
        Page responsePage = page.map(e -> {
            OrgUserModel.OrgUserResponse response = new OrgUserModel.OrgUserResponse();
            BeanUtils.copyProperties((Object)e, (Object)response);
            return response;
        });
        return ResponseEntity.ok((Object)responsePage);
    }

    private void checkCreatedTimeBeginEnd(OrgUserModel.OrgUserComplexRequest request) {
        if (request.getCreatedDateBegin() != null) {
            Assert.notNull((Object)request.getCreatedDateEnd(), (String)"\u6309\u65f6\u95f4\u8303\u56f4\uff0c\u7528\u6237\u521b\u5efa\u65f6\u95f4\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DateTime tempDate = new DateTime((Object)request.getCreatedDateBegin());
        DateTime beginDate = new DateTime(tempDate.getYear(), tempDate.getMonthOfYear(), tempDate.getDayOfMonth(), 0, 0, 0);
        log.info("beginDate:{}", (Object)beginDate.toDateTime());
        tempDate = new DateTime((Object)request.getCreatedDateEnd());
        tempDate = tempDate.plusDays(1);
        request.setCreatedDateBegin(beginDate.toDate());
        request.setCreatedDateEnd(tempDate.toDate());
        Assert.isTrue((boolean)tempDate.isAfter((ReadableInstant)beginDate), (String)"\u7528\u6237\u521b\u5efa\u65f6\u95f4\u7684\u67e5\u8be2\u7ed3\u675f\u65f6\u95f4\u5e94\u8be5\u5927\u4e8e\u67e5\u8be2\u5f00\u59cb\u65f6\u95f4");
    }

    private void checkQueryType(OrgUserModel.OrgUserComplexRequest request) {
        if (1 == request.getQueryType()) {
            request.setOrgCode(null);
            request.setOrgName(null);
            Assert.isTrue((request.getOrgId() != null && request.getOrgId() >= 0L ? 1 : 0) != 0, (String)"\u67e5\u8be2\u7c7b\u578b\u4e3a\uff1a\u7ec4\u7ec7ID\u67e5\u8be2\uff0c\u7ec4\u7ec7ID\u4e3a\u5fc5\u586b\u4e14ID\u5927\u4e8e\u7b49\u4e8e0");
            return;
        }
        if (2 == request.getQueryType()) {
            request.setOrgId(null);
            request.setOrgName(null);
            Assert.hasText((String)request.getOrgCode(), (String)"\u67e5\u8be2\u7c7b\u578b\u4e3a\uff1a\u7ec4\u7ec7Code\u67e5\u8be2\uff0c\u7ec4\u7ec7Code\u4e3a\u5fc5\u586b");
            return;
        }
        if (3 == request.getQueryType()) {
            request.setOrgCode(null);
            request.setOrgId(null);
            Assert.hasText((String)request.getOrgName(), (String)"\u67e5\u8be2\u7c7b\u578b\u4e3a\uff1a\u7ec4\u7ec7\u540d\u79f0\uff0c\u7ec4\u7ec7\u540d\u79f0\u4e3a\u5fc5\u586b");
            Assert.isTrue((request.getRangeType() != null ? 1 : 0) != 0, (String)"\u67e5\u8be2\u7c7b\u578b\u4e3a\uff1a\u7ec4\u7ec7\u540d\u79f0\u65f6\uff0c\u67e5\u8be2\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u4ec5\u652f\u6301\u5f53\u524d\u8282\u70b9\u67e5\u8be2");
            Assert.isTrue((request.getRangeType() == 0 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u7c7b\u578b\u4e3a\uff1a\u7ec4\u7ec7\u540d\u79f0\u65f6\uff0c\u67e5\u8be2\u8303\u56f4\u4ec5\u652f\u6301\u5f53\u524d\u8282\u70b9\u67e5\u8be2");
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7ID\u5206\u9875\u67e5\u8be2\u7528\u6237\u5217\u8868\u4e3b\u8981\u4fe1\u606f")
    public ResponseEntity<Page<OrgUserModel.OrgUserResponse>> page(@Valid OrgUserModel.OrgUserRequest request, Pageable pageable) {
        Assert.isTrue((pageable.getPageSize() <= 100 ? 1 : 0) != 0, (String)"\u6bcf\u9875\u8bb0\u5f55\u6570\u4e0d\u80fd\u5927\u4e8e100\u6761");
        pageable = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.unsorted());
        if (null == request.getRangeType()) {
            request.setRangeType(Integer.valueOf(0));
        }
        log.info("OrgUserRequest.request:{},page:{}", (Object)request, (Object)pageable);
        OrgUserBO orgUserBO = new OrgUserBO();
        BeanUtils.copyProperties((Object)request, (Object)orgUserBO);
        Page<OrgUserDTO> page = 0 == request.getRangeType() ? this.orgUserService.pageByCurrentOrg(pageable, orgUserBO) : this.orgUserService.pageByBelongOrg(pageable, orgUserBO);
        Page responsePage = page.map(e -> {
            OrgUserModel.OrgUserResponse response = new OrgUserModel.OrgUserResponse();
            BeanUtils.copyProperties((Object)e, (Object)response);
            return response;
        });
        return ResponseEntity.ok((Object)responsePage);
    }

    private void checkRangeTypePageSizeArgs(int rangeType, int requestRangeType, int row, Pageable pageable, String message) {
        if (rangeType == requestRangeType) {
            Assert.isTrue((pageable.getPageSize() <= row ? 1 : 0) != 0, (String)message);
        }
    }
}

