/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.controller;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.api.common.response.ResponseBoolenEntity;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.current.user.RoleApi;
import com.xforceplus.api.model.ResourceModel;
import com.xforceplus.api.model.RoleModel;
import com.xforceplus.api.model.UserModel;
import com.xforceplus.business.common.controller.AbstractController;
import com.xforceplus.business.excel.ExcelService;
import com.xforceplus.business.excel.QueryParam;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.file.controller.vo.ImportFileRespVo;
import com.xforceplus.business.file.service.ExportFileService;
import com.xforceplus.business.file.service.ImportFileService;
import com.xforceplus.business.resource.service.ResourceService;
import com.xforceplus.business.tenant.service.TenantPolicyService;
import com.xforceplus.domain.resource.ResourceDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.tenant.view.SysRole;
import com.xforceplus.entity.ExcelFileStore;
import com.xforceplus.entity.Resource;
import com.xforceplus.entity.Role;
import com.xforceplus.entity.User;
import com.xforceplus.exception.AccessDeniedException;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.domain.view.RoleView;
import com.xforceplus.tenant.security.core.domain.view.UserView;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.geewit.data.jpa.essential.domain.SortFactory;
import io.geewit.data.jpa.essential.search.DynamicSpecifications;
import io.geewit.data.jpa.essential.search.SearchFilter;
import io.geewit.data.jpa.essential.web.servlet.Servlets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u5168\u5c40\u89d2\u8272\u76f8\u5173\u63a5\u53e3", description="\u5168\u5c40\u89d2\u8272\u76f8\u5173\u63a5\u53e3")
@Validated
@Controller
public class RoleController
extends AbstractController
implements com.xforceplus.api.global.user.RoleApi,
com.xforceplus.api.tenant.user.RoleApi,
RoleApi {
    private static final Logger logger = LoggerFactory.getLogger(RoleController.class);
    private final ResourceService resourceService;
    private final ExcelService excelService;
    private final ImportFileService importFileService;
    private final ExportFileService exportFileService;
    private final TenantPolicyService tenantPolicyService;
    @Value(value="${xforce.global.grading-managment.enable:true}")
    private boolean globalGradingEnabled;

    public RoleController(ResourceService resourceService, ExcelService excelService, ImportFileService importFileService, ExportFileService exportFileService, TenantPolicyService tenantPolicyService) {
        this.resourceService = resourceService;
        this.excelService = excelService;
        this.importFileService = importFileService;
        this.exportFileService = exportFileService;
        this.tenantPolicyService = tenantPolicyService;
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:read"})
    @ApiIgnore
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u7528\u6237\u5206\u9875")
    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u5206\u9875\u5217\u8868\u67e5\u8be2", value={"/api/global/roles/query"}, method={RequestMethod.GET})
    public Page<Role> page(WebRequest request, @ApiParam(value="pageable") Pageable pageable) {
        Map searchParams = Servlets.getParametersStartingWith((WebRequest)request, (String)"search_");
        Collection filters = SearchFilter.parse((Map)searchParams);
        Specification specification = DynamicSpecifications.bySearchFilter((Collection)filters);
        Page<Role> page = this.roleService.page((Specification<Role>)specification, pageable);
        return page;
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:read"})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u5168\u5c40\u89d2\u8272\u5206\u9875\u5217\u8868", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u7cfb\u7edf\u5168\u5c40\u89d2\u8272\u5206\u9875\u5217\u8868")
    @JsonView(value={RoleView.RoleInfo.class})
    public ResponseEntity<Page<Role>> page(@ApiParam(value="request") RoleModel.Request.Query query, @ApiParam(value="pageable") Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        query.setType(Integer.valueOf(0));
        Page<Role> result = this.roleService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:read"})
    @ApiIgnore
    @ApiOperation(value="\u83b7\u53d6\u5168\u5c40\u89d2\u8272\u5217\u8868", notes="\u901a\u8fc7\u53c2\u6570\uff0c\u83b7\u53d6\u5168\u5c40\u89d2\u8272\u5217\u8868")
    @JsonView(value={RoleView.RoleInfo.class})
    @ResponseBody
    @RequestMapping(name="\u5168\u5c40\u89d2\u8272\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/list"}, method={RequestMethod.GET})
    public ResponseEntity<List<Role>> list(@ApiParam(value="request") RoleModel.Request.Query query, @ApiParam(value="sort") Sort sort) {
        Sort currentSort = SortFactory.ofDefaultSort((Sort)sort, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}));
        query.setType(Integer.valueOf(0));
        List<Role> result = this.roleService.list(query, currentSort);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:save"})
    @ApiOperation(value="\u65b0\u589e\u5168\u5c40\u89d2\u8272")
    public ResponseEntity<Role> create(@ApiParam(value="model", required=true) @Validated RoleModel.Request.Create model) {
        Role result = this.roleService.create(model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:save"})
    @ApiOperation(value="\u66f4\u65b0\u5168\u5c40\u89d2\u8272")
    public ResponseEntity<Role> update(@ApiParam(value="roleId", required=true) long roleId, @ApiParam(value="model", required=true) @Validated RoleModel.Request.Update model) {
        Role result = this.roleService.update(roleId, (RoleModel.Request.Save)model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:save"})
    @ApiOperation(value="\u66f4\u65b0\u5168\u5c40\u89d2\u8272\u72b6\u6001")
    public ResponseEntity<String> updateStatus(long roleId, int status) {
        this.roleService.updateStatus(roleId, status);
        return ResponseEntity.ok((Object)"\u66f4\u65b0\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:save"})
    @ApiIgnore
    @ApiOperation(value="\u542f\u7528\u5168\u5c40\u89d2\u8272")
    @ResponseBody
    @RequestMapping(name="\u542f\u7528\u5168\u5c40\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}/enable"}, method={RequestMethod.PUT})
    public ResponseEntity<String> enable(@PathVariable(value="roleId") long roleId) {
        this.roleService.enable(roleId);
        return ResponseEntity.ok((Object)"\u542f\u7528\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:save"})
    @ApiIgnore
    @ApiOperation(value="\u7981\u7528\u5168\u5c40\u89d2\u8272")
    @ResponseBody
    @RequestMapping(name="\u7981\u7528\u5168\u5c40\u89d2\u8272", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/roles/{roleId}/disable"}, method={RequestMethod.PUT})
    public ResponseEntity<String> disable(@PathVariable(value="roleId") long roleId) {
        this.roleService.disable(roleId);
        return ResponseEntity.ok((Object)"\u7981\u7528\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:read"})
    @JsonView(value={RoleView.RoleInfo.class})
    @ApiOperation(value="\u83b7\u53d6\u5168\u5c40\u89d2\u8272\u4fe1\u606f")
    public ResponseEntity<Role> info(@ApiParam(value="roleId", required=true) long roleId) {
        Role result = this.roleService.findById(roleId);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:save"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u5168\u5c40\u89d2\u8272")
    public ResponseEntity<String> delete(@ApiParam(value="roleId", required=true) long roleId) {
        this.roleService.deleteById(roleId);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:read"})
    @ApiOperation(value="\u5168\u5c40\u89d2\u8272\u7528\u6237\u5217\u8868")
    @JsonView(value={UserView.UserInfo.class})
    public ResponseEntity<Page<User>> users(@ApiParam(value="roleId", required=true) long roleId, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}));
        UserModel.Request.Query query = new UserModel.Request.Query();
        query.setRoleId(Long.valueOf(roleId));
        Page<User> result = this.userService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role-resourceset:read"})
    @ApiOperation(value="\u5168\u5c40\u89d2\u8272\u8d44\u6e90\u7801\u5217\u8868")
    public ResponseEntity<Page<Resource>> resources(@ApiParam(value="roleId", required=true) long roleId, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"resourceId"}));
        ResourceModel.Request.Query query = new ResourceModel.Request.Query();
        query.setRoleId(Long.valueOf(roleId));
        query.setStatus(Integer.valueOf(1));
        Page<Resource> result = this.resourceService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:users:save"})
    @ApiOperation(value="\u5168\u5c40\u89d2\u8272\u6279\u91cf\u7ed1\u5b9a\u7528\u6237", notes="\u5168\u5c40\u89d2\u8272\u6279\u91cf\u7ed1\u5b9a\u7528\u6237")
    public ResponseEntity<String> bindUsers(@ApiParam(value="roleId", required=true) long roleId, RoleModel.Request.BindUsers bindUsers) {
        this.roleService.bindUsers(roleId, bindUsers);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:users:save"})
    @ApiOperation(value="\u5168\u5c40\u89d2\u8272\u6279\u91cf\u7ed1\u5b9a\u7528\u6237(\u5e9f\u5f03)")
    @Deprecated
    @ResponseBody
    @RequestMapping(name="\u5168\u5c40\u89d2\u8272\u6279\u91cf\u7ed1\u5b9a\u7528\u6237(\u5e9f\u5f03)", value={"/api/global/roles/{roleId}/users/legacy"}, method={RequestMethod.POST})
    public ResponseEntity<String> legacyBindRoles(@PathVariable(value="roleId") long roleId, @RequestBody List<Long> userIds) {
        this.roleService.bindUsers(roleId, userIds, true);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role-resourceset:save"})
    @ApiOperation(value="\u5168\u5c40\u89d2\u8272\u6279\u91cf\u7ed1\u5b9a\u529f\u80fd\u96c6", notes="\u5168\u5c40\u89d2\u8272\u6279\u91cf\u7ed1\u5b9a\u529f\u80fd\u96c6")
    public ResponseEntity<String> bindResourceSets(@ApiParam(value="roleId", required=true) long roleId, RoleModel.Request.BindResourceSets bindResourceSets) {
        this.roleService.bindResourceSets(roleId, bindResourceSets);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:read"})
    @JsonView(value={RoleView.RoleInfo.class})
    @ApiOperation(value="\u83b7\u53d6\u5168\u5c40\u89d2\u8272\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u5168\u5c40\u89d2\u8272\u5206\u9875")
    public ResponseEntity<Page<Role>> page(@ApiParam(value="tenantKey", required=true) String tenantKey, @ApiParam(value="request") RoleModel.Request.Query query, @ApiParam(value="pageable") Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        long tenantId = super.toTenantId(tenantKey, query.getByTenantCode());
        query.setTenantId(Long.valueOf(tenantId));
        query.setType(Integer.valueOf(0));
        Page<Role> result = this.roleService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:read"})
    @ApiIgnore
    @ApiOperation(value="\u83b7\u53d6\u5168\u5c40\u89d2\u8272\u5217\u8868", notes="\u901a\u8fc7\u53c2\u6570\uff0c\u83b7\u53d6\u5168\u5c40\u89d2\u8272\u5217\u8868")
    @ResponseBody
    @RequestMapping(name="\u5168\u5c40\u89d2\u8272\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/roles/list"}, method={RequestMethod.GET})
    public ResponseEntity<List<Role>> list(@ApiParam(value="tenantKey", required=true) String tenantKey, @ApiParam(value="request") RoleModel.Request.Query query, @ApiParam(value="sort") Sort sort) {
        Sort currentSort = SortFactory.ofDefaultSort((Sort)sort, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        long tenantId = super.toTenantId(tenantKey, query.getByTenantCode());
        query.setTenantId(Long.valueOf(tenantId));
        query.setType(Integer.valueOf(0));
        List<Role> result = this.roleService.list(query, currentSort);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:save"})
    @ApiOperation(value="\u79df\u6237\u65b0\u589e\u5168\u5c40\u89d2\u8272")
    public ResponseEntity<Role> create(@ApiParam(value="tenantKey", required=true) String tenantKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="model", required=true) RoleModel.Request.Create model) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        model.setTenantId(Long.valueOf(tenantId));
        Role result = model.getId() != null && model.getId() > 0L ? this.roleService.updateByTenantId(tenantId, model.getId(), (RoleModel.Request.Save)model) : this.roleService.create(model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:save"})
    @ApiOperation(value="\u6279\u91cf\u521b\u5efa\u5168\u5c40\u89d2\u82722.0-2")
    public <R extends RoleDto> ResponseEntity<List<R>> batchCreate(String tenantKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, List<RoleModel.Request.Save> models) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        ArrayList<Role> roles = new ArrayList<Role>();
        for (RoleModel.Request.Save save : models) {
            save.setTenantId(Long.valueOf(tenantId));
            roles.add(this.roleService.save(save));
        }
        return ResponseEntity.ok(roles);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role-resourceset:save"})
    @ApiOperation(value="\u6279\u91cf\u7ed1\u5b9a\u5168\u5c40\u89d2\u8272\u548c\u529f\u80fd\u96c6\u54082.0-6")
    public ResponseBoolenEntity<Boolean, RoleModel.Request.BindResourceSet> bindResourceSets(String tenantKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @Valid List<RoleModel.Request.BindResourceSet> bindResourceSets) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        return this.roleService.bindResourceSets(bindResourceSets);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:save"})
    @ApiOperation(value="\u79df\u6237\u66f4\u65b0\u5168\u5c40\u89d2\u8272")
    public ResponseEntity<Role> update(@ApiParam(value="tenantKey", required=true) String tenantKey, @ApiParam(value="roleKey", required=true) String roleKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byRoleCode", required=false) Boolean byRoleCode, @ApiParam(value="model", required=true) RoleModel.Request.Update model) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long roleId = super.toRoleId(tenantId, roleKey, byRoleCode);
        Role result = this.roleService.updateByTenantId(tenantId, roleId, (RoleModel.Request.Save)model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:save"})
    @ApiOperation(value="\u79df\u6237\u66f4\u65b0\u5168\u5c40\u89d2\u8272\u72b6\u6001")
    public ResponseEntity<String> updateStatus(@ApiParam(value="tenantKey", required=true) String tenantKey, @ApiParam(value="roleKey", required=true) String roleKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byRoleCode", required=false) Boolean byRoleCode, @ApiParam(value="status", required=true) int status) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long roleId = super.toRoleId(tenantId, roleKey, byRoleCode);
        this.roleService.updateStatus(tenantId, roleId, status);
        return ResponseEntity.ok((Object)"\u66f4\u65b0\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:read"})
    @JsonView(value={RoleView.RoleInfo.class})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u5168\u5c40\u89d2\u8272\u4fe1\u606f")
    public ResponseEntity<Role> info(@ApiParam(value="tenantKey", required=true) String tenantKey, @ApiParam(value="roleKey", required=true) String roleKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byRoleCode", required=false) Boolean byRoleCode) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long roleId = super.toRoleId(tenantId, roleKey, byRoleCode);
        Role result = this.roleService.findByTenantId(tenantId, roleId);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:save"})
    @ApiOperation(value="\u79df\u6237\u6839\u636eid\u5220\u9664\u5168\u5c40\u89d2\u8272")
    public ResponseEntity<String> delete(@ApiParam(value="tenantKey", required=true) String tenantKey, @ApiParam(value="roleKey", required=true) String roleKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byRoleCode", required=false) Boolean byRoleCode) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long roleId = super.toRoleId(tenantId, roleKey, byRoleCode);
        this.roleService.deleteByTenantIdAndId(tenantId, roleId);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u79df\u6237\u5168\u5c40\u89d2\u8272\u7528\u6237\u5217\u8868")
    public ResponseEntity<Page<User>> users(@ApiParam(value="tenantKey", required=true) String tenantKey, @ApiParam(value="roleKey", required=true) String roleKey, UserModel.Request.Query query, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        long tenantId = super.toTenantId(tenantKey, query.getByTenantCode());
        long roleId = super.toRoleId(tenantId, roleKey, query.getByRoleCode());
        query.setTenantId(Long.valueOf(tenantId));
        query.setRoleId(Long.valueOf(roleId));
        Page<User> result = this.userService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role-resourceset:read"})
    @ApiOperation(value="\u79df\u6237\u5168\u5c40\u89d2\u8272\u8d44\u6e90\u7801\u5217\u8868")
    public <T extends ResourceDto<T>> ResponseEntity<Page<T>> resources(String tenantKey, String roleKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byRoleCode", required=false) Boolean byRoleCode, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long roleId = super.toRoleId(tenantId, roleKey, byRoleCode);
        ResourceModel.Request.Query query = new ResourceModel.Request.Query();
        query.setTenantId(Long.valueOf(tenantId));
        query.setRoleId(Long.valueOf(roleId));
        query.setStatus(Integer.valueOf(1));
        Page<Resource> result = this.resourceService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:save"})
    public ResponseEntity<String> bindUsers(String tenantKey, String roleKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byRoleCode", required=false) Boolean byRoleCode, RoleModel.Request.BindUsers bindUsers) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long roleId = super.toRoleId(tenantId, roleKey, byRoleCode);
        this.roleService.bindUsers(tenantId, roleId, bindUsers, 0);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:save"})
    @Deprecated
    @ResponseBody
    @RequestMapping(name="\u5168\u5c40\u89d2\u8272\u6279\u91cf\u7ed1\u5b9a\u7528\u6237(\u5e9f\u5f03)", value={"/api/{tenantKey}/roles/{roleKey}/users/legacy"}, method={RequestMethod.POST})
    public ResponseEntity<String> legacyBindUsers(@PathVariable(value="tenantKey") String tenantKey, @PathVariable(value="roleKey") String roleKey, @RequestParam(value="byTenantCode", required=false) @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @RequestParam(value="byRoleCode", required=false) @ApiParam(value="byRoleCode", required=false) Boolean byRoleCode, @RequestBody List<Long> userIds) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long roleId = super.toRoleId(tenantId, roleKey, byRoleCode);
        this.roleService.bindUsers(tenantId, roleId, userIds, false, 0);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:save"})
    public ResponseEntity<String> unbindUsers(String tenantKey, String roleKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byRoleCode", required=false) Boolean byRoleCode, RoleModel.Request.UnbindUsers unbindUsers) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long roleId = super.toRoleId(tenantId, roleKey, byRoleCode);
        this.roleService.unbindUsers(tenantId, roleId, unbindUsers);
        return ResponseEntity.ok((Object)"\u53cd\u7ed1\u5b9a\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:save"})
    @ApiOperation(value="\u521b\u5efa\u7cfb\u7edf\u5168\u5c40\u89d2\u8272")
    public ResponseEntity<String> sysSave(RoleModel.Request.SysCreate model) {
        this.roleService.sysSave(model);
        return ResponseEntity.ok();
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:save"})
    @ApiOperation(value="\u66f4\u65b0\u7cfb\u7edf\u5168\u5c40\u89d2\u8272")
    public ResponseEntity<String> sysUpdate(long roleId, RoleModel.Request.SysCreate model) {
        this.roleService.sysUpdate(roleId, model);
        return ResponseEntity.ok();
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:read"})
    @JsonView(value={SysRole.class})
    @ApiOperation(value="\u7cfb\u7edf\u5168\u5c40\u89d2\u8272\u4fe1\u606f")
    public ResponseEntity<Role> sysInfo(long roleId) {
        Role result = this.roleService.sysInfo(roleId);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:save"})
    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165\u5173\u8054\u8d26\u53f7\u548c\u5168\u5c40\u89d2\u8272")
    public <T extends RoleDto> ResponseEntity<T> batchImportBind(String tenantKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, MultipartFile file) {
        Long tenantId = super.toTenantId(tenantKey, byTenantCode);
        return this.excelService.batchImportRoles(tenantId, file);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:save"})
    @ApiOperation(value="\u5bfc\u5165\u5168\u5c40\u89d2\u8272\u79df\u6237\u529f\u80fd\u96c6")
    @ResponseBody
    @RequestMapping(name="\u5bfc\u5165\u7cfb\u7edf\u5168\u5c40\u89d2\u8272\u79df\u6237\u529f\u80fd\u96c6", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/sys/roles/{roleId}/upload"}, method={RequestMethod.POST})
    public ResponseEntity<Long> importSysData(@PathVariable(value="roleId") @Valid @Min(value=1L) @Valid @Min(value=1L) long roleId, @RequestParam(name="file", required=false) MultipartFile file) {
        return this.roleService.importSysData(roleId, file);
    }

    @ApiOperation(value="\u5f53\u524d\u7528\u6237\u7684\u5168\u5c40\u89d2\u8272\u5206\u9875")
    public ResponseEntity<Page<Role>> currentPage(RoleModel.Request.Query query, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        boolean tenantGradingEnabled = this.tenantPolicyService.tenantGradingManagementEnabled(authorizedUser.getTenantId());
        if (this.globalGradingEnabled && tenantGradingEnabled && !authorizedUser.isAdmin()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        query.setTenantId(authorizedUser.getTenantId());
        if (query.getExcludeBoundCurrent() != null && query.getExcludeBoundCurrent().booleanValue() && query.getUserId() == null) {
            String message = "\u7f3a\u5c11\u53c2\u6570: userId";
            throw new IllegalArgumentException(message);
        }
        query.setType(Integer.valueOf(0));
        Page<Role> page = this.roleService.page(query, currentPageable);
        return ResponseEntity.ok(page);
    }

    @JsonView(value={RoleView.RoleInfo.class})
    public ResponseEntity<Role> currentCreate(RoleModel.Request.Create model) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        boolean tenantGradingEnabled = this.tenantPolicyService.tenantGradingManagementEnabled(authorizedUser.getTenantId());
        if (this.globalGradingEnabled && tenantGradingEnabled && !authorizedUser.isAdmin()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        model.setTenantId(authorizedUser.getTenantId());
        Role result = model.getId() != null && model.getId() > 0L ? this.roleService.updateByTenantId(authorizedUser.getTenantId(), model.getId(), (RoleModel.Request.Save)model) : this.roleService.create(model);
        return ResponseEntity.ok((Object)result);
    }

    @JsonView(value={RoleView.RoleInfo.class})
    public ResponseEntity<Role> currentInfo(Long roleId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        Role result = this.roleService.findByTenantId(tenantId, roleId);
        return ResponseEntity.ok((Object)result);
    }

    @JsonView(value={RoleView.RoleInfo.class})
    public ResponseEntity<Role> currentUpdate(Long roleId, RoleModel.Request.Update model) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        boolean tenantGradingEnabled = this.tenantPolicyService.tenantGradingManagementEnabled(authorizedUser.getTenantId());
        if (this.globalGradingEnabled && tenantGradingEnabled && !authorizedUser.isAdmin()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        long tenantId = authorizedUser.getTenantId();
        Role result = this.roleService.updateByTenantId(tenantId, roleId, (RoleModel.Request.Save)model);
        return ResponseEntity.ok((Object)result);
    }

    public ResponseEntity<String> currentDelete(Long roleId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        boolean tenantGradingEnabled = this.tenantPolicyService.tenantGradingManagementEnabled(authorizedUser.getTenantId());
        if (this.globalGradingEnabled && tenantGradingEnabled && !authorizedUser.isAdmin()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        long tenantId = authorizedUser.getTenantId();
        this.roleService.deleteByTenantIdAndId(tenantId, roleId);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    @JsonView(value={UserView.UserInfo.class})
    public ResponseEntity<Page<User>> currentBindedRoles(Long roleId, UserModel.Request.Query query, Pageable pageable) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        boolean tenantGradingEnabled = this.tenantPolicyService.tenantGradingManagementEnabled(authorizedUser.getTenantId());
        if (this.globalGradingEnabled && tenantGradingEnabled && !authorizedUser.isAdmin()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        long tenantId = authorizedUser.getTenantId();
        query.setTenantId(Long.valueOf(tenantId));
        query.setRoleId(roleId);
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Page<User> result = this.userService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    public ResponseEntity<String> currentBindRoles(Long roleId, RoleModel.Request.BindUsers bindUsers) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        boolean tenantGradingEnabled = this.tenantPolicyService.tenantGradingManagementEnabled(authorizedUser.getTenantId());
        if (this.globalGradingEnabled && tenantGradingEnabled && !authorizedUser.isAdmin()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        long tenantId = authorizedUser.getTenantId();
        this.roleService.bindUsers(tenantId, roleId, bindUsers, 0);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    public ResponseEntity<String> currentUnbindRoles(Long roleId, RoleModel.Request.UnbindUsers unbindUsers) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        boolean tenantGradingEnabled = this.tenantPolicyService.tenantGradingManagementEnabled(authorizedUser.getTenantId());
        if (this.globalGradingEnabled && tenantGradingEnabled && !authorizedUser.isAdmin()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        long tenantId = authorizedUser.getTenantId();
        this.roleService.unbindUsers(tenantId, roleId, unbindUsers);
        return ResponseEntity.ok((Object)"\u53cd\u7ed1\u5b9a\u6210\u529f");
    }

    public ResponseEntity<String> currentEnable(Long roleId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        boolean tenantGradingEnabled = this.tenantPolicyService.tenantGradingManagementEnabled(authorizedUser.getTenantId());
        if (this.globalGradingEnabled && tenantGradingEnabled && !authorizedUser.isAdmin()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        long tenantId = authorizedUser.getTenantId();
        this.roleService.updateStatus(tenantId, roleId, 1);
        return ResponseEntity.ok((Object)"\u66f4\u65b0\u6210\u529f");
    }

    public ResponseEntity<String> currentDisable(Long roleId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        boolean tenantGradingEnabled = this.tenantPolicyService.tenantGradingManagementEnabled(authorizedUser.getTenantId());
        if (this.globalGradingEnabled && tenantGradingEnabled && !authorizedUser.isAdmin()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        long tenantId = authorizedUser.getTenantId();
        this.roleService.updateStatus(tenantId, roleId, 0);
        return ResponseEntity.ok((Object)"\u66f4\u65b0\u6210\u529f");
    }

    public ResponseEntity<ImportFileRespVo> exportRoles(@RequestBody RoleModel.Request.Export query) {
        if (ArrayUtils.isEmpty((Object[])query.getSheets())) {
            throw new IllegalArgumentException("\u8bf7\u5148\u9009\u62e9\u5bfc\u51fa\u6a21\u677f");
        }
        QueryParam queryParam = QueryParam.builder().param("P_QUERY", query).build();
        ExcelConfigBusinessType businessType = ExcelConfigBusinessType.ROLE_EXCEL_FILE;
        ExcelFileStore excelFileStore = this.exportFileService.asyncExcelExport(queryParam.params(), businessType);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setId(excelFileStore.getId());
        respVo.setBusinessType(businessType.getBusinessName());
        return ResponseEntity.ok((Object)respVo);
    }

    @ApiOperation(value="\u5f53\u524d\u7528\u6237\u5168\u5c40\u89d2\u8272\u6279\u91cf\u7ed1\u5b9a\u7528\u6237(\u5e9f\u5f03)")
    @Deprecated
    @ResponseBody
    @RequestMapping(name="\u5f53\u524d\u7528\u6237\u5168\u5c40\u89d2\u8272\u6279\u91cf\u7ed1\u5b9a\u7528\u6237(\u5e9f\u5f03)", value={"/api/current/roles/{roleId}/users/legacy"}, method={RequestMethod.POST})
    public ResponseEntity<String> currentLegacyBindRoles(@PathVariable(value="roleId") long roleId, @RequestBody List<Long> userIds) {
        long tenantId = UserInfoHolder.get().getTenantId();
        this.roleService.bindUsers(tenantId, roleId, userIds, true, 0);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:role:save"})
    @ApiOperation(value="\u5168\u5c40\u89d2\u8272\u6279\u91cf\u7ed1\u5b9a\u8d26\u53f7\u5bfc\u5165excel")
    @ResponseBody
    @RequestMapping(name="\u5168\u5c40\u89d2\u8272\u6279\u91cf\u7ed1\u5b9a\u8d26\u53f7\u5bfc\u5165excel", value={"${xforce.tenant.service.url.prefix:/api}/current${xforce.tenant.service.version:}/roles/account/import"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<ImportFileRespVo> batchImportBind(@RequestParam(value="file") MultipartFile file) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        boolean tenantGradingEnabled = this.tenantPolicyService.tenantGradingManagementEnabled(authorizedUser.getTenantId());
        if (this.globalGradingEnabled && tenantGradingEnabled && !authorizedUser.isAdmin()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        Long tenantId = authorizedUser.getTenantId();
        Long userId = authorizedUser.getId();
        String businessType = ExcelConfigBusinessType.ROLE_BIND_ACCOUNT_IMPORT.name();
        ExcelFileStore excelFileStore = this.importFileService.createAndSaveFile(file, businessType, userId, tenantId);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setBusinessType(businessType);
        respVo.setFileId(excelFileStore.getSourceFileId());
        respVo.setId(excelFileStore.getId());
        return ResponseEntity.ok((Object)respVo);
    }
}

