/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.user.UserApi;
import com.xforceplus.api.model.OrgModel;
import com.xforceplus.api.model.RoleModel;
import com.xforceplus.api.model.SettleFlowPackageModel;
import com.xforceplus.api.model.UserModel;
import com.xforceplus.business.common.controller.AbstractController;
import com.xforceplus.business.excel.ExcelService;
import com.xforceplus.business.excel.QueryParam;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.file.controller.vo.ImportFileRespVo;
import com.xforceplus.business.file.service.ExportFileService;
import com.xforceplus.business.file.service.FileService;
import com.xforceplus.business.file.service.ImportFileService;
import com.xforceplus.business.settle.service.SettleFlowService;
import com.xforceplus.business.tenant.service.FixService;
import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.domain.user.UserExportDto;
import com.xforceplus.domain.user.view.ExtraInfo;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.ExcelFileStore;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.Role;
import com.xforceplus.entity.SettleFlow;
import com.xforceplus.entity.SettleFlowPackage;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.User;
import com.xforceplus.tenant.core.exception.UnknownException;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.domain.view.RoleView;
import com.xforceplus.tenant.security.core.domain.view.UserView;
import io.geewit.core.jackson.view.View;
import io.geewit.core.utils.enums.BinaryUtils;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.geewit.data.jpa.essential.domain.SortFactory;
import io.geewit.data.jpa.essential.search.DynamicSpecifications;
import io.geewit.data.jpa.essential.search.SearchFilter;
import io.geewit.data.jpa.essential.web.servlet.Servlets;
import io.geewit.web.utils.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Valid;
import javax.validation.Validator;
import javax.validation.constraints.Min;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u7528\u6237\u76f8\u5173\u63a5\u53e3", description="\u7528\u6237\u76f8\u5173\u63a5\u53e3")
@Validated
@Controller
public class UserController
extends AbstractController
implements UserApi,
com.xforceplus.api.tenant.user.UserApi,
com.xforceplus.api.current.user.UserApi {
    private static final Logger logger = LoggerFactory.getLogger(UserController.class);
    private final ExcelService excelService;
    private final FileService fileService;
    private final FixService fixService;
    private final SettleFlowService settleFlowService;
    private final ExportFileService exportFileService;
    @Autowired
    private ImportFileService importFileService;
    @Autowired
    private Validator validator;

    public UserController(ExcelService excelService, FileService fileService, FixService fixService, ExportFileService exportFileService, SettleFlowService settleFlowService) {
        this.excelService = excelService;
        this.fileService = fileService;
        this.fixService = fixService;
        this.exportFileService = exportFileService;
        this.settleFlowService = settleFlowService;
    }

    @ApiIgnore
    @JsonView(value={UserView.UserInfo.class})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u7528\u6237\u5206\u9875")
    @ResponseBody
    @RequestMapping(name="\u7528\u6237\u5206\u9875\u5217\u8868\u67e5\u8be2", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/query"}, method={RequestMethod.GET})
    public Page<User> page(WebRequest request, Pageable pageable) {
        Map searchParams = Servlets.getParametersStartingWith((WebRequest)request, (String)"search_");
        Collection filters = SearchFilter.parse((Map)searchParams);
        Specification specification = DynamicSpecifications.bySearchFilter((Collection)filters);
        Page<User> page = this.userService.page((Specification<User>)specification, pageable);
        return page;
    }

    @JsonView(value={UserView.UserInfo.class})
    @AuthorizedDefinition(resources={"xforce:operation:user-accounts:read"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u7528\u6237\u5206\u9875")
    public ResponseEntity<Page<User>> page(UserModel.Request.Query query, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}));
        Page<User> result = this.userService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @JsonView(value={UserView.UserInfo.class})
    @ApiOperation(value="\u521b\u5efa\u7528\u6237")
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> create(UserModel.Request.Create model) {
        UserModel.Request.SaveUserOutput result = this.userService.save(model, model.isRoleOverwrite(), model.isOrgOverwrite(), model.isTagOverwrite(), model.isAppOverwrite(), model.isMergeAccount(), model.isStrict());
        UserService.removeCachedRoleOrgUserRelsThreadLocal();
        if (result.getUserResultMap().isEmpty()) {
            throw new UnknownException("\u672a\u77e5\u9519\u8bef");
        }
        UserModel.Request.SaveUserContext saveUserContext = (UserModel.Request.SaveUserContext)result.getUserResultMap().values().stream().findFirst().orElseThrow(() -> new UnknownException("\u672a\u77e5\u9519\u8bef"));
        UserDto user = saveUserContext.getUser();
        AccountDto account = saveUserContext.getAccount();
        if (account != null) {
            user.setAccount(account);
        }
        return ResponseEntity.ok((Object)user);
    }

    @JsonView(value={UserView.UserInfo.class})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> simpleCreate(UserModel.Request.SimpleCreate model) {
        UserModel.Request.Create save = new UserModel.Request.Create();
        BeanUtils.copyProperties((Object)model, (Object)save);
        save.setIsRoleOverwrite(Boolean.valueOf(false));
        save.setIsOrgOverwrite(Boolean.valueOf(false));
        save.setIsTagOverwrite(Boolean.valueOf(false));
        save.setIsAppOverwrite(Boolean.valueOf(false));
        save.setIsMergeAccount(Boolean.valueOf(true));
        save.setIsStrict(Boolean.valueOf(true));
        UserModel.Request.SaveUserOutput result = this.userService.save(save, save.isRoleOverwrite(), save.isOrgOverwrite(), save.isTagOverwrite(), save.isAppOverwrite(), save.isMergeAccount(), save.isStrict());
        UserService.removeCachedRoleOrgUserRelsThreadLocal();
        if (result.getUserResultMap().isEmpty()) {
            throw new UnknownException("\u672a\u77e5\u9519\u8bef");
        }
        UserModel.Request.SaveUserContext saveUserContext = (UserModel.Request.SaveUserContext)result.getUserResultMap().values().stream().findFirst().orElseThrow(() -> new UnknownException("\u672a\u77e5\u9519\u8bef"));
        UserDto user = saveUserContext.getUser();
        AccountDto account = saveUserContext.getAccount();
        if (account != null) {
            user.setAccount(account);
        }
        return ResponseEntity.ok((Object)user);
    }

    @ApiOperation(value="\u6279\u91cf\u521b\u5efa\u7528\u6237\u548c\u8d26\u62372.0-1")
    public ResponseEntity<List<UserModel.Request.BatchSaveVo>> createBatch(List<UserModel.Request.BatchSave> models) {
        List<UserModel.Request.BatchSaveVo> result = this.userService.batchCreate(models);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:user-accounts:read"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u8be6\u60c5")
    @JsonView(value={UserView.UserInfo.class})
    public ResponseEntity<User> info(long userId, String loginId, String modules, int extraInfoDimension) {
        User result = this.userService.findByLoginId(userId, loginId, modules, extraInfoDimension);
        return ResponseEntity.ok((Object)result);
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u540d\u83b7\u53d6\u7528\u6237\u8be6\u60c5")
    @JsonView(value={UserView.UserInfo.class})
    public ResponseEntity<User> userInfo(String username, String tenantCode, String userCode, int extraInfoDimension) {
        User result;
        if (StringUtils.isNotBlank((CharSequence)username)) {
            result = StringUtils.isNotBlank((CharSequence)tenantCode) ? this.userService.findByTenantCodeAndUsername(tenantCode, username, extraInfoDimension) : this.userService.findByUsername(username, extraInfoDimension);
        } else if (StringUtils.isNotBlank((CharSequence)tenantCode) && StringUtils.isNotBlank((CharSequence)userCode)) {
            long tenantId = super.toTenantId(tenantCode, true);
            Long userId = super.toUserId(tenantId, userCode, true);
            if (userId == null) {
                String message = "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7528\u6237(tenantCode:" + tenantCode + ", userCode:" + userCode + ")";
                throw new IllegalArgumentException(message);
            }
            result = this.userService.findByTenantIdAndUserIdAndLoginId(tenantId, userId, null, null, extraInfoDimension);
        } else {
            String message = "\u9519\u8bef\u7684\u53c2\u6570,username:" + username + ",tenantCode=" + tenantCode + ",userCode=" + userCode;
            throw new IllegalArgumentException(message);
        }
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:user-accounts:save"})
    @JsonView(value={UserView.UserInfo.class})
    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u4fe1\u606f")
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> update(long userId, UserModel.Request.Update model) {
        model.setIsMergeAccount(Boolean.valueOf(true));
        model.setIsStrict(Boolean.valueOf(true));
        model.setUserId(Long.valueOf(userId));
        UserModel.Request.SaveUserOutput saveUserOutput = this.userService.save(model, model.isRoleOverwrite(), model.isOrgOverwrite(), model.isTagOverwrite(), model.isAppOverwrite(), model.isMergeAccount(), model.isStrict());
        UserService.removeCachedRoleOrgUserRelsThreadLocal();
        Map userContextMap = saveUserOutput.getUserResultMap();
        if (userContextMap.values().isEmpty()) {
            throw new IllegalArgumentException("\u6ca1\u6709\u8fd4\u56de\u671f\u671b\u7684\u503c");
        }
        UserModel.Request.SaveUserContext saveUserContext = (UserModel.Request.SaveUserContext)userContextMap.values().stream().findFirst().orElseThrow(() -> new IllegalArgumentException("\u6ca1\u6709\u8fd4\u56de\u671f\u671b\u7684\u503c"));
        UserDto user = saveUserContext.getUser();
        AccountDto account = saveUserContext.getAccount();
        if (account != null) {
            user.setAccount(account);
        }
        if (((User)user).getTenant() == null && user.getTenantId() != null && user.getTenantId() > 0L) {
            Tenant tenant = this.tenantService.findById(user.getTenantId());
            ((User)user).setTenant(tenant);
        }
        return ResponseEntity.ok((Object)user);
    }

    @JsonView(value={UserView.UserInfo.class})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> simpleUpdate(long userId, UserModel.Request.SimpleUpdate model) {
        UserModel.Request.Update save = new UserModel.Request.Update();
        BeanUtils.copyProperties((Object)model, (Object)save);
        save.setUserId(Long.valueOf(userId));
        save.setIsRoleOverwrite(Boolean.valueOf(false));
        save.setIsOrgOverwrite(Boolean.valueOf(false));
        save.setIsTagOverwrite(Boolean.valueOf(false));
        save.setIsAppOverwrite(Boolean.valueOf(false));
        save.setIsMergeAccount(Boolean.valueOf(true));
        save.setIsStrict(Boolean.valueOf(true));
        UserModel.Request.SaveUserOutput saveUserOutput = this.userService.save(save, save.isRoleOverwrite(), save.isOrgOverwrite(), save.isTagOverwrite(), save.isAppOverwrite(), save.isMergeAccount(), save.isStrict());
        UserService.removeCachedRoleOrgUserRelsThreadLocal();
        Map userContextMap = saveUserOutput.getUserResultMap();
        if (userContextMap.values().isEmpty()) {
            throw new IllegalArgumentException("\u6ca1\u6709\u8fd4\u56de\u671f\u671b\u7684\u503c");
        }
        UserModel.Request.SaveUserContext saveUserContext = (UserModel.Request.SaveUserContext)userContextMap.values().stream().findFirst().orElseThrow(() -> new IllegalArgumentException("\u6ca1\u6709\u8fd4\u56de\u671f\u671b\u7684\u503c"));
        UserDto user = saveUserContext.getUser();
        AccountDto account = saveUserContext.getAccount();
        if (account != null) {
            user.setAccount(account);
        }
        return ResponseEntity.ok((Object)user);
    }

    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u72b6\u6001")
    public ResponseEntity<String> updateStatus(long userId, int status) {
        this.userService.updateStatus(userId, status);
        return ResponseEntity.ok((Object)"\u66f4\u65b0\u72b6\u6001\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237")
    public ResponseEntity<String> delete(long id) {
        this.userService.deleteById(id);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7ec4\u7ec7\u6811", notes="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u7684\u7ec4\u7ec7\u6811")
    @JsonView(value={View.Tree.class})
    public ResponseEntity<OrgStruct> userOrgs(long userId, String modules) {
        List<OrgStruct> orgs = this.orgService.findTreeByUserId(userId, modules);
        OrgStruct result = orgs.stream().findFirst().orElse(null);
        return ResponseEntity.ok((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u8d44\u6e90\u7801\u96c6\u5408", notes="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u8d44\u6e90\u7801\u96c6\u5408")
    public ResponseEntity<Set<String>> userResources(long userId, String loginId, String modules) {
        User user = this.userService.findByLoginId(userId, loginId, modules, BinaryUtils.toBinary((Enum)ExtraInfo.resources));
        Set resources = user.getResourceCodes();
        return ResponseEntity.ok((Object)resources);
    }

    public ResponseEntity<Set<String>> appResources(@Valid @Min(value=1L) @Valid @Min(value=1L) long userId, long appId, String loginId, String modules) {
        HashSet resources;
        User user = this.userService.findByLoginId(userId, loginId, modules, BinaryUtils.toBinary((Enum)ExtraInfo.resourceDetail));
        Map appResources = user.getAppResources();
        Set set = resources = appResources == null ? new HashSet() : (Set)appResources.get(appId);
        if (resources == null) {
            resources = new HashSet();
        }
        return ResponseEntity.ok(resources);
    }

    public ResponseEntity<Map<Long, Set<String>>> appsResources(@Valid @Min(value=1L) @Valid @Min(value=1L) long userId, String appIds, String loginId, String modules) {
        User user = this.userService.findByLoginId(userId, loginId, modules, BinaryUtils.toBinary((Enum)ExtraInfo.resourceDetail));
        Map appResources = user.getAppResources();
        if (appResources == null || appResources.isEmpty()) {
            return ResponseEntity.ok(new HashMap(0));
        }
        String[] appIdsArray = StringUtils.split((String)appIds, (String)",");
        Set<Long> removingIds = appResources.keySet().stream().filter(Objects::nonNull).filter(key -> !ArrayUtils.contains((Object[])appIdsArray, (Object)String.valueOf(key))).collect(Collectors.toSet());
        removingIds.forEach(appResources::remove);
        return ResponseEntity.ok((Object)appResources);
    }

    public ResponseEntity<String> bindRoles(long userId, UserModel.Request.BindRoles bindRoles) {
        this.userService.bindRoles(null, null, userId, bindRoles.getAllRoleIds(), bindRoles.getRoleIds(), bindRoles.getGradingRoleIds(), bindRoles.getOrgRoleIds(), bindRoles.isOverwrite(), false, false);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @ApiOperation(value="\u7ed1\u5b9a\u7528\u6237\u89d2\u8272\u5217\u8868(\u5e9f\u5f03)")
    @Deprecated
    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u7ed1\u5b9a\u7528\u6237\u89d2\u8272(\u5e9f\u5f03)", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/roles/legacy"}, method={RequestMethod.POST})
    public ResponseEntity<String> legacyBindRoles(@PathVariable(value="userId") long userId, @RequestBody List<Long> roleIds) {
        this.userService.bindRoles(null, null, userId, null, roleIds, null, null, true, false, false);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @ApiIgnore
    @ResponseBody
    @RequestMapping(name="\u6e05\u7406\u7528\u6237\u7f13\u5b58", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/{userId}/cache/clear"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> clearCache(@PathVariable(value="userId") long userId) {
        this.userService.clearCache(userId);
        return ResponseEntity.ok((Object)"\u6e05\u7406\u6210\u529f");
    }

    @ApiOperation(value="\u7ed1\u5b9a\u89d2\u8272\u548c\u4eba\u54582.0-5", notes="\u7ed1\u5b9a\u89d2\u8272\u548c\u4eba\u5458")
    public ResponseEntity<List<UserModel.Request.BindRole>> bindUsersAndRoles(List<UserModel.Request.BindRole> bindRoles) {
        return this.userService.bindUsersAndRoles(bindRoles);
    }

    public ResponseEntity<String> bindOrgs(long userId, UserModel.Request.BindOrgs bindOrgs) {
        this.userService.bindOrgs(null, userId, bindOrgs.getOrgIds(), bindOrgs.getModules(), bindOrgs.isOverwrite(), false, false);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @ApiOperation(value="\u7ed1\u5b9a\u7ec4\u7ec7\u548c\u4eba\u54582.0-4", notes="\u7ed1\u5b9a\u7ec4\u7ec7\u548c\u4eba\u5458")
    public ResponseEntity<List<UserModel.Request.BindOrg>> bindUserAndOrg(@RequestBody List<UserModel.Request.BindOrg> bindOrgs) {
        return this.userService.bindUserOrg(bindOrgs);
    }

    @ApiOperation(value="\u68c0\u67e5\u7528\u6237\u662f\u5426\u6709\u63a5\u53e3\u8bbf\u95ee\u6743\u9650")
    public ResponseEntity<Boolean> checkUriAuthz(long userId, UserModel.Request.CheckUriAuthzQuery checkUriAuthzQuery) {
        checkUriAuthzQuery.setUserId(Long.valueOf(userId));
        boolean result = this.userService.checkUriAuthz(checkUriAuthzQuery);
        return ResponseEntity.ok((Object)result);
    }

    @JsonView(value={UserView.UserInfo.class})
    @ApiOperation(value="\u79df\u6237\u4e0b\u83b7\u53d6\u7528\u6237\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u7528\u6237\u5206\u9875")
    public ResponseEntity<Page<User>> page(String tenantKey, UserModel.Request.Query query, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}));
        query.setTenantId(Long.valueOf(super.toTenantId(tenantKey, query.getByTenantCode())));
        Page<User> result = this.userService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5217\u8868", notes="\u901a\u8fc7\u53c2\u6570\uff0c\u83b7\u53d6\u7528\u6237\u5217\u8868")
    public ResponseEntity<List<User>> list(String tenantKey, UserModel.Request.Query query, Sort sort) {
        Sort currentSort = SortFactory.ofDefaultSort((Sort)sort, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}));
        query.setTenantId(Long.valueOf(super.toTenantId(tenantKey, query.getByTenantCode())));
        List<User> result = this.userService.list(query, currentSort);
        return ResponseEntity.ok(result);
    }

    @JsonView(value={UserView.UserInfo.class})
    @ApiOperation(value="\u79df\u6237\u4e0b\u521b\u5efa\u7528\u6237")
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> create(String tenantKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, UserModel.Request.Create model) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        model.setTenantId(Long.valueOf(tenantId));
        UserModel.Request.SaveUserOutput saveUserOutput = this.userService.save(tenantId, 0L, Stream.of(model).collect(Collectors.toList()), model.isRoleOverwrite(), model.isOrgOverwrite(), model.isTagOverwrite(), model.isAppOverwrite(), model.isMergeAccount(), model.isStrict());
        UserService.removeCachedRoleOrgUserRelsThreadLocal();
        if (saveUserOutput.getUserResultMap().isEmpty()) {
            throw new UnknownException("\u672a\u77e5\u9519\u8bef");
        }
        UserModel.Request.SaveUserContext saveUserContext = (UserModel.Request.SaveUserContext)saveUserOutput.getUserResultMap().values().stream().findFirst().orElseThrow(() -> new UnknownException("\u672a\u77e5\u9519\u8bef"));
        UserDto user = saveUserContext.getUser();
        AccountDto account = saveUserContext.getAccount();
        if (account != null) {
            user.setAccount(account);
        }
        return ResponseEntity.ok((Object)user);
    }

    @JsonView(value={UserView.UserInfo.class})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> simpleCreate(String tenantKey, Boolean byTenantCode, UserModel.Request.SimpleCreate model) {
        UserModel.Request.Create save = new UserModel.Request.Create();
        BeanUtils.copyProperties((Object)model, (Object)save);
        save.setIsRoleOverwrite(Boolean.valueOf(false));
        save.setIsOrgOverwrite(Boolean.valueOf(false));
        save.setIsTagOverwrite(Boolean.valueOf(false));
        save.setIsAppOverwrite(Boolean.valueOf(false));
        save.setIsMergeAccount(Boolean.valueOf(true));
        save.setIsStrict(Boolean.valueOf(true));
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        save.setTenantId(Long.valueOf(tenantId));
        UserModel.Request.SaveUserOutput result = this.userService.save(save, save.isRoleOverwrite(), save.isOrgOverwrite(), save.isTagOverwrite(), save.isAppOverwrite(), save.isMergeAccount(), save.isStrict());
        UserService.removeCachedRoleOrgUserRelsThreadLocal();
        if (result.getUserResultMap().isEmpty()) {
            throw new UnknownException("\u672a\u77e5\u9519\u8bef");
        }
        UserModel.Request.SaveUserContext saveUserContext = (UserModel.Request.SaveUserContext)result.getUserResultMap().values().stream().findFirst().orElseThrow(() -> new UnknownException("\u672a\u77e5\u9519\u8bef"));
        UserDto user = saveUserContext.getUser();
        AccountDto account = saveUserContext.getAccount();
        if (account != null) {
            user.setAccount(account);
        }
        return ResponseEntity.ok((Object)user);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165\u7528\u6237")
    public ResponseEntity<Boolean> batchImport(String tenantKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, UserModel.Request.BatchImport batchImport) {
        logger.info("batchImport.isRoleOverwrite = {}, isOrgOverwrite = {}, isTagOverwrite = {}, isAppOverwrite = {}, isOverwrite = {}, isMergeAccount = {}, isStrict = {}", new Object[]{batchImport.isRoleOverwrite(), batchImport.isOrgOverwrite(), batchImport.isTagOverwrite(), batchImport.isAppOverwrite(), batchImport.isOverwrite(), batchImport.isMergeAccount(), batchImport.isStrict()});
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        UserModel.Request.SaveUserOutput result = this.userService.save(tenantId, 0L, batchImport.getModels(), batchImport.isRoleOverwrite(), batchImport.isOrgOverwrite(), batchImport.isTagOverwrite(), batchImport.isAppOverwrite(), batchImport.isMergeAccount(), batchImport.isStrict());
        UserService.removeCachedRoleOrgUserRelsThreadLocal();
        return ResponseEntity.ok((Object)true);
    }

    public ResponseEntity<List<UserModel.Response.BatchSyncResult>> batchSync(@Valid UserModel.Request.BatchSync batchSync) {
        List<UserModel.Response.BatchSyncResult> result = this.userService.batchCreate(batchSync.getTenantId(), batchSync);
        UserService.removeCachedRoleOrgUserRelsThreadLocal();
        return ResponseEntity.ok(result);
    }

    public ResponseEntity<User> changeTenant(Long userId, Long tenantId) {
        User user = this.userService.changeTenant(userId, tenantId);
        return ResponseEntity.ok((Object)user);
    }

    @ApiOperation(value="\u6279\u91cf\u5f80\u7ec4\u7ec7\u5bfc\u5165\u7528\u6237")
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<UserModel.Request.SaveUserOutput<U, O, R, A>> batchImportIntoOrg(String tenantKey, String orgKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byOrgCode", required=false) Boolean byOrgCode, List<UserModel.Request.Create> models) {
        if (CollectionUtils.isEmpty(models)) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u62a5\u6587");
        }
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long orgId = super.toOrgId(tenantId, orgKey, byOrgCode);
        UserModel.Request.Create firstModel = models.get(0);
        UserModel.Request.SaveUserOutput result = this.userService.save(tenantId, orgId, models, firstModel.isRoleOverwrite(), firstModel.isOrgOverwrite(), firstModel.isTagOverwrite(), firstModel.isTagOverwrite(), firstModel.isMergeAccount(), firstModel.isStrict());
        UserService.removeCachedRoleOrgUserRelsThreadLocal();
        return ResponseEntity.ok(result);
    }

    @ApiOperation(value="\u4e00\u7ad9\u5f0f\u5165\u4f4f\u6279\u91cf\u5f80\u7ec4\u7ec7\u5bfc\u5165\u7528\u6237")
    @JsonView(value={View.Page.class})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<UserModel.Request.SaveUserOutput<U, O, R, A>> batchCreateUser(String flowId, Long companyId, List<UserModel.Request.Create> models) {
        SettleFlow flow;
        try {
            long id = Long.parseLong(flowId);
            flow = this.settleFlowService.findByFlowId(id);
        }
        catch (NumberFormatException e) {
            String message = e.getMessage() + ", value: " + flowId;
            logger.warn(message);
            flow = this.settleFlowService.findByFlowCode(flowId);
        }
        if (null == flow) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5165\u9a7b\u9875\u9762\u6d41");
        }
        if (null == flow.getFlowId()) {
            return ResponseEntity.fail((String)"0", (String)"\u79df\u6237\u4e0d\u5b58\u5728\u6d41\u7a0b");
        }
        logger.info("\u4e00\u7ad9\u5f0f\u5165\u4f4f:\u5f00\u59cb\u67e5\u8be2\u89d2\u8272 {}", (Object)JsonUtils.toJson((Object)flow));
        RoleModel.Request.Query roleQuery = new RoleModel.Request.Query();
        roleQuery.setTenantId(models.get(0).getTenantId());
        List<Role> tenantRoles = this.roleService.list(roleQuery, Sort.unsorted());
        tenantRoles = this.getRoles(models, flow, tenantRoles);
        logger.info("\u4e00\u7ad9\u5f0f\u5165\u4f4f:\u521b\u5efa\u89d2\u8272\u6210\u529f {}", (Object)JsonUtils.toJson(tenantRoles));
        if (CollectionUtils.isEmpty(tenantRoles)) {
            return ResponseEntity.fail((String)"UCTSCM0000", (String)"\u89d2\u8272\u521b\u5efa\u5931\u8d25");
        }
        List ids = tenantRoles.stream().map(Role::getId).collect(Collectors.toList());
        models.forEach(model -> {
            HashSet roleIds = model.getRoleIds();
            if (CollectionUtils.isEmpty((Collection)roleIds)) {
                roleIds = new HashSet();
            }
            roleIds.addAll(ids);
            model.setRoleIds(roleIds);
        });
        logger.info("\u4e00\u7ad9\u5f0f\u5165\u4f4f:\u67e5\u8be2\u7ec4\u7ec7 \u5f00\u59cb ");
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setCompanyId(companyId);
        query.setTenantId(models.get(0).getTenantId());
        query.setStatus(Integer.valueOf(1));
        List<OrgStruct> org = this.orgService.list(query, Sort.unsorted());
        if (null == org || org.size() != 1) {
            logger.error(JsonUtils.toJson(org));
            return ResponseEntity.fail((String)"UCTSCM0000", (String)"\u516c\u53f8\u4e3a\u7a7a\u6216\u8005\u6709\u591a\u4e2a");
        }
        this.userService.filterUser(models);
        logger.info("\u4e00\u7ad9\u5f0f\u5165\u4f4f:\u4fdd\u5b58\u7528\u6237{}", (Object)JsonUtils.toJson(org));
        UserModel.Request.SaveUserOutput result = this.userService.save((long)org.get(0).getTenantId(), org.get(0).getOrgId(), models, true, true, true, true, false, true);
        UserService.removeCachedRoleOrgUserRelsThreadLocal();
        return ResponseEntity.ok(result);
    }

    public List<Role> getRoles(List<UserModel.Request.Create> models, SettleFlow flow, List<Role> tenantRoles) {
        if (CollectionUtils.isEmpty(tenantRoles)) {
            logger.info("\u4e00\u7ad9\u5f0f\u5165\u4f4f:\u521b\u5efa\u79df\u6237\u89d2\u8272 {}", (Object)models.get(0).getTenantId());
            SettleFlowPackageModel.Request.Query packageQuery = new SettleFlowPackageModel.Request.Query();
            packageQuery.setFlowId(flow.getFlowId());
            Page<SettleFlowPackage> packages = this.settleFlowService.packages(packageQuery, Pageable.unpaged());
            if (CollectionUtils.isEmpty((Collection)packages.getContent())) {
                throw new IllegalArgumentException("\u670d\u52a1\u5305\u6ca1\u914d\u7f6e");
            }
            List<Long> resourceSetIds = this.settleFlowService.findResourceByPackage(packages.getContent());
            RoleModel.Request.Create create = new RoleModel.Request.Create();
            RoleModel.Request.BindResourceSets bindResourceSets = new RoleModel.Request.BindResourceSets();
            bindResourceSets.setOverwrite(true);
            bindResourceSets.setResourcesetIds(resourceSetIds);
            create.setBindResourceSets(bindResourceSets);
            create.setRoleCode(String.valueOf(models.get(0).getTenantId()));
            create.setRoleName("\u7ba1\u7406\u5458");
            create.setRoleDesc("\u6613\u5feb\u62a5");
            create.setStatus(Integer.valueOf(1));
            create.setTenantId(models.get(0).getTenantId());
            Role res = this.roleService.create(create);
            tenantRoles = Stream.of(res).collect(Collectors.toList());
        }
        return tenantRoles;
    }

    @JsonView(value={UserView.UserInfo.class})
    @ApiOperation(value="\u79df\u6237\u4fee\u6539\u7528\u6237\u4fe1\u606f")
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> update(String tenantKey, String userKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byUserCode", required=false) Boolean byUserCode, UserModel.Request.Update model) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long userId = super.toUserId(tenantId, userKey, byUserCode);
        model.setTenantId(Long.valueOf(tenantId));
        model.setUserId(Long.valueOf(userId));
        model.setIsOverwrite(Boolean.valueOf(true));
        model.setIsMergeAccount(Boolean.valueOf(true));
        model.setIsStrict(Boolean.valueOf(true));
        UserModel.Request.SaveUserOutput saveUserOutput = this.userService.save(model, model.isRoleOverwrite(), model.isOrgOverwrite(), model.isTagOverwrite(), model.isAppOverwrite(), model.isMergeAccount(), model.isStrict());
        UserService.removeCachedRoleOrgUserRelsThreadLocal();
        Map userContextMap = saveUserOutput.getUserResultMap();
        if (userContextMap.values().isEmpty()) {
            throw new IllegalArgumentException("\u6ca1\u6709\u8fd4\u56de\u671f\u671b\u7684\u503c");
        }
        UserDto result = ((UserModel.Request.SaveUserContext)userContextMap.values().stream().findFirst().orElseThrow(() -> new IllegalArgumentException("\u6ca1\u6709\u8fd4\u56de\u671f\u671b\u7684\u503c"))).getUser();
        return ResponseEntity.ok((Object)result);
    }

    @JsonView(value={UserView.UserInfo.class})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> ResponseEntity<U> simpleUpdate(String tenantKey, String userKey, Boolean byTenantCode, Boolean byUserCode, UserModel.Request.SimpleUpdate model) {
        UserModel.Request.Update save = new UserModel.Request.Update();
        BeanUtils.copyProperties((Object)model, (Object)save);
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long userId = super.toUserId(tenantId, userKey, byUserCode);
        save.setTenantId(Long.valueOf(tenantId));
        save.setUserId(Long.valueOf(userId));
        save.setIsRoleOverwrite(Boolean.valueOf(false));
        save.setIsOrgOverwrite(Boolean.valueOf(false));
        save.setIsTagOverwrite(Boolean.valueOf(false));
        save.setIsAppOverwrite(Boolean.valueOf(false));
        save.setIsMergeAccount(Boolean.valueOf(true));
        save.setIsStrict(Boolean.valueOf(true));
        UserModel.Request.SaveUserOutput saveUserOutput = this.userService.save(save, save.isRoleOverwrite(), save.isOrgOverwrite(), save.isTagOverwrite(), save.isAppOverwrite(), save.isMergeAccount(), save.isStrict());
        UserService.removeCachedRoleOrgUserRelsThreadLocal();
        Map userContextMap = saveUserOutput.getUserResultMap();
        if (userContextMap.values().isEmpty()) {
            throw new IllegalArgumentException("\u6ca1\u6709\u8fd4\u56de\u671f\u671b\u7684\u503c");
        }
        UserDto result = ((UserModel.Request.SaveUserContext)userContextMap.values().stream().findFirst().orElseThrow(() -> new IllegalArgumentException("\u6ca1\u6709\u8fd4\u56de\u671f\u671b\u7684\u503c"))).getUser();
        return ResponseEntity.ok((Object)result);
    }

    @JsonView(value={UserView.UserInfo.class})
    @ApiOperation(value="\u79df\u6237\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    public ResponseEntity<User> info(String tenantKey, String userKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byUserCode", required=false) Boolean byUserCode, String loginId, String modules, int extraInfoDimension) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long userId = super.toUserId(tenantId, userKey, byUserCode);
        User result = this.userService.findByTenantIdAndUserIdAndLoginId(tenantId, userId, loginId, modules, extraInfoDimension);
        return ResponseEntity.ok((Object)result);
    }

    @Deprecated
    @ApiOperation(value="\u79df\u6237\u5220\u9664\u7528\u6237")
    public ResponseEntity<String> delete(String tenantKey, String userKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byUserCode", required=false) Boolean byUserCode) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long userId = super.toUserId(tenantId, userKey, byUserCode);
        this.userService.deleteByTenantIdAndUserId(tenantId, userId);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u79df\u6237\u7ed1\u5b9a\u7528\u6237\u89d2\u8272\u5217\u8868")
    public ResponseEntity<String> bindRoles(String tenantKey, String userKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byUserCode", required=false) Boolean byUserCode, UserModel.Request.BindRoles bindRoles) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long userId = super.toUserId(tenantId, userKey, byUserCode);
        this.userService.bindRoles(tenantId, null, userId, bindRoles.getAllRoleIds(), bindRoles.getRoleIds(), bindRoles.getGradingRoleIds(), bindRoles.getOrgRoleIds(), bindRoles.isOverwrite(), false, false);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @ApiOperation(value="\u79df\u6237\u7ed1\u5b9a\u7528\u6237\u89d2\u8272\u5217\u8868(\u5e9f\u5f03)")
    @Deprecated
    @RequestMapping(name="\u79df\u6237\u6279\u91cf\u7ed1\u5b9a\u7528\u6237\u89d2\u8272(\u5e9f\u5f03)", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/users/{userKey}/roles/legacy"}, method={RequestMethod.POST})
    public ResponseEntity<String> legacyBindRoles(@PathVariable(value="tenantKey") String tenantKey, @PathVariable(value="userKey") String userKey, @RequestParam(value="byTenantCode", required=false) Boolean byTenantCode, @RequestParam(value="byUserCode", required=false) Boolean byUserCode, @RequestBody List<Long> roleIds) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long userId = super.toUserId(tenantId, userKey, byUserCode);
        this.userService.bindRoles(tenantId, null, userId, null, roleIds, null, null, false, false, false);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @ApiOperation(value="\u79df\u6237\u53cd\u7ed1\u5b9a\u7528\u6237\u89d2\u8272\u5217\u8868")
    public ResponseEntity<String> unbindRoles(String tenantKey, String userKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byUserCode", required=false) Boolean byUserCode, UserModel.Request.UnbindRoles unbindRoles) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long userId = super.toUserId(tenantId, userKey, byUserCode);
        this.userService.unbindRoles(tenantId, userId, unbindRoles.getRoleIds());
        return ResponseEntity.ok((Object)"\u53cd\u7ed1\u5b9a\u6210\u529f");
    }

    @ApiOperation(value="\u79df\u6237\u7ed1\u5b9a\u7528\u6237\u7ec4\u7ec7\u5217\u8868")
    public ResponseEntity<String> bindOrgs(String tenantKey, String userKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byUserCode", required=false) Boolean byUserCode, UserModel.Request.BindOrgs bindOrgs) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long userId = super.toUserId(tenantId, userKey, byUserCode);
        this.userService.bindOrgs(tenantId, userId, bindOrgs.getOrgIds(), bindOrgs.getModules(), bindOrgs.isOverwrite(), false, false);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @ApiOperation(value="\u79df\u6237\u53cd\u7ed1\u5b9a\u7528\u6237\u7ec4\u7ec7\u5217\u8868")
    public ResponseEntity<String> unbindOrgs(String tenantKey, String userKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byUserCode", required=false) Boolean byUserCode, UserModel.Request.UnbindOrgs unbindOrgs) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long userId = super.toUserId(tenantId, userKey, byUserCode);
        this.userService.unbindOrgs(tenantId, userId, unbindOrgs.getModules(), unbindOrgs.getOrgIds());
        return ResponseEntity.ok((Object)"\u53cd\u7ed1\u5b9a\u6210\u529f");
    }

    @ApiOperation(value="\u79df\u6237\u66f4\u65b0\u7528\u6237\u72b6\u6001")
    public ResponseEntity<String> updateStatus(String tenantKey, String userKey, int status, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byUserCode", required=false) Boolean byUserCode) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long userId = super.toUserId(tenantId, userKey, byUserCode);
        this.userService.updateStatus(tenantId, userId, status);
        return ResponseEntity.ok((Object)"\u66f4\u65b0\u6210\u529f");
    }

    @ApiOperation(value="\u79df\u6237\u4e0b\u83b7\u53d6\u7528\u6237\u8d44\u6e90\u7801\u96c6\u5408", notes="\u79df\u6237\u4e0b\u83b7\u53d6\u7528\u6237\u8d44\u6e90\u7801\u96c6\u5408")
    public ResponseEntity<Set<String>> userResources(String tenantKey, String userKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byUserCode", required=false) Boolean byUserCode, String loginId, String modules) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long userId = super.toUserId(tenantId, userKey, byUserCode);
        User user = this.userService.findByLoginId(userId, loginId, modules, BinaryUtils.toBinary((Enum)ExtraInfo.resources));
        HashSet resources = user.getResourceCodes();
        if (resources == null) {
            resources = new HashSet();
        }
        return ResponseEntity.ok((Object)resources);
    }

    public ResponseEntity<Map<Long, Set<String>>> appsResources(String tenantKey, String userKey, Boolean byTenantCode, Boolean byUserCode, String appIds, String loginId, String modules) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long userId = super.toUserId(tenantId, userKey, byUserCode);
        return this.appsResources(userId, appIds, loginId, modules);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165\u7528\u6237Excel.")
    public ResponseEntity<Boolean> batchImportFromExcel(String tenantKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, MultipartFile file) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        return this.excelService.batchImportUsers(tenantId, file);
    }

    public ResponseEntity<String> tenantDisable(String tenantKey, Boolean byTenantCode, long userId) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        this.userService.updateStatus(tenantId, userId, 0);
        return ResponseEntity.ok((Object)"\u7981\u7528\u6210\u529f");
    }

    @JsonView(value={UserView.UserInfo.class})
    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u83b7\u53d6\u7528\u6237\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u7528\u6237\u5206\u9875")
    public ResponseEntity<Page<User>> currentPage(UserModel.Request.Query query, Pageable pageable) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        query.setIncludeIndependents(Boolean.valueOf(true));
        return this.page(tenantId, query, pageable);
    }

    @JsonView(value={UserView.UserInfo.class})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f")
    public ResponseEntity<User> currentInfo(String loginId, int extraInfoDimension) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        long userId = authorizedUser.getId();
        if (loginId == null) {
            loginId = authorizedUser.getLoginId();
        }
        String modules = authorizedUser.getModules();
        return this.info(tenantId, userId, loginId, modules, extraInfoDimension);
    }

    public ResponseEntity<Set<String>> currentResources() {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        long userId = authorizedUser.getId();
        String loginId = authorizedUser.getLoginId();
        String modules = authorizedUser.getModules();
        return this.userResources(tenantId, userId, loginId, modules);
    }

    @JsonView(value={UserView.UserInfo.class})
    public ResponseEntity<User> currentUserinfo(long userId, int extraInfo) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        String modules = authorizedUser.getModules();
        return this.info(tenantId, userId, null, modules, extraInfo);
    }

    @JsonView(value={UserView.UserInfo.class})
    public ResponseEntity<User> currentCreate(UserModel.Request.Create model) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        return this.create(tenantId, model);
    }

    @JsonView(value={UserView.UserInfo.class})
    public ResponseEntity<User> currentUpdate(long userId, UserModel.Request.Update model) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        return this.update(tenantId, userId, model);
    }

    public ResponseEntity<User> currentSimpleCreate(UserModel.Request.SimpleCreate model) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        return this.simpleCreate(tenantId, model);
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u66f4\u65b0\u4eba\u5458\u4fe1\u606f")
    public ResponseEntity<User> currentSimpleUpdate(long userId, UserModel.Request.SimpleUpdate model) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        return this.simpleUpdate(tenantId, userId, model);
    }

    public ResponseEntity<String> currentEnable(long userId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        this.userService.updateStatus(tenantId, userId, 1);
        return ResponseEntity.ok((Object)"\u542f\u7528\u6210\u529f");
    }

    public ResponseEntity<String> currentDisable(long userId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        this.userService.updateStatus(tenantId, userId, 0);
        return ResponseEntity.ok((Object)"\u7981\u7528\u6210\u529f");
    }

    public ResponseEntity<String> currentDeleteUser(Long userId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        return this.delete(tenantId, userId);
    }

    @JsonView(value={RoleView.RoleInfo.class})
    public ResponseEntity<Page<Role>> currentBindedRoles(Long userId, RoleModel.Request.Query query, Pageable pageable) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        query.setTenantId(Long.valueOf(tenantId));
        query.setUserId(userId);
        if (query.getStatus() == null) {
            query.setStatus(Integer.valueOf(1));
        }
        Page<Role> result = this.roleService.page(query, pageable);
        return ResponseEntity.ok(result);
    }

    public ResponseEntity<String> currentBindRoles(Long userId, UserModel.Request.BindRoles bindRoles) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        return this.bindRoles(tenantId, userId, bindRoles);
    }

    public ResponseEntity<String> currentUnbindRoles(Long userId, UserModel.Request.UnbindRoles unbindRoles) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        return this.unbindRoles(tenantId, userId, unbindRoles);
    }

    public ResponseEntity<String> currentBindOrgs(Long userId, UserModel.Request.BindOrgs bindOrgs) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        return this.bindOrgs(tenantId, userId, bindOrgs);
    }

    public ResponseEntity<String> currentUnbindOrgs(Long userId, UserModel.Request.UnbindOrgs unbindOrgs) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        return this.unbindOrgs(tenantId, userId, unbindOrgs);
    }

    public ResponseEntity<Page<OrgStruct>> bindedOrgsPage(Long userId, OrgModel.Request.Query query, Pageable pageable) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        query.setTenantId(Long.valueOf(tenantId));
        query.setUserId(userId);
        if (query.getStatus() == null) {
            query.setStatus(Integer.valueOf(1));
        }
        query.setModules(authorizedUser.getModules());
        Page<OrgStruct> result = this.orgService.page(query, pageable);
        return ResponseEntity.ok(result);
    }

    @JsonView(value={View.List.class})
    public ResponseEntity<List<OrgStruct>> bindedOrgs(Long userId, OrgModel.Request.Query query, Sort sort) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        query.setTenantId(Long.valueOf(tenantId));
        query.setUserId(userId);
        if (query.getStatus() == null) {
            query.setStatus(Integer.valueOf(1));
        }
        query.setModules(authorizedUser.getModules());
        List<OrgStruct> result = this.orgService.list(query, sort);
        return ResponseEntity.ok(result);
    }

    @ApiOperation(value="\u5f53\u524d\u7528\u6237\u7ed1\u5b9a\u7528\u6237\u89d2\u8272\u5217\u8868(\u5e9f\u5f03)")
    @Deprecated
    @ResponseBody
    @RequestMapping(name="\u5f53\u524d\u7528\u6237\u6279\u91cf\u7ed1\u5b9a\u7528\u6237\u89d2\u8272(\u5e9f\u5f03)", value={"${xforce.tenant.service.url.prefix:/api}/current${xforce.tenant.service.version:}/users/{userKey}/roles/legacy"}, method={RequestMethod.POST})
    public ResponseEntity<String> currentBindRolesLegacy(@PathVariable(value="userKey") String userKey, @RequestParam(value="byUserCode", required=false) Boolean byUserCode, @RequestBody List<Long> roleIds) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        long userId = super.toUserId(tenantId, userKey, byUserCode);
        this.userService.bindRoles(tenantId, null, userId, null, roleIds, null, null, false, false, false);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @ResponseBody
    @ApiOperation(value="\u4fee\u590d\u7528\u6237\u7ec4\u7ec7", notes="\u4fee\u590d\u7528\u6237\u7ec4\u7ec7")
    @RequestMapping(name="\u4fee\u590d\u7528\u6237\u7ec4\u7ec7", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/users/orgs/fix"}, method={RequestMethod.POST})
    public ResponseEntity<String> fixAllPaths() {
        this.fixService.fixAllUserOrgs();
        return ResponseEntity.ok((Object)"\u4fee\u590d\u6210\u529f");
    }

    public ResponseEntity export(@RequestBody UserModel.Export export) {
        Long fileId;
        if (CollectionUtils.isEmpty((Collection)export.getUserIds())) {
            throw new IllegalArgumentException("\u672a\u9009\u62e9\u4eba\u5458");
        }
        List<UserExportDto> users = this.userService.getExportData(export.getUserIds());
        if (CollectionUtils.isEmpty(users)) {
            throw new IllegalArgumentException("\u5bfc\u51fa\u5931\u8d25\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u4eba\u5458");
        }
        LinkedHashMap<String, String> rules = new LinkedHashMap<String, String>();
        rules.put("userName", "\u59d3\u540d");
        rules.put("userCode", "\u4eba\u5458\u4ee3\u7801");
        rules.put("userNumber", "\u5de5\u53f7");
        rules.put("status", "\u72b6\u6001");
        rules.put("email", "\u90ae\u7bb1\u8d26\u53f7");
        rules.put("telPhone", "\u624b\u673a\u8d26\u53f7");
        rules.put("accountName", "\u666e\u901a\u8d26\u53f7");
        rules.put("invoices", "\u53d1\u7968\u7c7b\u578b");
        rules.put("ticketOpeningTerminal", "\u5f00\u7968\u7ec8\u7aef");
        rules.put("printingEquipment", "\u7a0e\u63a7\u8bbe\u5907");
        rules.put("roleNames", "\u89d2\u8272\u540d\u79f0");
        rules.put("roleCodes", "\u89d2\u8272\u4ee3\u7801");
        rules.put("orgNames", "\u7ec4\u7ec7\u540d\u79f0");
        rules.put("orgCodes", "\u7ec4\u7ec7\u4ee3\u7801");
        try {
            String json = JSON.toJSONString(users, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            fileId = this.fileService.exportDataExcel(json, rules, "\u4eba\u5458\u5bfc\u51fa\u5217\u8868");
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new IllegalArgumentException("\u4eba\u5458\u5bfc\u51fa\u5931\u8d25");
        }
        return ResponseEntity.ok((Object)fileId);
    }

    @AuthorizedDefinition(resources={"xforce:business:user:read"})
    @ApiOperation(value="\u6279\u91cf\u5bfc\u51fa\u7528\u6237\u5173\u8054\u4fe1\u606ftoExcel")
    public ResponseEntity batchExport(UserModel.Request.Query query) {
        if (CollectionUtils.isEmpty((Collection)query.getSheets())) {
            throw new IllegalArgumentException("\u8bf7\u9009\u62e9SheetName");
        }
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        Long tenantId = authorizedUser.getTenantId();
        query.setTenantId(tenantId);
        this.userService.buildCurrentQuery(query, authorizedUser);
        QueryParam queryParam = QueryParam.builder().param("P_QUERY", query).build();
        ExcelConfigBusinessType businessType = ExcelConfigBusinessType.USER_IMPORT;
        ExcelFileStore excelFileStore = this.exportFileService.asyncExcelExport(queryParam.params(), businessType);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setId(excelFileStore.getId());
        respVo.setBusinessType(businessType.getBusinessName());
        return ResponseEntity.ok((Object)respVo);
    }

    @AuthorizedDefinition(resources={"xforce:business:user:save"})
    @ApiOperation(value="\u6279\u91cf\u4eceExcel\u5bfc\u5165\u7528\u6237\u5173\u8054\u4fe1\u606f")
    public ResponseEntity<ImportFileRespVo> batchImportData(MultipartFile file) {
        IAuthorizedUser currentUser = UserInfoHolder.currentUser();
        Long tenantId = currentUser.getTenantId();
        Long userId = currentUser.getId();
        ExcelFileStore excelFileStore = this.importFileService.createAndSaveFile(file, ExcelConfigBusinessType.USER_IMPORT.name(), userId, tenantId);
        ImportFileRespVo respVO = new ImportFileRespVo();
        respVO.setBusinessType(ExcelConfigBusinessType.USER_IMPORT.name());
        respVO.setFileId(excelFileStore.getSourceFileId());
        respVO.setId(excelFileStore.getId());
        return ResponseEntity.ok((Object)respVO);
    }

    public ResponseEntity<Map<Long, Set<String>>> appsResources(String appIds) {
        IAuthorizedUser currentUser = UserInfoHolder.currentUser();
        Long tenantId = currentUser.getTenantId();
        Long userId = currentUser.getId();
        String loginId = currentUser.getLoginId();
        String modules = currentUser.getModules();
        return this.appsResources(tenantId, userId, appIds, loginId, modules);
    }

    @ApiOperation(value="\u62f7\u8d1d\u6307\u5b9a\u7528\u6237\u6743\u9650\u76f8\u5173\u6743\u9650")
    public ResponseEntity copyPrivilege(UserModel.Request.CopyPrivilege privilege) {
        Long tenantId = UserInfoHolder.get().getTenantId();
        this.userService.copyPrivilege(tenantId, privilege);
        return ResponseEntity.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u7a0e\u53f7")
    public ResponseEntity<Set<String>> taxNums(Long userId, String loginId, String modules) {
        Set orgs;
        User result = this.userService.findByLoginId(userId, loginId, modules, BinaryUtils.toBinary((Enum)ExtraInfo.companies));
        Set<Object> set = new HashSet();
        if (null != result && !CollectionUtils.isEmpty((Collection)(orgs = result.getCompanies()))) {
            set = orgs.stream().map(OrgStruct::getTaxNum).collect(Collectors.toSet());
        }
        return ResponseEntity.ok(set);
    }

    public ResponseEntity<Set<Company>> companies(Long userId, String loginId, String modules) {
        User result = this.userService.findByLoginId(userId, loginId, modules, ExtraInfo.companies.value());
        Set<Object> companies = new HashSet();
        if (null != result && !CollectionUtils.isEmpty((Collection)result.getCompanies())) {
            companies = result.getCompanies().stream().filter(orgStruct -> null != orgStruct.getCompany()).map(OrgStruct::getCompany).collect(Collectors.toSet());
        }
        return ResponseEntity.ok(companies);
    }

    @ApiOperation(value="\u65b0\u589e\u7ed1\u5b9a\u8bbe\u5907")
    public ResponseEntity<String> bindPrintingEquipment(Long tenantId, Long userId, List<String> equipmentList) {
        User user = this.userService.findById(userId);
        if (!user.getTenantId().equals(tenantId)) {
            throw new IllegalArgumentException("\u7528\u6237\u4fe1\u606f\u548c\u79df\u6237\u4e0d\u5339\u914d\uff01");
        }
        this.userService.bindPrintingEquipment(user, equipmentList);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @ApiOperation(value="\u89e3\u7d81\u8bbe\u5907")
    public ResponseEntity<String> unbindPrintingEquipment(Long tenantId, Long userId, List<String> equipmentList) {
        User user = this.userService.findById(userId);
        if (!user.getTenantId().equals(tenantId)) {
            throw new IllegalArgumentException("\u7528\u6237\u4fe1\u606f\u548c\u79df\u6237\u4e0d\u5339\u914d\uff01");
        }
        this.userService.unbindPrintingEquipment(user, equipmentList);
        return ResponseEntity.ok((Object)"\u89e3\u7ed1\u6210\u529f");
    }

    @ApiOperation(value="\u65b0\u589e\u7ed1\u5b9a\u7ec8\u7aef")
    public ResponseEntity<String> bindTicketTerminal(Long tenantId, Long userId, List<String> terminalList) {
        User user = this.userService.findById(userId);
        if (!user.getTenantId().equals(tenantId)) {
            throw new IllegalArgumentException("\u7528\u6237\u4fe1\u606f\u548c\u79df\u6237\u4e0d\u5339\u914d\uff01");
        }
        this.userService.bindTicketTerminal(user, terminalList);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @ApiOperation(value="\u89e3\u7ed1\u7ec8\u7aef")
    public ResponseEntity<String> unbindTicketTerminal(Long tenantId, Long userId, List<String> terminalList) {
        User user = this.userService.findById(userId);
        if (!user.getTenantId().equals(tenantId)) {
            throw new IllegalArgumentException("\u7528\u6237\u4fe1\u606f\u548c\u79df\u6237\u4e0d\u5339\u914d\uff01");
        }
        this.userService.unbindTicketTerminal(user, terminalList);
        return ResponseEntity.ok((Object)"\u89e3\u7ed1\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:business:user:tenant:manager"})
    public ResponseEntity<String> changeTenantManager(String username, Long tenantId) {
        this.userService.changeTenantManager(username, tenantId);
        return ResponseEntity.ok((Object)"\u7ba1\u7406\u5458\u66f4\u6362\u6210\u529f");
    }

    public ResponseEntity<String> logoff(Long userId, String loginId) {
        this.userService.logoff(userId, loginId);
        return ResponseEntity.ok((Object)"\u767b\u51fa\u6210\u529f");
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u540d\u83b7\u53d6\u7528\u6237\u8be6\u60c5")
    @JsonView(value={UserView.UserInfo.class})
    public ResponseEntity<User> userInfo(String username) {
        Optional<User> result = this.userService.findByTenantIdAndUsername(UserInfoHolder.get().getTenantId(), username);
        if (!result.isPresent()) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7528\u6237(\u7528\u6237\u540d:" + username + ")");
        }
        return ResponseEntity.ok((Object)result.get());
    }
}

