/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.api.model.RoleModel;
import com.xforceplus.business.tenant.service.RoleService;
import com.xforceplus.dao.OrgStructDao;
import com.xforceplus.dao.OrgUserRelDao;
import com.xforceplus.dao.ResourcesetDao;
import com.xforceplus.dao.RoleResourcesetRelDao;
import com.xforceplus.dao.RoleUserRelDao;
import com.xforceplus.dao.UserDao;
import com.xforceplus.domain.resource.ResourcesetDto;
import com.xforceplus.domain.tenant.GradingRoleDTO;
import com.xforceplus.domain.tenant.GradingRoleOrg;
import com.xforceplus.domain.tenant.OrgRoleCntDTO;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.OrgUserRel;
import com.xforceplus.entity.Resourceset;
import com.xforceplus.entity.Role;
import com.xforceplus.entity.RoleResourcesetRel;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.transaction.Transactional;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GradingRoleService {
    @Autowired
    private RoleService roleService;
    @Autowired
    private OrgStructDao orgStructDao;
    @Autowired
    private OrgUserRelDao orgUserRelDao;
    @Autowired
    private RoleUserRelDao roleUserRelDao;
    @Autowired
    private RoleResourcesetRelDao roleResourcesetRelDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private ResourcesetDao resourcesetDao;
    @Value(value="${xforce.tenant.grading.role.user.maxCnt:5}")
    private Integer maxUserCnt;

    @Transactional(rollbackOn={Exception.class})
    public Role create(RoleModel.Request.GradingRoleCreate model) {
        RoleModel.Request.Create role = new RoleModel.Request.Create();
        BeanUtils.copyProperties((Object)model, (Object)role);
        role.setType(Integer.valueOf(1));
        if (CollectionUtils.isEmpty((Collection)model.getResourcesetIds())) {
            role.setStatus(Integer.valueOf(0));
        }
        Role base = this.roleService.create(role);
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        if (!CollectionUtils.isEmpty((Collection)model.getOrgIds())) {
            List orgStructs = this.orgStructDao.findAllById((Iterable)model.getOrgIds());
            boolean orgAlreadyBinded = orgStructs.stream().anyMatch(o -> o.getGradingRoleId() != null);
            if (orgAlreadyBinded) {
                throw new IllegalArgumentException("\u7ec4\u7ec7id\u975e\u6cd5\uff0c\u4e00\u4e2a\u7ec4\u7ec7\u53ea\u80fd\u7ed1\u5b9a\u4e00\u4e2a\u5206\u7ea7\u7ba1\u7406\u89d2\u8272!");
            }
            Set<Long> orgIds = model.getOrgIds().stream().collect(Collectors.toSet());
            this.batchSetOrgGradingRoles(base.getId(), orgIds);
        }
        if (!CollectionUtils.isEmpty((Collection)model.getResourcesetIds())) {
            this.batchRelGradingRoleResourcesets(base, model.getResourcesetIds());
        }
        return base;
    }

    public Page<GradingRoleDTO> page(RoleModel.Request.Query query, Pageable currentPageable) {
        query.setType(Integer.valueOf(1));
        Page<Role> rolePage = this.roleService.page(query, currentPageable);
        if (!CollectionUtils.isEmpty((Collection)rolePage.getContent())) {
            Set<Long> roleIds = rolePage.getContent().stream().map(Role::getId).collect(Collectors.toSet());
            List<OrgRoleCntDTO> orgRoleCntDTOS = this.roleService.getOrgRoleCntByGradingRoleIds(query.getTenantId(), roleIds);
            HashMap<Long, Long> map = new HashMap<Long, Long>();
            if (!CollectionUtils.isEmpty(orgRoleCntDTOS)) {
                for (OrgRoleCntDTO orgRoleCntDTO : orgRoleCntDTOS) {
                    map.put(orgRoleCntDTO.getRoleId(), orgRoleCntDTO.getOrgRoleCnt());
                }
            }
            List orgs = this.orgStructDao.findOrgsByGradingRoleIds(roleIds);
            Map<Object, Object> orgMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)orgs)) {
                orgMap = orgs.stream().collect(Collectors.groupingBy(GradingRoleOrg::getRoleId));
            }
            HashMap finalOrgMap = orgMap;
            Page page = rolePage.map(role -> {
                GradingRoleDTO dto = new GradingRoleDTO();
                BeanUtils.copyProperties((Object)role, (Object)dto);
                dto.setOrgRoleCnt(Long.valueOf(map.get(role.getId()) == null ? 0L : (Long)map.get(role.getId())));
                dto.setOrgs((List)finalOrgMap.get(role.getId()));
                return dto;
            });
            return page;
        }
        return new PageImpl(new ArrayList());
    }

    public GradingRoleDTO findByRoleId(Long roleId) {
        Role role = this.roleService.findById(roleId);
        GradingRoleDTO dto = new GradingRoleDTO();
        BeanUtils.copyProperties((Object)role, (Object)dto);
        Map<Object, Object> resourcesetMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)role.getResourcesets())) {
            resourcesetMap = role.getResourcesets().stream().collect(Collectors.groupingBy(ResourcesetDto::getAppId));
            dto.setResourcesetMap(resourcesetMap);
        }
        List gradingRoleOrgs = this.orgStructDao.findOrgsByGradingRoleIds(Stream.of(roleId).collect(Collectors.toSet()));
        dto.setOrgs(gradingRoleOrgs);
        List userIds = this.roleUserRelDao.findUserIdsByRoleId(roleId);
        if (!CollectionUtils.isEmpty((Collection)userIds)) {
            List gradingRoleUsers = this.userDao.findGradingRoleUserByUserIds(userIds);
            dto.setUsers(gradingRoleUsers);
        } else {
            dto.setUsers(new ArrayList());
        }
        return dto;
    }

    @Transactional(rollbackOn={Exception.class})
    public GradingRoleDTO updateByTenantId(long tenantId, Long roleId, RoleModel.Request.Update model) {
        model.setType(Integer.valueOf(1));
        model.setTenantId(Long.valueOf(tenantId));
        Role role = this.roleService.updateByTenantId(tenantId, roleId, (RoleModel.Request.Save)model);
        GradingRoleDTO dto = new GradingRoleDTO();
        BeanUtils.copyProperties((Object)role, (Object)dto);
        return dto;
    }

    public List<GradingRoleOrg> findBindedOrgsByRoleId(Long roleId) {
        return this.orgStructDao.findOrgsByGradingRoleIds(Stream.of(roleId).collect(Collectors.toSet()));
    }

    public List<Resourceset> findBindedResourcesetsByRoleId(Long roleId) {
        Role role = this.roleService.findById(roleId);
        List rels = role.getRoleResourcesetRels();
        if (!CollectionUtils.isEmpty((Collection)rels)) {
            List resourcesetIds = rels.stream().map(RoleResourcesetRel::getResousesetId).collect(Collectors.toList());
            return this.resourcesetDao.findByResourcesetIds(resourcesetIds);
        }
        return Collections.emptyList();
    }

    @Transactional(rollbackOn={Exception.class})
    public void saveGradingRoleOrgs(Long roleId, RoleModel.Request.BindOrgs bindOrgs) {
        List gradingRoleOrgs = this.orgStructDao.findOrgsByGradingRoleIds(Stream.of(roleId).collect(Collectors.toSet()));
        if (CollectionUtils.isEmpty((Collection)gradingRoleOrgs)) {
            if (bindOrgs != null && !CollectionUtils.isEmpty((Collection)bindOrgs.getOrgIds())) {
                this.batchSetOrgGradingRoles(roleId, bindOrgs.getOrgIds());
            }
        } else {
            Set<Long> bindedOrgIds = gradingRoleOrgs.stream().filter(Objects::nonNull).map(GradingRoleOrg::getOrgId).collect(Collectors.toSet());
            if (bindOrgs == null || CollectionUtils.isEmpty((Collection)bindOrgs.getOrgIds())) {
                this.batchSetOrgGradingRoles(null, bindedOrgIds);
            } else {
                HashSet<Long> toBindOrgIds = new HashSet<Long>(bindOrgs.getOrgIds());
                toBindOrgIds.removeAll(bindedOrgIds);
                if (!CollectionUtils.isEmpty(toBindOrgIds)) {
                    this.batchSetOrgGradingRoles(roleId, toBindOrgIds);
                }
                toBindOrgIds.clear();
                toBindOrgIds = new HashSet(bindOrgs.getOrgIds());
                bindedOrgIds.removeAll(toBindOrgIds);
                if (!CollectionUtils.isEmpty(bindedOrgIds)) {
                    this.batchSetOrgGradingRoles(null, bindedOrgIds);
                }
            }
        }
    }

    private void batchSetOrgGradingRoles(Long roleId, Set<Long> orgIds) {
        List orgStructs = this.orgStructDao.findAllById(orgIds);
        for (OrgStruct orgStruct : orgStructs) {
            Long defaultOrgRoleId;
            Long originGradingRoleId = orgStruct.getGradingRoleId();
            orgStruct.setGradingRoleId(roleId);
            if (null != roleId && Objects.equals(originGradingRoleId, roleId) || null == (defaultOrgRoleId = orgStruct.getDefaultOrgRoleId())) continue;
            orgStruct.setDefaultOrgRoleId(null);
            Set orgUserRels = this.orgUserRelDao.findRelsByOrgIds((Collection)Stream.of(orgStruct.getOrgId()).collect(Collectors.toSet()));
            if (CollectionUtils.isEmpty((Collection)orgUserRels)) continue;
            Set userIds = orgUserRels.stream().map(OrgUserRel::getUserId).collect(Collectors.toSet());
            this.roleUserRelDao.deleteByRoleIdAndUserIds(defaultOrgRoleId.longValue(), userIds);
        }
        this.orgStructDao.saveAllAndFlush((Iterable)orgStructs);
    }

    @Transactional(rollbackOn={Exception.class})
    public void saveGradingRoleResourcesets(Long roleId, RoleModel.Request.BindResourceSets bindResourceSets) {
        Role role = this.roleService.findById(roleId);
        List resourcesets = Collections.EMPTY_LIST;
        List rels = role.getRoleResourcesetRels();
        if (!CollectionUtils.isEmpty((Collection)rels)) {
            List resourcesetIds = rels.stream().map(RoleResourcesetRel::getResousesetId).collect(Collectors.toList());
            resourcesets = this.resourcesetDao.findByResourcesetIds(resourcesetIds);
        }
        if (CollectionUtils.isEmpty((Collection)resourcesets)) {
            if (bindResourceSets != null && !CollectionUtils.isEmpty((Collection)bindResourceSets.getResourcesetIds())) {
                this.batchRelGradingRoleResourcesets(role, new HashSet<Long>(bindResourceSets.getResourcesetIds()));
            } else {
                this.roleService.disable(roleId);
                this.roleService.disableOrgRolesByGradingRoleId(roleId);
            }
        } else {
            Set<Long> bindedResourcesetIds = resourcesets.stream().filter(Objects::nonNull).map(ResourcesetDto::getResourcesetId).collect(Collectors.toSet());
            if (bindResourceSets == null || CollectionUtils.isEmpty((Collection)bindResourceSets.getResourcesetIds())) {
                this.unbindGradingRoleResourcesets(roleId, bindedResourcesetIds);
                this.roleService.disable(roleId);
                this.roleService.disableOrgRolesByGradingRoleId(roleId);
            } else {
                HashSet<Long> toBindResourcesetIds = new HashSet<Long>(bindResourceSets.getResourcesetIds());
                toBindResourcesetIds.removeAll(bindedResourcesetIds);
                if (!CollectionUtils.isEmpty(toBindResourcesetIds)) {
                    this.batchRelGradingRoleResourcesets(role, toBindResourcesetIds);
                }
                toBindResourcesetIds.clear();
                toBindResourcesetIds = new HashSet(bindResourceSets.getResourcesetIds());
                bindedResourcesetIds.removeAll(toBindResourcesetIds);
                if (!CollectionUtils.isEmpty(bindedResourcesetIds)) {
                    this.unbindGradingRoleResourcesets(roleId, bindedResourcesetIds);
                    List<Role> orgRoles = this.roleService.findByTenantIdAndFromRoleId(role.getTenantId(), roleId);
                    if (!CollectionUtils.isEmpty(orgRoles)) {
                        for (Role orgRole : orgRoles) {
                            List list;
                            List rrs = this.roleResourcesetRelDao.findByRoleId(orgRole.getId().longValue());
                            if (!CollectionUtils.isEmpty((Collection)rrs)) {
                                Set brrIds = rrs.stream().map(RoleResourcesetRel::getResousesetId).collect(Collectors.toSet());
                                for (Long brrId : brrIds) {
                                    if (!bindedResourcesetIds.contains(brrId)) continue;
                                    this.roleResourcesetRelDao.deleteByRoleIdAndResourcesetId(orgRole.getId(), brrId);
                                }
                            }
                            if (!CollectionUtils.isEmpty((Collection)(list = this.roleResourcesetRelDao.findByRoleId(orgRole.getId().longValue())))) continue;
                            this.roleService.disable(orgRole.getId());
                        }
                    }
                }
            }
        }
    }

    private void batchRelGradingRoleResourcesets(Role role, Set<Long> bindResourcesetIds) {
        HashSet<RoleResourcesetRel> roleResourcesetRels = new HashSet<RoleResourcesetRel>();
        for (Long resourcesetId : bindResourcesetIds) {
            Resourceset r = (Resourceset)this.resourcesetDao.findById((Object)resourcesetId).orElseThrow(() -> new IllegalArgumentException("\u529f\u80fd\u96c6id\u975e\u6cd5!"));
            RoleResourcesetRel rel = new RoleResourcesetRel();
            rel.setRoleId(role.getId());
            rel.setTenantId(role.getTenantId());
            rel.setResousesetId(resourcesetId);
            roleResourcesetRels.add(rel);
        }
        this.roleResourcesetRelDao.saveAllAndFlush(roleResourcesetRels);
    }

    private void unbindGradingRoleResourcesets(Long roleId, Set<Long> bindedResourcesetIds) {
        this.roleResourcesetRelDao.unbindGradingRoleResourcesets(roleId, bindedResourcesetIds);
    }

    public void bindUsers(long tenantId, Long roleId, RoleModel.Request.BindUsers bindUsers) {
        if (null == bindUsers) {
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)bindUsers.getUserIds()) && bindUsers.getUserIds().size() > this.maxUserCnt) {
            throw new IllegalArgumentException("\u4e00\u4e2a\u5206\u7ea7\u89d2\u8272\u6700\u591a\u53ea\u80fd\u7ed1\u5b9a" + this.maxUserCnt + "\u4e2a\u7528\u6237\uff01");
        }
        long count = this.roleUserRelDao.countByRoleId(roleId.longValue());
        if (count + (long)bindUsers.getUserIds().size() > (long)this.maxUserCnt.intValue()) {
            throw new IllegalArgumentException("\u4e00\u4e2a\u5206\u7ea7\u89d2\u8272\u6700\u591a\u53ea\u80fd\u7ed1\u5b9a" + this.maxUserCnt + "\u4e2a\u7528\u6237\uff01");
        }
        for (Long userId : bindUsers.getUserIds()) {
            Set gradingRoleIds = this.roleUserRelDao.findGradingRoleIdsByUserId(userId);
            if (CollectionUtils.isEmpty((Collection)gradingRoleIds) || gradingRoleIds.size() <= 1 && (gradingRoleIds.size() != 1 || gradingRoleIds.contains(roleId))) continue;
            throw new IllegalArgumentException("\u4e00\u4e2a\u7528\u6237\u53ea\u80fd\u7ed1\u5b9a\u4e00\u4e2a\u5206\u7ea7\u7ba1\u7406\u5458\u89d2\u8272\uff0c\u7528\u6237[" + userId + "]\u5df2\u7ed1\u5b9a\u5176\u4ed6\u5206\u7ea7\u7ba1\u7406\u5458\u89d2\u8272\uff01");
        }
        this.roleService.bindUsers(tenantId, roleId, bindUsers, 1);
    }

    @Transactional(rollbackOn={Exception.class})
    public void deleteByTenantIdAndId(long tenantId, Long roleId) {
        List<Role> orgRoles;
        Role role = this.roleService.findById(roleId);
        if (role.getStatus() != 0) {
            throw new IllegalArgumentException("\u53ea\u80fd\u5220\u9664\u672a\u542f\u7528\u7684\u5206\u7ea7\u89d2\u8272!");
        }
        this.roleService.deleteByTenantIdAndId(tenantId, roleId);
        List orgs = this.orgStructDao.findOrgsByGradingRoleIds(Stream.of(roleId).collect(Collectors.toSet()));
        if (!CollectionUtils.isEmpty((Collection)orgs)) {
            Set<Long> orgIds = orgs.stream().map(GradingRoleOrg::getOrgId).collect(Collectors.toSet());
            this.batchSetOrgGradingRoles(null, orgIds);
        }
        if (!CollectionUtils.isEmpty(orgRoles = this.roleService.findByTenantIdAndFromRoleId(tenantId, roleId))) {
            List<Long> ids = orgRoles.stream().map(Role::getId).collect(Collectors.toList());
            this.roleUserRelDao.deleteByTenantIdAndRoleIds(tenantId, ids);
            this.roleResourcesetRelDao.deleteByTenantIdAndRoleIds(tenantId, ids);
            this.roleService.deleteByTenantIdAndIds(tenantId, ids);
        }
        this.roleResourcesetRelDao.deleteByTenantIdAndRoleIds(tenantId, Stream.of(roleId).collect(Collectors.toList()));
    }

    @Transactional(rollbackOn={Exception.class})
    public void enable(long roleId) {
        Role role = this.roleService.findById(roleId);
        List resourcesets = Collections.EMPTY_LIST;
        List rels = role.getRoleResourcesetRels();
        if (!CollectionUtils.isEmpty((Collection)rels)) {
            List resourcesetIds = rels.stream().map(RoleResourcesetRel::getResousesetId).collect(Collectors.toList());
            resourcesets = this.resourcesetDao.findByResourcesetIds(resourcesetIds);
        }
        if (CollectionUtils.isEmpty((Collection)resourcesets)) {
            throw new IllegalArgumentException("\u8be5\u89d2\u8272\u5173\u8054\u7684\u529f\u80fd\u96c6\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u542f\u7528!");
        }
        boolean anyEnabled = resourcesets.stream().anyMatch(r -> r.getStatus() == 1);
        if (!anyEnabled) {
            throw new IllegalArgumentException("\u8be5\u89d2\u8272\u5173\u8054\u7684\u529f\u80fd\u96c6\u90fd\u662f\u505c\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u542f\u7528!");
        }
        this.roleService.enable(roleId);
    }

    @Transactional(rollbackOn={Exception.class})
    public void disable(long tenantId, long roleId) {
        this.roleService.updateStatus(tenantId, roleId, 0);
        this.roleService.disableOrgRolesByGradingRoleId(roleId);
    }
}

