/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.api.model.OrgModel;
import com.xforceplus.business.company.service.CompanyExtensionService;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelWriteService;
import com.xforceplus.business.tenant.excel.CompanyExportData;
import com.xforceplus.config.ImportExportThreadPool;
import com.xforceplus.dao.OrgCompanynoDao;
import com.xforceplus.dao.OrgStructDao;
import com.xforceplus.entity.OrgCompanyRel;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.query.OrgQueryHelper;
import com.xforceplus.tenant.security.core.domain.OrgType;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrgExcelExportService
implements ExcelWriteService {
    private static final Logger logger = LoggerFactory.getLogger(OrgExcelExportService.class);
    private static final String COMPANYNOS_DELIMITER = "/";
    @Autowired
    private OrgStructDao orgStructDao;
    @Autowired
    private OrgCompanynoDao orgCompanynoDao;
    @Autowired
    private CompanyExtensionService companyExtensionService;

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.ORG_IMPORT;
    }

    @Override
    public void write(Context context) {
        Page<OrgStruct> page;
        OrgModel.Request.Query query = context.getParam("P_QUERY", OrgModel.Request.Query.class);
        SimpleExcelWriter simpleExcelWriter = context.getSimpleExcelWriter();
        List sheetNames = query.getSheets();
        Integer maxPageSize = context.getMaxPageSize();
        logger.info("maxPageSize:{}", (Object)maxPageSize);
        PageRequest pageable = PageRequest.of((int)0, (int)1000, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        do {
            page = this.excelPage(query, (Pageable)pageable);
            List orgStructList = page.getContent();
            List<Object> resultList = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)query.getWithExtendParams())) {
                resultList = this.fillOrg(orgStructList);
            } else {
                Collections.addAll(resultList, orgStructList.toArray(new OrgStruct[0]));
            }
            resultList.forEach(org -> sheetNames.forEach(sheetName -> this.writeSheet(simpleExcelWriter, (String)sheetName, (OrgStruct)org)));
        } while (page.hasNext() && (pageable = pageable.next()) != null && page.getNumber() < maxPageSize);
        simpleExcelWriter.param("SUCCESS_SIZE", page.getTotalElements());
    }

    private Page<OrgStruct> excelPage(OrgModel.Request.Query query, Pageable pageable) {
        Specification specification = OrgQueryHelper.querySpecification((OrgModel.Request.Query)query);
        Page page = this.orgStructDao.findAll(specification, pageable, EntityGraphs.named((String)"Org.graph"));
        return page;
    }

    private List<OrgStruct> fillOrg(List<OrgStruct> orgStructList) {
        int partitionSize = orgStructList.size() > ImportExportThreadPool.CORE_POOL_SIZE ? orgStructList.size() / ImportExportThreadPool.CORE_POOL_SIZE : 1;
        ArrayList futureList = new ArrayList();
        List partitionList = ListUtils.partition(orgStructList, (int)partitionSize);
        partitionList.forEach(list -> futureList.add(CompletableFuture.runAsync(() -> this.batchSetExtend((List<OrgStruct>)list), ImportExportThreadPool.get())));
        try {
            CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).get();
            ArrayList<OrgStruct> resultList = new ArrayList<OrgStruct>();
            partitionList.forEach(item -> resultList.addAll((Collection<OrgStruct>)item));
            return resultList;
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("error to async fill org extend:{}", (Object)e.getMessage());
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            logger.error("error to handle query result:{}", (Object)unsupportedOperationException.getMessage());
            throw new IllegalArgumentException(unsupportedOperationException.getMessage());
        }
    }

    private void batchSetExtend(List<OrgStruct> list) {
        list.forEach(org -> {
            if (org != null && org.getOrgId() != null && org.getOrgId() > 0L) {
                List orgCompanyRels = this.orgCompanynoDao.findByOrgId(org.getOrgId().longValue());
                Set companyNos = orgCompanyRels.stream().map(OrgCompanyRel::getCompanyNo).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).collect(Collectors.toSet());
                org.setCompanyNos(companyNos);
                if (OrgType.COMPANY.equals((Object)org.getOrgType())) {
                    org.setCompanyCode(org.getCompanyCode());
                    org.setCompanyName(org.getCompanyName());
                    org.setTaxNum(org.getTaxNum());
                }
            }
        });
    }

    private void writeSheet(SimpleExcelWriter simpleExcelWriter, String sheetName, OrgStruct org) {
        switch (sheetName) {
            case "\u516c\u53f8": {
                if (!OrgType.COMPANY.equals((Object)org.getOrgType())) break;
                logger.info("writeSheet1");
                this.writeSheet1(simpleExcelWriter, sheetName, org);
                break;
            }
            case "\u7ec4\u7ec7": {
                if (org.getOrgType() == null || OrgType.GROUP.equals((Object)org.getOrgType())) break;
                this.writeSheet2(simpleExcelWriter, sheetName, org);
                break;
            }
        }
    }

    private void writeSheet1(SimpleExcelWriter simpleExcelWriter, String sheetName, OrgStruct org) {
        if (org.getCompany() == null) {
            logger.info("org.company = null, return");
            return;
        }
        CompanyExportData row = new CompanyExportData();
        BeanUtils.copyProperties((Object)org.getCompany(), (Object)row);
        simpleExcelWriter.fill(sheetName, Stream.of(row).collect(Collectors.toList()));
    }

    private void writeSheet2(SimpleExcelWriter simpleExcelWriter, String sheetName, OrgStruct org) {
        HashMap<String, Object> row = new HashMap<String, Object>(30);
        BeanUtils.copyProperties((Object)org, row, (String[])((String[])Stream.of("companyNos").toArray(String[]::new)));
        if (org.getParentId() != null && org.getParentId() > 0L) {
            Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                predicates.add(builder.equal((Expression)root.get("orgId"), (Object)org.getParentId()));
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
                return criteriaQuery.getRestriction();
            };
            Optional parentOptional = this.orgStructDao.findOne((Specification)specification);
            parentOptional.ifPresent(orgStruct -> row.put("parentCode", orgStruct.getOrgCode()));
        }
        if (org.getOrgType() != null) {
            row.put("orgType", org.getOrgType().value());
        }
        if (!CollectionUtils.isEmpty((Collection)org.getCompanyNos())) {
            String companyNos = String.join((CharSequence)COMPANYNOS_DELIMITER, org.getCompanyNos());
            row.put("companyNos", companyNos);
        }
        if (OrgType.COMPANY.equals((Object)org.getOrgType())) {
            if (org.getCompanyId() != null) {
                int authSwitch = this.companyExtensionService.getCompanyTerminalSwitch(org.getTenantId(), org.getCompanyId());
                row.put("authSwitch", authSwitch);
            } else {
                row.put("authSwitch", 0);
            }
        }
        simpleExcelWriter.fill(sheetName, Stream.of(row).collect(Collectors.toList()));
    }
}

