/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.CellData;
import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.api.model.OrgModel;
import com.xforceplus.business.company.service.CompanyExtensionService;
import com.xforceplus.business.company.service.CompanyService;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.DataRow;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.ExcelValidator;
import com.xforceplus.business.excel.file.ExcelFileDTO;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.MessageRow;
import com.xforceplus.business.excel.reader.SimpleDataReadListener;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelReaderService;
import com.xforceplus.business.tenant.excel.OrgCompanyExcelImportData;
import com.xforceplus.business.tenant.excel.OrgExcelImportData;
import com.xforceplus.business.tenant.service.OrgService;
import com.xforceplus.business.tenant.service.WrapperOrgService;
import com.xforceplus.config.ImportExportThreadPool;
import com.xforceplus.domain.company.CompanyDto;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.CompanyApply;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.tenant.security.core.domain.OrgType;
import com.xforceplus.utils.BatchUtils;
import io.geewit.core.utils.reflection.BeanUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgExcelImportService
implements ExcelReaderService {
    private static final Logger logger = LoggerFactory.getLogger(OrgExcelImportService.class);
    @Autowired
    private OrgService orgService;
    @Autowired
    private WrapperOrgService wrapperOrgService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private CompanyExtensionService companyExtensionService;
    private static final HashMap<String, Integer> HEADER_MAP = new HashMap(2);

    @Override
    public HashMap<String, Integer> getSheetHeaderNumber() {
        return HEADER_MAP;
    }

    public static <T> AnalysisEventListener<T> listener(final Context context, final Consumer<List<T>> consumer) {
        return new AnalysisEventListener<T>(){
            private List<T> list = new ArrayList();
            private int batchSize = context.getFileDTO() != null ? context.getFileDTO().getBatchSize() : 3000;
            private List<CompletableFuture<Void>> futureList = new ArrayList<CompletableFuture<Void>>();

            public void invoke(T data, AnalysisContext analysisContext) {
                if (data instanceof DataRow) {
                    Long tenantId;
                    ExcelFileDTO importFileDTO;
                    Integer rowIndex = analysisContext.readRowHolder().getRowIndex();
                    ((DataRow)data).setRowIndex(rowIndex);
                    if (data instanceof OrgExcelImportData && (importFileDTO = context.getFileDTO()) != null && (tenantId = importFileDTO.getTenantId()) != null) {
                        ((OrgExcelImportData)data).setTenantId(tenantId);
                    }
                }
                this.list.add(data);
                if (this.list.size() >= this.batchSize) {
                    this.process(this.list);
                }
            }

            public void invokeHead(Map<Integer, CellData> headMap, AnalysisContext analysisContext) {
                context.setHeadMap(analysisContext.readSheetHolder().getSheetName(), headMap);
                super.invokeHead(headMap, analysisContext);
            }

            public void onException(Exception exception, AnalysisContext context2) throws Exception {
                if (this.list.size() > 0) {
                    this.process(this.list);
                }
                super.onException(exception, context2);
            }

            public void doAfterAllAnalysed(AnalysisContext context2) {
                if (this.list.size() > 0) {
                    this.process(this.list);
                }
            }

            private void process(List<T> dataList) {
                ArrayList dataToProcess = new ArrayList(dataList);
                CompletableFuture<Void> future = BatchUtils.doBatchAsync(dataToProcess, this::batchValidate);
                future.get();
                consumer.accept(dataToProcess);
                this.list.clear();
            }

            private void batchValidate(List<T> dataList) {
                dataList.forEach(ExcelValidator::validate);
            }
        };
    }

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.ORG_IMPORT;
    }

    @Override
    public Context importExcel(Context context) {
        List<ExcelSheet> sheets = context.getExcelBook().getExcelSheets();
        ArrayList<OrgExcelImportData> orgDatas = new ArrayList<OrgExcelImportData>();
        ArrayList<OrgCompanyExcelImportData> companyDatas = new ArrayList<OrgCompanyExcelImportData>();
        this.readSheet(context, sheets, orgDatas, companyDatas);
        this.saveOrgData(context, orgDatas, companyDatas);
        return context;
    }

    private void readSheet(Context context, List<ExcelSheet> sheets, List<OrgExcelImportData> orgDatas, List<OrgCompanyExcelImportData> companyDatas) {
        Optional<ExcelSheet> sheet2Optional;
        Optional<ExcelSheet> sheet1Optional = sheets.stream().filter(sheet -> "\u516c\u53f8".equals(sheet.getSheetName())).findAny();
        if (sheet1Optional.isPresent()) {
            this.readSheet1(context, companyDatas);
        }
        if ((sheet2Optional = sheets.stream().filter(sheet -> "\u7ec4\u7ec7".equals(sheet.getSheetName())).findAny()).isPresent()) {
            this.readSheet2(context, orgDatas);
        }
    }

    private void readSheet1(Context context, List<OrgCompanyExcelImportData> companyDatas) {
        Integer headerNumber = HEADER_MAP.get("\u516c\u53f8");
        if (headerNumber == null) {
            headerNumber = 2;
        }
        MessageRow messageRow = new MessageRow("\u516c\u53f8");
        context.messageRow("\u516c\u53f8", messageRow);
        AnalysisEventListener excelReadListener = SimpleDataReadListener.listener(context, rows -> {
            logger.info("consume company data, size:{}", (Object)rows.size());
            for (OrgCompanyExcelImportData row : rows) {
                if (!row.getValidatedStatus().booleanValue()) {
                    logger.debug("\u6570\u636e\u6821\u9a8c\u4e0d\u901a\u8fc7, continue");
                    messageRow.fail(row.getRowIndex(), row.getValidatedMessage());
                    continue;
                }
                companyDatas.add(row);
            }
        });
        context.getSimpleExcelReader().read(OrgCompanyExcelImportData.class, excelReadListener, "\u516c\u53f8", headerNumber);
    }

    private void readSheet2(Context context, List<OrgExcelImportData> orgDatas) {
        Integer headerNumber = HEADER_MAP.get("\u7ec4\u7ec7");
        if (headerNumber == null) {
            headerNumber = 2;
        }
        MessageRow messageRow = new MessageRow("\u7ec4\u7ec7");
        context.messageRow("\u7ec4\u7ec7", messageRow);
        AnalysisEventListener excelReadListener = OrgExcelImportService.listener(context, rows -> {
            logger.info("consume org data, size:{}", (Object)rows.size());
            for (OrgExcelImportData row : rows) {
                if (!row.getValidatedStatus().booleanValue()) {
                    logger.debug("\u6570\u636e\u6821\u9a8c\u4e0d\u901a\u8fc7, continue");
                    messageRow.fail(row.getRowIndex(), row.getValidatedMessage());
                    continue;
                }
                orgDatas.add(row);
            }
        });
        context.getSimpleExcelReader().read(OrgExcelImportData.class, excelReadListener, "\u7ec4\u7ec7", headerNumber);
    }

    public void saveOrgData(Context context, List<OrgExcelImportData> orgDatas, List<OrgCompanyExcelImportData> companyDatas) {
        logger.info("saving org data,company size={},org size={}", (Object)companyDatas.size(), (Object)orgDatas.size());
        HashMap<String, Object> companies = new HashMap<String, Object>(companyDatas.size());
        HashMap<String, Integer> companyRows = new HashMap<String, Integer>(companyDatas.size());
        HashMap<String, OrgCompanyExcelImportData> companyRowData = new HashMap<String, OrgCompanyExcelImportData>(companyDatas.size());
        ArrayList<Triple<String, Integer, Integer>> tripleList = new ArrayList<Triple<String, Integer, Integer>>();
        Map orgExcelImportDataMap = orgDatas.stream().collect(Collectors.toMap(OrgExcelImportData::getTaxNum, Function.identity(), (oldData, newData) -> newData));
        for (OrgCompanyExcelImportData orgCompanyExcelImportData : companyDatas) {
            CompanyApply companyApply;
            if (!orgCompanyExcelImportData.getValidatedStatus().booleanValue()) {
                logger.info("\u516c\u53f8\u6570\u636e\u6821\u9a8c\u4e0d\u901a\u8fc7, continue");
                continue;
            }
            companyRowData.put(orgCompanyExcelImportData.getTaxNum(), orgCompanyExcelImportData);
            if (orgCompanyExcelImportData.isNew().booleanValue()) {
                companyApply = new CompanyApply();
                BeanUtils.copyProperties((Object)orgCompanyExcelImportData, (Object)companyApply, (String[])((String[])Stream.of("company", "companyApply").toArray(String[]::new)));
                companies.put(companyApply.getTaxNum(), companyApply);
                companyRows.put(orgCompanyExcelImportData.getTaxNum(), orgCompanyExcelImportData.getRowIndex());
            } else if (orgCompanyExcelImportData.getCompany() != null) {
                Company company = orgCompanyExcelImportData.getCompany();
                BeanUtils.copyProperties((Object)orgCompanyExcelImportData, (Object)company, (String[])((String[])Stream.of("company", "companyApply").toArray(String[]::new)));
                companies.put(company.getTaxNum(), company);
                companyRows.put(orgCompanyExcelImportData.getTaxNum(), orgCompanyExcelImportData.getRowIndex());
            } else {
                companyApply = orgCompanyExcelImportData.getCompanyApply();
                BeanUtils.copyProperties((Object)orgCompanyExcelImportData, (Object)companyApply, (String[])((String[])Stream.of("company", "companyApply").toArray(String[]::new)));
                companies.put(companyApply.getTaxNum(), companyApply);
                companyRows.put(orgCompanyExcelImportData.getTaxNum(), orgCompanyExcelImportData.getRowIndex());
            }
            String taxNum = orgCompanyExcelImportData.getTaxNum();
            if (orgExcelImportDataMap.containsKey(taxNum)) {
                context.success("\u516c\u53f8", orgCompanyExcelImportData.getRowIndex());
                continue;
            }
            context.messageRow("\u516c\u53f8", orgCompanyExcelImportData.getRowIndex(), "\u516c\u53f8\u7a0e\u53f7\u4e3a\uff1a(" + taxNum + ")\u7684\u516c\u53f8\uff0c\u76f8\u5e94\u5bf9\u5e94\u7ec4\u7ec7\u6821\u9a8c\u6ca1\u6709\u901a\u8fc7\u6216\u6ca1\u6709\u7ec4\u7ec7");
        }
        ArrayList<Pair<OrgModel.Request.Save, Integer>> orgPairs = new ArrayList<Pair>();
        for (OrgExcelImportData orgData : orgDatas) {
            if (!orgData.getValidatedStatus().booleanValue()) {
                logger.info("\u7ec4\u7ec7\u6570\u636e\u6821\u9a8c\u4e0d\u901a\u8fc7, continue");
                continue;
            }
            OrgModel.Request.Save orgSave = new OrgModel.Request.Save();
            CompanyDto companyDto = null;
            if (StringUtils.isNotBlank((CharSequence)orgData.getTaxNum())) {
                Optional<Company> company;
                companyDto = (CompanyDto)companies.get(orgData.getTaxNum());
                if (companyDto == null && (company = this.companyService.findOneByTaxNum(orgData.getTaxNum())).isPresent()) {
                    companyDto = (CompanyDto)company.get();
                    orgSave.setWithApplication(false);
                }
                if (companyDto == null) {
                    context.messageRow("\u7ec4\u7ec7", orgData.getRowIndex(), "\u65b0\u589e\u7ec4\u7ec7\u7a0e\u53f7\u4e0d\u5b58\u5728");
                    continue;
                }
                orgData.setOrgType(OrgType.COMPANY);
                OrgCompanyExcelImportData orgCompanyExcelImportData = (OrgCompanyExcelImportData)companyRowData.get(orgData.getTaxNum());
                if (orgCompanyExcelImportData != null && orgCompanyExcelImportData.isNew().booleanValue()) {
                    orgSave.setWithApplication(true);
                } else {
                    orgSave.setWithApplication(false);
                }
                tripleList.add(Triple.of((Object)orgData.getTaxNum(), (Object)orgData.getRowIndex(), (Object)(orgData.getTerminalAuth() == null ? 1 : orgData.getTerminalAuth())));
            }
            if (!orgData.isNew().booleanValue()) {
                OrgStruct org = orgData.getOrg();
                if (org == null) continue;
                orgSave.setOrgId(org.getOrgId());
                orgSave.setIsAutoBindParentOrgUsers(Boolean.valueOf(false));
            }
            CompanyModel.Request.Save companySave = new CompanyModel.Request.Save();
            BeanUtils.copyProperties((Object)orgData, (Object)orgSave, (String[])((String[])Stream.of("company").toArray(String[]::new)));
            if (companyDto != null) {
                BeanUtils.copyProperties((Object)companyDto, (Object)companySave, (String[])((String[])Stream.of("company").toArray(String[]::new)));
                orgSave.setCompany(companySave);
            }
            orgPairs.add(Pair.of((Object)orgSave, (Object)orgData.getRowIndex()));
            context.success("\u7ec4\u7ec7", orgData.getRowIndex());
        }
        int n = orgPairs.size() > ImportExportThreadPool.CORE_POOL_SIZE ? orgPairs.size() / ImportExportThreadPool.CORE_POOL_SIZE : 1;
        List splistList = ListUtils.partition(orgPairs, (int)n);
        ArrayList futureList = new ArrayList();
        ArrayList setList = new ArrayList();
        splistList.forEach(item -> futureList.add(CompletableFuture.supplyAsync(() -> item.stream().map(Pair::getLeft).filter(org -> this.orgService.findByTenantIdAndOrgCode(org.getTenantId(), org.getOrgCode()).isEmpty()).map(OrgModel.Request.Save::getOrgCode).collect(Collectors.toSet()), ImportExportThreadPool.get())));
        CompletableFuture<Void> future = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0]));
        HashSet savingOrgCode = new HashSet();
        try {
            future.get();
            futureList.forEach(item -> {
                try {
                    Set result = (Set)item.get();
                    savingOrgCode.addAll(result);
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        orgPairs = orgPairs.stream().sorted(Comparator.comparing(pair -> {
            OrgModel.Request.Save save = (OrgModel.Request.Save)pair.getLeft();
            int comparing = 0;
            if (savingOrgCode.stream().anyMatch(code -> code.equals(save.getParentCode()))) {
                --comparing;
            }
            if (savingOrgCode.stream().anyMatch(code -> code.equals(save.getOrgCode()))) {
                --comparing;
            }
            return comparing;
        })).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(orgPairs)) {
            this.asyncSave(orgPairs, context, companyRows, n);
        }
        this.asyncSaveTerminalAuth(tripleList, context.getFileDTO().getTenantId(), context, companyRows, n);
    }

    private void asyncSave(List<Pair<OrgModel.Request.Save, Integer>> orgPairs, Context context, Map<String, Integer> companyRows, int batchSize) {
        List pairList = ListUtils.partition(orgPairs, (int)batchSize);
        ArrayList dtFutureList = new ArrayList();
        pairList.forEach(item -> dtFutureList.add(CompletableFuture.runAsync(() -> this.doBatch((List<Pair<OrgModel.Request.Save, Integer>>)item, context, companyRows), ImportExportThreadPool.get())));
        CompletableFuture.allOf(dtFutureList.toArray(new CompletableFuture[0])).get();
    }

    private void doBatch(List<Pair<OrgModel.Request.Save, Integer>> orgPairs, Context context, Map<String, Integer> companyRows) {
        for (Pair<OrgModel.Request.Save, Integer> savingPair : orgPairs) {
            String message;
            OrgModel.Request.Save save = (OrgModel.Request.Save)savingPair.getLeft();
            Integer rowIndex = (Integer)savingPair.getRight();
            if (save.getOrgId() != null) {
                try {
                    this.wrapperOrgService.save((long)save.getTenantId(), save, true);
                }
                catch (Exception e) {
                    message = "\u7b2c" + rowIndex + "\u884c\u51fa\u9519: " + e.getMessage();
                    logger.warn(message);
                    context.messageRow("\u7ec4\u7ec7", rowIndex, e.getMessage());
                    this.setCompanyErrorMessage(save, companyRows, context);
                }
                continue;
            }
            try {
                this.wrapperOrgService.create(save);
            }
            catch (Exception e) {
                message = "\u7b2c" + rowIndex + "\u884c\u51fa\u9519: " + e.getMessage();
                logger.warn(message);
                context.messageRow("\u7ec4\u7ec7", rowIndex, e.getMessage());
                this.setCompanyErrorMessage(save, companyRows, context);
            }
        }
    }

    private void setCompanyErrorMessage(OrgModel.Request.Save save, Map<String, Integer> params, Context context) {
        if (save.getCompany() == null) {
            return;
        }
        String taxNum = save.getCompany().getTaxNum();
        if (StringUtils.isBlank((CharSequence)taxNum)) {
            return;
        }
        if (!params.containsKey(taxNum)) {
            return;
        }
        Integer rowIndex = params.get(taxNum);
        context.messageRow("\u516c\u53f8", rowIndex, "\u5931\u8d25");
    }

    private void asyncSaveTerminalAuth(List<Triple<String, Integer, Integer>> list, Long tenantId, Context context, Map<String, Integer> companyRows, int batchSize) {
        ArrayList completableFutureList = new ArrayList();
        List partitionList = ListUtils.partition(list, (int)batchSize);
        partitionList.forEach(item -> completableFutureList.add(CompletableFuture.runAsync(() -> this.batchSaveTerminalAuth((List<Triple<String, Integer, Integer>>)item, tenantId, context, companyRows), ImportExportThreadPool.get())));
        try {
            CompletableFuture.allOf(completableFutureList.toArray(new CompletableFuture[0])).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("error to async batch save terminal auth {}", (Object)e.getMessage());
            throw new IllegalArgumentException("\u4fdd\u5b58\u7ec8\u7aef\u9274\u6743\u5931\u8d25");
        }
    }

    private void batchSaveTerminalAuth(List<Triple<String, Integer, Integer>> dataList, Long tenantId, Context context, Map<String, Integer> companyRows) {
        dataList.forEach(item -> {
            block2: {
                try {
                    this.companyExtensionService.setTerminalAuthByTaxNum((String)item.getLeft(), tenantId, (Integer)item.getRight());
                }
                catch (Exception e) {
                    logger.error("save terminal auth error,rowIndex={} taxNum={},message={}", new Object[]{item.getMiddle(), item.getLeft(), e.getMessage()});
                    context.messageRow("\u7ec4\u7ec7", (Integer)item.getMiddle(), e.getMessage());
                    Integer companyIndex = (Integer)companyRows.get(item.getLeft());
                    if (companyIndex == null) break block2;
                    context.messageRow("\u516c\u53f8", companyIndex, "\u7ec8\u7aef\u9274\u6743\u5bfc\u5165\u5931\u8d25");
                }
            }
        });
    }

    static {
        HEADER_MAP.put("\u516c\u53f8", 2);
        HEADER_MAP.put("\u7ec4\u7ec7", 2);
    }
}

