/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.api.model.OrgModel;
import com.xforceplus.api.model.TreeModel;
import com.xforceplus.bo.org.OrgCompanyQueryBo;
import com.xforceplus.bo.org.OrgUserStatisticsQueryBo;
import com.xforceplus.business.company.service.CompanyApplyService;
import com.xforceplus.business.company.service.CompanyService;
import com.xforceplus.business.excel.company.OrgCompanyNumberDTO;
import com.xforceplus.business.messagebus.OrgPubService;
import com.xforceplus.business.org.virtual.service.OrgVirtualOrgStructService;
import com.xforceplus.business.tenant.service.OrgExtensionService;
import com.xforceplus.business.tenant.service.OrgUserService;
import com.xforceplus.business.tenant.service.TenantPolicyService;
import com.xforceplus.dao.CompanyDao;
import com.xforceplus.dao.OrgCompanynoDao;
import com.xforceplus.dao.OrgExtensionDao;
import com.xforceplus.dao.OrgStructDao;
import com.xforceplus.dao.OrgUserRelDao;
import com.xforceplus.dao.OrgVirtualDao;
import com.xforceplus.dao.RoleDao;
import com.xforceplus.dao.RoleUserRelDao;
import com.xforceplus.dao.SettleStepDao;
import com.xforceplus.dao.TenantCompanyRelDao;
import com.xforceplus.dao.TenantDao;
import com.xforceplus.dao.TenantPolicyDao;
import com.xforceplus.dao.UserDao;
import com.xforceplus.domain.org.view.OrgExtraInfo;
import com.xforceplus.domain.validation.ValidationGroup;
import com.xforceplus.dto.org.OrgCompanyDTO;
import com.xforceplus.dto.org.OrgCompanyNoDTO;
import com.xforceplus.dto.org.OrgParentDTO;
import com.xforceplus.dto.org.OrgUserStatisticsDTO;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.CompanyApply;
import com.xforceplus.entity.OrgCompanyRel;
import com.xforceplus.entity.OrgExtension;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.OrgUserRel;
import com.xforceplus.entity.RoleUserRel;
import com.xforceplus.entity.SettleStep;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.User;
import com.xforceplus.query.OrgQueryHelper;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.domain.OrgType;
import com.xforceplus.utils.OrgUtils;
import com.xforceplus.utils.RoleUtils;
import com.xforceplus.utils.excel.ExcelUtils;
import com.xforceplus.utils.excel.exception.ImportException;
import io.geewit.core.utils.enums.BinaryUtils;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.core.utils.tree.TreeUtils;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import io.geewit.utils.uuid.UUIDUtils;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.validation.Valid;
import javax.validation.Validator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;

@Validated
@Service
public class OrgService {
    private static final Logger logger = LoggerFactory.getLogger(OrgService.class);
    private final OrgExtensionService orgExtensionService;
    private final OrgStructDao orgStructDao;
    private final OrgUserRelDao orgUserRelDao;
    private final TenantDao tenantDao;
    @Autowired
    private CompanyDao companyDao;
    private final UserDao userDao;
    private final Validator validator;
    private final CompanyService companyService;
    private final SettleStepDao settleStepDao;
    private final CompanyApplyService companyApplyService;
    private final OrgExtensionDao orgExtensionDao;
    private final OrgCompanynoDao orgCompanynoDao;
    private final OrgVirtualOrgStructService orgVirtualOrgStructService;
    private final TenantPolicyDao tenantPolicyDao;
    @Autowired
    private OrgUserService orgUserService;
    @Autowired
    private OrgVirtualDao orgVirtualDao;
    @Autowired(required=false)
    private OrgPubService orgPubService;
    @Autowired
    private TenantPolicyService tenantPolicyService;
    @Autowired
    private RoleUserRelDao roleUserRelDao;
    @Autowired
    private RoleDao roleDao;
    @Value(value="${xforce.global.grading-managment.enable:true}")
    private boolean globalGradingEnabled;
    private static final String SAVE = "save";
    private static final String DELETE = "delete";
    @Autowired
    private TenantCompanyRelDao tenantCompanyRelDao;

    public OrgService(OrgStructDao orgStructDao, OrgUserRelDao orgUserRelDao, TenantDao tenantDao, UserDao userDao, OrgExtensionService orgExtensionService, Validator validator, CompanyService companyService, SettleStepDao settleStepDao, CompanyApplyService companyApplyService, OrgExtensionDao orgExtensionDao, OrgCompanynoDao orgCompanynoDao, OrgVirtualOrgStructService orgVirtualOrgStructService, TenantPolicyDao tenantPolicyDao) {
        this.orgStructDao = orgStructDao;
        this.orgUserRelDao = orgUserRelDao;
        this.tenantDao = tenantDao;
        this.userDao = userDao;
        this.orgExtensionService = orgExtensionService;
        this.validator = validator;
        this.companyService = companyService;
        this.settleStepDao = settleStepDao;
        this.companyApplyService = companyApplyService;
        this.orgExtensionDao = orgExtensionDao;
        this.orgCompanynoDao = orgCompanynoDao;
        this.orgVirtualOrgStructService = orgVirtualOrgStructService;
        this.tenantPolicyDao = tenantPolicyDao;
    }

    public Page<OrgStruct> page(OrgModel.Request.Query query, Pageable pageable) {
        Page page;
        Object[] orgCodes;
        if (query.getTenantId() != null && query.getTenantId() > 0L && StringUtils.isNotBlank((CharSequence)query.getModules()) && ArrayUtils.isNotEmpty((Object[])(orgCodes = StringUtils.split((String)query.getModules(), (String)",")))) {
            List filteringParentIdsList = this.orgStructDao.findParentIdsByTenantIdAndOrgCodes(query.getTenantId().longValue(), (Collection)Stream.of(orgCodes).collect(Collectors.toSet()));
            query.setFilterParentIds(new HashSet(filteringParentIdsList));
        }
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        try {
            this.buildCurrentQuery(query, authorizedUser);
        }
        catch (InvalidParameterException e) {
            logger.warn(e.getMessage());
            return Page.empty((Pageable)pageable);
        }
        if (query.isTupleSelection()) {
            Page tuples = this.orgStructDao.findTuples(query, pageable);
            List contents = tuples.getContent().stream().map(OrgQueryHelper.tupleMapper((OrgModel.Request.Query)query)).collect(Collectors.toList());
            page = new PageImpl(contents, pageable, tuples.getTotalElements());
        } else {
            Specification specification = OrgQueryHelper.querySpecification((OrgModel.Request.Query)query);
            page = this.orgStructDao.findAll(specification, pageable);
        }
        List<OrgStruct> contents = this.fillOrgExtend(page.getContent(), query);
        return new PageImpl(contents, pageable, page.getTotalElements());
    }

    public List<OrgStruct> list(OrgModel.Request.Query query, Sort sort) {
        List<OrgStruct> list;
        Object[] orgCodes;
        if (query.getTenantId() != null && query.getTenantId() > 0L && StringUtils.isNotBlank((CharSequence)query.getModules()) && ArrayUtils.isNotEmpty((Object[])(orgCodes = StringUtils.split((String)query.getModules(), (String)",")))) {
            Set<Object> filterParentIds;
            List filteringParentIdsList = this.orgStructDao.findParentIdsByTenantIdAndOrgCodes(query.getTenantId().longValue(), (Collection)Stream.of(orgCodes).collect(Collectors.toSet()));
            if (query.getFilterParentIds() == null || query.getFilterParentIds().isEmpty()) {
                filterParentIds = new HashSet(filteringParentIdsList);
            } else {
                filterParentIds = query.getFilterParentIds();
                if (filteringParentIdsList != null && !filteringParentIdsList.isEmpty()) {
                    filterParentIds = filterParentIds.stream().filter(i -> filteringParentIdsList.stream().anyMatch(p -> p.equals(i))).collect(Collectors.toSet());
                }
            }
            query.setFilterParentIds(filterParentIds);
        }
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        try {
            this.buildCurrentQuery(query, authorizedUser);
        }
        catch (InvalidParameterException e) {
            return Collections.emptyList();
        }
        if (query.isTupleSelection()) {
            List tuples = this.orgStructDao.findTuples(query, sort);
            list = tuples.stream().map(OrgQueryHelper.tupleMapper((OrgModel.Request.Query)query)).collect(Collectors.toList());
        } else {
            Specification specification = OrgQueryHelper.querySpecification((OrgModel.Request.Query)query);
            list = this.orgStructDao.findAll(specification, sort, EntityGraphs.named((String)"Org.graph"));
        }
        list = this.fillOrgExtend(list, query);
        return list;
    }

    public List<OrgStruct> roots(OrgModel.Request.Query query) {
        query.setRootOrg(Boolean.valueOf(true));
        query.setStatus(Integer.valueOf(1));
        query.setWithChildrenCount(Boolean.valueOf(true));
        query.setWithUserBoundFlag(Boolean.valueOf(true));
        List<OrgStruct> roots = this.list(query, Sort.unsorted());
        return roots;
    }

    private void buildLazyLoadCurrentQuery(OrgModel.Request.Query query) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Long tenantId = authorizedUser.getTenantId();
        query.setTenantId(tenantId);
        Set treeAttributes = Stream.of("orgId", "orgName", "parentId", "orgType").collect(Collectors.toSet());
        if (query.getAttributes() == null || query.getAttributes().isEmpty()) {
            query.setAttributes(treeAttributes);
        } else {
            query.getAttributes().addAll(treeAttributes);
        }
        query.setStatus(Integer.valueOf(1));
        if (query.getRootOrg() == null || !query.getRootOrg().booleanValue()) {
            Long userId = authorizedUser.getId();
            query.setUserId(userId);
            Set filterParentIds = this.orgStructDao.findParentIdsByTenantIdAndUserId(tenantId.longValue(), userId.longValue());
            if (query.getFilterParentIds() != null && !query.getFilterParentIds().isEmpty() && filterParentIds != null && !filterParentIds.isEmpty()) {
                Set filterParentIdsSet = filterParentIds;
                filterParentIds = query.getFilterParentIds().stream().filter(i -> filterParentIdsSet.stream().anyMatch(p -> p.equals(i))).collect(Collectors.toSet());
            }
            filterParentIds = OrgUtils.compressParentIdsCollection((Collection)filterParentIds);
            query.setFilterParentIds(filterParentIds);
        }
        this.buildFilterParentIds(query, authorizedUser);
    }

    public List<OrgStruct> lazyLoadCurrentUserOrgTrees(OrgModel.Request.Query query) {
        query.setTree(true);
        query.setWithChildrenCount(Boolean.valueOf(true));
        this.buildLazyLoadCurrentQuery(query);
        List list = this.orgStructDao.findAttributes(query, Sort.unsorted());
        return list;
    }

    public List<OrgStruct> lazyLoadCurrentUserOrgRoots(OrgModel.Request.Query query) {
        query.setRootOrg(Boolean.valueOf(true));
        query.setTree(true);
        query.setWithChildrenCount(Boolean.valueOf(true));
        int status = query.getStatus() == null ? 1 : query.getStatus();
        query.setStatus(Integer.valueOf(status));
        this.buildLazyLoadCurrentQuery(query);
        List<OrgStruct> list = this.orgStructDao.findAttributes(query, Sort.unsorted());
        list = this.fillOrgExtend(list, query);
        return list;
    }

    public List<OrgStruct> lazyLoadCurrentUserOrgChildren(OrgModel.Request.Query query) {
        query.setTree(true);
        query.setWithChildrenCount(Boolean.valueOf(true));
        this.buildLazyLoadCurrentQuery(query);
        List<OrgStruct> list = this.orgStructDao.findAttributes(query, Sort.unsorted());
        list = this.fillOrgExtend(list, query);
        return list;
    }

    public List<OrgStruct> lazyLoadCurrentUserOrgDescendants(OrgModel.Request.TreeQuery treeQuery) {
        Set<Object> excludeParentIds;
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setTenantId(treeQuery.getTenantId());
        query.setTree(true);
        query.setOrgNameLike(treeQuery.getOrgName());
        query.setWithChildrenCount(treeQuery.getWithChildrenCount());
        query.setWithUserBoundFlag(treeQuery.getWithUserBound());
        if (treeQuery.getRootId() != null && treeQuery.getRootId() > 0L) {
            String parentIds2 = this.orgStructDao.findParentIdsByOrgId(treeQuery.getRootId().longValue());
            query.setParentIds(parentIds2);
            excludeParentIds = OrgUtils.findOrgIdInParentIds((String)parentIds2).stream().filter(id -> !id.equals(treeQuery.getRootId())).collect(Collectors.toSet());
        } else {
            excludeParentIds = new HashSet();
        }
        Set treeAttributes = Stream.of("orgId", "orgName", "orgType", "parentId", "parentIds").collect(Collectors.toSet());
        if (query.getAttributes() == null || query.getAttributes().isEmpty()) {
            query.setAttributes(treeAttributes);
        } else {
            query.getAttributes().addAll(treeAttributes);
        }
        this.buildLazyLoadCurrentQuery(query);
        List<OrgStruct> list = this.orgStructDao.findAttributes(query, Sort.unsorted());
        Set parentIdsSet = list.stream().map(OrgStruct::getParentIds).collect(Collectors.toSet());
        Set loadedOrgIds = list.stream().map(OrgStruct::getOrgId).collect(Collectors.toSet());
        excludeParentIds.addAll(loadedOrgIds);
        Set orgIds = parentIdsSet.stream().map(parentIds -> OrgUtils.findOrgIdInParentIds((String)parentIds)).flatMap(Collection::stream).filter(id -> excludeParentIds.stream().noneMatch(excludeParentId -> excludeParentId.equals(id))).collect(Collectors.toSet());
        if (orgIds != null && !orgIds.isEmpty()) {
            query = new OrgModel.Request.Query();
            query.setTenantId(treeQuery.getTenantId());
            query.setOrgIds(orgIds);
            query.setAttributes(treeAttributes);
            query.setWithChildrenCount(treeQuery.getWithChildrenCount());
            query.setWithUserBoundFlag(treeQuery.getWithUserBound());
            query.setTree(true);
            List parentOrgs = this.orgStructDao.findAttributes(query, Sort.unsorted());
            list.addAll(parentOrgs);
        }
        list = this.fillOrgExtend(list, query);
        return list;
    }

    private void buildFilterParentIds(OrgModel.Request.Query query, IAuthorizedUser authorizedUser) {
        if (authorizedUser == null) {
            return;
        }
        boolean tenantGradingEnabled = this.tenantPolicyService.tenantGradingManagementEnabled(authorizedUser.getTenantId());
        if (this.globalGradingEnabled && tenantGradingEnabled) {
            Set<Object> filterParentIds;
            Set roles = authorizedUser.getRoles();
            Triple<Boolean, Set<Long>, Set<Long>> adminAndGradingRoles = RoleUtils.calcAdminAndGradingRoles(authorizedUser);
            boolean isAdmin = (Boolean)adminAndGradingRoles.getLeft();
            Set gradingRoleIds = (Set)adminAndGradingRoles.getMiddle();
            Set orgRoleIds = (Set)adminAndGradingRoles.getRight();
            if (orgRoleIds != null && !orgRoleIds.isEmpty()) {
                Set orgIds = this.roleUserRelDao.findOrgIdsByTenantIdAndRoleIdsAndType(authorizedUser.getTenantId().longValue(), (Collection)orgRoleIds);
                filterParentIds = this.orgStructDao.findParentIdsByTenantIdAndOrgIds(authorizedUser.getTenantId().longValue(), (Collection)orgIds);
            } else {
                filterParentIds = new HashSet();
            }
            if (gradingRoleIds != null && !gradingRoleIds.isEmpty()) {
                List gradingOrgParentIdsList = this.orgStructDao.listParentIdsByGradingRoleIds((Collection)gradingRoleIds);
                filterParentIds.addAll(gradingOrgParentIdsList);
            }
            if (query.getFilterParentIds() != null && !query.getFilterParentIds().isEmpty() && filterParentIds != null && !filterParentIds.isEmpty()) {
                Set filterParentIdsSet = filterParentIds;
                filterParentIds = query.getFilterParentIds().stream().filter(i -> filterParentIdsSet.stream().anyMatch(p -> p.equals(i))).collect(Collectors.toSet());
            }
            if (filterParentIds != null && !filterParentIds.isEmpty()) {
                query.setFilterParentIds(filterParentIds);
            } else if (!isAdmin) {
                throw new InvalidParameterException("\u975e\u7ba1\u7406\u5458\u8eab\u4efd, \u8fd4\u56de\u7a7a\u5217\u8868");
            }
        }
    }

    public void buildCurrentQuery(OrgModel.Request.Query query, IAuthorizedUser authorizedUser) {
        if (authorizedUser == null) {
            return;
        }
        this.buildFilterParentIds(query, authorizedUser);
        String modules = authorizedUser.getModules();
        query.setModules(modules);
    }

    private List<OrgStruct> fillOrgExtend(List<OrgStruct> orgs, OrgModel.Request.Query query) {
        if (orgs == null || orgs.isEmpty()) {
            return orgs;
        }
        ArrayList<OrgStruct> result = new ArrayList<OrgStruct>(orgs.size());
        boolean enableUserCount = false;
        boolean enableParentName = false;
        boolean enableExtensions = false;
        boolean enableCompanyNos = false;
        boolean enableParentOrgs = false;
        boolean enableChildrenCount = (Boolean)ObjectUtils.defaultIfNull((Object)query.getWithChildrenCount(), (Object)false);
        if (StringUtils.isNotBlank((CharSequence)query.getWithExtendParams())) {
            String[] withExtendParamsArray;
            for (String withExtendParam : withExtendParamsArray = StringUtils.split((String)query.getWithExtendParams(), (String)",")) {
                if ("userCount".equalsIgnoreCase(withExtendParam)) {
                    enableUserCount = true;
                    continue;
                }
                if ("parentName".equalsIgnoreCase(withExtendParam)) {
                    enableParentName = true;
                    continue;
                }
                if ("extensions".equalsIgnoreCase(withExtendParam)) {
                    enableExtensions = true;
                    continue;
                }
                if ("companyNos".equalsIgnoreCase(withExtendParam)) {
                    enableCompanyNos = true;
                    continue;
                }
                if ("parentOrgs".equalsIgnoreCase(withExtendParam)) {
                    enableParentOrgs = true;
                    continue;
                }
                if (enableChildrenCount || !"childrenCount".equalsIgnoreCase(withExtendParam)) continue;
                enableChildrenCount = true;
            }
        }
        HashSet<Long> orgIds = new HashSet<Long>(orgs.size());
        HashSet<Long> companyIds = new HashSet<Long>();
        HashSet<Long> tenantIds = new HashSet<Long>();
        Map<Object, Object> orgUserStatisticsDTOMap = Collections.emptyMap();
        Map<Object, Object> orgParentDTOMap = Collections.emptyMap();
        HashMap orgCompanyNoMap = new HashMap();
        Map<Object, Object> orgExtensionMap = Collections.emptyMap();
        Map<Object, Object> childrenCountMaps = Collections.emptyMap();
        HashSet<Long> orgParentIds = new HashSet<Long>(orgs.size());
        Map companyMap = Collections.emptyMap();
        boolean hasCompanyLoaded = false;
        Map tenantMap = Collections.emptyMap();
        boolean hasTenantLoaded = false;
        for (OrgStruct orgStruct : orgs) {
            orgIds.add(orgStruct.getOrgId());
            orgParentIds.add(orgStruct.getParentId());
            if (query.isTree()) continue;
            hasTenantLoaded |= orgStruct.isTenantLoaded();
            if (orgStruct.getTenantId() != null && orgStruct.getTenantId() > 0L) {
                tenantIds.add(orgStruct.getTenantId());
            }
            hasCompanyLoaded |= orgStruct.isCompanyLoaded();
            if (!OrgType.COMPANY.equals((Object)orgStruct.getOrgType()) || orgStruct.getCompanyId() == null || orgStruct.getCompanyId() <= 0L) continue;
            companyIds.add(orgStruct.getCompanyId());
        }
        if (enableUserCount) {
            orgUserStatisticsDTOMap = this.findOrgUserStatisticsByOrgIds(orgIds);
        }
        if (enableParentName) {
            orgParentDTOMap = this.findOrgParentNameByOrgParentIds(orgParentIds);
        }
        if (enableExtensions) {
            orgExtensionMap = this.findOrgExtensionByOrgIds(orgIds);
        }
        if (enableChildrenCount) {
            List childrenCountPairs = this.orgStructDao.findChildrenCountMapsByOrgIds(orgIds);
            childrenCountMaps = childrenCountPairs.stream().collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        }
        if (enableCompanyNos) {
            List companyNosPairs = this.orgCompanynoDao.findCompanyNosPairsByOrgIds(orgIds);
            for (Pair pair : companyNosPairs) {
                if (orgCompanyNoMap.containsKey(pair.getLeft())) {
                    Set companyNos = (Set)orgCompanyNoMap.get(pair.getLeft());
                    if (companyNos == null) {
                        companyNos = Stream.of(pair.getRight()).collect(Collectors.toSet());
                    } else {
                        companyNos.add(pair.getRight());
                    }
                    orgCompanyNoMap.put(pair.getLeft(), companyNos);
                    continue;
                }
                orgCompanyNoMap.put(pair.getLeft(), Stream.of(pair.getRight()).collect(Collectors.toSet()));
            }
        }
        if (!hasTenantLoaded && tenantIds != null && !tenantIds.isEmpty()) {
            tenantMap = this.tenantDao.findTenantMapByTenantIds(tenantIds);
        }
        if (!hasCompanyLoaded && companyIds != null && !companyIds.isEmpty()) {
            companyMap = this.companyDao.findCompanyMapByCompanyIds(companyIds);
        }
        for (OrgStruct orgStruct : orgs) {
            Tenant tenant;
            Company company;
            if (orgStruct == null || orgStruct.getOrgId() == null || orgStruct.getOrgId() <= 0L) continue;
            OrgStruct resultOrg = new OrgStruct();
            Set ignoreProperties = Stream.of("companyNos", "gradingRole", "defaultOrgRole", "orgUserRels").collect(Collectors.toSet());
            if (!hasCompanyLoaded) {
                ignoreProperties.add("company");
            }
            if (!hasTenantLoaded) {
                ignoreProperties.add("tenant");
            }
            BeanUtils.copyProperties((Object)orgStruct, (Object)resultOrg, (String[])((String[])ignoreProperties.stream().toArray(String[]::new)));
            if (enableUserCount) {
                if (orgUserStatisticsDTOMap.containsKey(orgStruct.getOrgId())) {
                    resultOrg.setUserCount((Long)orgUserStatisticsDTOMap.get(orgStruct.getOrgId()));
                } else {
                    resultOrg.setUserCount(Long.valueOf(0L));
                }
            }
            if (enableChildrenCount) {
                if (childrenCountMaps.containsKey(orgStruct.getOrgId())) {
                    resultOrg.setChildrenCount((Long)childrenCountMaps.get(orgStruct.getOrgId()));
                } else {
                    resultOrg.setChildrenCount(Long.valueOf(0L));
                }
            }
            if (enableParentName) {
                if (orgStruct.getParentId() != null && orgStruct.getParentId() > 0L && orgParentDTOMap.containsKey(orgStruct.getParentId())) {
                    resultOrg.setParentName((String)orgParentDTOMap.get(orgStruct.getParentId()));
                } else {
                    resultOrg.setParentName("");
                }
            }
            if (enableExtensions) {
                if (orgExtensionMap.containsKey(orgStruct.getOrgId())) {
                    List extentions = (List)orgExtensionMap.get(orgStruct.getOrgId());
                    resultOrg.setExtensions(new HashSet(extentions));
                } else {
                    resultOrg.setExtensions(Collections.emptySet());
                }
            }
            if (enableParentOrgs) {
                Set parentOrgIds = OrgUtils.findOrgIdInParentIds((String)orgStruct.getParentIds());
                ArrayList<OrgStruct> parentOrgs = new ArrayList<OrgStruct>();
                for (Long parentOrgId : parentOrgIds) {
                    OrgStruct parentOrg;
                    Optional<OrgStruct> orgOptional = orgs.stream().filter(o -> o.getOrgId().equals(parentOrgId)).findAny();
                    if (orgOptional.isPresent()) {
                        parentOrg = new OrgStruct();
                        BeanUtils.copyProperties((Object)orgOptional.get(), (Object)parentOrg, (String[])((String[])Stream.of("parentOrgs", "children").toArray(String[]::new)));
                        parentOrgs.add(parentOrg);
                        continue;
                    }
                    parentOrg = this.findById(parentOrgId, 0);
                    if (parentOrg == null) continue;
                    parentOrgs.add(parentOrg);
                }
                resultOrg.setParentOrgs(parentOrgs);
            }
            if (enableCompanyNos) {
                if (orgCompanyNoMap.containsKey(orgStruct.getOrgId())) {
                    Set companyNos = (Set)orgCompanyNoMap.get(orgStruct.getOrgId());
                    resultOrg.setCompanyNos(companyNos);
                } else {
                    resultOrg.setCompanyNos(Collections.emptySet());
                }
            }
            if (!hasCompanyLoaded && OrgType.COMPANY.equals((Object)orgStruct.getOrgType()) && orgStruct.getCompanyId() != null && orgStruct.getCompanyId() > 0L && (company = (Company)companyMap.get(orgStruct.getCompanyId())) != null) {
                resultOrg.setCompany(company);
            }
            if (!hasTenantLoaded && orgStruct.getTenantId() != null && orgStruct.getTenantId() > 0L && (tenant = (Tenant)tenantMap.get(orgStruct.getTenantId())) != null) {
                resultOrg.setTenant(tenant);
            }
            result.add(resultOrg);
        }
        return result;
    }

    public Map<Long, List<OrgExtension>> findOrgExtensionByOrgIds(Collection<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.emptyMap();
        }
        List orgExtensionList = this.orgExtensionDao.findByOrgIds(orgIds);
        return orgExtensionList.stream().collect(Collectors.groupingBy(OrgExtension::getOrgStructId));
    }

    public Map<Long, Set<String>> findOrgCompanyNosByOrgIds(List<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.emptyMap();
        }
        List list = this.orgCompanynoDao.findByOrgIds(orgIds);
        return list.stream().filter(e -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{e.getCompanyNo()})).collect(Collectors.groupingBy(OrgCompanyRel::getOrgStructId, Collectors.mapping(OrgCompanyRel::getCompanyNo, Collectors.toSet())));
    }

    public Map<Long, String> findOrgParentNameByOrgParentIds(Set<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.emptyMap();
        }
        List list = this.orgStructDao.findOrgParentByOrgIds(orgIds);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyMap();
        }
        return list.stream().collect(Collectors.toMap(OrgParentDTO::getOrgId, OrgParentDTO::getOrgName));
    }

    public Map<Long, Long> findOrgUserStatisticsByOrgIds(Set<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.emptyMap();
        }
        OrgUserStatisticsQueryBo queryBo = new OrgUserStatisticsQueryBo();
        queryBo.setOrgIds(orgIds);
        List list = this.orgStructDao.findUserStatisticsByOrgIds(queryBo);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyMap();
        }
        return list.stream().collect(Collectors.toMap(OrgUserStatisticsDTO::getOrgId, OrgUserStatisticsDTO::getUserTotalNum));
    }

    public Page<OrgStruct> page(Specification<OrgStruct> specification, Pageable pageable) {
        return this.orgStructDao.findAll(specification, pageable, EntityGraphs.named((String)"Org.graph"));
    }

    public List<OrgStruct> findByTaxNumAndCompanyIdAndTenantId(String taxNum, Long companyId, Long tenantId, Long orgId, String tenantCode, boolean withHost, Boolean hostTenantOnly, Integer status) {
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setTaxNum(taxNum);
        query.setCompanyId(companyId);
        query.setWithIsHost(Boolean.valueOf(withHost));
        query.setOrgId(orgId);
        if (tenantId != null && tenantId > 0L) {
            query.setTenantId(tenantId);
            query.setTenantCode(null);
        } else if (StringUtils.isNotBlank((CharSequence)tenantCode)) {
            tenantId = this.tenantDao.findTenantIdByTenantCode(tenantCode);
            query.setTenantId(tenantId);
            query.setTenantCode(null);
        }
        if (status != null) {
            query.setStatus(status);
        }
        query.setAttributes(Stream.of("org", "company", "tenant").collect(Collectors.toSet()));
        List<OrgStruct> orgs = this.list(query, Sort.unsorted());
        return orgs;
    }

    public Optional<OrgStruct> findOne(OrgModel.Request.Query query) {
        Specification specification = OrgQueryHelper.queryOneSpecification((OrgModel.Request.Query)query);
        return this.orgStructDao.findOne(specification);
    }

    public List<OrgModel.Response.CmsTenantCompany> listFromCms(String tenantId, String taxNum) {
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        if (!StringUtils.isEmpty((CharSequence)tenantId)) {
            query.setTenantId(Long.valueOf(tenantId));
        }
        if (!StringUtils.isEmpty((CharSequence)taxNum)) {
            query.setTaxNum(taxNum);
        }
        query.setOrgType(OrgType.COMPANY.name());
        query.setStatus(Integer.valueOf(1));
        ArrayList<OrgModel.Response.CmsTenantCompany> companyRelList = new ArrayList<OrgModel.Response.CmsTenantCompany>();
        Specification specification = OrgQueryHelper.querySpecification((OrgModel.Request.Query)query);
        List list = this.orgStructDao.findAll(specification, EntityGraphs.named((String)"Org.graph"));
        for (OrgStruct org : list) {
            OrgModel.Response.CmsTenantCompany companyRelDto = new OrgModel.Response.CmsTenantCompany();
            companyRelDto.setCompanyName(org.getCompanyName());
            companyRelDto.setTaxNo(org.getTaxNum());
            companyRelDto.setCompanyCode(org.getCompanyCode());
            companyRelDto.setTenantName(org.getTenantName());
            companyRelDto.setTenantCode(org.getTenantCode());
            if (CollectionUtils.isNotEmpty((Collection)org.getCompanyNos())) {
                companyRelDto.setCompanyNo((String)org.getCompanyNos().stream().findFirst().orElse(null));
            }
            companyRelList.add(companyRelDto);
        }
        return companyRelList;
    }

    public Long countByTenantIdAndOrgCode(long tenantId, String orgCode) {
        long orgCodeCount = this.orgStructDao.countByTenantIdAndOrgCode(tenantId, orgCode);
        return orgCodeCount;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public OrgStruct create(@Valid OrgModel.Request.Save model) {
        Optional SettleStepEntity;
        long countGradingRoleId;
        long countDefaultOrgRoleId;
        long orgCodeCount;
        logger.info("unique:{},application:{}", (Object)model.getUniqueCompany(), (Object)model.isWithApplication());
        Long tenantId = model.getTenantId();
        List tenantPolicies = this.tenantPolicyDao.findPoliciesByTenantIdAndName(tenantId.longValue(), "createCompanyAudit");
        if (!tenantPolicies.isEmpty()) {
            String policy = (String)tenantPolicies.stream().findFirst().get();
            boolean withApplication = "1".equals(policy);
            model.setWithApplication(withApplication);
        }
        if ((model.getOrgId() == null || model.getOrgId() == 0L) && StringUtils.isNotEmpty((CharSequence)model.getOrgCode()) && (orgCodeCount = this.countByTenantIdAndOrgCode(tenantId, model.getOrgCode()).longValue()) > 0L) {
            throw new IllegalArgumentException("orgCode (" + model.getOrgCode() + ") \u5df2\u7ecf\u5b58\u5728");
        }
        if (model.getUniqueCompany() == null) {
            model.setUniqueCompany(Boolean.valueOf(true));
        }
        if (StringUtils.isBlank((CharSequence)model.getOrgCode())) {
            model.setOrgCode(UUIDUtils.randomUUID());
        }
        if (model.getOrgType() == null && model.getCompany() != null && StringUtils.isNotBlank((CharSequence)model.getCompany().getCompanyName()) && StringUtils.isNotBlank((CharSequence)model.getCompany().getTaxNum())) {
            model.setOrgType(OrgType.COMPANY);
        }
        if (OrgType.COMPANY.equals((Object)model.getOrgType())) {
            this.validCompany(model.getCompany());
        }
        if (OrgType.COMPANY.equals((Object)model.getOrgType()) && model.getUniqueCompany().booleanValue() && model.getCompany() != null) {
            Optional<CompanyApply> optional;
            if (model.isWithApplication() && (optional = this.companyApplyService.findByTenantIdAndTaxNum(model.getTenantId(), model.getCompany().getTaxNum())).isPresent()) {
                String message = "\u7a0e\u53f7\u4e3a:" + model.getCompany().getTaxNum() + "\u516c\u53f8\u5df2\u7533\u8bf7\uff0c\u5f85\u5ba1\u6279";
                throw new IllegalArgumentException(message);
            }
            Optional companyOptional = this.orgStructDao.findByTenantIdAndTaxNum(model.getTenantId().longValue(), model.getCompany().getTaxNum());
            if (companyOptional.isPresent()) {
                String message = "\u7a0e\u53f7\u4e3a:" + model.getCompany().getTaxNum() + "\u516c\u53f8\u5728\u79df\u6237\u5185\u5df2\u5b58\u5728";
                throw new IllegalArgumentException(message);
            }
        }
        if (model.getDefaultOrgRoleId() != null && (countDefaultOrgRoleId = this.roleDao.countRoleByTenantIdAndIdAndType(model.getTenantId().longValue(), model.getDefaultOrgRoleId().longValue(), 2)) == 0L) {
            throw new IllegalArgumentException("\u6307\u5b9a\u7684\u9ed8\u8ba4\u7ec4\u7ec7\u89d2\u8272(id:" + model.getDefaultOrgRoleId() + ")\u4e0d\u5b58\u5728");
        }
        if (model.getGradingRoleId() != null && (countGradingRoleId = this.roleDao.countRoleByTenantIdAndIdAndType(model.getTenantId().longValue(), model.getGradingRoleId().longValue(), 1)) == 0L) {
            throw new IllegalArgumentException("\u6307\u5b9a\u7684\u5206\u7ea7\u7ba1\u7406\u5458\u89d2\u8272(id:" + model.getGradingRoleId() + ")\u4e0d\u5b58\u5728");
        }
        OrgStruct orgStructEntity = new OrgStruct();
        BeanUtils.copyProperties((Object)model, (Object)orgStructEntity, (String[])((String[])Stream.of("company", "tenant", "companyNos", "extensions").toArray(String[]::new)));
        boolean isOverwrite = true;
        logger.info("create Org, isOverwrite = true");
        Company company = null;
        if (OrgType.COMPANY.equals((Object)model.getOrgType()) && model.getCompany() == null) {
            throw new IllegalArgumentException("\u7c7b\u578b\u4e3a\u516c\u53f8\u7684\u7ec4\u7ec7\u9700\u8981\u8f93\u5165\u516c\u53f8\u4fe1\u606f");
        }
        if (OrgType.COMPANY.equals((Object)model.getOrgType()) && !model.isWithApplication() && (company = this.saveCompany((long)orgStructEntity.getTenantId(), model, isOverwrite)) != null) {
            orgStructEntity.setCompanyId(company.getCompanyId());
        }
        model.setIsAutoBindParentOrgUsers(Boolean.TRUE);
        orgStructEntity = this.saveOrgStructEntity(model, orgStructEntity, company);
        orgStructEntity = this.saveAndFlush(orgStructEntity);
        if (model.isWithApplication() && model.getCompany() != null && OrgType.COMPANY.equals((Object)model.getOrgType())) {
            try {
                this.companyApplyService.apply(orgStructEntity.getTenantId(), orgStructEntity.getOrgId(), model.getCompany());
            }
            catch (Exception e) {
                String message = "\u7a0e\u53f7\u4e3a:" + model.getCompany().getTaxNum() + "\u516c\u53f8\u5df2\u7533\u8bf7\uff0c\u5f85\u5ba1\u6279";
                logger.warn(e.getMessage() + "," + message, (Throwable)e);
                throw new IllegalArgumentException(message);
            }
        }
        if (company != null && !(SettleStepEntity = this.settleStepDao.findByTaxNum(company.getTaxNum())).isPresent()) {
            SettleStep settleStep = new SettleStep();
            settleStep.setFlowId(Long.valueOf(0L));
            settleStep.setCompanyName(company.getCompanyName());
            settleStep.setTaxNum(company.getTaxNum());
            settleStep.setStepStatus(Integer.valueOf(0));
            settleStep.setParamsJson("");
            settleStep.setTemplateCode("");
            settleStep.setTenantId(model.getTenantId());
            this.settleStepDao.saveAndFlush((Object)settleStep);
        }
        if (OrgType.COMPANY.equals((Object)orgStructEntity.getOrgType()) && CollectionUtils.isNotEmpty((Collection)model.getCompanyNos())) {
            this.companyService.saveCompanyNos(orgStructEntity.getOrgId(), model.getCompanyNos(), model.isOverwrite());
        }
        OrgStruct result = new OrgStruct();
        BeanUtils.copyProperties((Object)orgStructEntity, (Object)result);
        if (company != null) {
            result.setCompany(company);
        }
        if (CollectionUtils.isNotEmpty((Collection)model.getCompanyNos())) {
            result.setCompanyNos(model.getCompanyNos());
        }
        if (CollectionUtils.isNotEmpty((Collection)model.getExtensions())) {
            Set<OrgExtension> extensions = this.orgExtensionService.batchSave(orgStructEntity.getOrgId(), model.getExtensions(), isOverwrite);
            Set extensionDtos = extensions.stream().filter(Objects::nonNull).collect(Collectors.toSet());
            result.setExtensions(extensionDtos);
        }
        return result;
    }

    private void validCompany(CompanyModel.Request.Save company) {
        if (company == null) {
            return;
        }
        Assert.hasText((String)company.getCompanyName(), (String)"\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)company.getTaxNum(), (String)"\u516c\u53f8\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public OrgStruct createAsync(@Valid OrgModel.Request.Save model) {
        Optional SettleStepEntity;
        OrgStruct orgStructEntity = new OrgStruct();
        BeanUtils.copyProperties((Object)model, (Object)orgStructEntity, (String[])((String[])Stream.of("company", "tenant", "companyNos", "extensions").toArray(String[]::new)));
        boolean isOverwrite = true;
        Boolean isAutoBindParentOrgUsers = Boolean.TRUE;
        logger.info("create Org, isOverwrite = true");
        Company company = null;
        if (OrgType.COMPANY.equals((Object)model.getOrgType()) && model.getCompany() == null) {
            throw new IllegalArgumentException("\u7c7b\u578b\u4e3a\u516c\u53f8\u7684\u7ec4\u7ec7\u9700\u8981\u8f93\u5165\u516c\u53f8\u4fe1\u606f");
        }
        if (OrgType.COMPANY.equals((Object)model.getOrgType()) && !model.isWithApplication() && (company = this.saveCompany((long)orgStructEntity.getTenantId(), model, isOverwrite)) != null) {
            orgStructEntity.setCompanyId(company.getCompanyId());
        }
        if (model.isWithApplication() && model.getCompany() != null) {
            this.companyApplyService.apply(orgStructEntity.getTenantId(), orgStructEntity.getOrgId(), model.getCompany());
        }
        orgStructEntity = this.saveOrgStructEntity(model, orgStructEntity, company);
        orgStructEntity = this.saveAndFlush(orgStructEntity);
        logger.info("isAutoBindParentOrgUsers = {}", (Object)isAutoBindParentOrgUsers);
        if (isAutoBindParentOrgUsers.booleanValue()) {
            this.orgUserService.autoBindUsers(orgStructEntity.getTenantId(), orgStructEntity.getOrgId());
        }
        if (company != null && !(SettleStepEntity = this.settleStepDao.findByTaxNum(company.getTaxNum())).isPresent()) {
            SettleStep settleStep = new SettleStep();
            settleStep.setFlowId(Long.valueOf(0L));
            settleStep.setCompanyName(company.getCompanyName());
            settleStep.setTaxNum(company.getTaxNum());
            settleStep.setStepStatus(Integer.valueOf(0));
            settleStep.setParamsJson("");
            settleStep.setTemplateCode("");
            settleStep.setTenantId(model.getTenantId());
            this.settleStepDao.saveAndFlush((Object)settleStep);
        }
        if (OrgType.COMPANY.equals((Object)orgStructEntity.getOrgType()) && CollectionUtils.isNotEmpty((Collection)model.getCompanyNos())) {
            this.companyService.saveCompanyNos(orgStructEntity.getOrgId(), model.getCompanyNos(), model.isOverwrite());
        }
        OrgStruct result = new OrgStruct();
        BeanUtils.copyProperties((Object)orgStructEntity, (Object)result);
        if (company != null) {
            result.setCompany(company);
        }
        if (CollectionUtils.isNotEmpty((Collection)model.getCompanyNos())) {
            result.setCompanyNos(model.getCompanyNos());
        }
        if (CollectionUtils.isNotEmpty((Collection)model.getExtensions())) {
            Set<OrgExtension> extensions = this.orgExtensionService.batchSave(orgStructEntity.getOrgId(), model.getExtensions(), isOverwrite);
            Set extensionDtos = extensions.stream().filter(Objects::nonNull).collect(Collectors.toSet());
            result.setExtensions(extensionDtos);
        }
        return result;
    }

    private OrgStruct saveOrgStructEntity(OrgModel.Request.Save model, OrgStruct entity, Company company) {
        List rootIds;
        String message;
        String message2;
        OrgStruct existEntity = null;
        if (OrgType.COMPANY.equals((Object)model.getOrgType()) && company != null && company.getCompanyId() != null && company.getCompanyId() > 0L) {
            OrgModel.Request.Query query = new OrgModel.Request.Query();
            query.setTenantId(entity.getTenantId());
            query.setCompanyId(entity.getCompanyId());
            List companyOrgs = this.orgStructDao.findAll(OrgQueryHelper.querySpecification((OrgModel.Request.Query)query));
            if (!companyOrgs.isEmpty()) {
                Iterator iterator = companyOrgs.iterator();
                if (iterator.hasNext()) {
                    OrgStruct companyOrg = (OrgStruct)iterator.next();
                    if (companyOrg.getStatus() != null && companyOrg.getStatus() == 1) {
                        if (model.getUniqueCompany() != null && model.getUniqueCompany().booleanValue()) {
                            message2 = "\u7a0e\u53f7\u4e3a:" + company.getTaxNum() + "\u516c\u53f8\u5df2\u5b58\u5728, \u65e0\u6cd5\u91cd\u590d\u63d0\u4ea4";
                            logger.warn(message2);
                            if (model.getIsStrict() != null && model.getIsStrict().booleanValue()) {
                                throw new IllegalArgumentException(message2);
                            }
                        }
                        existEntity = companyOrg;
                    } else {
                        companyOrg.setStatus(Integer.valueOf(1));
                        existEntity = companyOrg;
                    }
                }
                BeanUtils.copyProperties((Object)entity, (Object)existEntity, (String[])((String[])Stream.of("orgUserRels", "defaultOrgRole", "gradingRole", "companyNos", "companyNos", "tenant", "company").toArray(String[]::new)));
                entity = existEntity;
            }
        }
        Long parentId = null;
        Long tenantId = null;
        if (entity != null) {
            tenantId = entity.getTenantId();
        }
        if (tenantId == null && model.getTenantId() != null) {
            tenantId = model.getTenantId();
        }
        if (tenantId == null) {
            message = "\u79df\u6237id(" + tenantId + ")\u4e3a\u7a7a";
            logger.warn(message);
            if (model.getIsStrict() != null && model.getIsStrict().booleanValue()) {
                throw new IllegalArgumentException(message);
            }
        }
        if (model.getParentId() != null && model.getParentId() > 0L && (parentId = this.orgStructDao.findOrgIdByTenantIdAndOrgId(tenantId.longValue(), model.getParentId().longValue())) == null) {
            message = "\u975e\u6cd5\u7684\u7236\u7ea7\u7ec4\u7ec7id(" + model.getParentId() + ")";
            logger.warn(message);
            if (model.getIsStrict() != null && model.getIsStrict().booleanValue()) {
                throw new IllegalArgumentException(message);
            }
        }
        if (parentId == null && StringUtils.isNotBlank((CharSequence)model.getParentCode())) {
            List parentIdList = this.orgStructDao.findOrgIdByTenantIdAndOrgCode(tenantId.longValue(), model.getParentCode());
            if (parentIdList.isEmpty()) {
                String message3 = "\u975e\u6cd5\u7684\u7236\u7ea7\u7ec4\u7ec7code(" + model.getParentCode() + ")";
                logger.warn(message3);
                if (model.getIsStrict() != null && model.getIsStrict().booleanValue()) {
                    throw new IllegalArgumentException(message3);
                }
            } else {
                parentId = (Long)parentIdList.get(0);
            }
        }
        if (parentId == null && entity.getParentId() == null && !(rootIds = this.orgStructDao.findRootIdsByTenantId(tenantId.longValue())).isEmpty()) {
            parentId = (Long)rootIds.get(0);
        }
        if (parentId != null && parentId <= 0L) {
            parentId = null;
        }
        if (parentId != null) {
            long countCompanies;
            entity.setParentId((Serializable)parentId);
            if (OrgType.GROUP.equals((Object)entity.getOrgType()) && entity.getParentId() > 0L) {
                entity.setOrgType(OrgType.NORMAL);
            }
            if (OrgType.COMPANY.equals((Object)entity.getOrgType()) && entity.getCompanyId() != null && entity.getCompanyId() > 0L && (countCompanies = this.orgStructDao.countCompaniesByParentIdAndCompanyId(parentId.longValue(), entity.getCompanyId().longValue())) > 0L) {
                message2 = "\u7236\u7ec4\u7ec7\u4e0b\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u516c\u53f8";
                logger.warn(message2);
                if (model.getIsStrict() != null && model.getIsStrict().booleanValue()) {
                    throw new IllegalArgumentException(message2);
                }
            }
            model.setIsAutoBindParentOrgUsers(Boolean.valueOf(true));
        } else if (!OrgType.GROUP.equals((Object)entity.getOrgType())) {
            if (entity.getParentId() == null) {
                logger.warn("\u975e\u96c6\u56e2\u7ec4\u7ec7\u7684\u7236\u7ea7\u7ec4\u7ec7\u4e3a\u7a7a: tenantId:{},orgCode:{},orgName:{}", new Object[]{tenantId, entity.getOrgCode(), entity.getOrgName()});
                long finalTenantId = tenantId;
                List rootIds2 = this.orgStructDao.findRootIdsByTenantId(tenantId.longValue());
                Long rootId = (Long)rootIds2.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u79df\u6237(" + finalTenantId + ")\u7684\u6839\u7ec4\u7ec7"));
                logger.info("tenantId:{}, rootId:{}, orgCode:{}, orgName:{}", new Object[]{tenantId, rootId, entity.getOrgCode(), entity.getOrgName()});
                entity.setParentId((Serializable)rootId);
            }
            model.setIsAutoBindParentOrgUsers(Boolean.valueOf(true));
        }
        if (model.isWithApplication() && model.getCompany() != null) {
            entity.setAuditStatus(Integer.valueOf(0));
            entity.setStatus(Integer.valueOf(0));
        }
        return entity;
    }

    private Company saveCompany(long tenantId, OrgModel.Request.Save model, boolean isOverwrite) {
        Optional tenantOptional = this.tenantDao.findById((Object)tenantId);
        if (!tenantOptional.isPresent()) {
            throw new IllegalArgumentException("\u6ca1\u6709\u5bf9\u5e94\u7684\u79df\u6237(id:" + tenantId + ")");
        }
        Set constraintViolations = this.validator.validate((Object)model, new Class[]{ValidationGroup.OnCreate.class});
        if (!constraintViolations.isEmpty()) {
            String errorMsgs = constraintViolations.stream().map(violation -> violation.getPropertyPath() + violation.getMessage()).collect(Collectors.joining(","));
            throw new IllegalArgumentException(errorMsgs);
        }
        Company company = null;
        if (model.getCompany() == null) {
            return company;
        }
        if (model.getCompany().getCompanyId() != null && model.getCompany().getCompanyId() > 0L) {
            company = this.companyService.findById(model.getCompany().getCompanyId());
        } else {
            if (model.getCompany().getHostTenantId() == null) {
                model.getCompany().setHostTenantId(Long.valueOf(tenantId));
            }
            company = this.companyService.save(model.getCompany(), isOverwrite);
        }
        Tenant tenant = (Tenant)tenantOptional.get();
        this.companyService.saveTenantCompany(tenant, company);
        return company;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public OrgStruct update(long orgId, OrgModel.Request.Save model) {
        OrgStruct existEntity = (OrgStruct)this.orgStructDao.findOne((Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.equal((Expression)root.get("orgId"), (Object)orgId)).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u7ec4\u7ec7\u5b9e\u4f53"));
        OrgStruct result = this.update(existEntity, model);
        return result;
    }

    private OrgStruct update(OrgStruct existEntity, OrgModel.Request.Save model) {
        Company company;
        long countGradingRoleId;
        long countDefaultOrgRoleId;
        if (model.getDefaultOrgRoleId() != null && model.getDefaultOrgRoleId() > 0L && !model.getDefaultOrgRoleId().equals(existEntity.getDefaultOrgRoleId()) && (countDefaultOrgRoleId = this.roleDao.countRoleByTenantIdAndIdAndType(existEntity.getTenantId().longValue(), model.getDefaultOrgRoleId().longValue(), 2)) == 0L) {
            throw new IllegalArgumentException("\u6307\u5b9a\u7684\u9ed8\u8ba4\u7ec4\u7ec7\u89d2\u8272(id:" + model.getDefaultOrgRoleId() + ")\u4e0d\u5b58\u5728");
        }
        if (model.getGradingRoleId() != null && model.getGradingRoleId() > 0L && !model.getGradingRoleId().equals(existEntity.getGradingRoleId()) && (countGradingRoleId = this.roleDao.countRoleByTenantIdAndIdAndType(existEntity.getTenantId().longValue(), model.getGradingRoleId().longValue(), 1)) == 0L) {
            throw new IllegalArgumentException("\u6307\u5b9a\u7684\u5206\u7ea7\u7ba1\u7406\u5458\u89d2\u8272(id:" + model.getGradingRoleId() + ")\u4e0d\u5b58\u5728");
        }
        if (existEntity.getDefaultOrgRoleId() != null && existEntity.getDefaultOrgRoleId() > 0L && model.getDefaultOrgRoleId() != null && model.getDefaultOrgRoleId() == -1L) {
            this.roleUserRelDao.deleteByRoleIdAndOrgIdAndType(existEntity.getDefaultOrgRoleId().longValue(), ((Long)existEntity.getId()).longValue(), 2);
        }
        if (existEntity.getGradingRoleId() != null && existEntity.getGradingRoleId() > 0L && model.getGradingRoleId() != null && model.getGradingRoleId() == -1L) {
            this.roleUserRelDao.deleteByRoleIdAndOrgIdAndType(existEntity.getGradingRoleId().longValue(), ((Long)existEntity.getId()).longValue(), 1);
        }
        BeanUtils.copyProperties((Object)model, (Object)existEntity, (String[])((String[])Stream.of("orgId", "company", "tenant", "companyNos", "extensions").toArray(String[]::new)));
        if (existEntity.getOrgId() != null && existEntity.getParentId() != null && existEntity.getParentId().equals(existEntity.getOrgId())) {
            throw new IllegalArgumentException("\u7236\u7ec4\u7ec7\u4e0d\u80fd\u5173\u8054\u672c\u8eab");
        }
        OrgStruct result = new OrgStruct();
        boolean isOverwrite = model.isOverwrite();
        if (model.getCompany() != null && (company = this.saveCompany((long)existEntity.getTenantId(), model, isOverwrite)) != null) {
            List existCompanyOrgIds;
            if (model.getUniqueCompany() != null && model.getUniqueCompany().booleanValue() && !(existCompanyOrgIds = this.orgStructDao.findIdByTenantIdAndCompanyId(existEntity.getTenantId().longValue(), company.getCompanyId().longValue())).isEmpty() && !existCompanyOrgIds.contains(existEntity.getOrgId())) {
                throw new IllegalArgumentException("\u7ec4\u7ec7\u6811\u5185\u5df2\u5b58\u5728\u516c\u53f8(" + company.getCompanyName() + ")");
            }
            existEntity.setCompanyId(company.getCompanyId());
        }
        if (CollectionUtils.isNotEmpty((Collection)model.getCompanyNos())) {
            this.companyService.saveCompanyNos(existEntity.getOrgId(), model.getCompanyNos(), isOverwrite);
            result.setCompanyNos(model.getCompanyNos());
        }
        if (CollectionUtils.isNotEmpty((Collection)model.getExtensions())) {
            Set<OrgExtension> extensions = this.orgExtensionService.batchSave(existEntity.getOrgId(), model.getExtensions(), isOverwrite);
            Set extensionDtos = extensions.stream().filter(Objects::nonNull).collect(Collectors.toSet());
            result.setExtensions(extensionDtos);
        }
        existEntity = this.saveAndFlush(existEntity);
        BeanUtils.copyProperties((Object)existEntity, (Object)result, (String[])((String[])Stream.of("companyNos", "extensions").toArray(String[]::new)));
        return result;
    }

    public OrgStruct findById(long orgId, int extraInfoDimension) {
        OrgStruct org = (OrgStruct)this.orgStructDao.findById((Serializable)Long.valueOf(orgId), EntityGraphs.named((String)"Org.graph")).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u7ec4\u7ec7\u5b9e\u4f53(orgId:" + orgId + ")"));
        if (BinaryUtils.is((Enum)OrgExtraInfo.extentions, (int)extraInfoDimension)) {
            List<OrgExtension> extentions = this.orgExtensionService.findByOrgId(orgId);
            org.setExtensions(new HashSet<OrgExtension>(extentions));
        }
        if (BinaryUtils.is((Enum)OrgExtraInfo.children, (int)extraInfoDimension) && org.getTenantId() != null && org.getTenantId() > 0L) {
            OrgModel.Request.Query childrenQuery = new OrgModel.Request.Query();
            childrenQuery.setTenantId(org.getTenantId());
            childrenQuery.setParentId(org.getOrgId());
            Specification childrenSpecification = OrgQueryHelper.querySpecification((OrgModel.Request.Query)childrenQuery);
            List children = this.orgStructDao.findAll(childrenSpecification, EntityGraphs.named((String)"Org.graph"));
            org.setChildren(children);
        }
        return org;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteById(long orgId) {
        OrgStruct org = (OrgStruct)this.orgStructDao.findById((Object)orgId).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u7ec4\u7ec7(" + orgId + ")\u5b9e\u4f53"));
        this.deleteOrgWithValidation(org);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteByTenantIdAndId(long tenantId, long orgId) {
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setTenantId(Long.valueOf(tenantId));
        query.setOrgId(Long.valueOf(orgId));
        Optional<OrgStruct> existOptional = this.findOne(query);
        if (!existOptional.isPresent()) {
            String message = "\u672a\u627e\u5230\u7ec4\u7ec7\u5b9e\u4f53(" + orgId + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        OrgStruct existOrg = existOptional.get();
        this.deleteOrgWithValidation(existOrg);
    }

    private void beforeDelOrDisableOrgValidation(long orgId) {
        long childrenCount = this.orgStructDao.countChildren(orgId);
        if (childrenCount > 0L) {
            String message = "\u8be5\u7ec4\u7ec7(" + orgId + ")\u5b58\u5728\u5b50\u7ec4\u7ec7\u65e0\u6cd5\u5220\u9664\u6216\u7981\u7528";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
    }

    private void deleteOrgWithValidation(OrgStruct org) {
        this.beforeDelOrDisableOrgValidation(org.getOrgId());
        long userCount = this.orgUserRelDao.countByOrgId(org.getOrgId().longValue());
        if (userCount > 0L) {
            String message = "\u5df2\u5173\u8054\u4eba\u5458\u7684\u7ec4\u7ec7\u65e0\u6cd5\u5220\u9664\uff0c\u82e5\u9700\u5220\u9664\uff0c\u8bf7\u5148\u79fb\u9664\u7ec4\u7ec7\u5185\u4eba\u5458";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        Long defaultOrgRoleId = org.getDefaultOrgRoleId();
        if (null != defaultOrgRoleId) {
            this.roleUserRelDao.deleteByRoleIdAndOrgId(defaultOrgRoleId, org.getOrgId());
        }
        this.deleteOrg(org);
    }

    private void deleteOrg(OrgStruct org) {
        this.orgStructDao.deleteById(org.getOrgId());
        this.orgPubService.sendOrgMsg(DELETE, org);
        this.orgExtensionDao.deleteByOrgId(org.getOrgId().longValue());
        if (org.getTenantId() != null && org.getTenantId() > 0L && org.getCompanyId() != null && org.getCompanyId() > 0L) {
            this.tenantCompanyRelDao.deleteByTenantIdAndCompanyId(org.getTenantId().longValue(), org.getCompanyId().longValue());
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteByTenantIdAndCompanyId(long tenantId, long companyId) {
        List orgs = this.orgStructDao.findAll((Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get("tenantId"), (Object)tenantId), (Expression)criteriaBuilder.equal((Expression)root.get("companyId"), (Object)companyId)));
        Set orgIds = orgs.stream().filter(Objects::nonNull).map(OrgStruct::getOrgId).collect(Collectors.toSet());
        this.orgStructDao.disableByIds(orgIds);
        this.orgUserRelDao.deleteByOrgIds(orgIds);
        this.orgExtensionDao.deleteByOrgIds(orgIds);
        orgs.stream().forEach(org -> this.orgPubService.sendOrgMsg(SAVE, (OrgStruct)org));
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public OrgStruct updateByTenantId(long tenantId, long orgId, OrgModel.Request.Save model) {
        long orgCodeCount;
        List orgVirtuals;
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setTenantId(Long.valueOf(tenantId));
        query.setOrgId(Long.valueOf(orgId));
        Optional<OrgStruct> existOptional = this.findOne(query);
        OrgStruct existEntity = existOptional.orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u7ec4\u7ec7\u5b9e\u4f53(tenantId:" + tenantId + ", orgId:" + orgId + ")"));
        if (model.getStatus() != null && 0 == model.getStatus() && CollectionUtils.isNotEmpty((Collection)(orgVirtuals = this.orgVirtualDao.findByOrgStructId(Long.valueOf(orgId))))) {
            throw new IllegalArgumentException("\u8be5\u7ec4\u7ec7(" + orgId + ")\u72b6\u6001\u4e0d\u80fd\u505c\u7528\uff0c\u5df2\u5173\u8054\u865a\u62df\u7ec4\u7ec7");
        }
        if (StringUtils.isNotEmpty((CharSequence)model.getOrgCode()) && !model.getOrgCode().equalsIgnoreCase(existEntity.getOrgCode()) && (orgCodeCount = this.orgStructDao.countByTenantIdAndOrgCode(tenantId, model.getOrgCode())) > 0L) {
            throw new IllegalArgumentException("orgCode (" + model.getOrgCode() + ") \u5df2\u7ecf\u5b58\u5728");
        }
        OrgStruct result = this.update(existEntity, model);
        return result;
    }

    public OrgStruct info(long tenantId, long orgId) {
        OrgStruct org = this.findByTenantIdAndId(tenantId, orgId);
        if (org.getParentId() != null && org.getParentId() > 0L) {
            String parentName = this.orgStructDao.findNameByOrgId(org.getParentId().longValue());
            org.setParentName(parentName);
        }
        List<OrgExtension> extentions = this.orgExtensionService.findByOrgId(org.getOrgId());
        org.setExtensions(new HashSet<OrgExtension>(extentions));
        return org;
    }

    public OrgStruct findByTenantIdAndId(long tenantId, long orgId) {
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setTenantId(Long.valueOf(tenantId));
        query.setOrgId(Long.valueOf(orgId));
        Optional<OrgStruct> existOptional = this.findOne(query);
        String message = "\u672a\u627e\u5230\u7ec4\u7ec7\u5b9e\u4f53(tenantId:" + tenantId + ", orgId:" + orgId + ")";
        OrgStruct org = existOptional.orElseThrow(() -> new IllegalArgumentException(message));
        return org;
    }

    public List<OrgStruct> findDescendantsById(long orgId) {
        return this.orgStructDao.findDescendantsById(orgId);
    }

    public List<OrgStruct> findTreeByUserId(long userId, String modules) {
        Optional existsUserOptional = this.userDao.findById((Object)userId);
        if (!existsUserOptional.isPresent()) {
            String message = "\u627e\u4e0d\u5230\u7528\u6237\u5b9e\u4f53(userId:" + userId + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setTenantId(((User)existsUserOptional.get()).getTenantId());
        query.setUserId(Long.valueOf(userId));
        query.setModules(modules);
        query.setStatus(Integer.valueOf(1));
        List<OrgStruct> orgs = this.list(query, Sort.unsorted());
        return TreeUtils.buildTree(orgs);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public OrgSaveOutput saveOrg(OrgSaveInput orgSaveInput, OrgModel.Request.Save model, boolean isOverwrite) {
        Set<OrgExtension> extensions;
        List orgStructs;
        CompanyModel.Request.Save companyCreate = model.getCompany();
        Company company = null;
        Long companyId = null;
        OrgSaveOutput orgSaveOutput = new OrgSaveOutput();
        if (companyCreate != null) {
            logger.info("companyCreate != null");
            companyCreate.setHostTenantId(Long.valueOf(orgSaveInput.tenantId));
            company = this.companyService.save(companyCreate, isOverwrite);
            companyId = company.getCompanyId();
        }
        if (companyId != null) {
            Tenant tenant = (Tenant)this.tenantDao.findById((Object)orgSaveInput.tenantId).get();
            this.companyService.saveTenantCompany(tenant, company);
        }
        OrgStruct orgStruct = null;
        boolean isNew = false;
        if (model.getOrgId() != null && model.getOrgId() > 0L) {
            orgStruct = this.orgStructDao.findById((Object)model.getOrgId()).orElse(null);
        }
        if (orgStruct == null && StringUtils.isNotBlank((CharSequence)model.getOrgCode()) && !(orgStructs = this.orgStructDao.findByTenantIdAndOrgCode(orgSaveInput.tenantId, model.getOrgCode())).isEmpty()) {
            Optional<OrgStruct> orgStructOptional = orgStructs.stream().filter(o -> o.getStatus() != null && o.getStatus() == 1).findFirst();
            if (orgStructOptional.isPresent()) {
                orgStruct = orgStructOptional.get();
            } else {
                orgStructOptional = orgStructs.stream().filter(o -> o.getStatus() == null || o.getStatus() == 0).findFirst();
                if (orgStructOptional.isPresent()) {
                    orgStruct = orgStructOptional.get();
                }
            }
        }
        if (companyId != null && companyId > 0L && model.getUniqueCompany() != null && model.getUniqueCompany().booleanValue()) {
            OrgModel.Request.Query query = new OrgModel.Request.Query();
            query.setCompanyId(companyId);
            query.setTenantId(Long.valueOf(orgSaveInput.tenantId));
            List exsitCompanyOrgs = this.orgStructDao.findAll(OrgQueryHelper.querySpecification((OrgModel.Request.Query)query));
            for (OrgStruct exsitCompanyOrg : exsitCompanyOrgs) {
                if (model.getOrgId() != null && model.getOrgId().equals(exsitCompanyOrg.getOrgId())) {
                    orgStruct = exsitCompanyOrg;
                    break;
                }
                if (exsitCompanyOrg.getStatus() != null && exsitCompanyOrg.getStatus() == 1) {
                    orgStruct = exsitCompanyOrg;
                    continue;
                }
                exsitCompanyOrg.setStatus(Integer.valueOf(1));
                orgStruct = exsitCompanyOrg;
            }
        }
        if (orgStruct == null) {
            isNew = true;
            if (orgSaveInput.parentId > 0L) {
                model.setParentId(Long.valueOf(orgSaveInput.parentId));
            }
            if (model.getOrgId() != null && model.getOrgId() == 0L) {
                model.setOrgId(null);
            }
            model.setTenantId(Long.valueOf(orgSaveInput.tenantId));
            orgStruct = new OrgStruct();
        } else if (orgStruct.getStatus() != null && orgStruct.getStatus() == 0 && model.getStatus() != null && model.getStatus() == 1) {
            orgStruct.setStatus(Integer.valueOf(1));
        }
        long parentId = 0L;
        if (StringUtils.isNotBlank((CharSequence)model.getParentCode())) {
            List parentIdList = this.orgStructDao.findOrgIdByTenantIdAndOrgCode(orgSaveInput.tenantId, model.getParentCode());
            if (parentIdList.isEmpty()) {
                String message = "\u975e\u6cd5\u7684\u7236\u7ea7\u7ec4\u7ec7code(" + model.getParentCode() + ")";
                logger.warn(message);
                throw new IllegalArgumentException(message);
            }
            parentId = (Long)parentIdList.get(0);
        } else {
            List rootIds = this.orgStructDao.findRootIdsByTenantId(orgSaveInput.tenantId);
            if (!rootIds.isEmpty()) {
                parentId = (Long)rootIds.get(0);
            }
        }
        if (parentId > 0L) {
            model.setParentId(Long.valueOf(parentId));
        }
        if (model.getParentId() != null && model.getParentId() == 0L) {
            model.setParentId(null);
        }
        if (StringUtils.isBlank((CharSequence)model.getOrgCode())) {
            model.setOrgCode(null);
        }
        if (StringUtils.isBlank((CharSequence)model.getOrgName())) {
            model.setOrgName(null);
        }
        BeanUtils.copyProperties((Object)model, (Object)orgStruct, (String[])((String[])Stream.of("orgId", "company", "tenant", "companyNos", "extensions").toArray(String[]::new)));
        if (orgStruct.getCompanyId() == null && companyId != null && companyId > 0L) {
            orgStruct.setCompanyId(companyId);
        }
        if (StringUtils.isBlank((CharSequence)orgStruct.getOrgCode())) {
            orgStruct.setOrgCode(UUIDUtils.randomUUID());
        }
        orgStruct = this.saveAndFlush(orgStruct);
        if (company != null && orgStruct.getCompany() == null) {
            orgStruct.setCompany(company);
        }
        orgSaveInput.orgs.add(orgStruct);
        orgSaveOutput.addOrg(orgStruct);
        if (OrgType.COMPANY.equals((Object)orgStruct.getOrgType())) {
            this.companyService.saveCompanyNos(orgStruct.getOrgId(), model.getCompanyNos(), isOverwrite);
        }
        if (CollectionUtils.isNotEmpty(extensions = this.orgExtensionService.batchSave(orgStruct.getOrgId(), model.getExtensions(), isOverwrite)) && orgStruct.getExtensions() == null) {
            Set extensionDtos = extensions.stream().filter(Objects::nonNull).collect(Collectors.toSet());
            orgStruct.setExtensions(extensionDtos);
        }
        return orgSaveOutput;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public OrgSaveOutput update(long tenantId, OrgModel.Request.Save model, boolean isOverwrite) {
        if (!this.tenantDao.existsById((Object)tenantId)) {
            String message = "\u4e0d\u5408\u6cd5\u7684\u79df\u6237id(" + tenantId + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        logger.info("save Org tenantId({})", (Object)tenantId);
        OrgSaveInput orgSaveInput = new OrgSaveInput(tenantId, 0L, null, new ArrayList<OrgStruct>());
        OrgSaveOutput orgSaveOutput = this.saveOrg(orgSaveInput, model, isOverwrite);
        return orgSaveOutput;
    }

    public List<OrgStruct> findByTenantIdAndCompanyId(long tenantId, long companyId) {
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setTenantId(Long.valueOf(tenantId));
        query.setCompanyId(Long.valueOf(companyId));
        return this.list(query, Sort.unsorted());
    }

    public Page<OrgStruct> findRoots(Pageable pageable) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.or((Expression)builder.isNull((Expression)root.get("parentId")), (Expression)builder.equal((Expression)root.get("parentId"), (Object)0)));
            predicates.add(builder.equal((Expression)root.get("status"), (Object)1));
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return this.orgStructDao.findAll((Specification)specification, pageable);
    }

    public Page<OrgStruct> findRoots(long tenantId, Pageable pageable) {
        Specification<OrgStruct> specification = this.findRootsSpecification(tenantId);
        return this.orgStructDao.findAll(specification, pageable);
    }

    public List<OrgStruct> findAllRoots(long tenantId, Sort sort) {
        Specification<OrgStruct> specification = this.findRootsSpecification(tenantId);
        return this.orgStructDao.findAll(specification, sort);
    }

    private Specification<OrgStruct> findRootsSpecification(long tenantId) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)tenantId));
            predicates.add(builder.equal((Expression)root.get("status"), (Object)1));
            predicates.add(builder.or((Expression)builder.isNull((Expression)root.get("parentId")), (Expression)builder.equal((Expression)root.get("parentId"), (Object)0)));
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void updateStatus(long orgId, int status) {
        int result;
        if (status > 0) {
            result = this.orgStructDao.enable(orgId);
        } else {
            List orgVirtuals = this.orgVirtualDao.findByOrgStructId(Long.valueOf(orgId));
            if (CollectionUtils.isNotEmpty((Collection)orgVirtuals)) {
                throw new IllegalArgumentException("\u8be5\u7ec4\u7ec7(" + orgId + ")\u72b6\u6001\u4e0d\u80fd\u505c\u7528\uff0c\u5df2\u5173\u8054\u865a\u62df\u7ec4\u7ec7");
            }
            this.beforeDelOrDisableOrgValidation(orgId);
            result = this.orgStructDao.disable(orgId);
        }
        if (result == 0) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u7ec4\u7ec7\u5b9e\u4f53(" + orgId + ")");
        }
        OrgStruct orgStruct = (OrgStruct)this.orgStructDao.findById((Object)orgId).get();
        this.orgPubService.sendOrgMsg(SAVE, orgStruct);
    }

    public List<OrgStruct> findTreeByTenantId(OrgModel.Request.TreeQuery treeQuery) {
        Set orgIdSet;
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setTenantId(treeQuery.getTenantId());
        query.setStatus(treeQuery.getStatus());
        query.setModules(treeQuery.getModules());
        query.setOrgNameLike(treeQuery.getOrgName());
        query.setUserId(treeQuery.getUserId());
        query.setWithUserBoundFlag(treeQuery.getWithUserBound());
        query.setWithChildrenCount(treeQuery.getWithChildrenCount());
        Set treeAttributes = Stream.of("orgId", "orgName", "parentId", "orgType", "parentIds").collect(Collectors.toSet());
        if (treeQuery.getAttributes() != null && !treeQuery.getAttributes().isEmpty()) {
            treeAttributes.addAll(treeQuery.getAttributes());
        }
        query.setAttributes(treeAttributes);
        query.setTree(true);
        String filterParentIds = null;
        if (treeQuery.getRootId() != null && treeQuery.getRootId() > 0L && (filterParentIds = this.orgStructDao.findParentIdsByOrgId(treeQuery.getRootId().longValue())) != null) {
            query.setFilterParentIds(Stream.of(filterParentIds).collect(Collectors.toSet()));
        }
        List<OrgStruct> orgs = this.list(query, Sort.unsorted());
        if (StringUtils.isNotBlank((CharSequence)treeQuery.getOrgName()) && !orgs.isEmpty() && !(orgIdSet = orgs.stream().map(o -> OrgUtils.findOrgIdInParentIds((String)o.getParentIds())).flatMap(Collection::stream).collect(Collectors.toSet())).isEmpty()) {
            Set selectedOrgIds = orgs.stream().map(OrgStruct::getOrgId).collect(Collectors.toSet());
            HashSet<Long> selectingOrgIds = new HashSet<Long>();
            Set<Object> orgSet = new HashSet();
            for (Long orgId : orgIdSet) {
                boolean anyMatch = false;
                for (OrgStruct selectedOrg : orgs) {
                    if (!selectedOrg.getOrgId().equals(orgId)) continue;
                    anyMatch = true;
                    orgSet.add(selectedOrg);
                    break;
                }
                if (anyMatch) continue;
                selectingOrgIds.add(orgId);
            }
            if (selectingOrgIds != null && !selectingOrgIds.isEmpty()) {
                List<OrgStruct> list;
                query = new OrgModel.Request.Query();
                query.setTenantId(treeQuery.getTenantId());
                query.setStatus(treeQuery.getStatus());
                query.setModules(treeQuery.getModules());
                query.setOrgIds(selectingOrgIds);
                query.setWithUserBoundFlag(treeQuery.getWithUserBound());
                query.setWithChildrenCount(treeQuery.getWithChildrenCount());
                if (treeQuery.getAttributes() != null && !treeQuery.getAttributes().isEmpty()) {
                    treeAttributes.addAll(treeQuery.getAttributes());
                }
                query.setAttributes(treeAttributes);
                query.setTree(true);
                if (filterParentIds != null) {
                    query.setParentIds(filterParentIds);
                }
                if (!(list = this.list(query, Sort.unsorted())).isEmpty()) {
                    orgSet.addAll(list);
                }
            }
            if (filterParentIds != null) {
                String finalParentIds = filterParentIds;
                orgSet = orgSet.stream().filter(o -> StringUtils.startsWith((CharSequence)o.getParentIds(), (CharSequence)finalParentIds)).collect(Collectors.toSet());
            }
            orgs = new ArrayList<OrgStruct>(orgSet);
        }
        return TreeUtils.buildTree(orgs);
    }

    public List<OrgStruct> findByTenantIdAndOrgCode(long tenantId, String orgCode) {
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setTenantId(Long.valueOf(tenantId));
        query.setOrgCode(orgCode);
        query.setStatus(Integer.valueOf(1));
        Specification specification = OrgQueryHelper.querySpecification((OrgModel.Request.Query)query);
        List orgs = this.orgStructDao.findAll(specification);
        return orgs;
    }

    public List<OrgStruct> listByTenantIdAndUserId(long tenantId, long userId, String modules, Set<String> attributes) {
        OrgModel.Request.Query orgQuery = new OrgModel.Request.Query();
        orgQuery.setTenantId(Long.valueOf(tenantId));
        orgQuery.setUserId(Long.valueOf(userId));
        orgQuery.setStatus(Integer.valueOf(1));
        orgQuery.setWithIsHost(Boolean.TRUE);
        orgQuery.setModules(modules);
        orgQuery.setAttributes(attributes);
        List<OrgStruct> orgs = this.list(orgQuery, Sort.unsorted());
        return orgs;
    }

    public List<OrgStruct> listByTenantIdAndUserId(long tenantId, long userId, String modules) {
        return this.listByTenantIdAndUserId(tenantId, userId, modules, null);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void updateStatus(long tenantId, long orgId, int status) {
        int result;
        if (status > 0) {
            result = this.orgStructDao.enable(tenantId, orgId);
        } else {
            List orgVirtuals = this.orgVirtualDao.findByOrgStructId(Long.valueOf(orgId));
            if (CollectionUtils.isNotEmpty((Collection)orgVirtuals)) {
                throw new IllegalArgumentException("\u8be5\u7ec4\u7ec7(" + orgId + ")\u72b6\u6001\u4e0d\u80fd\u505c\u7528\uff0c\u5df2\u5173\u8054\u865a\u62df\u7ec4\u7ec7");
            }
            this.beforeDelOrDisableOrgValidation(orgId);
            result = this.orgStructDao.disable(tenantId, orgId);
        }
        if (result == 0) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u7ec4\u7ec7\u5b9e\u4f53(" + orgId + ")");
        }
        OrgStruct orgStruct = (OrgStruct)this.orgStructDao.findById((Object)orgId).get();
        this.orgPubService.sendOrgMsg(SAVE, orgStruct);
    }

    public Long findIdByTenantIdAndCode(long tenantId, String orgCode) {
        return this.orgStructDao.findIdByTenantIdAndCode(tenantId, orgCode);
    }

    public boolean checkName(Long tenantId, String orgName) {
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setTenantId(tenantId);
        query.setOrgName(orgName);
        Specification specification = OrgQueryHelper.queryOneSpecification((OrgModel.Request.Query)query);
        return this.orgStructDao.count(specification) == 0L;
    }

    public OrgModel.Request.ExcelModel findParentOrgInModels(OrgModel.Request.ExcelModel org, List<OrgModel.Request.ExcelModel> excelModels) {
        List parents = excelModels.stream().filter(Objects::nonNull).filter(excelModel -> excelModel.getOrgCode() != null && excelModel.getOrgCode().equals(org.getParentOrgCode()) && StringUtils.isNotBlank((CharSequence)org.getParentOrgCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(parents) || parents.size() > 1) {
            return null;
        }
        return (OrgModel.Request.ExcelModel)parents.get(0);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void saveSingle(Long tenantId, Map<String, OrgStruct> currentSaveOrgs, OrgModel.Request.ExcelModel org, OrgStruct parentOrg) throws ImportException {
        ExcelUtils.checkField(org, this.validator);
        if (org.getOrgType() != null && OrgType.COMPANY.value() == org.getOrgType().intValue()) {
            this.checkCompany(org);
        }
        this.checkCurrentOrgs(parentOrg, org);
        List oldOrgs = this.orgStructDao.findByTenantIdAndOrgCode(tenantId.longValue(), org.getOrgCode());
        if (oldOrgs.size() > 1) {
            throw new ImportException(Stream.of("\u7ec4\u7ec7code\u5b58\u5728\u591a\u4e2a" + org.getOrgCode()).collect(Collectors.toList()));
        }
        if (CollectionUtils.isEmpty((Collection)oldOrgs)) {
            OrgStruct save = this.saveOrg(tenantId, org, parentOrg);
            this.orgPubService.sendOrgMsg(SAVE, save);
            if (save != null && save.getOrgCode() != null) {
                currentSaveOrgs.put(save.getOrgCode(), save);
            }
        } else {
            OrgStruct oldOrg = (OrgStruct)oldOrgs.get(0);
            Company company = oldOrg.getCompany();
            if (!(null == company || company.getCompanyName().equals(org.getCompanyName()) && company.getTaxNum().equals(org.getTaxNum()))) {
                throw new ImportException(Stream.of("\u65b0\u8001\u7ec4\u7ec7\u540d\u79f0\u6216\u8005\u7a0e\u53f7\u4e0d\u4e00\u81f4" + org.getOrgCode()).collect(Collectors.toList()));
            }
            if (oldOrg.getOrgType().value() != org.getOrgType().intValue()) {
                throw new ImportException(Stream.of("\u65b0\u8001\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u76f8\u540c" + org.getOrgCode()).collect(Collectors.toList()));
            }
            if (!this.checkCurrentDataCompareOrigin(oldOrg, org, parentOrg.getOrgId())) {
                Set<String> companyNos;
                OrgStruct updater = this.updateOrg(oldOrg, org, parentOrg.getOrgId());
                if (StringUtils.isNotBlank((CharSequence)org.getCompanyNo()) && !(companyNos = Stream.of(StringUtils.split((String)org.getCompanyNo(), (String)"/")).filter(Objects::nonNull).collect(Collectors.toSet())).isEmpty()) {
                    this.companyService.saveCompanyNos(oldOrg.getOrgId(), companyNos, true);
                }
                currentSaveOrgs.put(org.getOrgCode(), updater);
            } else {
                currentSaveOrgs.put(org.getOrgCode(), (OrgStruct)oldOrgs.get(0));
            }
        }
    }

    private boolean checkCurrentDataCompareOrigin(OrgStruct orgStruct, OrgModel.Request.ExcelModel org, Long orgId) {
        return orgStruct.getOrgCode().equals(org.getOrgCode()) && orgStruct.getOrgName().equals(org.getOrgName()) && orgId.equals(orgStruct.getOrgId());
    }

    private OrgStruct updateOrg(OrgStruct orgStruct, OrgModel.Request.ExcelModel org, Long orgId) {
        List orgVirtuals;
        if (null != orgStruct.getOrgId() && 0 == org.getStatus() && CollectionUtils.isNotEmpty((Collection)(orgVirtuals = this.orgVirtualDao.findByOrgStructId(orgId)))) {
            throw new IllegalArgumentException("\u8be5\u7ec4\u7ec7(" + orgId + ")\u72b6\u6001\u4e0d\u80fd\u505c\u7528\uff0c\u5df2\u5173\u8054\u865a\u62df\u7ec4\u7ec7");
        }
        orgStruct.setOrgName(org.getOrgName());
        orgStruct.setStatus(org.getStatus());
        orgStruct.setOrgCode(org.getOrgCode());
        orgStruct.setParentId((Serializable)orgId);
        this.saveAndFlush(orgStruct);
        return orgStruct;
    }

    private OrgStruct saveOrg(Long tenantId, OrgModel.Request.ExcelModel org, OrgStruct parentOrg) {
        OrgSaveInput orgSaveInput;
        OrgSaveOutput orgSaveOutput;
        OrgModel.Request.Save testSave = new OrgModel.Request.Save();
        CompanyModel.Request.Save company = new CompanyModel.Request.Save();
        BeanUtils.copyProperties((Object)org, (Object)testSave);
        testSave.setParentId(parentOrg.getOrgId());
        testSave.setTenantId(tenantId);
        testSave.setStatus(org.getStatus());
        testSave.setWithApplication(false);
        if (StringUtils.isNotBlank((CharSequence)org.getCompanyNo())) {
            testSave.setCompanyNos(Stream.of(org.getCompanyNo().split("/")).collect(Collectors.toSet()));
        }
        OrgType enumOrgType = OrgType.COMPANY;
        if (org.getOrgType().intValue() == OrgType.GROUP.value()) {
            enumOrgType = OrgType.GROUP;
        } else if (org.getOrgType().intValue() == OrgType.NORMAL.value()) {
            enumOrgType = OrgType.NORMAL;
        }
        testSave.setOrgType(enumOrgType);
        testSave.setParentCode(org.getParentOrgCode());
        if (org.getOrgType().equals(OrgType.COMPANY.value())) {
            BeanUtils.copyProperties((Object)org, (Object)company);
            company.setStatus(Integer.valueOf(1));
            testSave.setCompany(company);
        }
        if (null == (orgSaveOutput = this.saveOrg(orgSaveInput = new OrgSaveInput(tenantId, parentOrg.getOrgId(), parentOrg, new ArrayList<OrgStruct>()), testSave, true))) {
            return null;
        }
        return orgSaveOutput.findFirst();
    }

    private void checkCurrentOrgs(OrgStruct parentOrg, OrgModel.Request.ExcelModel org) throws ImportException {
        if (OrgType.GROUP == parentOrg.getOrgType() && org.getOrgType() == 0 && org.getOrgType() == 1) {
            throw new ImportException(Stream.of("\u7236\u7ec4\u7ec7\u662f\u6bcd\u516c\u53f8\uff0c\u5b50\u7ec4\u7ec7\u5fc5\u987b\u662f\u516c\u53f8\u6216\u8005\u6bcd\u516c\u53f8" + org.getOrgCode()).collect(Collectors.toList()));
        }
        logger.info("\u7ec4\u7ec7\u4fe1\u606fid{},{}\u72b6\u6001{}", new Object[]{parentOrg.getOrgId(), parentOrg.getOrgType(), parentOrg.getAuditStatus()});
        if (parentOrg.getOrgType().equals((Object)OrgType.COMPANY) && (null == parentOrg.getAuditStatus() || parentOrg.getAuditStatus() == 0)) {
            org.setAuditStatus(Integer.valueOf(0));
            return;
        }
        org.setAuditStatus(Integer.valueOf(1));
    }

    public OrgStruct findParentOrgType(Long tenantId, OrgModel.Request.ExcelModel org) {
        Set orgCodes = Stream.of(org.getParentOrgCode()).filter(Objects::nonNull).collect(Collectors.toSet());
        List parentOrgs = this.orgStructDao.findByTenantIdAndOrgCodes(tenantId.longValue(), orgCodes);
        if (CollectionUtils.isNotEmpty((Collection)parentOrgs) && StringUtils.isNotBlank((CharSequence)((OrgStruct)parentOrgs.get(0)).getOrgCode())) {
            return (OrgStruct)parentOrgs.get(0);
        }
        return null;
    }

    private void checkCompany(OrgModel.Request.ExcelModel org) throws ImportException {
        ArrayList<String> errMsg = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)org.getCompanyName())) {
            errMsg.add("\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a:" + org.getOrgCode());
        }
        if (StringUtils.isBlank((CharSequence)org.getTaxNum())) {
            errMsg.add("\u516c\u53f8\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a:" + org.getOrgCode());
        }
        if (CollectionUtils.isNotEmpty(errMsg)) {
            throw new ImportException(errMsg);
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void updateParentIds(long orgId, String parentIds) {
        Optional optionalOrgStruct = this.orgStructDao.findById((Object)orgId);
        if (!optionalOrgStruct.isPresent()) {
            logger.warn("\u4fee\u6539parentIds\u5931\u8d25\uff0corgId:{}", (Object)orgId);
            return;
        }
        OrgStruct org = (OrgStruct)optionalOrgStruct.get();
        org.setParentIds(parentIds);
        org.setBuiltParentIds(false);
        this.orgStructDao.saveAndFlush((Object)org);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<OrgStruct> saveWithResult(long tenantId, List<OrgModel.Request.Save> models) {
        if (CollectionUtils.isEmpty(models)) {
            return new ArrayList<OrgStruct>(0);
        }
        if (!this.tenantDao.existsById((Object)tenantId)) {
            throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u79df\u6237id(" + tenantId + ")");
        }
        List parents = this.orgStructDao.findRootsByTenantId(tenantId);
        if (CollectionUtils.isEmpty((Collection)parents)) {
            throw new IllegalArgumentException("\u6839\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a(tenantId: " + tenantId + ")");
        }
        OrgStruct parent = (OrgStruct)parents.get(0);
        OrgSaveInput orgSaveInput = new OrgSaveInput(tenantId, parent.getOrgId(), parent, new ArrayList<OrgStruct>());
        models.forEach(model -> this.create((OrgModel.Request.Save)model));
        List<OrgStruct> res = orgSaveInput.orgs.stream().map(item -> {
            OrgStruct org = new OrgStruct();
            org.setCompanyId(item.getCompanyId());
            org.setOrgId(item.getOrgId());
            org.setOrgCode(item.getOrgCode());
            org.setTenantId(item.getTenantId());
            return org;
        }).collect(Collectors.toList());
        return res;
    }

    @Transactional
    public <C extends CompanyModel.Request.Save> Company saveCompanyAsync(long tenantId, Long rootOrgId, C model) {
        OrgModel.Request.Save orgModel = new OrgModel.Request.Save();
        orgModel.setTenantId(Long.valueOf(tenantId));
        orgModel.setOrgName(model.getCompanyName());
        orgModel.setOrgDesc(model.getCompanyName());
        orgModel.setOrgType(OrgType.COMPANY);
        orgModel.setCompany(model);
        orgModel.setIsStrict(Boolean.valueOf(false));
        OrgStruct org = this.createAsync(orgModel);
        return org.getCompany();
    }

    @Transactional
    public <C extends CompanyModel.Request.Save> Company saveCompany(long tenantId, Long rootOrgId, C model) {
        OrgModel.Request.Save orgModel = new OrgModel.Request.Save();
        orgModel.setTenantId(Long.valueOf(tenantId));
        orgModel.setOrgName(model.getCompanyName());
        orgModel.setOrgDesc(model.getCompanyName());
        orgModel.setParentId(rootOrgId);
        orgModel.setOrgType(OrgType.COMPANY);
        orgModel.setCompany(model);
        OrgStruct org = this.create(orgModel);
        return org.getCompany();
    }

    @Transactional
    public <C extends CompanyModel.Request.Save> Company saveCompany(long tenantId, C model) {
        return this.saveCompany(tenantId, null, model);
    }

    @Transactional
    public <C extends CompanyModel.Request.Save> Company saveCompanyAsync(long tenantId, C model) {
        return this.saveCompanyAsync(tenantId, null, model);
    }

    @Transactional(readOnly=true)
    public List<OrgCompanyDTO> findOrgCompanyByTaxNum(@Valid OrgCompanyQueryBo queryBo) {
        List companyDTOList = this.orgStructDao.findOrgCompanyByTaxNum(queryBo);
        List orgIds = companyDTOList.stream().map(e -> e.getOrgId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orgIds)) {
            return companyDTOList;
        }
        List companyNoDTOList = this.orgStructDao.findCompanyNoByOrgIds(orgIds);
        Map companyNoMap = companyNoDTOList.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getCompanyNo())).collect(Collectors.groupingBy(OrgCompanyNoDTO::getOrgId, Collectors.mapping(OrgCompanyNoDTO::getCompanyNo, Collectors.toList())));
        companyDTOList.stream().map(e -> {
            List companyNos = (List)companyNoMap.get(e.getOrgId());
            if (CollectionUtils.isEmpty((Collection)companyNos)) {
                companyNos = Collections.emptyList();
            }
            e.setCompanyNos(companyNos);
            return e;
        }).collect(Collectors.toList());
        return companyDTOList;
    }

    public Optional<OrgCompanyRel> findOrgComNum(final OrgCompanyNumberDTO orgCompanyNumberDTO) {
        Specification<OrgCompanyRel> specification = new Specification<OrgCompanyRel>(){

            public Predicate toPredicate(Root<OrgCompanyRel> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
                if (orgCompanyNumberDTO.getOrgId() != null) {
                    predicateList.add(cb.equal(root.get("orgStructId").as(Long.class), (Object)orgCompanyNumberDTO.getOrgId()));
                }
                if (StringUtils.isNotBlank((CharSequence)orgCompanyNumberDTO.getCompanyNumber())) {
                    predicateList.add(cb.equal(root.get("companyNo").as(String.class), (Object)orgCompanyNumberDTO.getCompanyNumber()));
                }
                Predicate[] pre = new Predicate[predicateList.size()];
                pre = predicateList.toArray(pre);
                return query.where(pre).getRestriction();
            }
        };
        return this.orgCompanynoDao.findOne((Specification)specification);
    }

    public List<OrgStruct> listByOrgKeys(Long tenantId, TreeModel.OrgScope scope, boolean byId, Set<String> keySet) {
        List models = null;
        if (byId) {
            Set idSet = keySet.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet());
            models = this.orgStructDao.findOrgByTenantIdAndOrgIds(tenantId.longValue(), idSet);
        } else {
            models = this.orgStructDao.findOrgByTenantIdAndOrgCodes(tenantId.longValue(), keySet);
        }
        if (TreeModel.OrgScope.SELF.equals((Object)scope)) {
            return models;
        }
        for (OrgStruct orgStruct : models) {
            List orgs = null;
            switch (scope) {
                case ANCESTOR: {
                    OrgModel.Request.Query query = new OrgModel.Request.Query();
                    query.setIds((Collection)OrgUtils.findOrgIdInParentIds((String)orgStruct.getParentIds()));
                    orgs = this.orgStructDao.findAll(OrgQueryHelper.querySpecification((OrgModel.Request.Query)query), EntityGraphs.named((String)"Org.graph"));
                    orgs = orgs.stream().filter(o -> !o.getOrgId().equals(orgStruct.getOrgId())).collect(Collectors.toList());
                    ArrayList<OrgStruct> ancestors = new ArrayList<OrgStruct>(orgs.size());
                    for (OrgStruct o2 : orgs) {
                        OrgStruct o22 = new OrgStruct();
                        BeanUtils.copyProperties((Object)o2, (Object)o22, (String[])((String[])Stream.of("ancestors").toArray(String[]::new)));
                        ancestors.add(o22);
                    }
                    orgStruct.setAncestors(ancestors);
                    break;
                }
                case DESCENDANT: {
                    orgs = this.orgStructDao.findChildrenByParentIds(orgStruct.getParentIds() + "%");
                    orgs = orgs.stream().filter(o -> !o.getOrgId().equals(orgStruct.getOrgId())).collect(Collectors.toList());
                    ArrayList<OrgStruct> descendants = new ArrayList<OrgStruct>(orgs.size());
                    for (OrgStruct o3 : orgs) {
                        OrgStruct o2 = new OrgStruct();
                        BeanUtils.copyProperties((Object)o3, (Object)o2, (String[])((String[])Stream.of("descendants").toArray(String[]::new)));
                        descendants.add(o2);
                    }
                    orgStruct.setDescendants(descendants);
                    break;
                }
            }
        }
        return models;
    }

    public boolean existOrgId(long orgId) {
        return this.orgStructDao.existsById((Object)orgId);
    }

    public boolean existByTenantIdAndOrgId(long tenantId, long orgId) {
        return this.orgStructDao.existsByTenantIdAndOrgId(tenantId, orgId);
    }

    public OrgStruct saveAndFlush(OrgStruct orgStruct) {
        Optional optionalTenant;
        Optional existOptional;
        Long existDefaultRoleId = null;
        Long newDefaultRoleId = orgStruct.getDefaultOrgRoleId();
        Tenant tenant = orgStruct.getTenant();
        if (orgStruct.getOrgId() != null && orgStruct.getOrgId() > 0L && (existOptional = this.orgStructDao.findById((Object)orgStruct.getOrgId())).isPresent()) {
            existDefaultRoleId = ((OrgStruct)existOptional.get()).getDefaultOrgRoleId();
        }
        this.setGradingRoleIdIfParentOrgRelated(orgStruct);
        this.relOrgUserWithNewOrgRoleId(orgStruct);
        orgStruct = (OrgStruct)this.orgStructDao.saveAndFlush((Object)orgStruct);
        if (tenant == null && orgStruct.getTenantId() != null && (optionalTenant = this.tenantDao.findById((Object)orgStruct.getTenantId())).isPresent()) {
            tenant = (Tenant)optionalTenant.get();
        }
        if (tenant != null) {
            orgStruct.setTenant(tenant);
        }
        this.orgPubService.sendOrgMsg(SAVE, orgStruct);
        this.orgVirtualOrgStructService.asyncRelateParentOrgVirtual(orgStruct);
        if (existDefaultRoleId != null && !existDefaultRoleId.equals(newDefaultRoleId)) {
            if (newDefaultRoleId == null) {
                this.roleUserRelDao.deleteByRoleIdAndOrgId(existDefaultRoleId, orgStruct.getOrgId());
            } else {
                this.roleUserRelDao.updateRoleId(existDefaultRoleId.longValue(), newDefaultRoleId.longValue());
            }
        }
        return orgStruct;
    }

    private void setGradingRoleIdIfParentOrgRelated(OrgStruct orgStruct) {
        OrgStruct parentOrg;
        Long parentOrgId = orgStruct.getParentId();
        if (parentOrgId != null && parentOrgId > 0L && (parentOrg = (OrgStruct)this.orgStructDao.findById((Object)parentOrgId).orElseThrow(() -> new IllegalArgumentException("\u7ec4\u7ec7id \u3010" + parentOrgId + "\u3011\u4e0d\u5b58\u5728"))).getGradingRoleId() != null && parentOrg.getGradingRoleId() > 0L) {
            orgStruct.setGradingRoleId(parentOrg.getGradingRoleId());
        }
    }

    private void relOrgUserWithNewOrgRoleId(OrgStruct orgStruct) {
        List userIds;
        if (null != orgStruct.getDefaultOrgRoleId() && orgStruct.getDefaultOrgRoleId() > 0L && !CollectionUtils.isEmpty((Collection)(userIds = this.orgUserRelDao.findUserIdsNotBindOrgRole(orgStruct.getOrgId(), orgStruct.getDefaultOrgRoleId())))) {
            ArrayList<RoleUserRel> list = new ArrayList<RoleUserRel>();
            for (Long userId : userIds) {
                RoleUserRel rel = new RoleUserRel();
                rel.setOrgId(orgStruct.getOrgId());
                rel.setUserId(userId);
                rel.setRelType(2);
                rel.setRoleId(orgStruct.getDefaultOrgRoleId());
                rel.setTenantId(orgStruct.getTenantId());
                list.add(rel);
            }
            this.roleUserRelDao.saveAllAndFlush(list);
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void bindUsers(long tenantId, long orgId, OrgModel.Request.BindUsers bindUsers) {
        if (bindUsers == null) {
            return;
        }
        this.bindUsers(tenantId, orgId, bindUsers.getUserIds(), bindUsers.isOverwrite());
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void bindUsers(long orgId, OrgModel.Request.BindUsers bindUsers) {
        if (bindUsers == null) {
            return;
        }
        this.bindUsers(null, orgId, bindUsers.getUserIds(), bindUsers.isOverwrite());
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void bindUsers(Long tenantId, long orgId, Collection<Long> userIds, boolean isOverwrite) {
        Set relIds;
        boolean existsOrg = this.orgStructDao.existsByTenantIdAndOrgId(tenantId.longValue(), orgId);
        if (!existsOrg) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u7ec4\u7ec7\u5b9e\u4f53(" + orgId + ")");
        }
        List existRels = this.orgUserRelDao.findByOrgId(orgId);
        Set insertingRels = userIds.stream().filter(Objects::nonNull).filter(userId -> existRels.stream().map(OrgUserRel::getUserId).noneMatch(relUserId -> relUserId.equals(userId))).map(userId -> {
            Optional userOptional = this.userDao.findById(userId);
            if (userOptional.isPresent()) {
                OrgUserRel orgUserRel = new OrgUserRel();
                if (tenantId != null && tenantId > 0L) {
                    orgUserRel.setTenantId(tenantId);
                } else {
                    orgUserRel.setTenantId(((User)userOptional.get()).getTenantId());
                }
                orgUserRel.setOrgStructId(Long.valueOf(orgId));
                orgUserRel.setUserId(userId);
                return orgUserRel;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!insertingRels.isEmpty()) {
            this.orgUserRelDao.saveAllAndFlush(insertingRels);
        }
        if (isOverwrite && (relIds = existRels.stream().filter(rel -> userIds.stream().noneMatch(userId -> userId.equals(rel.getUserId()))).map(OrgUserRel::getId).collect(Collectors.toSet())) != null && !relIds.isEmpty()) {
            this.orgUserRelDao.deleteAllByIdInBatch(relIds);
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void unbindUsers(long tenantId, long orgId, OrgModel.Request.UnbindUsers unbindUsers) {
        Set userIds = unbindUsers.getUserIds();
        if (CollectionUtils.isNotEmpty((Collection)userIds)) {
            this.orgUserRelDao.deleteByTenantIdAndOrgIdAndUserIds(tenantId, orgId, (Collection)userIds);
        }
    }

    static class OrgSaveOutput {
        private List<OrgStruct> orgs;

        public void addOrg(OrgStruct org) {
            if (this.orgs == null) {
                this.orgs = new ArrayList<OrgStruct>();
            }
            this.orgs.add(org);
        }

        public OrgStruct findFirst() {
            return this.orgs.stream().filter(Objects::nonNull).findFirst().orElse(null);
        }

        public Company findFirstCompany() {
            OrgStruct firstOrg = this.findFirst();
            if (firstOrg != null) {
                return firstOrg.getCompany();
            }
            return null;
        }

        public Long findFirstCompanyId() {
            OrgStruct firstOrg = this.findFirst();
            if (firstOrg != null) {
                return firstOrg.getCompanyId();
            }
            return null;
        }

        public void setOrgs(List<OrgStruct> orgs) {
            this.orgs = orgs;
        }

        public List<OrgStruct> getOrgs() {
            return this.orgs;
        }

        public String toString() {
            return "OrgService.OrgSaveOutput(orgs=" + this.getOrgs() + ")";
        }

        public OrgSaveOutput(List<OrgStruct> orgs) {
            this.orgs = orgs;
        }

        public OrgSaveOutput() {
        }
    }

    static class OrgSaveInput {
        private long tenantId;
        private long parentId;
        private OrgStruct parent;
        private List<OrgStruct> orgs;

        public void setTenantId(long tenantId) {
            this.tenantId = tenantId;
        }

        public void setParentId(long parentId) {
            this.parentId = parentId;
        }

        public void setParent(OrgStruct parent) {
            this.parent = parent;
        }

        public void setOrgs(List<OrgStruct> orgs) {
            this.orgs = orgs;
        }

        public long getTenantId() {
            return this.tenantId;
        }

        public long getParentId() {
            return this.parentId;
        }

        public OrgStruct getParent() {
            return this.parent;
        }

        public List<OrgStruct> getOrgs() {
            return this.orgs;
        }

        public String toString() {
            return "OrgService.OrgSaveInput(tenantId=" + this.getTenantId() + ", parentId=" + this.getParentId() + ", parent=" + this.getParent() + ", orgs=" + this.getOrgs() + ")";
        }

        public OrgSaveInput(long tenantId, long parentId, OrgStruct parent, List<OrgStruct> orgs) {
            this.tenantId = tenantId;
            this.parentId = parentId;
            this.parent = parent;
            this.orgs = orgs;
        }

        public OrgSaveInput() {
        }
    }
}

