/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.api.model.TenantModel;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelWriteService;
import com.xforceplus.business.tenant.dto.TenantExportDTO;
import com.xforceplus.business.tenant.service.TenantService;
import com.xforceplus.entity.Tenant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class TenantExcelExportServiceImpl
implements ExcelWriteService {
    private static final Logger logger = LoggerFactory.getLogger(TenantExcelExportServiceImpl.class);
    @Autowired
    private TenantService tenantService;

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.TENANT_EXCEL_FILE;
    }

    @Override
    public void write(Context context) {
        TenantModel.Request.Query query = context.getParam("P_QUERY", TenantModel.Request.Query.class);
        SimpleExcelWriter simpleExcelWriter = context.getSimpleExcelWriter();
        Integer maxPageSize = context.getMaxPageSize();
        logger.info("maxPageSize:{}", (Object)maxPageSize);
        if (Objects.nonNull(query.getTenantIds()) && query.getTenantIds().length > 0) {
            logger.info("tenant export:{}", (Object)query.getTenantIds().length);
            List<Tenant> tenantList = this.tenantService.findAllById(Arrays.asList(query.getTenantIds()));
            List<TenantExportDTO> exportVOList = this.tenantService.convert2ExportDto(tenantList);
            simpleExcelWriter.fill(query.getSheets()[0], exportVOList);
        } else {
            Page<Tenant> page;
            PageRequest pageable = PageRequest.of((int)0, (int)1000, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
            do {
                page = this.tenantService.page(query, (Pageable)pageable);
                List<TenantExportDTO> exportVOList = this.tenantService.convert2ExportDto(page.toList());
                simpleExcelWriter.fill(query.getSheets()[0], exportVOList);
            } while (page.hasNext() && (pageable = pageable.next()) != null && page.getNumber() < maxPageSize);
            logger.info("tenant page export, total page:{}", page);
        }
    }
}

