/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.api.model.TenantModel;
import com.xforceplus.api.model.TenantPolicyModel;
import com.xforceplus.dao.TenantDao;
import com.xforceplus.dao.TenantPolicyDao;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.TenantPolicy;
import com.xforceplus.query.TenantPolicyQueryHelper;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class TenantPolicyService {
    private static final Logger logger = LoggerFactory.getLogger(TenantPolicyService.class);
    @Autowired
    private TenantPolicyDao tenantPolicyDao;
    @Autowired
    private TenantDao tenantDao;
    public static final String TENANT_GRADING_MANAGEMENT_ENABLED = "tenantGradingMgrEnabled";

    public Page<TenantPolicy> page(TenantPolicyModel.Request.Query query, Pageable page) {
        Specification specification = TenantPolicyQueryHelper.querySpecification((TenantPolicyModel.Request.Query)query);
        Page tenants = this.tenantPolicyDao.findAll(specification, page);
        return tenants;
    }

    public Map<String, TenantPolicy> policies(long tenantId) {
        List policies = this.tenantPolicyDao.findByTenantId(tenantId);
        if (policies.isEmpty()) {
            return Stream.of(TenantPolicy.ofDefault((String)"passwordLength", (String)"8")).collect(Collectors.toMap(TenantPolicy::getName, policy -> policy));
        }
        return policies.stream().collect(Collectors.toMap(TenantPolicy::getName, policy -> policy));
    }

    public boolean tenantGradingManagementEnabled(long tenantId) {
        String policy;
        Map<String, TenantPolicy> map = this.policies(tenantId);
        return null != map && null != map.get(TENANT_GRADING_MANAGEMENT_ENABLED) && "1".equals(policy = map.get(TENANT_GRADING_MANAGEMENT_ENABLED).getPolicy());
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void policies(long tenantId, TenantModel.Request.Policies policies) {
        if (policies == null || policies.getPolicies() == null) {
            logger.info("policies == null, return null");
            return;
        }
        logger.info("isOverwrite = {}", (Object)policies.isOverwrite());
        logger.info("policies = " + policies.getPolicies().stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(",")));
        List existPolicies = this.tenantPolicyDao.findByTenantId(tenantId);
        logger.info("exist tenant.policies.size = " + existPolicies.size());
        Set<TenantPolicy> savingPolicies = policies.getPolicies().stream().filter(Objects::nonNull).map(policy -> {
            TenantPolicy tenantPolicy = existPolicies.stream().filter(p -> p.getName().equals(policy.getName())).findAny().orElseGet(TenantPolicy::new);
            tenantPolicy.setTenantId(Long.valueOf(tenantId));
            tenantPolicy.setName(policy.getName());
            tenantPolicy.setPolicy(policy.getPolicy());
            return tenantPolicy;
        }).collect(Collectors.toSet());
        this.savePolicies(savingPolicies);
        if (policies.isOverwrite()) {
            existPolicies.stream().filter(Objects::nonNull).filter(existPolicy -> policies.getPolicies().stream().filter(Objects::nonNull).noneMatch(policy -> policy.getName().equals(existPolicy.getName()))).forEach(existPolicy -> {
                try {
                    this.tenantPolicyDao.deleteById(existPolicy.getId());
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            });
        }
    }

    @Deprecated
    public void savePolicies(Collection<TenantPolicy> policies) {
        if (!CollectionUtils.isEmpty(policies)) {
            policies.forEach(arg_0 -> ((TenantPolicyDao)this.tenantPolicyDao).saveAndFlush(arg_0));
        }
    }

    public TenantPolicy save(TenantPolicyModel.Request.Save model) {
        Tenant tenant = (Tenant)this.tenantDao.findById((Object)model.getTenantId()).orElseThrow(() -> new InvalidParameterException("\u79df\u6237(id: " + model.getTenantId() + ")\u4e0d\u5b58\u5728\uff01"));
        List policies = this.tenantPolicyDao.findByTenantIdAndName(model.getTenantId().longValue(), model.getName());
        if (!CollectionUtils.isEmpty((Collection)policies)) {
            throw new InvalidParameterException("\u79df\u6237(id: " + model.getTenantId() + ")\u7b56\u7565(name:" + model.getName() + ")\u5df2\u5b58\u5728\uff01");
        }
        TenantPolicy policy = new TenantPolicy();
        policy.setName(model.getName());
        policy.setPolicy(model.getPolicy());
        policy.setTenantId(model.getTenantId());
        return (TenantPolicy)this.tenantPolicyDao.saveAndFlush((Object)policy);
    }

    public void deleteById(Long id) {
        this.tenantPolicyDao.deleteById(id);
    }

    public TenantPolicy findById(long id) {
        return this.tenantPolicyDao.findById((Object)id).orElse(null);
    }

    public TenantPolicy update(TenantPolicyModel.Request.Update update) {
        TenantPolicy policy = (TenantPolicy)this.tenantPolicyDao.findById((Object)update.getId()).orElseThrow(() -> new InvalidParameterException("\u7b56\u7565ID\u4e0d\u5b58\u5728\uff01"));
        policy.setId(update.getId());
        policy.setName(update.getName());
        policy.setPolicy(update.getPolicy());
        return (TenantPolicy)this.tenantPolicyDao.saveAndFlush((Object)policy);
    }
}

