/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.business.tenant.service.TenantService;
import com.xforceplus.dao.TenantRelationDao;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.TenantRelation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantRelationService {
    private static final Logger logger = LoggerFactory.getLogger(TenantRelationService.class);
    @Autowired
    private TenantRelationDao tenantRelationDao;
    @Autowired
    private TenantService tenantService;

    public List<TenantRelation> findTenantRelationByTenantId(Long tenantId) {
        if (tenantId == null || tenantId < 1L) {
            throw new IllegalArgumentException("tenantId \u4e0d\u5408\u6cd5");
        }
        return this.tenantRelationDao.findByTenantId(tenantId);
    }

    public void addTenantReletion(Long parentTenantId, Long childTenantId) {
        if (parentTenantId == null || parentTenantId < 1L || childTenantId == null || childTenantId < 1L) {
            throw new IllegalArgumentException("tenantId \u4e0d\u5408\u6cd5");
        }
        if (parentTenantId.equals(childTenantId)) {
            throw new IllegalArgumentException("parent==child, \u4f60\u8fd9\u6837\u641e\uff0c\u7cfb\u7edf\u8981\u5d29\u6e83\u7684\uff01");
        }
        Tenant parentTenant = this.tenantService.findById(parentTenantId);
        Tenant childTenant = this.tenantService.findById(childTenantId);
        List tenantRelationList = this.tenantRelationDao.findByParentTenantIdAndChildTenantId(childTenantId, parentTenantId);
        if (tenantRelationList != null && tenantRelationList.size() > 0) {
            throw new IllegalArgumentException("\u53cd\u5411\u5173\u7cfb\u5df2\u7ecf\u5b58\u5728\uff0c\u4f60\u8fd9\u6837\u641e\uff0c\u7cfb\u7edf\u771f\u7684\u5d29\u6e83\u4e86\uff01");
        }
        tenantRelationList = this.tenantRelationDao.findByParentTenantIdAndChildTenantId(parentTenantId, childTenantId);
        if (tenantRelationList != null && tenantRelationList.size() > 0) {
            return;
        }
        TenantRelation tenantRelation = new TenantRelation();
        tenantRelation.setParentTenantId(parentTenantId);
        tenantRelation.setChildTenantId(childTenantId);
        this.tenantRelationDao.save((Object)tenantRelation);
    }

    public void deleteTenantReletion(Long parentTenantId, Long childTenantId) {
        if (parentTenantId == null || parentTenantId < 1L || childTenantId == null || childTenantId < 1L) {
            throw new IllegalArgumentException("tenantId \u4e0d\u5408\u6cd5");
        }
        List tenantRelationList = this.tenantRelationDao.findByParentTenantIdAndChildTenantId(parentTenantId, childTenantId);
        if (tenantRelationList != null && tenantRelationList.size() > 0) {
            this.tenantRelationDao.deleteAll((Iterable)tenantRelationList);
        }
    }
}

