/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.xforceplus.api.model.AccountModel;
import com.xforceplus.api.model.UserModel;
import com.xforceplus.bo.org.OrgCompanyQueryBo;
import com.xforceplus.business.account.service.AccountService;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.MessageRow;
import com.xforceplus.business.excel.reader.SimpleDataReadListener;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelReaderService;
import com.xforceplus.business.tenant.dto.UserImportDTO;
import com.xforceplus.business.tenant.dto.UserOrgImportDTO;
import com.xforceplus.business.tenant.dto.UserRoleImportDTO;
import com.xforceplus.business.tenant.dto.UserTagImportDTO;
import com.xforceplus.business.tenant.service.OrgService;
import com.xforceplus.business.tenant.service.RoleService;
import com.xforceplus.business.tenant.service.TenantService;
import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.config.ImportExportThreadPool;
import com.xforceplus.domain.account.AccountType;
import com.xforceplus.domain.user.view.ExtraInfo;
import com.xforceplus.dto.org.OrgCompanyDTO;
import com.xforceplus.entity.Account;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.RoleUserRel;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.User;
import com.xforceplus.entity.UserTag;
import com.xforceplus.tenant.security.core.domain.OrgType;
import io.geewit.core.utils.enums.BinaryUtils;
import io.geewit.core.utils.reflection.BeanUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserImportService
implements ExcelReaderService {
    private static final Logger logger = LoggerFactory.getLogger(UserImportService.class);
    public static final HashMap<String, Integer> SHEET_HEADER_NUMBER = new HashMap(6);
    private static final Integer HEADER_ROW_NUMBER = 2;
    @Autowired
    private UserService userService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private OrgService orgService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private AccountService accountService;

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.USER_IMPORT;
    }

    @Override
    public Context importExcel(Context context) {
        List<ExcelSheet> sheets = context.getExcelBook().getExcelSheets();
        for (ExcelSheet sheet : sheets) {
            AnalysisEventListener excelDataListener;
            MessageRow messageRows = new MessageRow(sheet.getSheetName());
            Integer headerNumber = SHEET_HEADER_NUMBER.get(sheet.getSheetName());
            if ("\u4eba\u5458\u57fa\u672c\u4fe1\u606f".equalsIgnoreCase(sheet.getSheetName())) {
                excelDataListener = null;
                excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveUserData(messageRows, context, (List<UserImportDTO>)rows));
                context.getSimpleExcelReader().read(UserImportDTO.class, excelDataListener, sheet.getSheetName(), headerNumber);
                continue;
            }
            if ("\u4eba\u5458\u548c\u7ec4\u7ec7\u5173\u7cfb".equalsIgnoreCase(sheet.getSheetName())) {
                excelDataListener = null;
                excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveUserOrgData(messageRows, context, (List<UserOrgImportDTO>)rows));
                context.getSimpleExcelReader().read(UserOrgImportDTO.class, excelDataListener, sheet.getSheetName(), headerNumber);
                continue;
            }
            if ("\u4eba\u5458\u548c\u89d2\u8272".equalsIgnoreCase(sheet.getSheetName())) {
                excelDataListener = null;
                excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveUserRoleData(messageRows, context, (List<UserRoleImportDTO>)rows));
                context.getSimpleExcelReader().read(UserRoleImportDTO.class, excelDataListener, sheet.getSheetName(), headerNumber);
                continue;
            }
            if ("\u4eba\u5458\u548c\u53d1\u7968\u7c7b\u578b".equalsIgnoreCase(sheet.getSheetName())) {
                excelDataListener = null;
                excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveUserTagData(messageRows, context, (List<UserTagImportDTO>)rows, "invoiceType"));
                context.getSimpleExcelReader().read(UserTagImportDTO.class, excelDataListener, sheet.getSheetName(), headerNumber);
                continue;
            }
            if ("\u4eba\u5458\u548c\u7a0e\u63a7\u8bbe\u5907".equalsIgnoreCase(sheet.getSheetName())) {
                excelDataListener = null;
                excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveUserTagData(messageRows, context, (List<UserTagImportDTO>)rows, "printingEquipment"));
                context.getSimpleExcelReader().read(UserTagImportDTO.class, excelDataListener, sheet.getSheetName(), headerNumber);
                continue;
            }
            if (!"\u4eba\u5458\u548c\u7a0e\u63a7\u7ec8\u7aef".equalsIgnoreCase(sheet.getSheetName())) continue;
            excelDataListener = null;
            excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveUserTagData(messageRows, context, (List<UserTagImportDTO>)rows, "ticketOpeningTerminal"));
            context.getSimpleExcelReader().read(UserTagImportDTO.class, excelDataListener, sheet.getSheetName(), headerNumber);
        }
        return context;
    }

    public void saveUserData(MessageRow messageRows, Context context, List<UserImportDTO> list) {
        Long tenantId = context.getFileDTO().getTenantId();
        Tenant tenant = this.tenantService.findById(tenantId);
        logger.info("user-data-size:{}", (Object)list.size());
        try {
            this.asyncBatchOperation(dataRowList -> this.saveUser((List<UserImportDTO>)dataRowList, messageRows, tenant, tenantId, context), list).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("save user error:{}", (Object)e.getMessage());
            throw new IllegalArgumentException("\u5bfc\u5165\u7528\u6237\u5931\u8d25\uff0c\u5f53\u524d\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }

    private void saveUser(List<UserImportDTO> list, MessageRow messageRows, Tenant tenant, Long tenantId, Context context) {
        logger.info("batch-user-data-size:{}", (Object)list.size());
        for (UserImportDTO userImportDTO : list) {
            logger.info("user excel info:{}", (Object)JSONObject.toJSONString((Object)userImportDTO));
            if (!userImportDTO.getValidatedStatus().booleanValue()) {
                messageRows.fail(userImportDTO.getRowIndex(), userImportDTO.getValidatedMessage());
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)userImportDTO.getEmail()) && StringUtils.isEmpty((CharSequence)userImportDTO.getTelPhone()) && StringUtils.isEmpty((CharSequence)userImportDTO.getUsername())) {
                messageRows.fail(userImportDTO.getRowIndex(), "\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            String username = this.getAccountName(userImportDTO);
            username = this.userService.getDomainAccountName(username, tenant.getTenantCode());
            User user = null;
            AccountModel.Request.Login query = new AccountModel.Request.Login();
            if (StringUtils.isNotBlank((CharSequence)userImportDTO.getTelPhone())) {
                query.setTelPhone(userImportDTO.getTelPhone());
            }
            if (StringUtils.isNotBlank((CharSequence)userImportDTO.getEmail())) {
                query.setEmail(userImportDTO.getEmail());
            }
            if (StringUtils.isNotBlank((CharSequence)userImportDTO.getUsername())) {
                query.setUsername(username);
            }
            Account account = null;
            List<Account> accountList = this.accountService.findAllByQuery(query);
            if (!CollectionUtils.isEmpty(accountList)) {
                if (accountList.size() == 1) {
                    account = accountList.get(0);
                    this.handleUserAccountUpdate(account, userImportDTO, tenant.getTenantCode());
                } else {
                    messageRows.fail(userImportDTO.getRowIndex(), "\u5e73\u53f0\u5df2\u5b58\u5728\u591a\u4e2a\u5bf9\u5e94\u8d26\u53f7\uff0c\u5bfc\u5165\u51b2\u7a81");
                    context.messageRow(messageRows.getSheetName(), messageRows);
                    return;
                }
            }
            if (account != null) {
                user = this.userService.findUserByTenantIdAndAccountIdWithoutStatus(tenantId, account.getAccountId());
            }
            if ("\u65b0\u5efa".equalsIgnoreCase(userImportDTO.getAction())) {
                if (user != null) {
                    messageRows.fail(userImportDTO.getRowIndex(), "\u7528\u6237\u5df2\u7ecf\u5b58\u5728");
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)userImportDTO.getPassword())) {
                    messageRows.fail(userImportDTO.getRowIndex(), "\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    continue;
                }
                UserModel.Request.Create userModel = new UserModel.Request.Create();
                userModel.setType(AccountType.OTHER);
                BeanUtils.copyProperties((Object)userImportDTO, (Object)userModel);
                AccountModel.Request.Create accountModel = new AccountModel.Request.Create();
                accountModel.setTelPhone(userImportDTO.getTelPhone());
                accountModel.setEmail(userImportDTO.getEmail());
                accountModel.setUsername(userImportDTO.getUsername());
                if (StringUtils.isNotBlank((CharSequence)userImportDTO.getUsername())) {
                    String tenantUserName = this.userService.getDomainAccountName(userImportDTO.getUsername(), tenant.getTenantCode());
                    accountModel.setUsername(tenantUserName);
                }
                if (userImportDTO.getChangePasswordFlag() != null) {
                    accountModel.setChangePasswordFlag(userImportDTO.getChangePasswordFlag() > 0);
                }
                accountModel.setType(AccountType.OTHER);
                if (!StringUtils.isEmpty((CharSequence)userImportDTO.getPassword())) {
                    accountModel.setPassword(userImportDTO.getPassword());
                    accountModel.setRandomPassword(false);
                }
                if (!StringUtils.isEmpty((CharSequence)accountModel.getEmail()) || !StringUtils.isEmpty((CharSequence)accountModel.getTelPhone())) {
                    userModel.setType(AccountType.PHONE_EMAIL);
                    accountModel.setType(AccountType.PHONE_EMAIL);
                }
                if (StringUtils.isNotBlank((CharSequence)userImportDTO.getUserSex())) {
                    if (userImportDTO.getUserSex().contains("\u7537")) {
                        userModel.setUserSex(Integer.valueOf(0));
                    } else {
                        userModel.setUserSex(Integer.valueOf(1));
                    }
                }
                userModel.setTenantId(tenantId);
                userModel.setContactAddr(userImportDTO.getContactAddr());
                userModel.setAccount(accountModel);
                try {
                    this.userService.saveUserPure(tenant, userModel, accountModel, account);
                    messageRows.success(userImportDTO.getRowIndex());
                }
                catch (Exception e) {
                    logger.error("\u4fee\u6539\u5f02\u5e38", (Throwable)e);
                    messageRows.fail(userImportDTO.getRowIndex(), e.getMessage());
                }
                continue;
            }
            if (!"\u4fee\u6539".equalsIgnoreCase(userImportDTO.getAction())) continue;
            if (user != null) {
                if (!StringUtils.isEmpty((CharSequence)userImportDTO.getEmail())) {
                    user.setEmail(userImportDTO.getEmail());
                }
                if (!StringUtils.isEmpty((CharSequence)userImportDTO.getUserPhone())) {
                    user.setUserPhone(userImportDTO.getUserPhone());
                }
                if (!StringUtils.isEmpty((CharSequence)userImportDTO.getUserName())) {
                    user.setUserName(userImportDTO.getUserName());
                }
                if (!StringUtils.isEmpty((CharSequence)userImportDTO.getUserIdCard())) {
                    user.setUserIdCard(userImportDTO.getUserIdCard());
                }
                if (!StringUtils.isEmpty((CharSequence)userImportDTO.getContactAddr())) {
                    user.setContactAddr(userImportDTO.getContactAddr());
                }
                if (!StringUtils.isEmpty((CharSequence)userImportDTO.getUserWorkTel())) {
                    user.setUserWorkTel(userImportDTO.getUserWorkTel());
                }
                if (!StringUtils.isEmpty((CharSequence)userImportDTO.getUserSex())) {
                    if (userImportDTO.getUserSex().contains("\u7537")) {
                        user.setUserSex(Integer.valueOf(0));
                    } else {
                        user.setUserSex(Integer.valueOf(1));
                    }
                }
                if (userImportDTO.getStatus() != null && userImportDTO.getStatus() > 0) {
                    user.setStatus(Integer.valueOf(1));
                    user.setActiveStatus(Integer.valueOf(1));
                } else {
                    user.setStatus(Integer.valueOf(0));
                    user.setActiveStatus(Integer.valueOf(0));
                }
                if (!StringUtils.isEmpty((CharSequence)userImportDTO.getUserNumber())) {
                    user.setUserNumber(userImportDTO.getUserNumber());
                }
                if (!StringUtils.isEmpty((CharSequence)userImportDTO.getUserCode())) {
                    user.setUserCode(userImportDTO.getUserCode());
                }
                if (!StringUtils.isEmpty((CharSequence)userImportDTO.getContactAddr())) {
                    user.setContactAddr(userImportDTO.getContactAddr());
                }
                if (userImportDTO.getChangePasswordFlag() != null && userImportDTO.getChangePasswordFlag() > 0) {
                    account.setChangePasswordFlag(Boolean.valueOf(true));
                } else {
                    account.setChangePasswordFlag(Boolean.valueOf(false));
                }
                if (userImportDTO.getExpiredDate() != null) {
                    user.setExpiredDate(userImportDTO.getExpiredDate());
                }
                try {
                    this.userService.updateUserPure(user, account);
                    messageRows.success(userImportDTO.getRowIndex());
                }
                catch (Exception e) {
                    logger.error("\u4fee\u6539\u5f02\u5e38", (Throwable)e);
                    messageRows.fail(userImportDTO.getRowIndex(), e.getMessage());
                }
                continue;
            }
            messageRows.fail(userImportDTO.getRowIndex(), "\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
        }
    }

    public void saveUserOrgData(MessageRow messageRows, Context context, List<UserOrgImportDTO> list) {
        Long tenantId = context.getFileDTO().getTenantId();
        Tenant tenant = this.tenantService.findById(tenantId);
        try {
            this.asyncBatchOperation(dataList -> this.saveUserOrg((List<UserOrgImportDTO>)dataList, messageRows, tenant, tenantId, context), list).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("save user-org error:{}", (Object)e.getMessage());
            throw new IllegalArgumentException("\u5bfc\u5165\u7528\u6237\u5173\u8054\u7ec4\u7ec7\u5931\u8d25\uff0c\u5f53\u524d\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }

    private void saveUserOrg(List<UserOrgImportDTO> list, MessageRow messageRows, Tenant tenant, Long tenantId, Context context) {
        for (UserOrgImportDTO orgImportDTO : list) {
            logger.info("user org:{}", (Object)JSONObject.toJSONString((Object)orgImportDTO));
            if (!orgImportDTO.getValidatedStatus().booleanValue()) {
                messageRows.fail(orgImportDTO.getRowIndex(), orgImportDTO.getValidatedMessage());
                continue;
            }
            String username = orgImportDTO.getUsername();
            String tenantUsername = this.userService.getDomainAccountName(username, tenant.getTenantCode());
            Optional<User> userOptional = this.userService.findByTenantIdAndUsername(tenantId, tenantUsername);
            User user = null;
            if (!userOptional.isPresent() && !(userOptional = this.userService.findByTenantIdAndUsername(tenantId, username)).isPresent()) {
                messageRows.fail(orgImportDTO.getRowIndex(), "\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
                continue;
            }
            user = userOptional.get();
            user = this.userService.findById(user.getId(), BinaryUtils.toBinary((Enum)ExtraInfo.currentOrgs));
            String orgCode = orgImportDTO.getOrgCode();
            String taxNum = orgImportDTO.getTaxNum();
            if ("\u7ed1\u5b9a".equalsIgnoreCase(orgImportDTO.getAction())) {
                boolean isBind = false;
                if (!CollectionUtils.isEmpty((Collection)user.getOrgs())) {
                    for (OrgStruct org : user.getOrgs()) {
                        if (!org.getOrgCode().equalsIgnoreCase(orgImportDTO.getOrgCode())) continue;
                        messageRows.fail(orgImportDTO.getRowIndex(), "\u8be5\u7ec4\u7ec7\u5df2\u7ecf\u7ed1\u5b9a");
                        isBind = true;
                        break;
                    }
                }
                if (isBind) continue;
                try {
                    if (StringUtils.isBlank((CharSequence)orgCode) && StringUtils.isBlank((CharSequence)taxNum)) {
                        messageRows.fail(orgImportDTO.getRowIndex(), "\u7ec4\u7ec7\u4ee3\u7801\u548c\u516c\u53f8\u7a0e\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                        context.messageRow(messageRows.getSheetName(), messageRows);
                        return;
                    }
                    if (StringUtils.isNotBlank((CharSequence)orgCode)) {
                        List<OrgStruct> orgStructList = this.orgService.findByTenantIdAndOrgCode(tenantId, orgImportDTO.getOrgCode());
                        if (!CollectionUtils.isEmpty(orgStructList)) {
                            Optional<Object> optionalOrgStruct = StringUtils.isNotBlank((CharSequence)taxNum) ? orgStructList.stream().filter(item -> taxNum.equals(item.getTaxNum())).findFirst() : orgStructList.stream().findFirst();
                            if (optionalOrgStruct.isPresent()) {
                                OrgStruct orgStruct = (OrgStruct)optionalOrgStruct.get();
                                if (orgStruct.getOrgType().equals((Object)OrgType.GROUP)) {
                                    messageRows.fail(orgImportDTO.getRowIndex(), "\u4e0d\u80fd\u7ed1\u5b9a\u6bcd\u516c\u53f8");
                                    continue;
                                }
                                this.userService.bindOrgs(user, Lists.newArrayList((Object[])new Long[]{((OrgStruct)optionalOrgStruct.get()).getOrgId()}), null, false, false, false);
                                messageRows.success(orgImportDTO.getRowIndex());
                                continue;
                            }
                            messageRows.fail(orgImportDTO.getRowIndex(), "\u7ec4\u7ec7\u4ee3\u7801\u548c\u516c\u53f8\u7a0e\u53f7\u4e0d\u4e00\u81f4\u6216\u4e0d\u5b58\u5728");
                            continue;
                        }
                        messageRows.fail(orgImportDTO.getRowIndex(), "\u7ec4\u7ec7code\u672a\u627e\u5230\uff01");
                        continue;
                    }
                    OrgCompanyQueryBo orgCompanyQueryBo = new OrgCompanyQueryBo();
                    orgCompanyQueryBo.setTaxNum(taxNum);
                    orgCompanyQueryBo.setTenantId(tenantId);
                    List<OrgCompanyDTO> orgCompanyDTOList = this.orgService.findOrgCompanyByTaxNum(orgCompanyQueryBo);
                    if (!CollectionUtils.isEmpty(orgCompanyDTOList)) {
                        this.userService.bindOrgs(user, Lists.newArrayList((Object[])new Long[]{orgCompanyDTOList.get(0).getOrgId()}), null, false, false, false);
                        messageRows.success(orgImportDTO.getRowIndex());
                        continue;
                    }
                    messageRows.fail(orgImportDTO.getRowIndex(), "\u516c\u53f8\u7a0e\u53f7\u672a\u627e\u5230\uff01");
                }
                catch (Exception e) {
                    logger.error("\u7ed1\u5b9a\u7ec4\u7ec7\u5f02\u5e38", (Throwable)e);
                    messageRows.fail(orgImportDTO.getRowIndex(), e.getMessage());
                }
                continue;
            }
            if (!"\u89e3\u7ed1".equalsIgnoreCase(orgImportDTO.getAction())) continue;
            boolean isUnBind = false;
            if (StringUtils.isBlank((CharSequence)orgCode) && StringUtils.isBlank((CharSequence)taxNum)) {
                messageRows.fail(orgImportDTO.getRowIndex(), "\u7ec4\u7ec7\u4ee3\u7801\u548c\u516c\u53f8\u7a0e\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                context.messageRow(messageRows.getSheetName(), messageRows);
                return;
            }
            if (!CollectionUtils.isEmpty((Collection)user.getCurrentOrgs())) {
                for (OrgStruct org : user.getCurrentOrgs()) {
                    if (StringUtils.isNotBlank((CharSequence)orgCode)) {
                        if (StringUtils.isNotBlank((CharSequence)taxNum)) {
                            if (!orgCode.equalsIgnoreCase(org.getOrgCode()) || !taxNum.equalsIgnoreCase(org.getTaxNum())) continue;
                            this.userService.unbindOrgs(tenantId, user.getId(), null, Lists.newArrayList((Object[])new Long[]{org.getOrgId()}));
                            isUnBind = true;
                            messageRows.success(orgImportDTO.getRowIndex());
                            break;
                        }
                        if (!orgCode.equalsIgnoreCase(org.getOrgCode())) continue;
                        this.userService.unbindOrgs(tenantId, user.getId(), null, Lists.newArrayList((Object[])new Long[]{org.getOrgId()}));
                        isUnBind = true;
                        messageRows.success(orgImportDTO.getRowIndex());
                        break;
                    }
                    if (!taxNum.equalsIgnoreCase(org.getTaxNum())) continue;
                    this.userService.unbindOrgs(tenantId, user.getId(), null, Lists.newArrayList((Object[])new Long[]{org.getOrgId()}));
                    isUnBind = true;
                    messageRows.success(orgImportDTO.getRowIndex());
                    break;
                }
            }
            if (isUnBind) continue;
            messageRows.fail(orgImportDTO.getRowIndex(), "\u8be5\u7ec4\u7ec7\u672a\u7ed1\u5b9a");
        }
    }

    public void saveUserTagData(MessageRow messageRows, Context context, List<UserTagImportDTO> list, String tagName) {
        Long tenantId = context.getFileDTO().getTenantId();
        Tenant tenant = this.tenantService.findById(tenantId);
        logger.info("import-tag-data:{},{}", (Object)tenant.getTenantCode(), (Object)tagName);
        for (UserTagImportDTO tag2 : list) {
            if (tag2.getValidatedStatus().booleanValue()) continue;
            messageRows.fail(tag2.getRowIndex(), tag2.getValidatedMessage());
        }
        logger.info("user-tag-size:{}", (Object)list.size());
        Map<String, List<UserTagImportDTO>> tagMap = list.stream().filter(tag -> StringUtils.isNotEmpty((CharSequence)tag.getUsername())).collect(Collectors.groupingBy(UserTagImportDTO::getUsername));
        ArrayList<Map.Entry<String, List<UserTagImportDTO>>> dataList = new ArrayList<Map.Entry<String, List<UserTagImportDTO>>>(tagMap.entrySet());
        try {
            this.asyncBatchOperation(data -> this.saveUserTag((List<Map.Entry<String, List<UserTagImportDTO>>>)data, messageRows, tenant, tenantId, context, tagName), dataList).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("save user-tag error:{}", (Object)e.getMessage());
            throw new IllegalArgumentException("\u5bfc\u5165\u7528\u6237\u6807\u7b7e\u5931\u8d25\uff0c\u5f53\u524d\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }

    private void saveUserTag(List<Map.Entry<String, List<UserTagImportDTO>>> list, MessageRow messageRows, Tenant tenant, Long tenantId, Context context, String tagName) {
        HashSet<Map.Entry<String, List<UserTagImportDTO>>> set = new HashSet<Map.Entry<String, List<UserTagImportDTO>>>(list);
        for (Map.Entry entry : set) {
            String username = (String)entry.getKey();
            String tenantUsername = this.userService.getDomainAccountName(username, tenant.getTenantCode());
            Optional<User> userOptional = this.userService.findByTenantIdAndUsername(tenantId, tenantUsername);
            User user = null;
            if (!userOptional.isPresent() && !(userOptional = this.userService.findByTenantIdAndUsername(tenantId, username)).isPresent()) {
                ((List)entry.getValue()).forEach(tag -> messageRows.fail(tag.getRowIndex(), "\u8be5\u7528\u6237\u4e0d\u5b58\u5728"));
                continue;
            }
            user = userOptional.get();
            String currentTagVal = "";
            UserTag currentUserTag = null;
            List userTagsList = user.getUserTags();
            if (!CollectionUtils.isEmpty((Collection)userTagsList)) {
                for (UserTag userTag : userTagsList) {
                    if (!tagName.equalsIgnoreCase(userTag.getTagName())) continue;
                    currentTagVal = userTag.getTagValue();
                    currentUserTag = userTag;
                }
            }
            Map<String, List<UserTagImportDTO>> tagMapByAction = ((List)entry.getValue()).stream().collect(Collectors.groupingBy(UserTagImportDTO::getAction));
            List<UserTagImportDTO> bindList = tagMapByAction.get("\u7ed1\u5b9a");
            List<UserTagImportDTO> unbindList = tagMapByAction.get("\u89e3\u7ed1");
            Set tagSet = Arrays.stream(currentTagVal.split(",")).collect(Collectors.toSet());
            if ("invoiceType".equalsIgnoreCase(tagName)) {
                if (!CollectionUtils.isEmpty(bindList)) {
                    currentTagVal = currentTagVal + "," + bindList.stream().map(tag -> tag.getInvoiceType()).distinct().collect(Collectors.joining(","));
                    tagSet.addAll(bindList.stream().filter(tag -> StringUtils.isNotEmpty((CharSequence)tag.getInvoiceType())).map(tag -> tag.getInvoiceType().trim()).distinct().collect(Collectors.toList()));
                }
                if (!CollectionUtils.isEmpty(unbindList)) {
                    for (UserTagImportDTO userTagImportDTO : unbindList) {
                        if (userTagImportDTO.getInvoiceType() == null) continue;
                        tagSet.remove(userTagImportDTO.getInvoiceType().trim());
                    }
                }
            } else if ("printingEquipment".equalsIgnoreCase(tagName)) {
                if (!CollectionUtils.isEmpty(bindList)) {
                    currentTagVal = currentTagVal + "," + bindList.stream().map(tag -> tag.getPrintingEquipment()).distinct().collect(Collectors.joining(","));
                    tagSet.addAll(bindList.stream().filter(tag -> StringUtils.isNotEmpty((CharSequence)tag.getPrintingEquipment())).map(tag -> tag.getPrintingEquipment().trim()).distinct().collect(Collectors.toList()));
                }
                if (!CollectionUtils.isEmpty(unbindList)) {
                    for (UserTagImportDTO userTagImportDTO : unbindList) {
                        if (userTagImportDTO.getPrintingEquipment() == null) continue;
                        tagSet.remove(userTagImportDTO.getPrintingEquipment().trim());
                    }
                }
            } else if ("ticketOpeningTerminal".equalsIgnoreCase(tagName)) {
                if (!CollectionUtils.isEmpty(bindList)) {
                    currentTagVal = currentTagVal + "," + bindList.stream().map(tag -> tag.getTicketOpeningTerminal()).distinct().collect(Collectors.joining(","));
                    tagSet.addAll(bindList.stream().filter(tag -> StringUtils.isNotEmpty((CharSequence)tag.getTicketOpeningTerminal())).map(tag -> tag.getTicketOpeningTerminal().trim()).distinct().collect(Collectors.toList()));
                }
                if (!CollectionUtils.isEmpty(unbindList)) {
                    for (UserTagImportDTO userTagImportDTO : unbindList) {
                        if (userTagImportDTO.getTicketOpeningTerminal() == null) continue;
                        tagSet.remove(userTagImportDTO.getTicketOpeningTerminal().trim());
                    }
                }
            }
            if (currentUserTag == null) {
                currentUserTag = new UserTag();
                currentUserTag.setTagName(tagName);
                currentUserTag.setUserId(user.getId());
            }
            currentUserTag.setTagValue(tagSet.stream().filter(t -> StringUtils.isNotBlank((CharSequence)t)).collect(Collectors.joining(",")));
            try {
                if (StringUtils.isBlank((CharSequence)currentUserTag.getTagValue()) && currentUserTag.getId() != null) {
                    this.userService.deleteUserTagById(currentUserTag.getId());
                } else {
                    if (currentUserTag.getTagValue().startsWith(",")) {
                        currentUserTag.setTagValue(currentUserTag.getTagValue().replaceFirst(",", ""));
                    }
                    this.userService.saveUserTag(currentUserTag);
                }
                if (!CollectionUtils.isEmpty(bindList)) {
                    for (UserTagImportDTO tag2 : bindList) {
                        logger.info("sheetName{},bindListSize:{}", (Object)tagName, (Object)bindList.size());
                        messageRows.success(tag2.getRowIndex());
                    }
                }
                if (CollectionUtils.isEmpty(unbindList)) continue;
                for (UserTagImportDTO tag2 : unbindList) {
                    messageRows.success(tag2.getRowIndex());
                }
            }
            catch (Exception e) {
                logger.error("\u66f4\u65b0usertag\u5931\u8d25", (Throwable)e);
                if (!CollectionUtils.isEmpty(bindList)) {
                    for (UserTagImportDTO tag3 : bindList) {
                        messageRows.fail(tag3.getRowIndex(), "\u66f4\u65b0\u5931\u8d25\uff1a" + e.getMessage());
                    }
                }
                if (CollectionUtils.isEmpty(unbindList)) continue;
                for (UserTagImportDTO tag3 : unbindList) {
                    messageRows.fail(tag3.getRowIndex(), "\u66f4\u65b0\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
    }

    public void saveUserRoleData(MessageRow messageRows, Context context, List<UserRoleImportDTO> list) {
        Long tenantId = context.getFileDTO().getTenantId();
        Tenant tenant = this.tenantService.findById(tenantId);
        try {
            this.asyncBatchOperation(data -> this.saveUserRole((List<UserRoleImportDTO>)data, messageRows, tenant, tenantId, context), list).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("save user-role error:{}", (Object)e.getMessage());
            throw new IllegalArgumentException("\u5bfc\u5165\u7528\u6237\u89d2\u8272\u5931\u8d25\uff0c\u5f53\u524d\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }

    private void saveUserRole(List<UserRoleImportDTO> list, MessageRow messageRows, Tenant tenant, Long tenantId, Context context) {
        for (UserRoleImportDTO roleImportDTO : list) {
            logger.info("user role:{}", (Object)JSONObject.toJSONString((Object)roleImportDTO));
            if (!roleImportDTO.getValidatedStatus().booleanValue()) {
                messageRows.fail(roleImportDTO.getRowIndex(), roleImportDTO.getValidatedMessage());
                continue;
            }
            String username = roleImportDTO.getUsername();
            String tenantUsername = this.userService.getDomainAccountName(username, tenant.getTenantCode());
            Optional<User> userOptional = this.userService.findByTenantIdAndUsername(tenantId, tenantUsername);
            User user = null;
            if (!userOptional.isPresent() && !(userOptional = this.userService.findByTenantIdAndUsername(tenantId, username)).isPresent()) {
                messageRows.fail(roleImportDTO.getRowIndex(), "\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
                continue;
            }
            user = userOptional.get();
            if ("\u7ed1\u5b9a".equalsIgnoreCase(roleImportDTO.getAction())) {
                boolean isBind = false;
                if (!CollectionUtils.isEmpty((Collection)user.getRoleUserRels())) {
                    for (RoleUserRel roleUserRel : user.getRoleUserRels()) {
                        if (!roleUserRel.getRole().getCode().equalsIgnoreCase(roleImportDTO.getRoleCode())) continue;
                        messageRows.fail(roleImportDTO.getRowIndex(), "\u8be5\u89d2\u8272\u5df2\u7ecf\u7ed1\u5b9a");
                        isBind = true;
                        break;
                    }
                }
                if (isBind) continue;
                try {
                    Long roleId = this.roleService.findIdByTenantIdAndCode(tenantId, roleImportDTO.getRoleCode());
                    if (roleId != null) {
                        this.userService.bindRoles(tenantId, null, user.getId(), Lists.newArrayList((Object[])new Long[]{roleId}), null, null, null, false, false, false);
                        messageRows.success(roleImportDTO.getRowIndex());
                        continue;
                    }
                    messageRows.fail(roleImportDTO.getRowIndex(), "\u89d2\u8272code\u4e0d\u5b58\u5728");
                }
                catch (Exception e) {
                    logger.error("role bind error", (Throwable)e);
                    messageRows.fail(roleImportDTO.getRowIndex(), e.getMessage());
                }
                continue;
            }
            if (!"\u89e3\u7ed1".equalsIgnoreCase(roleImportDTO.getAction())) continue;
            boolean isUnBind = false;
            for (RoleUserRel roleUserRel : user.getRoleUserRels()) {
                if (!roleUserRel.getRole().getCode().equalsIgnoreCase(roleImportDTO.getRoleCode())) continue;
                this.userService.unbindRoles(tenantId, user.getId(), Lists.newArrayList((Object[])new Long[]{roleUserRel.getRoleId()}));
                isUnBind = true;
                messageRows.success(roleImportDTO.getRowIndex());
                break;
            }
            if (isUnBind) continue;
            messageRows.fail(roleImportDTO.getRowIndex(), "\u8be5\u89d2\u8272code\u672a\u7ed1\u5b9a");
        }
    }

    private String getAccountName(UserImportDTO userImportDTO) {
        String accountName = userImportDTO.getEmail();
        if (StringUtils.isEmpty((CharSequence)accountName)) {
            accountName = userImportDTO.getTelPhone();
        }
        if (StringUtils.isEmpty((CharSequence)accountName)) {
            accountName = userImportDTO.getUsername();
        }
        return accountName;
    }

    @Override
    public HashMap<String, Integer> getSheetHeaderNumber() {
        return SHEET_HEADER_NUMBER;
    }

    private CompletableFuture<Void> asyncBatchOperation(Consumer<List> consumer, List dataList) {
        int partitionSize = dataList.size() > ImportExportThreadPool.CORE_POOL_SIZE ? dataList.size() / ImportExportThreadPool.CORE_POOL_SIZE : 1;
        List partitionList = ListUtils.partition((List)dataList, (int)partitionSize);
        ArrayList futureList = new ArrayList();
        partitionList.forEach(item -> futureList.add(CompletableFuture.runAsync(() -> consumer.accept((List)item), ImportExportThreadPool.get())));
        return CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0]));
    }

    private void handleUserAccountUpdate(Account account, UserImportDTO importDTO, String tenantCode) {
        if (StringUtils.isNotBlank((CharSequence)importDTO.getEmail()) && StringUtils.isBlank((CharSequence)account.getEmail())) {
            account.setEmail(importDTO.getEmail());
        }
        if (StringUtils.isNotBlank((CharSequence)importDTO.getTelPhone()) && StringUtils.isBlank((CharSequence)account.getTelPhone())) {
            account.setTelPhone(importDTO.getTelPhone());
        }
        if (StringUtils.isNotBlank((CharSequence)importDTO.getUsername()) && StringUtils.isBlank((CharSequence)account.getUsername())) {
            String tenantUsername = this.userService.getDomainAccountName(importDTO.getUsername(), tenantCode);
            account.setUsername(tenantUsername);
        }
    }

    static {
        SHEET_HEADER_NUMBER.put("\u4eba\u5458\u57fa\u672c\u4fe1\u606f", HEADER_ROW_NUMBER);
        SHEET_HEADER_NUMBER.put("\u4eba\u5458\u548c\u7ec4\u7ec7\u5173\u7cfb", HEADER_ROW_NUMBER);
        SHEET_HEADER_NUMBER.put("\u4eba\u5458\u548c\u89d2\u8272", HEADER_ROW_NUMBER);
        SHEET_HEADER_NUMBER.put("\u4eba\u5458\u548c\u7a0e\u63a7\u8bbe\u5907", HEADER_ROW_NUMBER);
        SHEET_HEADER_NUMBER.put("\u4eba\u5458\u548c\u7a0e\u63a7\u7ec8\u7aef", HEADER_ROW_NUMBER);
        SHEET_HEADER_NUMBER.put("\u4eba\u5458\u548c\u53d1\u7968\u7c7b\u578b", HEADER_ROW_NUMBER);
    }
}

