/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.entity.User;
import io.geewit.core.utils.reflection.BeanUtils;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;

@Service
public class UserRedisCacheService {
    private static final Logger log = LoggerFactory.getLogger(UserRedisCacheService.class);
    public static final String LOGIN_USER_KEY = "userId:%s:loginId:%s";
    public static final String USER_CACHE_NAME = "User";
    private final CacheManager cacheManager;

    public UserRedisCacheService(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public Optional<User> getUserByUserIdAndLoginId(Long userId, String loginId) {
        User user;
        Cache cache = this.cacheManager.getCache(USER_CACHE_NAME);
        if (cache == null) {
            return Optional.empty();
        }
        if (StringUtils.isEmpty((CharSequence)loginId)) {
            return Optional.empty();
        }
        String cacheKey = String.format(LOGIN_USER_KEY, userId, loginId);
        try {
            user = (User)cache.get((Object)cacheKey, User.class);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            user = null;
        }
        log.info("cached user in redis: {}", (Object)user);
        return Optional.ofNullable(user);
    }

    public void pubUserByUserIdAndLoginId(User user, Long userId, String loginId) {
        if (StringUtils.isEmpty((CharSequence)loginId)) {
            return;
        }
        Cache cache = this.cacheManager.getCache(USER_CACHE_NAME);
        if (cache == null) {
            return;
        }
        String cacheKey = String.format(LOGIN_USER_KEY, userId, loginId);
        User cachingUser = new User();
        BeanUtils.copyProperties((Object)user, (Object)cachingUser, (String[])((String[])Stream.of("taxNums", "roleUserRels", "orgUserRels", "orgVirtualNodeUserRels", "userApps").toArray(String[]::new)));
        cache.put((Object)cacheKey, (Object)cachingUser);
    }

    public void cleanUserByUserIdAndLoginId(long userId, String loginId) {
        Cache cache = this.cacheManager.getCache(USER_CACHE_NAME);
        if (cache == null) {
            return;
        }
        String cacheKey = String.format(LOGIN_USER_KEY, userId, loginId);
        cache.evictIfPresent((Object)cacheKey);
    }
}

