/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.google.common.collect.Lists;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.AccountModel;
import com.xforceplus.api.model.OrgModel;
import com.xforceplus.api.model.RoleModel;
import com.xforceplus.api.model.UserModel;
import com.xforceplus.business.account.service.AccountService;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.externalservice.terminal.TerminalApiServiceImpl;
import com.xforceplus.business.externalservice.terminal.model.MsDeviceInfo;
import com.xforceplus.business.externalservice.terminal.model.MsTerminalQueryResponseInfo;
import com.xforceplus.business.messagebus.UserPubService;
import com.xforceplus.business.resource.service.ResourceService;
import com.xforceplus.business.resource.service.ServiceApiService;
import com.xforceplus.business.resource.service.ServicePackageService;
import com.xforceplus.business.tenant.dto.RoleAccountImportDto;
import com.xforceplus.business.tenant.dto.UserExportDTO;
import com.xforceplus.business.tenant.dto.UserOrgExportDTO;
import com.xforceplus.business.tenant.dto.UserRoleExportDTO;
import com.xforceplus.business.tenant.dto.UserTagDTO;
import com.xforceplus.business.tenant.dto.UserTerminalDTO;
import com.xforceplus.business.tenant.service.OrgService;
import com.xforceplus.business.tenant.service.RoleAccountImportService;
import com.xforceplus.business.tenant.service.RoleService;
import com.xforceplus.business.tenant.service.TenantPolicyService;
import com.xforceplus.business.tenant.service.UserRedisCacheService;
import com.xforceplus.config.ImportExportThreadPool;
import com.xforceplus.constants.EnvProfile;
import com.xforceplus.dao.AccountDao;
import com.xforceplus.dao.AppDao;
import com.xforceplus.dao.CompanyTenantRelDao;
import com.xforceplus.dao.OrgStructDao;
import com.xforceplus.dao.OrgUserRelDao;
import com.xforceplus.dao.RoleDao;
import com.xforceplus.dao.RoleUserRelDao;
import com.xforceplus.dao.TenantDao;
import com.xforceplus.dao.UserAppDao;
import com.xforceplus.dao.UserDao;
import com.xforceplus.dao.UserTagDao;
import com.xforceplus.domain.account.AccountDto;
import com.xforceplus.domain.account.AccountType;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.resource.RequestUri;
import com.xforceplus.domain.resource.RequestUriAuthz;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.tenant.TenantManagerDto;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.domain.user.UserExportDto;
import com.xforceplus.domain.user.view.ExtraInfo;
import com.xforceplus.entity.Account;
import com.xforceplus.entity.App;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.OrgUserRel;
import com.xforceplus.entity.Resource;
import com.xforceplus.entity.Role;
import com.xforceplus.entity.RoleUserRel;
import com.xforceplus.entity.ServicePackage;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.User;
import com.xforceplus.entity.UserApp;
import com.xforceplus.entity.UserTag;
import com.xforceplus.query.OrgQueryHelper;
import com.xforceplus.query.UserQueryHelper;
import com.xforceplus.redis.lock.RedisLock;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.domain.OrgType;
import com.xforceplus.utils.DateUtils;
import com.xforceplus.utils.OrgUtils;
import com.xforceplus.utils.RegExUtil;
import com.xforceplus.utils.RequestMappingHelper;
import com.xforceplus.utils.RoleUtils;
import io.geewit.core.jackson.view.View;
import io.geewit.core.utils.enums.BinaryUtils;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.core.utils.tree.TreeUtils;
import io.geewit.data.jpa.essential.domain.EntityGraph;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import io.geewit.data.jpa.essential.search.DynamicSpecifications;
import io.geewit.data.jpa.essential.search.Operator;
import io.geewit.data.jpa.essential.search.SearchFilter;
import io.geewit.web.utils.JsonUtils;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@CacheConfig(cacheNames={"AuthorizedUser", "User"})
@Service
public class UserService
implements DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(UserService.class);
    private static final String EVENT_USERS_STATUS = "EVENT_USERS_STATUS";
    private static final String PRINTING_EQUIPMENT = "printingEquipment";
    private static final String TICKET_TERMINAL = "ticketOpeningTerminal";
    private final AppDao appDao;
    private final AccountDao accountDao;
    private final OrgService orgService;
    private final RoleService roleService;
    private final UserDao userDao;
    private final UserAppDao userAppDao;
    private final UserTagDao userTagDao;
    private final RoleDao roleDao;
    private final OrgStructDao orgStructDao;
    private final OrgUserRelDao orgUserRelDao;
    private final RoleUserRelDao roleUserRelDao;
    private final TenantDao tenantDao;
    private final AccountService accountService;
    private final ServicePackageService packageService;
    private final ServiceApiService serviceApiService;
    private final CacheManager cacheManager;
    private final RedisTemplate redisTemplate;
    private final UserRedisCacheService userRedisCacheService;
    private TerminalApiServiceImpl terminalApiService;
    @Autowired
    private Validator validator;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private CompanyTenantRelDao companyTenantRelDao;
    @Autowired
    private TenantPolicyService tenantPolicyService;
    @Autowired
    private UserPubService userPubService;
    @Value(value="${xforce.global.grading-managment.enable:true}")
    private boolean globalGradingEnabled;
    private static final ThreadLocal<CachedRoleOrgUserRels> cachedRoleOrgUserRelsThreadLocal = new ThreadLocal();

    public UserService(AppDao appDao, AccountDao accountDao, UserDao userDao, UserAppDao userAppDao, UserTagDao userTagDao, RoleDao roleDao, OrgStructDao orgStructDao, OrgUserRelDao orgUserRelDao, RoleUserRelDao roleUserRelDao, TenantDao tenantDao, AccountService accountService, OrgService orgService, RoleService roleService, ServicePackageService packageService, ServiceApiService serviceApiService, CacheManager cacheManager, RedisTemplate redisTemplate, UserRedisCacheService userRedisCacheService, TerminalApiServiceImpl terminalApiService) {
        this.appDao = appDao;
        this.accountDao = accountDao;
        this.userDao = userDao;
        this.userAppDao = userAppDao;
        this.userTagDao = userTagDao;
        this.roleDao = roleDao;
        this.orgStructDao = orgStructDao;
        this.orgUserRelDao = orgUserRelDao;
        this.roleUserRelDao = roleUserRelDao;
        this.tenantDao = tenantDao;
        this.accountService = accountService;
        this.orgService = orgService;
        this.roleService = roleService;
        this.packageService = packageService;
        this.serviceApiService = serviceApiService;
        this.cacheManager = cacheManager;
        this.redisTemplate = redisTemplate;
        this.userRedisCacheService = userRedisCacheService;
        this.terminalApiService = terminalApiService;
    }

    public void destroy() {
    }

    public Page<User> page(UserModel.Request.Query query, Pageable pageable) {
        Page<User> page = query.isDetail() ? this.page(query, pageable, EntityGraphs.named((String)"User.graph")) : this.page(query, pageable, EntityGraphs.named((String)"User.graph.account"));
        return page;
    }

    public Page<User> page(UserModel.Request.Query query, Pageable pageable, EntityGraph entityGraph) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        this.buildCurrentQuery(query, authorizedUser);
        Specification specification = UserQueryHelper.querySpecification((UserModel.Request.Query)query);
        Page result = entityGraph == null ? this.userDao.findAll(specification, pageable) : this.userDao.findAll(specification, pageable, entityGraph);
        if (query.isDetail()) {
            for (User user : result) {
                this.fulfill(user, 0);
                this.fillOrgRoles(user, query.getOrgId());
            }
        }
        return result;
    }

    public Page<User> page(Specification<User> specification, Pageable pageable) {
        return this.userDao.findAll(specification, pageable);
    }

    public List<User> list(UserModel.Request.Query query, Sort sort) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        this.buildCurrentQuery(query, authorizedUser);
        Specification specification = UserQueryHelper.querySpecification((UserModel.Request.Query)query);
        List list = this.userDao.findAll(specification, sort);
        return list;
    }

    public List<User> list(Specification<User> specification, Sort sort) {
        return this.userDao.findAll(specification, sort);
    }

    public Optional<User> findOne(UserModel.Request.Query query) {
        Specification specification = UserQueryHelper.queryOneSpecification((UserModel.Request.Query)query);
        return this.userDao.findOne(specification);
    }

    public long count(UserModel.Request.Query query) {
        Specification specification = UserQueryHelper.querySpecification((UserModel.Request.Query)query);
        return this.userDao.count(specification);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public <S extends UserModel.Request.Save, U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> UserModel.Request.SaveUserOutput<U, O, R, A> save(S model, boolean isRoleOverwrite, boolean isOrgOverwrite, boolean isTagOverwrite, boolean isAppOverwrite, boolean isMergeAccount, boolean isStrict) {
        User entity = new User();
        BeanUtils.copyProperties(model, (Object)entity, (String[])((String[])Stream.of("account").toArray(String[]::new)));
        long tenantId = model.getTenantId() != null ? model.getTenantId() : 0L;
        return this.save(tenantId, 0L, Stream.of(model).collect(Collectors.toList()), isRoleOverwrite, isOrgOverwrite, isTagOverwrite, isAppOverwrite, isMergeAccount, isStrict);
    }

    public <S extends UserModel.Request.Save, U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> UserModel.Request.SaveUserOutput<U, O, R, A> register(S model, String openId) {
        Object bindInfo = this.redisTemplate.opsForValue().get((Object)("BIND_WX_MP_" + openId));
        Long tenantId = 0L;
        if (bindInfo != null) {
            String[] binds = bindInfo.toString().split("#");
            if (binds.length == 2) {
                tenantId = Long.parseLong(binds[0]);
                long roleId = Long.parseLong(binds[1]);
                HashSet<Long> roles = new HashSet<Long>();
                roles.add(roleId);
                model.setRoleIds(roles);
            }
        } else {
            return null;
        }
        return this.save((long)tenantId, 0L, Stream.of(model).collect(Collectors.toList()), false, false, false, false, false, false);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void updateStatus(long userId, int status) {
        User existEntity = this.findById(userId);
        existEntity.setStatus(Integer.valueOf(status));
        this.saveAndFlush(existEntity);
        this.userPubService.sendUserToPubsub(existEntity, existEntity.getTenantId());
    }

    public void buildCurrentQuery(UserModel.Request.Query query, IAuthorizedUser authorizedUser) {
        if (authorizedUser == null) {
            return;
        }
        boolean tenantGradingEnabled = this.tenantPolicyService.tenantGradingManagementEnabled(authorizedUser.getTenantId());
        if (this.globalGradingEnabled && tenantGradingEnabled) {
            Triple<Boolean, Set<Long>, Set<Long>> adminAndGradingRoles = RoleUtils.calcAdminAndGradingRoles(authorizedUser);
            boolean isAdmin = (Boolean)adminAndGradingRoles.getLeft();
            Set gradingRoleIds = (Set)adminAndGradingRoles.getMiddle();
            Set orgRoleIds = (Set)adminAndGradingRoles.getRight();
            Set filterParentIds = new HashSet();
            if (orgRoleIds != null && !orgRoleIds.isEmpty()) {
                Set orgIds = this.roleUserRelDao.findOrgIdsByTenantIdAndRoleIdsAndType(authorizedUser.getTenantId().longValue(), (Collection)orgRoleIds);
                if (!(orgIds = orgIds.stream().filter(Objects::nonNull).collect(Collectors.toSet())).isEmpty()) {
                    filterParentIds = this.orgStructDao.findParentIdsByTenantIdAndOrgIds(authorizedUser.getTenantId().longValue(), orgIds);
                }
            }
            if (gradingRoleIds != null && !gradingRoleIds.isEmpty()) {
                List gradingOrgParentIdsList = this.orgStructDao.listParentIdsByGradingRoleIds((Collection)gradingRoleIds);
                filterParentIds.addAll(gradingOrgParentIdsList);
            }
            if (filterParentIds != null && !filterParentIds.isEmpty()) {
                query.setFilterOrgParentIds(filterParentIds);
            } else if (!isAdmin) {
                throw new InvalidParameterException("\u975e\u7ba1\u7406\u5458\u8eab\u4efd, \u8fd4\u56de\u7a7a\u5217\u8868");
            }
        } else {
            query.setIncludeIndependents(Boolean.valueOf(false));
        }
    }

    @RedisLock(lockPrefix="userCreate", key="userName")
    public User saveWithLock(UserModel.Request.Save model) {
        Optional entityOptional = this.userDao.findByTenantIdAndUserCode(model.getTenantId().longValue(), model.getUserCode());
        if (entityOptional.isPresent()) {
            logger.info("\u67e5\u8be2\u5230\u7528\u6237\u76f4\u63a5\u8fd4\u56de");
            return (User)entityOptional.get();
        }
        User entity = new User();
        BeanUtils.copyProperties((Object)model, (Object)entity, (String[])((String[])Stream.of("account").toArray(String[]::new)));
        if (entity.getUserPeriodTime() == null) {
            entity.setUserPeriodTime(new Date());
        }
        entity = this.saveAndFlush(entity);
        return entity;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public ResponseEntity<List<UserModel.Request.BindOrg>> bindUserOrg(List<UserModel.Request.BindOrg> bindOrgs) {
        if (CollectionUtils.isEmpty(bindOrgs)) {
            return ResponseEntity.fail((String)"0", (String)"\u8f93\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<UserModel.Request.BindOrg> resultOrgs = new ArrayList<UserModel.Request.BindOrg>(bindOrgs.size());
        for (UserModel.Request.BindOrg bindOrd : bindOrgs) {
            try {
                this.saveUserOrg(bindOrd);
                cachedRoleOrgUserRelsThreadLocal.remove();
                bindOrd.setResult(Boolean.valueOf(true));
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                bindOrd.setMsg(e.getMessage());
                bindOrd.setResult(Boolean.valueOf(false));
            }
            resultOrgs.add(bindOrd);
        }
        return ResponseEntity.ok(resultOrgs);
    }

    private void saveUserOrg(UserModel.Request.BindOrg bindOrg) {
        List orgs;
        String account = bindOrg.getAccount();
        AccountModel.Request.Login query = new AccountModel.Request.Login();
        if (account.contains("@")) {
            query.setEmail(account);
        } else if (RegExUtil.checkMobile((String)account)) {
            query.setTelPhone(account);
        } else {
            query.setUsername(account);
        }
        Account accountDto = this.accountService.findOneByQuery(query);
        if (null == accountDto || accountDto.getAccountId() < 1L) {
            throw new IllegalArgumentException("\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        UserModel.Request.Query userQuery = new UserModel.Request.Query();
        userQuery.setAccountId(accountDto.getAccountId());
        if (bindOrg.getTenantId() != null && bindOrg.getTenantId() > 0L) {
            userQuery.setTenantId(bindOrg.getTenantId());
        }
        if ((orgs = this.orgStructDao.findByTenantIdAndOrgCode(bindOrg.getTenantId().longValue(), bindOrg.getOrgCode())).isEmpty()) {
            throw new IllegalArgumentException("\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        }
        OrgStruct org = (OrgStruct)orgs.get(0);
        List<User> users = this.list(userQuery, Sort.unsorted());
        if (CollectionUtils.isEmpty(users)) {
            this.createUserAndBindOrg(accountDto, org);
            return;
        }
        for (User user : users) {
            if (!user.getTenantId().equals(org.getTenantId())) {
                String message = "\u7528\u6237(" + user.getId() + ")\u6240\u5728\u79df\u6237(" + user.getTenantId() + ")\u548c\u7ec4\u7ec7(" + org.getOrgId() + ")\u6240\u5728\u79df\u6237(" + org.getTenantId() + ")\u4e0d\u4e00\u81f4";
                throw new IllegalArgumentException(message);
            }
            this.bindUserIdAndOrgId(user, org.getOrgId());
        }
    }

    private void createUserAndBindOrg(Account accountDto, OrgStruct org) {
        User entity = new User();
        entity.setAccountId(accountDto.getAccountId());
        entity.setUserNumber(accountDto.getTelPhone());
        entity.setUserName(accountDto.getEmail());
        entity.setStatus(Integer.valueOf(1));
        User user = this.saveAndFlush(entity);
        if (!user.getTenantId().equals(org.getTenantId())) {
            String message = "\u7528\u6237(" + user.getId() + ")\u6240\u5728\u79df\u6237(" + user.getTenantId() + ")\u548c\u7ec4\u7ec7(" + org.getOrgId() + ")\u6240\u5728\u79df\u6237(" + org.getTenantId() + ")\u4e0d\u4e00\u81f4";
            throw new IllegalArgumentException(message);
        }
        this.bindUserIdAndOrgId(user, org.getOrgId());
    }

    private void bindUserIdAndOrgId(User user, Long orgId) {
        OrgUserRel orgUserRel = new OrgUserRel();
        orgUserRel.setFullSelectedFlag(Boolean.valueOf(true));
        orgUserRel.setOrgStructId(orgId);
        orgUserRel.setUserId(user.getId());
        orgUserRel.setTenantId(user.getTenantId());
        this.bindUserOrgs(Stream.of(orgUserRel).collect(Collectors.toList()), true);
    }

    public ResponseEntity<List<UserModel.Request.BindRole>> bindUsersAndRoles(List<UserModel.Request.BindRole> bindRoles) {
        ArrayList<UserModel.Request.BindRole> resultObj = new ArrayList<UserModel.Request.BindRole>(bindRoles.size());
        for (UserModel.Request.BindRole bindRole : bindRoles) {
            try {
                this.bindRoleAndAccount(bindRole.getAccount(), bindRole.getTenantId(), bindRole.getRoleCode());
                bindRole.setResult(true);
                resultObj.add(bindRole);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                bindRole.setResult(false);
                bindRole.setMsg(e.getMessage());
                resultObj.add(bindRole);
            }
        }
        return ResponseEntity.ok(resultObj);
    }

    private void bindRoleAndAccount(String account, Long tenantId, String roleCode) {
        AccountModel.Request.Login query = new AccountModel.Request.Login();
        if (account.contains("@")) {
            query.setEmail(account);
        } else {
            query.setTelPhone(account);
        }
        Account accountDto = this.accountService.findOneByQuery(query);
        if (null == accountDto || accountDto.getAccountId() < 1L) {
            throw new IllegalArgumentException("\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        UserModel.Request.Query userQuery = new UserModel.Request.Query();
        userQuery.setAccountId(accountDto.getAccountId());
        List<User> users = this.list(userQuery, Sort.unsorted());
        List roles = this.roleDao.findByTenantIdAndRoleCodes(tenantId.longValue(), (Collection)Stream.of(roleCode).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty((Collection)roles) || roles.size() > 1) {
            throw new IllegalArgumentException("\u89d2\u8272\u4e0d\u5b58\u5728\u6216\u8005\u4e3a\u591a\u4e2a");
        }
        ArrayList<RoleUserRel> roleUserRels = new ArrayList<RoleUserRel>(users.size());
        for (User user : users) {
            RoleUserRel roleUserRel = new RoleUserRel();
            roleUserRel.setTenantId(tenantId);
            roleUserRel.setRole((Role)roles.get(0));
            roleUserRel.setUserId(user.getId());
            roleUserRel.setRoleId(((Role)roles.get(0)).getId());
            Example example = Example.of((Object)roleUserRel);
            if (this.roleUserRelDao.exists(example)) continue;
            roleUserRels.add(roleUserRel);
        }
        if (!CollectionUtils.isEmpty(roleUserRels)) {
            roleUserRels.forEach(arg_0 -> ((RoleUserRelDao)this.roleUserRelDao).saveAndFlush(arg_0));
        }
    }

    public List<UserModel.Request.BatchSaveVo> batchCreate(List<UserModel.Request.BatchSave> models) {
        ArrayList<UserModel.Request.BatchSaveVo> batchSaveVo = new ArrayList<UserModel.Request.BatchSaveVo>(models.size());
        for (UserModel.Request.BatchSave save : models) {
            try {
                User user = this.createOneUser(save);
                batchSaveVo.add(new UserModel.Request.BatchSaveVo(user.getId(), Boolean.valueOf(true), "", save.getUserNumber()));
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                batchSaveVo.add(new UserModel.Request.BatchSaveVo(Long.valueOf(0L), Boolean.valueOf(false), e.getMessage(), save.getUserNumber()));
            }
        }
        return batchSaveVo;
    }

    private User createOneUser(UserModel.Request.BatchSave save) {
        AccountModel.Request.Login query = new AccountModel.Request.Login();
        query.setTelPhone(save.getUserNumber());
        Account account = this.accountService.findOneByQuery(query);
        if (account == null) {
            AccountModel.Request.Create create = new AccountModel.Request.Create();
            create.setPassword(save.getPassword());
            create.setStatus(Integer.valueOf(1));
            create.setTelPhone(save.getUserNumber());
            create.setEmail(save.getUserEmailAddr());
            account = this.accountService.saveOriginPassword(create);
        }
        if (account == null) {
            throw new IllegalArgumentException("\u521b\u5efa\u8d26\u53f7\u5931\u8d25");
        }
        save.setAccountId(account.getAccountId());
        return this.saveWithLock((UserModel.Request.Save)save);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public <S extends UserModel.Request.Save, U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> UserModel.Request.SaveUserOutput<U, O, R, A> save(UserModel.Request.SaveUserInput<S, O, U, R, A> saveUserInput) {
        Tenant tenant = null;
        if (saveUserInput.getTenantId() > 0L) {
            tenant = (Tenant)this.tenantDao.findById((Object)saveUserInput.getTenantId()).orElseThrow(() -> new IllegalArgumentException("\u975e\u6cd5\u7684\u79df\u6237id(" + saveUserInput.getTenantId() + ")"));
        }
        UserModel.Request.SaveUserOutput saveUserOutput = new UserModel.Request.SaveUserOutput(saveUserInput.getTenantId(), new HashMap());
        if (CollectionUtils.isEmpty((Collection)saveUserInput.getUsers())) {
            return saveUserOutput;
        }
        for (UserModel.Request.Save userModel : saveUserInput.getUsers()) {
            Optional userOptional;
            String message;
            AccountModel.Request.Create accountRequest;
            AccountType accountType = null;
            Account account = null;
            long accountId = 0L;
            long userId = 0L;
            User user = null;
            boolean isNew = false;
            if (userModel instanceof UserModel.Request.Create) {
                accountRequest = ((UserModel.Request.Create)userModel).getAccount();
                accountType = ((UserModel.Request.Create)userModel).getType();
            } else if (userModel instanceof UserModel.Request.Update) {
                accountRequest = ((UserModel.Request.Update)userModel).getAccount();
                userId = userModel.getUserId();
            } else {
                accountRequest = null;
            }
            if (accountRequest == null) {
                Optional userOptional2;
                logger.info("accountRequest == null");
                if (userModel.getAccountId() != null && userModel.getAccountId() > 0L) {
                    accountId = userModel.getAccountId();
                }
                if (accountId == 0L && userId > 0L) {
                    String message2;
                    userOptional2 = this.userDao.findById((Object)userId);
                    if (userOptional2.isPresent()) {
                        user = (User)userOptional2.get();
                        if (saveUserInput.getTenantId() > 0L && (user.getTenantId() == null || saveUserInput.getTenantId() != user.getTenantId().longValue())) {
                            message2 = "\u7528\u6237\u6240\u5728\u7684\u79df\u6237(" + user.getTenantId() + ")\u548c\u4f20\u5165\u53c2\u6570\u7684\u79df\u6237(" + saveUserInput.getTenantId() + ")\u4e0d\u4e00\u81f4";
                            logger.warn(message2);
                            throw new IllegalArgumentException(message2);
                        }
                        accountId = user.getAccountId();
                    } else {
                        message2 = "\u4e0d\u5b58\u5728\u7684userId(" + userId + ")";
                        throw new IllegalArgumentException(message2);
                    }
                }
                if (user == null && userModel.getTenantId() != null && userModel.getTenantId() > 0L && StringUtils.isNotBlank((CharSequence)userModel.getUserCode())) {
                    this.checkSaveUserTenantIdEquals(saveUserInput.getTenantId(), userModel.getTenantId());
                    userOptional2 = this.userDao.findByTenantIdAndUserCode(userModel.getTenantId().longValue(), userModel.getUserCode());
                    if (userOptional2.isPresent()) {
                        if (saveUserInput.isMergeAccount()) {
                            user = (User)userOptional2.get();
                            accountId = user.getAccountId();
                            if (tenant == null) {
                                tenant = user.getTenant();
                            }
                            isNew = false;
                        } else {
                            throw new IllegalArgumentException("\u91cd\u590d\u7684\u7528\u6237code(" + userModel.getUserCode() + ")");
                        }
                    }
                }
                if (accountId > 0L) {
                    message = "\u975e\u6cd5\u7684\u8d26\u6237id(" + accountId + ")";
                    account = (Account)this.accountDao.findById((Object)accountId).orElseThrow(() -> new IllegalArgumentException(message));
                }
                if (account == null) {
                    account = this.accountService.create(tenant, userModel.getUserPhone(), userModel.getUserEmailAddr(), userModel.getUserName(), null, userModel.getStatus(), accountType, true, false, saveUserInput.isMergeAccount(), false, null);
                }
                if (account == null) {
                    message = "\u65e0\u6cd5\u5173\u8054\u5e10\u53f7userPhone({" + userModel.getUserPhone() + "}), email({" + userModel.getUserEmailAddr() + "}), userName({" + userModel.getUserName() + "})";
                    logger.warn(message);
                    throw new IllegalArgumentException(message);
                }
                accountId = account.getAccountId();
            } else {
                logger.info("accountRequest != null");
                if (accountRequest instanceof AccountModel.Request.Update) {
                    if (((AccountModel.Request.Update)accountRequest).getAccountId() != null && ((AccountModel.Request.Update)accountRequest).getAccountId() != 0L) {
                        accountId = ((AccountModel.Request.Update)accountRequest).getAccountId();
                    }
                } else if (accountRequest instanceof AccountModel.Request.Create && accountId == 0L) {
                    if (accountType == null) {
                        accountType = accountRequest.getType();
                    }
                    if ((account = this.accountService.create(tenant, accountRequest.getTelPhone(), accountRequest.getEmail(), accountRequest.getUsername(), accountRequest.getPassword(), userModel.getStatus(), accountType, accountRequest.isEnableSendMsg(), accountRequest.isRandomPassword(), saveUserInput.isMergeAccount(), accountRequest.isChangePasswordFlag(), accountRequest.getUpdateIgnoreProperties())) == null) {
                        message = "user: " + accountRequest.toString() + "\u65e0\u6cd5\u5173\u8054\u5e10\u53f7";
                        logger.warn(message);
                        throw new IllegalArgumentException(message);
                    }
                    accountId = account.getAccountId();
                }
            }
            UserModel.Request.SaveUserContext saveUserContext = new UserModel.Request.SaveUserContext();
            if (account != null) {
                saveUserContext.setAccount(account);
            }
            if (accountId > 0L) {
                userModel.setAccountId(Long.valueOf(accountId));
            }
            if (user == null && userModel.getUserId() != null && userModel.getUserId() > 0L) {
                Optional<User> optionalUser = this.findUserById(userModel.getUserId());
                if (optionalUser.isPresent()) {
                    user = optionalUser.get();
                } else {
                    user = null;
                    userModel.setUserId(null);
                }
            }
            if (user == null && accountId > 0L) {
                List users = this.userDao.findByTenantIdAndAccountId(saveUserInput.getTenantId(), accountId);
                user = users.stream().findFirst().orElse(null);
            }
            if (user == null && StringUtils.isNotBlank((CharSequence)userModel.getUserCode()) && (userOptional = this.userDao.findByTenantIdAndUserCode(saveUserInput.getTenantId(), userModel.getUserCode())).isPresent()) {
                user = (User)userOptional.get();
            }
            if (user != null) {
                if (StringUtils.isBlank((CharSequence)userModel.getUserCode())) {
                    userModel.setUserCode(null);
                } else {
                    this.validExistsByTenantIdAndUserCode(saveUserInput.getTenantId(), user.getId(), userModel.getUserCode());
                }
                BeanUtils.copyProperties((Object)userModel, (Object)user, (String[])((String[])Stream.of("account").toArray(String[]::new)));
            } else {
                user = new User();
                isNew = true;
                BeanUtils.copyProperties((Object)userModel, (Object)user, (String[])((String[])Stream.of("account").toArray(String[]::new)));
                user.setTenantId(Long.valueOf(saveUserInput.getTenantId()));
            }
            if (accountId > 0L) {
                user.setAccountId(Long.valueOf(accountId));
            }
            if (userModel.getStatus() != null) {
                user.setStatus(userModel.getStatus());
                user.setActiveStatus(userModel.getStatus());
            }
            if (StringUtils.isBlank((CharSequence)user.getUserEmailAddr()) && account != null && StringUtils.isNotBlank((CharSequence)account.getEmail())) {
                user.setUserEmailAddr(account.getEmail());
            }
            if (StringUtils.isBlank((CharSequence)user.getUserPhone()) && account != null && StringUtils.isNotBlank((CharSequence)account.getTelPhone())) {
                user.setUserPhone(account.getTelPhone());
            }
            if (tenant == null) {
                tenant = user.getTenant();
            }
            user = this.saveAndFlush(user);
            if (tenant != null) {
                user.setTenant(tenant);
            }
            if (account != null) {
                user.setAccount((AccountDto)account);
                saveUserContext.setAccount((AccountDto)account);
            }
            this.saveUserTags(user.getId(), userModel, saveUserInput.isTagOverwrite());
            if (saveUserInput.getOrgStruct() != null && saveUserInput.getOrgStruct().getOrgId() > 0L || userModel.getOrgIds() != null || userModel.getOrgCodes() != null) {
                HashSet filteredOrgIds = new HashSet();
                HashSet<Long> tempOrgIds = new HashSet<Long>();
                if (saveUserInput.getOrgStruct() != null && saveUserInput.getOrgStruct().getOrgId() > 0L) {
                    tempOrgIds.add(saveUserInput.getOrgStruct().getOrgId());
                }
                if (!CollectionUtils.isEmpty((Collection)userModel.getOrgIds())) {
                    tempOrgIds.addAll(userModel.getOrgIds());
                }
                if (!CollectionUtils.isEmpty(tempOrgIds)) {
                    List orgIds = this.orgStructDao.findOrgIdsByTenantIdAndOrgIds(saveUserInput.getTenantId(), tempOrgIds);
                    filteredOrgIds.addAll(orgIds);
                }
                if (!CollectionUtils.isEmpty((Collection)userModel.getOrgCodes())) {
                    Set orgCodes = userModel.getOrgCodes();
                    List orgs = new ArrayList();
                    if (CollectionUtils.isEmpty((Collection)orgCodes)) {
                        if (isNew) {
                            orgs = this.orgStructDao.findRootsByTenantId(saveUserInput.getTenantId());
                        }
                    } else {
                        orgs = this.orgStructDao.findByTenantIdAndOrgCodes(saveUserInput.getTenantId(), (Collection)orgCodes);
                        if (orgCodes.size() != orgs.size()) {
                            List finalOrgs = orgs;
                            Set diffOrgCodes = orgCodes.stream().filter(orgCode -> finalOrgs.stream().map(OrgStruct::getOrgCode).noneMatch(finalOrgCode -> finalOrgCode.equals(orgCode))).collect(Collectors.toSet());
                            String message3 = "User(" + user.getUserCode() + ")\u5305\u542b\u542b\u6709\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u7684\u7ec4\u7ec7\u4ee3\u7801(" + String.join((CharSequence)",", diffOrgCodes) + ")";
                            logger.warn(message3);
                            if (saveUserInput.isStrict()) {
                                throw new IllegalArgumentException(message3);
                            }
                        }
                    }
                    if (!orgs.isEmpty()) {
                        Set orgIdSet = orgs.stream().map(OrgStruct::getOrgId).collect(Collectors.toSet());
                        if (logger.isInfoEnabled()) {
                            logger.info("orgIdSet = " + orgIdSet.stream().map(Object::toString).collect(Collectors.joining(",")));
                        }
                        filteredOrgIds.addAll(orgIdSet);
                    }
                }
                saveUserContext.addOrgIds(filteredOrgIds);
            }
            if (userModel.getRoleIds() != null || userModel.getRoleCodes() != null) {
                Set roleCodes;
                List roles;
                HashSet roleIds = new HashSet();
                if (!CollectionUtils.isEmpty((Collection)userModel.getRoleIds())) {
                    Set roleIdSet = userModel.getRoleIds().stream().filter(roleId -> roleId != null && roleId > 0L).collect(Collectors.toSet());
                    if (logger.isInfoEnabled()) {
                        logger.info("roleIdSet = " + roleIdSet.stream().map(Object::toString).collect(Collectors.joining(",")));
                    }
                    roles = this.roleDao.findAllById(roleIdSet);
                    roleIdSet = roles.stream().filter(role -> role.getTenantId().equals(saveUserInput.getTenantId()) || role.getTenantId() == -1L).map(Role::getId).collect(Collectors.toSet());
                    if (logger.isDebugEnabled()) {
                        logger.debug("roleIdSet = " + roleIdSet.stream().map(Object::toString).collect(Collectors.joining(",")));
                    }
                    roleIds.addAll(roleIdSet);
                    Set<Role> copingRoleTemplates = roles.stream().filter(role -> role.getTenantId() == 0L).collect(Collectors.toSet());
                    Set<Role> copiedRoles = this.roleService.copyRoleTempates(saveUserInput.getTenantId(), copingRoleTemplates);
                    if (!CollectionUtils.isEmpty(copiedRoles)) {
                        Set copiedRoleIds = copiedRoles.stream().map(Role::getId).collect(Collectors.toSet());
                        roleIds.addAll(copiedRoleIds);
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)(roleCodes = userModel.getRoleCodes()))) {
                    roles = this.roleDao.findByTenantIdAndRoleCodes(saveUserInput.getTenantId(), (Collection)roleCodes);
                    if (roleCodes.size() != roles.size()) {
                        String message4 = "User(" + user.getUserCode() + ")\u5305\u542b\u542b\u6709\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u7684\u89d2\u8272\u4ee3\u7801";
                        logger.warn(message4);
                        if (saveUserInput.isStrict()) {
                            throw new IllegalArgumentException(message4);
                        }
                    }
                    if (!roles.isEmpty()) {
                        Set roleIdSet = roles.stream().map(Role::getId).collect(Collectors.toSet());
                        if (logger.isDebugEnabled()) {
                            logger.debug("roleIdSet = " + roleIdSet.stream().map(Object::toString).collect(Collectors.joining(",")));
                        }
                        roleIds.addAll(roleIdSet);
                    }
                }
                saveUserContext.addRoleIds(roleIds);
            }
            if (null != userModel.getUserType() && userModel.getUserType() == 0) {
                saveUserContext.addRoleId(1L);
            }
            if (userModel.getAppIds() != null) {
                HashSet appIds = new HashSet();
                if (!userModel.getAppIds().isEmpty()) {
                    Set appIdSet = userModel.getAppIds().stream().filter(appId -> appId != null && appId > 0L).collect(Collectors.toSet());
                    if (logger.isInfoEnabled()) {
                        logger.info("appIdSet = " + appIdSet.stream().map(Object::toString).collect(Collectors.joining(",")));
                    }
                    List apps = this.appDao.findAllById(appIdSet);
                    appIdSet = apps.stream().map(App::getAppId).collect(Collectors.toSet());
                    if (logger.isInfoEnabled()) {
                        logger.info("appIdSet = " + appIdSet.stream().map(Object::toString).collect(Collectors.joining(",")));
                    }
                    if (!appIdSet.isEmpty()) {
                        appIds.addAll(appIdSet);
                    }
                }
                saveUserContext.addAppIds(appIds);
            }
            this.bindOrgs(user, saveUserContext.getOrgIds(), saveUserInput.getModules(), saveUserInput.isOrgOverwrite(), saveUserInput.isStrict(), true);
            this.bindRoles(user, null, saveUserContext.getRoleIds(), null, null, null, saveUserInput.isRoleOverwrite(), saveUserInput.isStrict(), true);
            this.bindApps(user, (Collection<Long>)saveUserContext.getAppIds(), saveUserInput.isAppOverwrite(), saveUserInput.isStrict());
            this.commitBindUserOrgs();
            this.commitBindUserRoles();
            if (tenant != null) {
                user.setTenant(tenant);
            }
            saveUserContext.setUser((UserDto)user);
            saveUserOutput.putSaveUserContext(user.getId().longValue(), saveUserContext);
        }
        return saveUserOutput;
    }

    private void checkSaveUserTenantIdEquals(Long sourceTenantId, Long targetTenantId) {
        if (!(sourceTenantId <= 0L || targetTenantId != null && sourceTenantId.equals(targetTenantId))) {
            String message = "\u7528\u6237\u6240\u5728\u7684\u79df\u6237(" + targetTenantId + ")\u548c\u4f20\u5165\u53c2\u6570\u7684\u79df\u6237(" + sourceTenantId + ")\u4e0d\u4e00\u81f4";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
    }

    @Transactional(readOnly=true)
    public Optional<User> findUserByTenantIdAndUserCode(Long tenantId, String userCode, Boolean marge) {
        List users = this.userDao.findAllByTenantIdAndUserCode(tenantId.longValue(), userCode);
        if (CollectionUtils.isEmpty((Collection)users)) {
            return Optional.empty();
        }
        if (marge.booleanValue() && users.size() > 1) {
            logger.error("\u5408\u5e76\u7684\u7528\u6237\u5b58\u5728\u4e24\u6761\u4ee5\u4e0a\u8bb0\u5f55tenantId:{},userCode:{},marge:{}:size:{}", new Object[]{tenantId, userCode, marge});
            throw new IllegalStateException("\u5408\u5e76\u7684\u7528\u6237\u5b58\u5728\u4e24\u6761\u4ee5\u4e0a\u8bb0\u5f55 userCode:" + userCode);
        }
        User user = this.findOneValidUser(users);
        return Optional.of(user);
    }

    @Transactional(readOnly=true)
    public User findUserByTenantIdAndAccountId(Long tenantId, Long accountId) {
        UserModel.Request.Query query = new UserModel.Request.Query();
        query.setAccountId(accountId);
        query.setTenantId(tenantId);
        query.setStatus(Integer.valueOf(1));
        List userList = this.userDao.findAll(UserQueryHelper.querySpecification((UserModel.Request.Query)query), EntityGraphs.named((String)"User.graph"));
        if (!CollectionUtils.isEmpty((Collection)userList)) {
            return (User)userList.get(0);
        }
        return null;
    }

    @Transactional(readOnly=true)
    public User findUserByTenantIdAndAccountIdWithoutStatus(Long tenantId, Long accountId) {
        UserModel.Request.Query query = new UserModel.Request.Query();
        query.setAccountId(accountId);
        query.setTenantId(tenantId);
        List userList = this.userDao.findAll(UserQueryHelper.querySpecification((UserModel.Request.Query)query), EntityGraphs.named((String)"User.graph"));
        if (!CollectionUtils.isEmpty((Collection)userList)) {
            return (User)userList.get(0);
        }
        return null;
    }

    @Transactional(readOnly=true)
    public void validExistsByTenantIdAndUserCode(long tenantId, Long userId, String userCode) {
        logger.info("validExistsByTenantIdAndUserCode-tenantId:{},userCode:{}", (Object)tenantId, (Object)userCode);
        Assert.hasText((String)userCode, (String)"\u7528\u6237\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List ids = this.userDao.selectIdsByTenantIdAndUserCode(tenantId, userCode);
        if (!(CollectionUtils.isEmpty((Collection)ids) || userId != null && ids.contains(userId))) {
            String message = "\u7528\u6237\u4ee3\u7801(" + userCode + ")\u51b2\u7a81";
            throw new IllegalArgumentException(message);
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public <S extends UserModel.Request.Save, U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> UserModel.Request.SaveUserOutput<U, O, R, A> save(long tenantId, OrgStruct orgStruct, S userSaveModel, boolean isRoleOverwrite, boolean isOrgOverwrite, boolean isTagOverwrite, boolean isAppOverwrite, boolean isMergeAccount, boolean isStrict) {
        if (!this.tenantDao.existsById((Object)tenantId)) {
            throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u79df\u6237id(" + tenantId + ")");
        }
        List models = Stream.of(userSaveModel).collect(Collectors.toList());
        ArrayList orgUserRels = new ArrayList();
        ArrayList roleUserRels = new ArrayList();
        UserModel.Request.SaveUserInput saveUserInput = new UserModel.Request.SaveUserInput(tenantId, (OrgDto)orgStruct, models, orgUserRels, roleUserRels, userSaveModel.getModules(), isRoleOverwrite, isOrgOverwrite, isAppOverwrite, isTagOverwrite, isMergeAccount, isStrict);
        UserModel.Request.SaveUserOutput<U, O, R, A> saveUserOutput = this.save(saveUserInput);
        return saveUserOutput;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public <S extends UserModel.Request.Save, U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> UserModel.Request.SaveUserOutput<U, O, R, A> save(long tenantId, long orgId, List<S> models, boolean isRoleOverwrite, boolean isOrgOverwrite, boolean isTagOverwrite, boolean isAppOverwrite, boolean isMergeAccount, boolean isStrict) {
        if (CollectionUtils.isEmpty(models)) {
            throw new IllegalArgumentException("\u6ca1\u6709\u6709\u6548\u62a5\u6587");
        }
        if (tenantId > 0L && !this.tenantDao.existsById((Object)tenantId)) {
            throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u79df\u6237id(" + tenantId + ")");
        }
        OrgStruct orgStruct = null;
        if (orgId > 0L) {
            Optional orgStructOptional;
            if (tenantId > 0L) {
                OrgModel.Request.Query query = new OrgModel.Request.Query();
                query.setTenantId(Long.valueOf(tenantId));
                query.setOrgId(Long.valueOf(orgId));
                orgStructOptional = this.orgStructDao.findOne(OrgQueryHelper.querySpecification((OrgModel.Request.Query)query), EntityGraphs.named((String)"Org.graph"));
            } else {
                orgStructOptional = this.orgStructDao.findById((Serializable)Long.valueOf(orgId), EntityGraphs.named((String)"Org.graph"));
            }
            if (orgStructOptional.isPresent()) {
                orgStruct = (OrgStruct)orgStructOptional.get();
            } else {
                String message = "\u4e0d\u5408\u6cd5\u7684\u7ec4\u7ec7id(" + orgId + ")\u548c\u79df\u6237id(" + tenantId + ")";
                logger.warn(message);
                throw new IllegalArgumentException(message);
            }
        }
        ArrayList orgUserRels = new ArrayList();
        ArrayList roleUserRels = new ArrayList();
        UserModel.Request.SaveUserInput saveUserInput = new UserModel.Request.SaveUserInput(tenantId, (OrgDto)orgStruct, models, orgUserRels, roleUserRels, null, isRoleOverwrite, isOrgOverwrite, isTagOverwrite, isAppOverwrite, isMergeAccount, isStrict);
        UserModel.Request.SaveUserOutput<U, O, R, A> saveUserOutput = this.save(saveUserInput);
        return saveUserOutput;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public User update(long userId, UserModel.Request.Save model) {
        User existEntity = this.findById(userId);
        if (StringUtils.isBlank((CharSequence)model.getUserCode())) {
            model.setUserCode(null);
        }
        BeanUtils.copyProperties((Object)model, (Object)existEntity, (String[])((String[])Stream.of("account").toArray(String[]::new)));
        User user = this.saveAndFlush(existEntity);
        this.saveUserTags(user.getId(), model, true);
        this.bindApps(user, (Collection<Long>)model.getAppIds(), true, false);
        this.bindOrgs(user.getTenantId(), user.getId(), model.getOrgIds(), model.getModules(), true, false, false);
        return user;
    }

    public void saveUserTags(long userId, UserModel.Request.Save model, boolean isOverwrite) {
        this.saveUserTags(userId, model.getInvoiceType(), model.getPrintingEquipment(), model.getTicketOpeningTerminal(), model.getBusinessExtensionAttribute(), isOverwrite);
    }

    public void saveUserTags(long userId, String invoiceType, String printingEquipment, String ticketOpeningTerminal, Object businessExtensionAttribute, boolean isOverwrite) {
        ArrayList<UserTag> saveTags;
        block22: {
            UserTag userTagTicketOpeningTerminal = null;
            UserTag userTagPrintingEquipment = null;
            UserTag userTagInvoiceType = null;
            UserTag userTagBusinessExtensionAttribute = null;
            List userTags = this.userTagDao.findByUserId(Long.valueOf(userId));
            for (UserTag userTag : userTags) {
                userTag.setUser(null);
                if (TICKET_TERMINAL.equals(userTag.getTagName())) {
                    userTagTicketOpeningTerminal = userTag;
                    continue;
                }
                if (PRINTING_EQUIPMENT.equals(userTag.getTagName())) {
                    userTagPrintingEquipment = userTag;
                    continue;
                }
                if ("invoiceType".equals(userTag.getTagName())) {
                    userTagInvoiceType = userTag;
                    continue;
                }
                if (!"businessExtensionAttribute".equals(userTag.getTagName())) continue;
                userTagBusinessExtensionAttribute = userTag;
            }
            if (userTagTicketOpeningTerminal == null) {
                userTagTicketOpeningTerminal = new UserTag();
                userTagTicketOpeningTerminal.setUserId(Long.valueOf(userId));
                userTagTicketOpeningTerminal.setTagName(TICKET_TERMINAL);
            }
            if (userTagPrintingEquipment == null) {
                userTagPrintingEquipment = new UserTag();
                userTagPrintingEquipment.setUserId(Long.valueOf(userId));
                userTagPrintingEquipment.setTagName(PRINTING_EQUIPMENT);
            }
            if (userTagInvoiceType == null) {
                userTagInvoiceType = new UserTag();
                userTagInvoiceType.setUserId(Long.valueOf(userId));
                userTagInvoiceType.setTagName("invoiceType");
            }
            if (userTagBusinessExtensionAttribute == null) {
                userTagBusinessExtensionAttribute = new UserTag();
                userTagBusinessExtensionAttribute.setUserId(Long.valueOf(userId));
                userTagBusinessExtensionAttribute.setTagName("businessExtensionAttribute");
            }
            saveTags = new ArrayList<UserTag>();
            if (StringUtils.isBlank((CharSequence)ticketOpeningTerminal) || "null".equals(ticketOpeningTerminal) || "[]".equals(ticketOpeningTerminal) || "{}".equals(ticketOpeningTerminal)) {
                if (isOverwrite) {
                    userTagTicketOpeningTerminal.setTagValue("");
                    saveTags.add(userTagTicketOpeningTerminal);
                }
            } else {
                userTagTicketOpeningTerminal.setTagValue(ticketOpeningTerminal);
                saveTags.add(userTagTicketOpeningTerminal);
            }
            if (StringUtils.isBlank((CharSequence)printingEquipment) || "null".equals(printingEquipment) || "[]".equals(printingEquipment) || "{}".equals(printingEquipment) || "\"\"".equals(printingEquipment)) {
                if (isOverwrite) {
                    userTagPrintingEquipment.setTagValue("");
                    saveTags.add(userTagPrintingEquipment);
                }
            } else {
                userTagPrintingEquipment.setTagValue(printingEquipment);
                saveTags.add(userTagPrintingEquipment);
            }
            if (StringUtils.isBlank((CharSequence)invoiceType) || "null".equals(invoiceType) || "[]".equals(invoiceType) || "{}".equals(invoiceType) || "\"\"".equals(invoiceType)) {
                if (isOverwrite) {
                    userTagInvoiceType.setTagValue("");
                    saveTags.add(userTagInvoiceType);
                }
            } else {
                userTagInvoiceType.setTagValue(invoiceType);
                saveTags.add(userTagInvoiceType);
            }
            try {
                String businessExtensionAttributeJson = JsonUtils.toJson((Object)businessExtensionAttribute);
                if (StringUtils.isBlank((CharSequence)businessExtensionAttributeJson) || "null".equals(businessExtensionAttributeJson) || "[]".equals(businessExtensionAttributeJson) || "{}".equals(businessExtensionAttributeJson) || "\"\"".equals(businessExtensionAttributeJson)) {
                    if (isOverwrite) {
                        userTagBusinessExtensionAttribute.setTagValue("");
                        saveTags.add(userTagBusinessExtensionAttribute);
                    }
                } else {
                    userTagBusinessExtensionAttribute.setTagValue(businessExtensionAttributeJson);
                    saveTags.add(userTagBusinessExtensionAttribute);
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                if (!isOverwrite) break block22;
                userTagBusinessExtensionAttribute.setTagValue("");
                saveTags.add(userTagBusinessExtensionAttribute);
            }
        }
        saveTags.forEach(arg_0 -> ((UserTagDao)this.userTagDao).saveAndFlush(arg_0));
    }

    public User findById(Long userId) {
        return this.findById(userId, 0);
    }

    public User findById(Long userId, int extraInfoDimension) {
        String message = "\u672a\u627e\u5230\u7528\u6237\u5b9e\u4f53(" + userId + ")";
        User user = (User)this.userDao.findById((Serializable)userId, EntityGraphs.named((String)"User.graph")).orElseThrow(() -> new IllegalArgumentException(message));
        this.fulfill(user, extraInfoDimension);
        this.setUserTags(user);
        return user;
    }

    public User findByLoginId(long userId, String loginId, String modules, int extraInfoDimension) {
        logger.info("findByLoginId,userId:{},loginId:{},extraInfoDimension:{}", new Object[]{userId, loginId, extraInfoDimension});
        return this.findByTenantIdAndUserIdAndLoginId(null, userId, loginId, modules, extraInfoDimension);
    }

    public User findByTenantIdAndUserId(long tenantId, long userId, String modules, Integer extraInfoDimension) {
        return this.findByTenantIdAndUserIdAndLoginId(tenantId, userId, null, modules, extraInfoDimension);
    }

    public User findByTenantIdAndUserIdAndLoginId(Long tenantId, long userId, String loginId, String modules, Integer extraInfoDimension) {
        logger.info("findByTenantIdAndUserIdAndLoginId(tenantId:{},userId:{},loginId:{},modules:{},extraInfoDimension:{})", new Object[]{tenantId, userId, loginId, modules, extraInfoDimension});
        Optional<User> optionalUser = this.userRedisCacheService.getUserByUserIdAndLoginId(userId, loginId);
        User user = null;
        boolean caching = false;
        if (optionalUser.isPresent()) {
            user = optionalUser.get();
            if (tenantId != null && tenantId > 0L && !tenantId.equals(user.getTenantId())) {
                throw new IllegalArgumentException("\u672a\u627e\u5230\u7528\u6237\u5b9e\u4f53(tenantId:" + tenantId + ", userId:" + userId + ")");
            }
            if (extraInfoDimension != null && extraInfoDimension > 0 && (user.getCachedExtraInfoDimension() & extraInfoDimension) != extraInfoDimension) {
                extraInfoDimension = extraInfoDimension | user.getCachedExtraInfoDimension();
                caching = true;
            }
        } else {
            if (tenantId != null && tenantId > 0L) {
                String message = "\u672a\u627e\u5230\u7528\u6237\u5b9e\u4f53(tenantId:" + tenantId + ", userId:" + userId + ")";
                UserModel.Request.Query query = new UserModel.Request.Query();
                query.setUserId(Long.valueOf(userId));
                query.setTenantId(tenantId);
                user = (User)this.userDao.findOne(UserQueryHelper.querySpecification((UserModel.Request.Query)query), EntityGraphs.named((String)"User.graph")).orElseThrow(() -> new IllegalArgumentException(message));
            } else {
                String message = "\u672a\u627e\u5230\u7528\u6237\u5b9e\u4f53(userId:" + userId + ")";
                user = (User)this.userDao.findById((Serializable)Long.valueOf(userId), EntityGraphs.named((String)"User.graph")).orElseThrow(() -> new IllegalArgumentException(message));
            }
            caching = true;
        }
        if (caching) {
            user.setModules(modules);
            user.setCachedExtraInfoDimension(extraInfoDimension.intValue());
            this.fulfill(user, extraInfoDimension);
            this.userRedisCacheService.pubUserByUserIdAndLoginId(user, userId, loginId);
        }
        this.setUserTags(user);
        return user;
    }

    public User login(AccountModel.Request.Login login, int extraInfoDimension) {
        Account account = this.accountService.findOneByLogin(login);
        this.accountService.validPassword(login, account);
        List users = this.userDao.findByAccountId(account.getAccountId());
        if (users.isEmpty()) {
            String message = "\u672a\u627e\u5230\u7528\u6237\u5b9e\u4f53(accountId:" + account.getAccountId() + ")";
            throw new IllegalArgumentException(message);
        }
        if (CollectionUtils.isEmpty(users = users.stream().filter(e -> e.getStatus() != 0 && (e.getExpiredDate() == null || DateUtils.afterNow((Date)e.getExpiredDate(), (boolean)true))).collect(Collectors.toList()))) {
            String message = "\u672a\u627e\u5230\u6709\u6548\u72b6\u6001\u7684\u7528\u6237\u5b9e\u4f53(accountId:" + account.getAccountId() + ")";
            throw new IllegalArgumentException(message);
        }
        Boolean changePwd = this.needModifyPassword(account.getPwdLastUpdateTime());
        account.setChangePasswordFlag(Boolean.valueOf(changePwd != false || account.getChangePasswordFlag() != false));
        User user = (User)users.get(0);
        user.setAccount((AccountDto)account);
        this.fulfill(user, extraInfoDimension);
        user.setUsername(account.getUsername());
        user.setEmail(account.getEmail());
        user.setMobile(account.getTelPhone());
        return user;
    }

    public User findByUsername(String username, int extraInfoDimension) {
        Account account = this.accountService.findOneByUsername(username);
        UserModel.Request.Query query = new UserModel.Request.Query();
        query.setAccountId(account.getAccountId());
        List<User> users = this.list(query, Sort.unsorted());
        if (users.isEmpty()) {
            String message = "\u672a\u627e\u5230\u7528\u6237\u5b9e\u4f53(accountId:" + account.getAccountId() + ")";
            throw new IllegalArgumentException(message);
        }
        Optional<User> optionalUser = users.stream().filter(u -> 1 == u.getStatus()).findFirst();
        User user = users.get(0);
        if (optionalUser.isPresent()) {
            user = optionalUser.get();
        }
        this.fulfill(user, extraInfoDimension);
        this.setUserTags(user);
        return user;
    }

    public User findByTenantCodeAndUsername(String tenantCode, String username, int extraInfoDimension) {
        Long tenantId = this.tenantDao.findTenantIdByTenantCode(tenantCode);
        if (tenantId == null) {
            String message = "\u672a\u627e\u5230\u79df\u6237\u5b9e\u4f53(" + tenantCode + ")";
            throw new IllegalArgumentException(message);
        }
        List<Account> accounts = this.accountService.findByTenantCodeAndUsername(tenantCode, username);
        Set accountIds = accounts.stream().map(Account::getAccountId).collect(Collectors.toSet());
        UserModel.Request.Query query = new UserModel.Request.Query();
        query.setAccountIds(accountIds);
        query.setTenantId(tenantId);
        List<User> users = this.list(query, Sort.unsorted());
        if (users.isEmpty()) {
            String message = "\u672a\u627e\u5230\u7528\u6237\u5b9e\u4f53(tenantCode: " + tenantCode + ", username:" + username + ")";
            throw new IllegalArgumentException(message);
        }
        User user = this.findOneValidUser(users);
        this.fulfill(user, extraInfoDimension);
        this.setUserTags(user);
        return user;
    }

    private User fulfill(User user, Integer extraInfoDimension) {
        HashSet<Role> roles;
        Optional tenantOptional;
        if (user.getAccount() == null && user.getAccountId() != null) {
            Optional accountOptional = this.accountDao.findById((Object)user.getAccountId());
            if (accountOptional.isPresent()) {
                user.setAccount((AccountDto)accountOptional.get());
            } else {
                throw new IllegalArgumentException("\u4e0d\u5b58\u5728id(" + user.getAccountId() + ")\u7684Account");
            }
        }
        user.setEmail(user.getAccount().getEmail());
        user.setMobile(user.getAccount().getTelPhone());
        if (user.getTenant() == null && user.getTenantId() != null && user.getTenantId() > 0L && (StringUtils.isBlank((CharSequence)user.getTenantName()) || StringUtils.isBlank((CharSequence)user.getTenantCode())) && (tenantOptional = this.tenantDao.findById((Object)user.getTenantId())).isPresent()) {
            user.setTenantName(((Tenant)tenantOptional.get()).getTenantName());
            user.setTenantCode(((Tenant)tenantOptional.get()).getTenantCode());
        }
        if (extraInfoDimension == null) {
            return user;
        }
        if (user.getRoles() == null) {
            roles = new HashSet<Role>(this.roleService.listByUserId(user.getId()));
            user.setRoles(roles);
        } else {
            roles = user.getRoles();
        }
        if (extraInfoDimension <= 0) {
            return user;
        }
        if (BinaryUtils.is((Enum)ExtraInfo.relatedCompanies, (int)extraInfoDimension)) {
            List relatedCompanyOrgs = this.orgStructDao.findRelatedCompaniesByUserId(user.getId().longValue());
            user.setRelatedCompanies(relatedCompanyOrgs.stream().collect(Collectors.toSet()));
        }
        if (BinaryUtils.hasAny((Collection)Stream.of(ExtraInfo.currentOrgs, ExtraInfo.orgs, ExtraInfo.companies, ExtraInfo.resources, ExtraInfo.packages, ExtraInfo.parentOrgs, ExtraInfo.parentCompanies, ExtraInfo.resourceDetail).collect(Collectors.toList()), (int)extraInfoDimension)) {
            List<OrgStruct> currentOrgs = this.orgService.listByTenantIdAndUserId(user.getTenantId(), user.getId(), user.getModules(), Stream.of("orgId", "companyId", "gradingRoleId", "defaultOrgRoleId", "orgCode", "orgName", "parentId", "parentIds", "orgType", "orgBizType", "status", "company").collect(Collectors.toSet()));
            if (BinaryUtils.hasAny((Collection)Stream.of(ExtraInfo.currentOrgs, ExtraInfo.orgs).collect(Collectors.toList()), (int)extraInfoDimension)) {
                user.setCurrentOrgs(new HashSet<OrgStruct>(currentOrgs));
            }
            HashSet<Object> parentOrgs = new HashSet<Object>();
            if (BinaryUtils.hasAny((Collection)Stream.of(ExtraInfo.resources, ExtraInfo.packages, ExtraInfo.parentOrgs, ExtraInfo.parentCompanies, ExtraInfo.companies, ExtraInfo.resourceDetail).collect(Collectors.toList()), (int)extraInfoDimension)) {
                Set<Object> parentOrgIds = new HashSet();
                for (OrgStruct orgStruct : currentOrgs) {
                    parentOrgs.add(orgStruct);
                    Set set = OrgUtils.findOrgIdInParentIds((String)orgStruct.getParentIds());
                    parentOrgIds.addAll(set);
                }
                if (!(parentOrgIds = parentOrgIds.stream().filter(Objects::nonNull).filter(orgId -> currentOrgs.stream().map(OrgStruct::getOrgId).noneMatch(orgId::equals)).collect(Collectors.toSet())).isEmpty()) {
                    HashSet<Long> orgIds = new HashSet<Long>();
                    for (Long l : parentOrgIds) {
                        OrgStruct parentOrg = parentOrgs.stream().filter(o -> o.getOrgId().equals(parentOrgId)).findAny().orElse(null);
                        if (parentOrg != null) {
                            logger.debug("this org exist in parentOrgs");
                            continue;
                        }
                        orgIds.add(l);
                        Optional parentOrgOptional = this.orgStructDao.findById((Serializable)l, EntityGraphs.named((String)"Org.graph"));
                        if (!parentOrgOptional.isPresent()) continue;
                        parentOrgs.add(parentOrgOptional.get());
                    }
                    if (!orgIds.isEmpty()) {
                        OrgModel.Request.Query query = new OrgModel.Request.Query();
                        query.setIds(orgIds);
                        query.setAttributes(Stream.of("orgId", "companyId", "gradingRoleId", "defaultOrgRoleId", "orgCode", "orgName", "orgType", "company").collect(Collectors.toSet()));
                        List list = this.orgStructDao.findAttributes(query, Sort.unsorted());
                        if (!list.isEmpty()) {
                            parentOrgs.addAll(list);
                        }
                    }
                }
                if (BinaryUtils.hasAny((Collection)Stream.of(ExtraInfo.parentOrgs, ExtraInfo.parentCompanies).collect(Collectors.toList()), (int)extraInfoDimension)) {
                    user.setParentOrgs(parentOrgs);
                }
                if (!CollectionUtils.isEmpty(currentOrgs) && BinaryUtils.is((Enum)ExtraInfo.companies, (int)extraInfoDimension)) {
                    Set companies = currentOrgs.stream().filter(org -> OrgType.COMPANY.equals((Object)org.getOrgType())).collect(Collectors.toSet());
                    user.setCompanies(companies);
                }
            }
            if (BinaryUtils.hasAny((Collection)Stream.of(ExtraInfo.resources, ExtraInfo.packages, ExtraInfo.resourceDetail).collect(Collectors.toList()), (int)extraInfoDimension)) {
                Set<Object> roleResources = new HashSet();
                if (!CollectionUtils.isEmpty((Collection)user.getRoles())) {
                    Set<Long> roleIds = user.getRoles().stream().map(Role::getId).filter(Objects::nonNull).collect(Collectors.toSet());
                    List<Resource> list = this.resourceService.listByRoleIds(roleIds, Stream.of("resourceId", "appId", "resourceCode", "isServicePackage").collect(Collectors.toSet()));
                    roleResources.addAll(list);
                }
                roleResources = roleResources.stream().collect(Collectors.toSet());
                if (BinaryUtils.is((Enum)ExtraInfo.resourceDetail, (int)extraInfoDimension)) {
                    user.setRoleResources(roleResources);
                }
                HashSet<ServicePackage> packages = new HashSet<ServicePackage>();
                HashSet<Resource> hashSet = new HashSet<Resource>();
                Set set = parentOrgs.stream().filter(o -> OrgType.COMPANY.equals((Object)o.getOrgType())).collect(Collectors.toSet());
                if (!set.isEmpty()) {
                    Map<Long, List<ServicePackage>> companyPackagesMap = this.packageService.listByTenantId(user.getTenantId());
                    HashSet<Long> packageIds = new HashSet<Long>();
                    for (OrgStruct orgStruct : set) {
                        List<ServicePackage> companyPackages;
                        orgStruct.setTenantId(user.getTenantId());
                        if (orgStruct.getCompanyId() == null || orgStruct.getCompanyId() <= 0L || (companyPackages = companyPackagesMap.get(orgStruct.getCompanyId())) == null || companyPackages.isEmpty()) continue;
                        if (BinaryUtils.is((Enum)ExtraInfo.packages, (int)extraInfoDimension)) {
                            packages.addAll(companyPackages);
                        }
                        packageIds.addAll(companyPackages.stream().filter(Objects::nonNull).map(ServicePackage::getServicePackageId).collect(Collectors.toSet()));
                    }
                    if (!packageIds.isEmpty()) {
                        List<Resource> resources = this.resourceService.listByPackageIds(packageIds, Stream.of("resourceId", "appId", "resourceCode", "isServicePackage").collect(Collectors.toSet()));
                        hashSet.addAll(resources);
                    }
                }
                if (BinaryUtils.is((Enum)ExtraInfo.packages, (int)extraInfoDimension)) {
                    user.setPackages(packages);
                }
                if (BinaryUtils.is((Enum)ExtraInfo.resourceDetail, (int)extraInfoDimension)) {
                    user.setPackageResources(hashSet);
                }
                if (BinaryUtils.hasAny((Collection)Stream.of(ExtraInfo.resources, ExtraInfo.resourceDetail).collect(Collectors.toList()), (int)extraInfoDimension)) {
                    HashMap<Long, Set> totalAppResourceCodes = new HashMap<Long, Set>();
                    HashSet<String> resourceCodes = new HashSet<String>();
                    for (Resource resource : roleResources) {
                        if (resource.getIsServicePackage().booleanValue() && !CollectionUtils.contains(hashSet.iterator(), (Object)resource) || !StringUtils.isNotBlank((CharSequence)resource.getResourceCode()) || resource.getAppId() == null) continue;
                        resourceCodes.add(resource.getResourceCode());
                        if (!BinaryUtils.is((Enum)ExtraInfo.resourceDetail, (int)extraInfoDimension)) continue;
                        Set appResourceCodes = totalAppResourceCodes.getOrDefault(resource.getAppId(), new HashSet());
                        appResourceCodes.add(resource.getResourceCode());
                        totalAppResourceCodes.put(resource.getAppId(), appResourceCodes);
                    }
                    if (BinaryUtils.is((Enum)ExtraInfo.resourceDetail, (int)extraInfoDimension)) {
                        user.setAppResources(totalAppResourceCodes);
                    }
                    user.setResourceCodes(resourceCodes);
                }
            }
        }
        return user;
    }

    private void setUserTags(User user) {
        List userTags = this.userTagDao.findByUserId(user.getId());
        for (UserTag userTag : userTags) {
            userTag.setUser(null);
            if (userTag.getTagName() == null) continue;
            switch (userTag.getTagName()) {
                case "invoiceType": {
                    user.setInvoiceType(userTag.getTagValue());
                    break;
                }
                case "printingEquipment": {
                    user.setPrintingEquipment(userTag.getTagValue());
                    break;
                }
                case "ticketOpeningTerminal": {
                    user.setTicketOpeningTerminal(userTag.getTagValue());
                    break;
                }
                case "businessExtensionAttribute": {
                    user.setBusinessExtensionAttribute(userTag.getTagValue());
                    break;
                }
            }
        }
    }

    private void fillOrgRoles(User user, Long orgId) {
        if (orgId == null || orgId == 0L) {
            return;
        }
        if (user.getRoles() == null || user.getRoles().isEmpty()) {
            return;
        }
        Set filterOrgIds = Stream.of(orgId).collect(Collectors.toSet());
        if (filterOrgIds != null && !filterOrgIds.isEmpty()) {
            Set allRoles = user.getRoles();
            Set roleIds = allRoles.stream().filter(r -> r.getTenantId() != null && r.getTenantId() > 0L && r.getType() != null && r.getType() == 2).map(Role::getId).filter(id -> id != null && id > 0L).collect(Collectors.toSet());
            RoleModel.Request.Query query = new RoleModel.Request.Query();
            query.setOrgIds(filterOrgIds);
            query.setIds(roleIds);
            query.setUserId(user.getId());
            query.setType(Integer.valueOf(2));
            query.setTenantId(user.getTenantId());
            if (query.getStatus() == null) {
                query.setStatus(Integer.valueOf(1));
            }
            List<Role> filteredRoles = this.roleService.list(query, Sort.unsorted());
            Set orgRoles = filteredRoles.stream().collect(Collectors.toSet());
            user.setOrgRoles(orgRoles);
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteById(long userId) {
        User existUser = this.findById(userId);
        this.userDao.deleteById(existUser.getId());
        this.orgUserRelDao.deleteByUserId(userId);
        this.userTagDao.deleteByUserId(userId);
        this.roleUserRelDao.deleteByUserId(userId);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteByTenantIdAndUserId(long tenantId, long userId) {
        UserModel.Request.Query query = new UserModel.Request.Query();
        query.setTenantId(Long.valueOf(tenantId));
        query.setUserId(Long.valueOf(userId));
        User user = this.findOne(query).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u7528\u6237\u5b9e\u4f53"));
        this.userDao.deleteById(Long.valueOf(userId));
        this.orgUserRelDao.deleteByUserId(userId);
        this.userTagDao.deleteByUserId(userId);
        this.roleUserRelDao.deleteByUserId(userId);
    }

    private void bindUserRoles(Collection<RoleUserRel> userRels, boolean cached) {
        if (userRels == null || userRels.isEmpty()) {
            return;
        }
        HashSet<RoleUserRel> rels = userRels instanceof Set ? (HashSet<RoleUserRel>)userRels : new HashSet<RoleUserRel>(userRels);
        CachedRoleOrgUserRels cachedAllRels = cachedRoleOrgUserRelsThreadLocal.get();
        if (cachedAllRels == null) {
            cachedAllRels = CachedRoleOrgUserRels.builder().insertingRoleUserRels(rels).build();
        } else if (cachedAllRels.insertingRoleUserRels == null) {
            cachedAllRels.insertingRoleUserRels = rels;
        } else {
            cachedAllRels.insertingRoleUserRels.addAll(rels);
        }
        if (cached) {
            cachedRoleOrgUserRelsThreadLocal.set(cachedAllRels);
        } else {
            this.roleUserRelDao.saveAllAndFlush(cachedAllRels.insertingRoleUserRels);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void commitBindUserRoles() {
        CachedRoleOrgUserRels cachedAllRels = cachedRoleOrgUserRelsThreadLocal.get();
        if (cachedAllRels != null && cachedAllRels.insertingRoleUserRels != null && !cachedAllRels.insertingRoleUserRels.isEmpty()) {
            this.roleUserRelDao.saveAllAndFlush(cachedAllRels.insertingRoleUserRels);
        }
    }

    private void bindUserOrgs(Collection<OrgUserRel> userRels, boolean cached) {
        if (userRels == null || userRels.isEmpty()) {
            return;
        }
        HashSet<OrgUserRel> rels = userRels instanceof Set ? (HashSet<OrgUserRel>)userRels : new HashSet<OrgUserRel>(userRels);
        CachedRoleOrgUserRels cachedAllRels = cachedRoleOrgUserRelsThreadLocal.get();
        if (cachedAllRels == null) {
            cachedAllRels = CachedRoleOrgUserRels.builder().insertingOrgUserRels(rels).build();
        } else if (cachedAllRels.insertingOrgUserRels == null) {
            cachedAllRels.insertingOrgUserRels = rels;
        } else {
            cachedAllRels.insertingOrgUserRels.addAll(rels);
        }
        if (cached) {
            cachedRoleOrgUserRelsThreadLocal.set(cachedAllRels);
        } else {
            this.orgUserRelDao.saveAllAndFlush(cachedAllRels.insertingOrgUserRels);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void commitBindUserOrgs() {
        CachedRoleOrgUserRels cachedAllRels = cachedRoleOrgUserRelsThreadLocal.get();
        if (cachedAllRels != null && cachedAllRels.insertingOrgUserRels != null && !cachedAllRels.insertingOrgUserRels.isEmpty()) {
            this.orgUserRelDao.saveAllAndFlush(cachedAllRels.insertingOrgUserRels);
        }
    }

    public static void removeCachedRoleOrgUserRelsThreadLocal() {
        if (cachedRoleOrgUserRelsThreadLocal != null) {
            cachedRoleOrgUserRelsThreadLocal.remove();
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void bindRoles(Long tenantId, Long orgId, long userId, Collection<Long> allRoleIds, Collection<Long> globalRoleIds, Collection<Long> gradingRoleIds, Collection<Long> orgRoleIds, boolean isOverwrite, boolean isStrict, boolean needCache) {
        User existEntity;
        if (tenantId != null && tenantId > 0L) {
            UserModel.Request.Query query = new UserModel.Request.Query();
            query.setUserId(Long.valueOf(userId));
            query.setTenantId(tenantId);
            existEntity = this.findOne(query).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u7528\u6237\u5b9e\u4f53(tenantId:" + tenantId + ", userId:" + userId + ")"));
        } else {
            existEntity = this.findUserById(userId).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u7528\u6237\u5b9e\u4f53(userId:" + userId + ")"));
        }
        this.bindRoles(existEntity, orgId, allRoleIds, globalRoleIds, gradingRoleIds, orgRoleIds, isOverwrite, isStrict, needCache);
    }

    @Transactional(rollbackFor={Exception.class})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> void bindRoles(U user, Long orgId, Collection<Long> allRoleIds, Collection<Long> globalRoleIds, Collection<Long> gradingRoleIds, Collection<Long> orgRoleIds, boolean isOverwrite, boolean isStrict, boolean needCache) {
        logger.info("tenantId:{},isOverwrite = {}, isStrict = {}", new Object[]{user.getTenantId(), isOverwrite, isStrict});
        if (allRoleIds == null && globalRoleIds == null && gradingRoleIds == null && orgRoleIds == null) {
            logger.info("roleIds == null, return");
            if (!needCache) {
                this.commitBindUserRoles();
            }
            return;
        }
        if (logger.isInfoEnabled()) {
            if (allRoleIds != null) {
                logger.info("allRoleIds = " + allRoleIds.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(",")));
            }
            if (globalRoleIds != null) {
                logger.info("globalRoleIds = " + globalRoleIds.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(",")));
            }
            if (gradingRoleIds != null) {
                logger.info("gradingRoleIds = " + gradingRoleIds.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(",")));
            }
            if (orgRoleIds != null) {
                logger.info("orgRoleIds = " + orgRoleIds.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(",")));
            }
        }
        List existRels = this.roleUserRelDao.findByUserId(user.getId().longValue());
        logger.info("exist role-user-rels.size = " + existRels.size());
        Triple<Set<RoleUserRel>, Set<RoleUserRel>, Set<Long>> allRelsTriple = this.processRoleUserRels(user, null, allRoleIds, existRels, null, isOverwrite, isStrict);
        Triple<Set<RoleUserRel>, Set<RoleUserRel>, Set<Long>> globalRelsTriple = this.processRoleUserRels(user, null, globalRoleIds, existRels, 0, isOverwrite, isStrict);
        Triple<Set<RoleUserRel>, Set<RoleUserRel>, Set<Long>> gradingRelsTriple = this.processRoleUserRels(user, null, gradingRoleIds, existRels, 1, isOverwrite, isStrict);
        Triple<Set<RoleUserRel>, Set<RoleUserRel>, Set<Long>> orgRelsTriple = this.processRoleUserRels(user, orgId, orgRoleIds, existRels, 2, isOverwrite, isStrict);
        Set exisAllRels = null;
        Set insertingAllRels = null;
        Set deletingAllRoleIds = null;
        if (allRelsTriple != null) {
            exisAllRels = (Set)allRelsTriple.getLeft();
            insertingAllRels = (Set)allRelsTriple.getMiddle();
            deletingAllRoleIds = (Set)allRelsTriple.getRight();
        }
        Set existGlobalRels = null;
        Set insertingGlobalRels = null;
        Set deletingGlobalRoleIds = null;
        if (globalRelsTriple != null) {
            existGlobalRels = (Set)globalRelsTriple.getLeft();
            insertingGlobalRels = (Set)globalRelsTriple.getMiddle();
            deletingGlobalRoleIds = (Set)globalRelsTriple.getRight();
        }
        Set existGradingRels = null;
        Set insertingGradingRels = null;
        Set deletingGradingRoleIds = null;
        if (gradingRelsTriple != null) {
            existGradingRels = (Set)gradingRelsTriple.getLeft();
            insertingGradingRels = (Set)gradingRelsTriple.getMiddle();
            deletingGradingRoleIds = (Set)gradingRelsTriple.getRight();
        }
        Set existOrgRels = null;
        Set insertingOrgRels = null;
        Set deletingOrgRoleIds = null;
        if (orgRelsTriple != null) {
            existOrgRels = (Set)orgRelsTriple.getLeft();
            insertingOrgRels = (Set)orgRelsTriple.getMiddle();
            deletingOrgRoleIds = (Set)orgRelsTriple.getRight();
            if (orgId != null && orgId > 0L) {
                RoleModel.Request.Query query = new RoleModel.Request.Query();
                query.setTenantId(user.getTenantId());
                if (query.getStatus() == null) {
                    query.setStatus(Integer.valueOf(1));
                }
                query.setType(Integer.valueOf(2));
                query.setOrgId(orgId);
                List<Role> roles = this.roleService.list(query, Sort.unsorted());
                if (roles != null && !roles.isEmpty()) {
                    if (existOrgRels != null && !existOrgRels.isEmpty()) {
                        existOrgRels = existOrgRels.stream().filter(rel -> roles.stream().anyMatch(r -> r.getId().equals(rel.getRoleId()))).collect(Collectors.toSet());
                    }
                    if (insertingOrgRels != null && !insertingOrgRels.isEmpty()) {
                        insertingOrgRels = insertingOrgRels.stream().filter(rel -> roles.stream().anyMatch(r -> r.getId().equals(rel.getRoleId()))).collect(Collectors.toSet());
                    }
                    if (deletingOrgRoleIds != null && !deletingOrgRoleIds.isEmpty()) {
                        deletingOrgRoleIds = deletingOrgRoleIds.stream().filter(id -> roles.stream().anyMatch(r -> r.getId().equals(id))).collect(Collectors.toSet());
                    }
                }
            }
        }
        HashSet<RoleUserRel> insertingRels = new HashSet<RoleUserRel>();
        if (insertingAllRels != null) {
            insertingRels.addAll(insertingAllRels);
        }
        if (insertingGlobalRels != null) {
            insertingRels.addAll(insertingGlobalRels);
        }
        if (insertingGradingRels != null) {
            insertingRels.addAll(insertingGradingRels);
        }
        if (insertingOrgRels != null) {
            insertingRels.addAll(insertingOrgRels);
        }
        this.bindUserRoles(insertingRels, needCache);
        if (isOverwrite) {
            HashSet<Long> deleltingRoleIds = new HashSet<Long>();
            if (deletingAllRoleIds != null && !deletingAllRoleIds.isEmpty()) {
                deleltingRoleIds.addAll(deletingAllRoleIds);
            }
            if (deletingGlobalRoleIds != null && !deletingGlobalRoleIds.isEmpty()) {
                deleltingRoleIds.addAll(deletingGlobalRoleIds);
            }
            if (deletingGradingRoleIds != null && !deletingGradingRoleIds.isEmpty()) {
                deleltingRoleIds.addAll(deletingGradingRoleIds);
            }
            if (deletingOrgRoleIds != null && !deletingOrgRoleIds.isEmpty()) {
                deleltingRoleIds.addAll(deletingOrgRoleIds);
            }
            if (deleltingRoleIds != null && !deleltingRoleIds.isEmpty()) {
                this.unbindRoles(user.getTenantId(), user.getId(), deleltingRoleIds);
            }
        }
    }

    private <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> Triple<Set<RoleUserRel>, Set<RoleUserRel>, Set<Long>> processRoleUserRels(U user, Long orgId, Collection<Long> roleIds, Collection<RoleUserRel> existTotalRels, Integer roleType, boolean isOverwrite, boolean isStrict) {
        if (roleIds == null || roleIds.isEmpty()) {
            return null;
        }
        Set existRels = existTotalRels.stream().filter(rel -> roleType == null || rel.getRelType() == roleType.intValue()).collect(Collectors.toSet());
        Set insertingRels = roleIds.stream().filter(roleId -> existRels.stream().map(RoleUserRel::getRoleId).noneMatch(existRoleId -> existRoleId.equals(roleId))).filter(Objects::nonNull).map(roleId -> {
            Integer relType;
            Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if (roleId != null && roleId > 0L) {
                    predicates.add(builder.equal((Expression)root.get("id"), roleId));
                }
                if (!predicates.isEmpty()) {
                    criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
                }
                return criteriaQuery.getRestriction();
            };
            Optional existsRole = this.roleDao.findOne((Specification)specification);
            if (existsRole.isPresent()) {
                Role role = (Role)existsRole.get();
                if (role.getTenantId() != null && role.getTenantId() > 0L && !role.getTenantId().equals(user.getTenantId())) {
                    if (isStrict) {
                        String message = "\u7528\u6237(" + user.getId() + ")\u6240\u5728\u79df\u6237(" + user.getTenantId() + ")\u548c\u89d2\u8272(" + role.getId() + ")\u6240\u5728\u79df\u6237(" + role.getTenantId() + ")\u4e0d\u4e00\u81f4";
                        throw new IllegalArgumentException(message);
                    }
                    return null;
                }
                relType = role.getType();
                if (roleType != null && relType != roleType) {
                    if (isStrict) {
                        String message = "\u89d2\u8272(id:" + role.getId() + "type:" + relType + ")\u4e0d\u662ftype = " + roleType + "\u7684\u89d2\u8272";
                        throw new IllegalArgumentException(message);
                    }
                    return null;
                }
            } else {
                if (isStrict) {
                    String message = "\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u89d2\u8272(id:" + roleId + ")";
                    throw new IllegalArgumentException(message);
                }
                return null;
            }
            logger.info("RoleUserRel.relType = {}", (Object)relType);
            RoleUserRel roleUserRel = new RoleUserRel();
            roleUserRel.setTenantId(user.getTenantId());
            roleUserRel.setRoleId(roleId);
            roleUserRel.setUserId(user.getId());
            if (relType == 2) {
                roleUserRel.setOrgId(orgId);
            }
            roleUserRel.setRelType(relType.intValue());
            return roleUserRel;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        Set deletingRoleIds = isOverwrite ? existRels.stream().filter(Objects::nonNull).filter(rel -> roleIds.stream().filter(Objects::nonNull).noneMatch(roleId -> roleId.equals(rel.getRoleId()))).filter(rel -> rel.getRoleId() > 1L).map(RoleUserRel::getRoleId).filter(Objects::nonNull).collect(Collectors.toSet()) : null;
        return Triple.of(existRels, insertingRels, deletingRoleIds);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void bindOrgs(Long tenantId, long userId, Collection<Long> orgIds, String modules, boolean isOverwrite, boolean isStrict, boolean needCache) {
        User existEntity;
        UserModel.Request.Query query = new UserModel.Request.Query();
        query.setUserId(Long.valueOf(userId));
        if (tenantId != null && tenantId > 0L) {
            query.setTenantId(tenantId);
            existEntity = this.findOne(query).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u7528\u6237\u5b9e\u4f53(tenantId:" + tenantId + ", userId:" + userId + ")"));
        } else {
            existEntity = this.findOne(query).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u7528\u6237\u5b9e\u4f53(userId:" + userId + ")"));
        }
        this.bindOrgs(existEntity, orgIds, modules, isOverwrite, isStrict, needCache);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> void bindOrgs(U user, Collection<Long> orgIds, String modules, boolean isOverwrite, boolean isStrict, boolean needCache) {
        Set<Object> insertingRels;
        Set parentIdsSet;
        logger.info("isOverwrite = {}, isStrict = {}", (Object)isOverwrite, (Object)isStrict);
        if (orgIds == null) {
            logger.info("orgIds == null, return");
            if (!needCache) {
                this.commitBindUserOrgs();
            }
            return;
        }
        if (orgIds.isEmpty() && !isOverwrite) {
            logger.info("orgIds isEmpty and isOverwrite = false, return");
            if (!needCache) {
                this.commitBindUserOrgs();
            }
            return;
        }
        Set<Long> orgIdSet = orgIds instanceof Set ? (HashSet<Long>)orgIds : new HashSet<Long>(orgIds);
        orgIdSet = orgIdSet.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        if (logger.isInfoEnabled()) {
            logger.info("orgIds = " + orgIdSet.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(",")));
        }
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setTenantId(user.getTenantId());
        query.setStatus(Integer.valueOf(1));
        query.setAttributes(Stream.of("orgId", "orgName", "parentId", "orgType").collect(Collectors.toSet()));
        List tenantOrgs = this.orgStructDao.findAttributes(query, Sort.unsorted());
        Set<String> filterParentIdsSet = this.filterParentIds(user.getTenantId(), modules, tenantOrgs);
        if (orgIdSet.isEmpty()) {
            parentIdsSet = Collections.emptySet();
        } else {
            Set<Long> orgIdSets = orgIdSet;
            parentIdsSet = tenantOrgs.stream().filter(Objects::nonNull).filter(o -> orgIdSets.stream().anyMatch(id -> id.equals(o.getOrgId()))).map(OrgStruct::getParentIds).filter(Objects::nonNull).collect(Collectors.toSet());
            if (StringUtils.isNotEmpty((CharSequence)modules)) {
                logger.info("update_user_filter,userId:{}, parentIdsSet:{}, filterParentIdsSet:{}", new Object[]{user.getId(), parentIdsSet, filterParentIdsSet});
                parentIdsSet = parentIdsSet.stream().filter(p -> filterParentIdsSet.stream().anyMatch(f -> p.startsWith((String)f))).collect(Collectors.toSet());
            }
        }
        parentIdsSet = OrgUtils.compressParentIdsCollection(parentIdsSet);
        Pair treeAllOrgIdsPair = TreeUtils.buildTreeAndCascadeCheckKeys((List)tenantOrgs, orgIdSet);
        List orgTree = (List)treeAllOrgIdsPair.getLeft();
        Set allOrgIds = (Set)treeAllOrgIdsPair.getRight();
        Set existOrgIds = this.orgUserRelDao.findOrgIdsByUserId(user.getId().longValue());
        logger.info("exist org-user({})-rels.size = {}", (Object)user.getId(), (Object)existOrgIds.size());
        if (!allOrgIds.isEmpty()) {
            insertingRels = allOrgIds.stream().filter(orgId -> !existOrgIds.contains(orgId)).filter(Objects::nonNull).map(orgId -> {
                Optional<OrgStruct> existsOrg = tenantOrgs.stream().filter(o -> ((Long)o.getId()).equals(orgId)).findFirst();
                if (!existsOrg.isPresent()) {
                    if (isStrict) {
                        String message = "\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u7ec4\u7ec7(id:" + orgId + ", tenantId:" + user.getTenantId() + ")";
                        logger.warn(message);
                        throw new IllegalArgumentException(message);
                    }
                    return null;
                }
                OrgStruct orgStruct = existsOrg.get();
                OrgUserRel orgUserRel = new OrgUserRel();
                orgUserRel.setTenantId(user.getTenantId());
                orgUserRel.setOrgStructId(orgId);
                orgUserRel.setUserId(user.getId());
                orgUserRel.setFullSelectedFlag(Boolean.valueOf(true));
                return orgUserRel;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            List rootIds = tenantOrgs.stream().filter(o -> o.getParentId() == null || o.getParentId() == 0L).map(OrgStruct::getOrgId).collect(Collectors.toList());
            if (rootIds == null) {
                String message = "\u65e0\u6548\u6570\u636e\uff0c\u79df\u6237(" + user.getTenantId() + ")\u65e0\u6839\u7ec4\u7ec7";
                logger.warn(message);
                throw new IllegalArgumentException(message);
            }
            Set<RoleUserRel> insertingDefaultRoleRels = tenantOrgs.stream().filter(o -> insertingRels.stream().anyMatch(rel -> rel.getOrgStructId().equals(o.getOrgId()))).map(o -> {
                if (o.getDefaultOrgRoleId() != null) {
                    RoleUserRel roleUserRel = new RoleUserRel();
                    roleUserRel.setRoleId(o.getDefaultOrgRoleId());
                    roleUserRel.setTenantId(o.getTenantId());
                    roleUserRel.setUserId(user.getId());
                    roleUserRel.setRelType(2);
                    return roleUserRel;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            this.bindUserRoles(insertingDefaultRoleRels, true);
        } else {
            insertingRels = Collections.emptySet();
        }
        this.bindUserOrgs(insertingRels, needCache);
        if (isOverwrite) {
            Set insertedOrgIds = insertingRels.stream().filter(Objects::nonNull).map(OrgUserRel::getOrgStructId).collect(Collectors.toSet());
            if (!insertedOrgIds.isEmpty()) {
                allOrgIds.addAll(insertedOrgIds);
            }
            Set<Long> deletingOrgIds = existOrgIds.stream().filter(Objects::nonNull).filter(existOrgId -> allOrgIds.stream().filter(Objects::nonNull).noneMatch(insertedOrgId -> insertedOrgId.equals(existOrgId))).filter(Objects::nonNull).collect(Collectors.toSet());
            this.unbindOrgsWithFilterParentIdsSet(user.getTenantId(), user.getId(), filterParentIdsSet, deletingOrgIds, false);
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void bindApps(long userId, Collection<Long> appIds, boolean isOverwrite, boolean isStrict) {
        User existEntity = this.findUserById(userId).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u7528\u6237(" + userId + ")\u5b9e\u4f53"));
        this.bindApps(existEntity, appIds, isOverwrite, isStrict);
    }

    public <U extends UserDto<O, R, A>, O extends OrgDto<O>, R extends RoleDto, A extends AccountDto> void bindApps(U user, Collection<Long> appIds, boolean isOverwrite, boolean isStrict) {
        logger.info("isOverwrite = {}, isStrict = {}", (Object)isOverwrite, (Object)isStrict);
        if (appIds == null) {
            return;
        }
        if (appIds.isEmpty()) {
            if (isOverwrite) {
                logger.info("appIds == null, isOverwrite = true, clean all");
                this.userAppDao.deleteByUserId(user.getId());
            } else {
                logger.info("appIds == null, isOverwrite = false, return");
            }
        }
        logger.info("appIds = " + appIds.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(",")));
        List existRels = this.userAppDao.findByUserId(user.getId().longValue());
        logger.info("exist user-app-rels.size = " + existRels.size());
        Set<UserApp> insertingRels = appIds.stream().filter(appId -> existRels.stream().map(UserApp::getAppId).noneMatch(newAppId -> newAppId.equals(appId))).filter(Objects::nonNull).map(appId -> {
            boolean exists = this.appDao.existsById(appId);
            if (!exists) {
                if (isStrict) {
                    String message = "\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u5e94\u7528(id:" + appId + ")";
                    throw new IllegalArgumentException(message);
                }
                return null;
            }
            UserApp userApp = new UserApp();
            userApp.setAppId(appId);
            userApp.setUserId(user.getId());
            return userApp;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        this.bindApps(insertingRels);
        if (isOverwrite) {
            existRels.stream().filter(rel -> appIds.stream().filter(Objects::nonNull).noneMatch(appId -> appId.equals(rel.getAppId()))).forEach(rel -> {
                try {
                    this.userAppDao.deleteById((Object)rel.getId());
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            });
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void bindApps(Collection<UserApp> rels) {
        if (rels != null && !rels.isEmpty()) {
            this.userAppDao.saveAllAndFlush(rels);
        }
    }

    public boolean checkUriAuthz(UserModel.Request.CheckUriAuthzQuery checkUriAuthzQuery) {
        Long userId = checkUriAuthzQuery.getUserId();
        logger.info("userId = {}", (Object)userId);
        Long routeId = checkUriAuthzQuery.getRouteId();
        Map<RequestUri, RequestUriAuthz> requestUriAuthzMap = this.serviceApiService.getRequestUriAndResourceCodesMapByRouteId(routeId);
        RequestUri requestUri = new RequestUri(checkUriAuthzQuery.getRequestUri(), checkUriAuthzQuery.getRequestMethod());
        RequestUriAuthz requestUriAuthz = RequestMappingHelper.lookupRequestUri(requestUri, requestUriAuthzMap, false);
        if (requestUriAuthz == null) {
            logger.info("requestUriAuthz == null, skip, return true");
            return true;
        }
        if (requestUriAuthz.getSkipAuthentication() != null && requestUriAuthz.getSkipAuthentication().booleanValue()) {
            logger.info("skipAuthentication, skip, return true");
            return true;
        }
        if (requestUriAuthz.getSkipAuthorization() != null && requestUriAuthz.getSkipAuthorization().booleanValue()) {
            logger.info("skipAuthorization, skip, return true");
            return true;
        }
        Set resourceCodes = requestUriAuthz.getResourceCodes();
        if (CollectionUtils.isEmpty((Collection)resourceCodes)) {
            logger.info("resourceCodes.isEmpty, skip, return true");
            return true;
        }
        User user = this.findById(userId, BinaryUtils.toBinary((Enum)ExtraInfo.resources));
        Set userResourceCodes = user.getResourceCodes();
        boolean result = userResourceCodes.parallelStream().anyMatch(resourceCodes::contains);
        return result;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void updateStatus(long tenantId, long userId, int status) {
        User existEntity = this.findByTenantIdAndUserId(tenantId, userId, null, 0);
        if (status == 0 && existEntity.isAdmin()) {
            throw new IllegalArgumentException("\u4e0d\u80fd\u7981\u7528\u79df\u6237\u7ba1\u7406\u5458");
        }
        existEntity.setStatus(Integer.valueOf(status));
        this.saveAndFlush(existEntity);
        this.userPubService.sendUserToPubsub(existEntity, tenantId);
    }

    public Long findIdByTenantIdAndCode(long tenantId, String userCode) {
        List userIds = this.userDao.selectIdsByTenantIdAndUserCode(tenantId, userCode);
        if (userIds == null || userIds.isEmpty()) {
            return null;
        }
        return (Long)userIds.stream().findFirst().get();
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void unbindRoles(long tenantId, long userId, Collection<Long> roleIds) {
        if (roleIds == null || roleIds.isEmpty()) {
            return;
        }
        HashSet<Long> deletingRoleIds = roleIds instanceof Set ? (HashSet<Long>)roleIds : new HashSet<Long>(roleIds);
        this.roleUserRelDao.deleteByTenantIdAndUserIdAndRoleIds(tenantId, userId, deletingRoleIds);
    }

    @Transactional
    public void unbindOrgs(long tenantId, long userId, String modules, Collection<Long> orgIds) {
        if (orgIds == null || orgIds.isEmpty()) {
            return;
        }
        Set<String> filterParentIdsSet = this.filterParentIds(tenantId, modules);
        this.unbindOrgsWithFilterParentIdsSet(tenantId, userId, filterParentIdsSet, orgIds, true);
    }

    private void unbindOrgsWithFilterParentIdsSet(long tenantId, long userId, Set<String> filterParentIdsSet, Collection<Long> orgIds, boolean cascade) {
        Set parentOrgIdSet;
        Set additionOrgIds;
        if (orgIds == null || orgIds.isEmpty()) {
            return;
        }
        HashSet<Long> deleltingOrgIds = orgIds instanceof Set ? (HashSet<Long>)orgIds : new HashSet<Long>(orgIds);
        Set attributes = Stream.of("orgId", "parentIds", "defaultOrgRoleId").collect(Collectors.toSet());
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setTenantId(Long.valueOf(tenantId));
        query.setOrgIds(deleltingOrgIds);
        query.setAttributes(attributes);
        List orgs = this.orgStructDao.findAttributes(query, Sort.unsorted());
        if (cascade) {
            Set deletingParentIdsSet = orgs.stream().map(org -> org.getParentIds()).collect(Collectors.toSet());
            deletingParentIdsSet = OrgUtils.compressParentIdsCollection(deletingParentIdsSet);
            query = new OrgModel.Request.Query();
            query.setTenantId(Long.valueOf(tenantId));
            query.setFilterParentIds(deletingParentIdsSet);
            query.setAttributes(attributes);
            orgs = this.orgStructDao.findAttributes(query, Sort.unsorted());
        }
        if (!(additionOrgIds = (parentOrgIdSet = orgs.stream().map(org -> OrgUtils.findOrgIdInParentIds((String)org.getParentIds())).flatMap(Collection::stream).collect(Collectors.toSet())).stream().filter(parentOrgId -> deleltingOrgIds.stream().noneMatch(orgId -> orgId.equals(parentOrgId))).collect(Collectors.toSet())).isEmpty()) {
            query = new OrgModel.Request.Query();
            query.setTenantId(Long.valueOf(tenantId));
            query.setOrgIds(additionOrgIds);
            query.setAttributes(attributes);
            List additionOrgs = this.orgStructDao.findAttributes(query, Sort.unsorted());
            orgs.addAll(additionOrgs);
            deleltingOrgIds.addAll(additionOrgIds);
        }
        HashSet<Long> deletingDefaultRoleIds = new HashSet<Long>();
        orgs.stream().filter(o -> filterParentIdsSet.isEmpty() || filterParentIdsSet.stream().anyMatch(p -> o.getParentIds().startsWith((String)p))).forEach(o -> {
            Long orgId = o.getOrgId();
            deleltingOrgIds.add(orgId);
            if (o.getDefaultOrgRoleId() != null) {
                deletingDefaultRoleIds.add(o.getDefaultOrgRoleId());
            }
        });
        if (deleltingOrgIds != null && !deleltingOrgIds.isEmpty()) {
            this.orgUserRelDao.deleteByTenantIdAndUserIdAndOrgIds(tenantId, userId, deleltingOrgIds);
        }
        if (!deletingDefaultRoleIds.isEmpty()) {
            this.unbindRoles(tenantId, userId, deletingDefaultRoleIds);
        }
    }

    private Set<String> filterParentIds(long tenantId, String modules) {
        Object[] orgCodeArray = StringUtils.split((String)modules, (String)",");
        if (ArrayUtils.isEmpty((Object[])orgCodeArray)) {
            return Collections.emptySet();
        }
        Set orgCodes = Stream.of(orgCodeArray).filter(Objects::nonNull).collect(Collectors.toSet());
        HashSet filterParentIdsSet = new HashSet();
        List filteringParentIdsList = orgCodes != null && !orgCodes.isEmpty() ? this.orgStructDao.findParentIdsByTenantIdAndOrgCodes(tenantId, orgCodes) : Collections.emptyList();
        return this.filterParentIds(filteringParentIdsList);
    }

    private Set<String> filterParentIds(long tenantId, String modules, List<OrgStruct> tenantOrgs) {
        Object[] orgCodeArray = StringUtils.split((String)modules, (String)",");
        if (ArrayUtils.isEmpty((Object[])orgCodeArray)) {
            return Collections.emptySet();
        }
        Set orgCodes = Stream.of(orgCodeArray).filter(Objects::nonNull).collect(Collectors.toSet());
        HashSet filterParentIdsSet = new HashSet();
        List<String> filteringParentIdsList = tenantOrgs.stream().filter(o -> o.getTenantId() != null && tenantId == o.getTenantId() && orgCodes.stream().anyMatch(code -> code.equals(o.getOrgCode()))).map(OrgStruct::getParentIds).collect(Collectors.toList());
        return this.filterParentIds(filteringParentIdsList);
    }

    private Set<String> filterParentIds(List<String> filteringParentIdsList) {
        if (filteringParentIdsList == null || filteringParentIdsList.isEmpty()) {
            return Collections.emptySet();
        }
        Collections.sort(filteringParentIdsList);
        HashSet<String> filterParentIdsSet = new HashSet<String>();
        filteringParentIdsList.stream().filter(filteringParentIds -> filterParentIdsSet.stream().noneMatch(filterParentIds -> StringUtils.startsWith((CharSequence)filteringParentIds, (CharSequence)filterParentIds))).forEach(filterParentIdsSet::add);
        return filterParentIdsSet;
    }

    public void filterUser(List<UserModel.Request.Create> models) {
        for (UserModel.Request.Create create : models) {
            if (null == create) continue;
            Long userId = 0L;
            Account account = new Account();
            AccountModel.Request.Create createAccount = create.getAccount();
            if (null != create.getUserId() && create.getUserId() > 0L) continue;
            if (createAccount != null) {
                if (StringUtils.isNotBlank((CharSequence)createAccount.getTelPhone())) {
                    account = this.accountDao.findByTelPhone(createAccount.getTelPhone());
                }
                if (StringUtils.isNotBlank((CharSequence)createAccount.getEmail()) && null == account) {
                    account = this.accountDao.findByEmail(createAccount.getEmail());
                }
                if (StringUtils.isNotBlank((CharSequence)create.getUserCode()) && null == account) {
                    account = this.accountDao.findByTelPhone(create.getUserCode());
                }
            }
            if (null == account || null == account.getAccountId() || account.getAccountId() == 0L) continue;
            Long accountId = account.getAccountId();
            if (create.getTenantId() == null || create.getTenantId() == 0L) continue;
            List users = this.userDao.findByTenantIdAndAccountId(create.getTenantId().longValue(), accountId.longValue());
            User user = users.stream().findFirst().orElse(null);
            if (null == user && StringUtils.isNotBlank((CharSequence)create.getUserCode())) {
                userId = this.findIdByTenantIdAndCode(create.getTenantId(), create.getUserCode());
            }
            if (null != user) {
                create.setUserId(user.getId());
                continue;
            }
            if (null == userId || userId <= 0L) continue;
            create.setUserId(userId);
        }
    }

    public void clearCache(long userId) {
    }

    public List<UserExportDto> getExportData(List<Long> userIds) {
        SearchFilter searchFilter = SearchFilter.build((String)"id", (Operator)Operator.IN, (Object[])userIds.toArray());
        Specification specification = DynamicSpecifications.bySearchFilter((Collection)Stream.of(searchFilter).collect(Collectors.toList()));
        List<User> users = this.list((Specification<User>)specification, Sort.unsorted());
        ArrayList<UserExportDto> userExportDtos = new ArrayList<UserExportDto>();
        users.forEach(user -> {
            List<OrgStruct> orgs = this.orgService.listByTenantIdAndUserId(user.getTenantId(), user.getId(), null);
            List<Role> roles = this.roleService.listByUserId(user.getId());
            Account account = user.getAccount();
            UserExportDto dto = new UserExportDto();
            dto.setUserName(user.getUserName());
            dto.setUserCode(user.getUserCode());
            dto.setUserNumber(user.getUserNumber());
            dto.setUserId(user.getId().toString());
            if (1 == user.getStatus()) {
                dto.setStatus("\u542f\u7528");
            } else if (0 == user.getStatus()) {
                dto.setStatus("\u672a\u542f\u7528");
            } else if (2 == user.getStatus()) {
                dto.setStatus("\u505c\u7528");
            }
            dto.setEmail(account.getEmail());
            dto.setTelPhone(account.getTelPhone());
            dto.setAccountName(account.getUsername());
            List tags = user.getUserTags();
            this.setUserExportDto(tags, dto);
            if (!CollectionUtils.isEmpty(orgs)) {
                dto.setOrgNames(orgs.stream().map(OrgStruct::getOrgName).collect(Collectors.joining("/")));
                dto.setOrgCodes(orgs.stream().map(OrgStruct::getOrgCode).collect(Collectors.joining("/")));
            }
            if (!CollectionUtils.isEmpty(roles)) {
                dto.setRoleCodes(roles.stream().map(Role::getCode).collect(Collectors.joining("/")));
                dto.setRoleNames(roles.stream().map(Role::getName).collect(Collectors.joining("/")));
            }
            userExportDtos.add(dto);
        });
        return userExportDtos;
    }

    private void setUserExportDto(List<UserTag> tags, UserExportDto dto) {
        if (CollectionUtils.isEmpty(tags)) {
            return;
        }
        for (UserTag tag : tags) {
            this.setUserExportDtoTags(dto, tag);
        }
    }

    private void setUserExportDtoTags(UserExportDto dto, UserTag tag) {
        switch (tag.getTagName()) {
            case "invoiceType": {
                String invoiceType = StringUtils.trimToEmpty((String)tag.getTagValue());
                invoiceType = invoiceType.replaceAll(",", "/");
                dto.setInvoices(invoiceType);
                break;
            }
            case "printingEquipment": {
                String printingEquipment = StringUtils.trimToEmpty((String)tag.getTagValue());
                printingEquipment = printingEquipment.replaceAll(",", "/");
                dto.setPrintingEquipment(printingEquipment);
                break;
            }
            case "ticketOpeningTerminal": {
                String ticketOpeningTerminal = StringUtils.trimToEmpty((String)tag.getTagValue());
                ticketOpeningTerminal = ticketOpeningTerminal.replaceAll(",", "/");
                dto.setTicketOpeningTerminal(ticketOpeningTerminal);
                break;
            }
            default: {
                logger.warn("tagName:{},tagValue:{}", (Object)tag.getTagName(), (Object)tag.getTagValue());
            }
        }
    }

    @Transactional
    public void fixUserOrg(User user) {
        Set orgIds = this.orgUserRelDao.findOrgIdsByUserId(user.getId().longValue());
        Set parentIdsSet = orgIds.isEmpty() ? new HashSet() : this.orgStructDao.findParentIdsByOrgIds((Collection)orgIds);
        HashSet<Long> descendantOrgIds = new HashSet<Long>();
        for (String parentIds : parentIdsSet) {
            Set childrenOrgIds = this.orgStructDao.findOrgIdsByParentIdsLike(parentIds + "%");
            descendantOrgIds.addAll(childrenOrgIds);
        }
        this.bindOrgs(user, descendantOrgIds, user.getModules(), true, false, false);
    }

    private List<UserExportDTO> buildUserForExport(List<User> userList) {
        return userList.stream().map(user -> {
            UserExportDTO userDTO = new UserExportDTO();
            BeanUtils.copyProperties((Object)user.getAccount(), (Object)userDTO);
            BeanUtils.copyProperties((Object)user, (Object)userDTO);
            userDTO.setUserName(user.getUserName());
            userDTO.setChangePasswordFlag(user.getAccount().getChangePasswordFlag() == true ? 1 : 0);
            if (user.getUserSex() != null) {
                userDTO.setUserSex(user.getUserSex() == 0 ? "\u7537" : "\u5973");
            }
            userDTO.setStatus(user.getStatus().toString());
            userDTO.setExpiredDate(user.getExpiredDate() != null ? user.getExpiredDate().toString() : null);
            return userDTO;
        }).collect(Collectors.toList());
    }

    private List<UserOrgExportDTO> buildUserOrgForExport(List<User> userList) {
        ArrayList all = Lists.newArrayList();
        for (User user : userList) {
            List userOrgExportDTOList = user.getCurrentOrgs().stream().map(org -> {
                UserOrgExportDTO userOrgExportDTO = new UserOrgExportDTO();
                BeanUtils.copyProperties((Object)user.getAccount(), (Object)userOrgExportDTO);
                userOrgExportDTO.setOrgCode(org.getOrgCode());
                userOrgExportDTO.setOrgName(org.getOrgName());
                userOrgExportDTO.setTaxNum(org.getTaxNum());
                if (!CollectionUtils.isEmpty((Collection)org.getCompanyNos())) {
                    userOrgExportDTO.setCompanyNos(org.getCompanyNos().stream().collect(Collectors.joining(",")));
                }
                return userOrgExportDTO;
            }).collect(Collectors.toList());
            all.addAll(userOrgExportDTOList);
        }
        return all;
    }

    private List<UserRoleExportDTO> buildUserRoleForExport(List<User> userList) {
        ArrayList all = Lists.newArrayList();
        for (User user : userList) {
            List userRoleExportDTOList = user.getRoles().stream().map(role -> {
                UserRoleExportDTO userRoleDto = new UserRoleExportDTO();
                BeanUtils.copyProperties((Object)user.getAccount(), (Object)userRoleDto);
                userRoleDto.setRoleCode(role.getCode());
                userRoleDto.setRoleName(role.getName());
                return userRoleDto;
            }).collect(Collectors.toList());
            all.addAll(userRoleExportDTOList);
        }
        return all;
    }

    private List<UserTagDTO> buildUserInvoiceTypeExport(List<User> userList) {
        List<Object> all = Lists.newArrayList();
        all = userList.stream().map(user -> {
            ArrayList invoiceList = Lists.newArrayList();
            for (UserTag userTag : user.getUserTags()) {
                if (!userTag.getTagName().equalsIgnoreCase("invoiceType")) continue;
                String[] invoices = userTag.getTagValue().split(",");
                Arrays.stream(invoices).forEach(inv -> {
                    UserTagDTO tag = new UserTagDTO();
                    tag.setUsername(user.getAccount().getUsername());
                    tag.setTelPhone(user.getAccount().getTelPhone());
                    tag.setEmail(user.getAccount().getEmail());
                    tag.setInvoiceType((String)inv);
                    invoiceList.add(tag);
                });
            }
            return invoiceList;
        }).flatMap(list -> list.stream()).distinct().collect(Collectors.toList());
        return all;
    }

    private List<UserTerminalDTO> buildUserTerminalExport(List<User> userList) {
        return userList.stream().map(user -> {
            ArrayList terminalList = Lists.newArrayList();
            for (UserTag userTag : user.getUserTags()) {
                if (!TICKET_TERMINAL.equalsIgnoreCase(userTag.getTagName()) || !StringUtils.isNotEmpty((CharSequence)userTag.getTagValue())) continue;
                String[] terminals = userTag.getTagValue().split(",");
                Map<String, MsTerminalQueryResponseInfo> resultMap = this.terminalApiService.getTerminalMap(Arrays.asList(terminals));
                for (String terminal : terminals) {
                    UserTerminalDTO dto = new UserTerminalDTO();
                    BeanUtils.copyProperties((Object)user.getAccount(), (Object)dto);
                    dto.setTicketOpeningTerminal(terminal);
                    MsTerminalQueryResponseInfo terminalInfo = resultMap.get(terminal);
                    if (terminalInfo != null) {
                        if (terminalInfo.getCompanyInfo() != null) {
                            dto.setCompanyName(terminalInfo.getCompanyInfo().getCompanyName());
                            dto.setTaxNum(terminalInfo.getCompanyInfo().getTaxNo());
                        }
                        dto.setDevNum(terminalInfo.getTerminalNo());
                    }
                    terminalList.add(dto);
                }
            }
            return terminalList;
        }).flatMap(list -> list.stream()).distinct().collect(Collectors.toList());
    }

    private List<UserTerminalDTO> buildUserEquipmentExport(List<User> userList) {
        return userList.stream().map(user -> {
            ArrayList equipmentList = Lists.newArrayList();
            for (UserTag userTag : user.getUserTags()) {
                if (!PRINTING_EQUIPMENT.equalsIgnoreCase(userTag.getTagName()) || !StringUtils.isNotEmpty((CharSequence)userTag.getTagValue())) continue;
                String[] strings = userTag.getTagValue().split(",");
                Map<String, MsDeviceInfo> resultMap = this.terminalApiService.getDeviceMap(Arrays.asList(strings));
                for (String equipment : strings) {
                    UserTerminalDTO dto = new UserTerminalDTO();
                    BeanUtils.copyProperties((Object)user.getAccount(), (Object)dto);
                    dto.setPrintingEquipment(equipment);
                    MsDeviceInfo terminalInfo = resultMap.get(equipment);
                    if (terminalInfo != null) {
                        if (terminalInfo.getCompanyInfo() != null) {
                            dto.setCompanyName(terminalInfo.getCompanyInfo().getCompanyName());
                            dto.setTaxNum(terminalInfo.getCompanyInfo().getTaxNo());
                        }
                        dto.setDevNum(terminalInfo.getDeviceNo());
                    }
                    equipmentList.add(dto);
                }
            }
            return equipmentList;
        }).flatMap(list -> list.stream()).distinct().collect(Collectors.toList());
    }

    private List<UserTagDTO> buildUserExtExport(List<User> userList) {
        return userList.stream().map(user -> {
            UserTagDTO dto = new UserTagDTO();
            for (UserTag userTag : user.getUserTags()) {
                if (!"businessExtensionAttribute".equalsIgnoreCase(userTag.getTagName())) continue;
                BeanUtils.copyProperties((Object)user.getAccount(), (Object)dto);
                dto.setBusinessExtensionAttribute(userTag.getTagValue());
                dto.setTagType("businessExtensionAttribute");
            }
            return dto;
        }).collect(Collectors.toList());
    }

    private String getAccountName(Account account) {
        String accountName = account.getEmail();
        if (StringUtils.isEmpty((CharSequence)accountName)) {
            accountName = account.getTelPhone();
        }
        if (StringUtils.isEmpty((CharSequence)accountName)) {
            accountName = account.getUsername();
        }
        return accountName;
    }

    public void fillExcel(List<User> userList, SimpleExcelWriter simpleExcelWriter, Collection<String> sheets) {
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        int partitionSize = userList.size() > ImportExportThreadPool.CORE_POOL_SIZE ? userList.size() / ImportExportThreadPool.CORE_POOL_SIZE : 1;
        List partitionList = ListUtils.partition(userList, (int)partitionSize);
        ArrayList futureList = new ArrayList();
        partitionList.forEach(list -> futureList.add(CompletableFuture.runAsync(() -> list.forEach(item -> this.fulfill((User)item, BinaryUtils.toBinary((Enum)ExtraInfo.currentOrgs))), ImportExportThreadPool.get())));
        try {
            CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        ArrayList<User> userListWithFullInfo = new ArrayList<User>();
        partitionList.forEach(item -> userListWithFullInfo.addAll((Collection<User>)item));
        Iterator<String> iterator = sheets.iterator();
        while (iterator.hasNext()) {
            String sheet;
            switch (sheet = iterator.next()) {
                case "\u4eba\u5458\u57fa\u672c\u4fe1\u606f": {
                    List<UserExportDTO> userExportDTOList = this.buildUserForExport(userListWithFullInfo);
                    simpleExcelWriter.fill("\u4eba\u5458\u57fa\u672c\u4fe1\u606f", userExportDTOList);
                    break;
                }
                case "\u4eba\u5458\u548c\u53d1\u7968\u7c7b\u578b": {
                    List<UserTagDTO> userTypeDTOList = this.buildUserInvoiceTypeExport(userListWithFullInfo);
                    simpleExcelWriter.fill("\u4eba\u5458\u548c\u53d1\u7968\u7c7b\u578b", userTypeDTOList);
                    break;
                }
                case "\u4eba\u5458\u548c\u7a0e\u63a7\u8bbe\u5907": {
                    List<UserTerminalDTO> userEquipmentDTOList = this.buildUserEquipmentExport(userListWithFullInfo);
                    simpleExcelWriter.fill("\u4eba\u5458\u548c\u7a0e\u63a7\u8bbe\u5907", userEquipmentDTOList);
                    break;
                }
                case "\u4eba\u5458\u548c\u7a0e\u63a7\u7ec8\u7aef": {
                    List<UserTerminalDTO> userTerminalDTOList = this.buildUserTerminalExport(userListWithFullInfo);
                    simpleExcelWriter.fill("\u4eba\u5458\u548c\u7a0e\u63a7\u7ec8\u7aef", userTerminalDTOList);
                    break;
                }
                case "\u4eba\u5458\u548c\u7ec4\u7ec7\u5173\u7cfb": {
                    List<UserOrgExportDTO> userOrgExportDTOList = this.buildUserOrgForExport(userListWithFullInfo);
                    simpleExcelWriter.fill("\u4eba\u5458\u548c\u7ec4\u7ec7\u5173\u7cfb", userOrgExportDTOList);
                    break;
                }
                case "\u4eba\u5458\u548c\u89d2\u8272": {
                    List<UserRoleExportDTO> userRoleExportDTOList = this.buildUserRoleForExport(userListWithFullInfo);
                    simpleExcelWriter.fill("\u4eba\u5458\u548c\u89d2\u8272", userRoleExportDTOList);
                    break;
                }
                case "\u4eba\u5458\u548c\u6269\u5c55\u5b57\u6bb5": {
                    List<UserTagDTO> userExtExportDTOList = this.buildUserExtExport(userListWithFullInfo);
                    simpleExcelWriter.fill("\u4eba\u5458\u548c\u6269\u5c55\u5b57\u6bb5", userExtExportDTOList);
                    break;
                }
            }
        }
    }

    public String bindRoleAccountRel(RoleAccountImportDto dto, Long tenantId) {
        block13: {
            List<Long> roleIds;
            List<User> userList;
            block12: {
                ArrayList<String> errMsg = new ArrayList<String>();
                if (StringUtils.isBlank((CharSequence)dto.getAction())) {
                    errMsg.add("\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)dto.getAccount())) {
                    errMsg.add("\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)dto.getRoleCode())) {
                    errMsg.add("\u89d2\u8272\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!RoleAccountImportService.ACTION_LISTS.contains(dto.getAction())) {
                    return "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u64cd\u4f5c\u7c7b\u578b\u5e94\u8be5\u4e3a:{\u7ed1\u5b9a,\u89e3\u7ed1}";
                }
                Account account = null;
                if (StringUtils.isNotBlank((CharSequence)dto.getAccount())) {
                    try {
                        account = this.accountService.findOneByUsername(dto.getAccount());
                    }
                    catch (IllegalArgumentException e) {
                        errMsg.add("\u8d26\u53f7\"" + dto.getAccount() + "\"\u4e0d\u5b58\u5728");
                    }
                }
                Role role = null;
                if (StringUtils.isNotBlank((CharSequence)dto.getRoleCode()) && (role = this.roleDao.findByTenantIdAndCode(tenantId.longValue(), dto.getRoleCode())) == null) {
                    errMsg.add("\u89d2\u8272\u4ee3\u7801\"" + dto.getRoleCode() + "\"\u4e0d\u5b58\u5728");
                }
                if (!CollectionUtils.isEmpty(errMsg)) {
                    return String.join((CharSequence)";", errMsg);
                }
                UserModel.Request.Query userQuery = new UserModel.Request.Query();
                userQuery.setAccountId(account.getAccountId());
                userQuery.setTenantId(tenantId);
                userList = this.list(userQuery, Sort.unsorted());
                roleIds = Arrays.asList(role.getId());
                if (!"\u7ed1\u5b9a".equals(dto.getAction())) break block12;
                if (CollectionUtils.isEmpty(userList)) break block13;
                for (User user : userList) {
                    this.bindRoles(user, null, roleIds, null, null, null, false, false, false);
                }
                break block13;
            }
            if ("\u89e3\u7ed1".equals(dto.getAction()) && !CollectionUtils.isEmpty(userList)) {
                for (User user : userList) {
                    this.unbindRoles(tenantId, user.getId(), roleIds);
                }
            }
        }
        return null;
    }

    public void saveUserTag(UserTag userTag) {
        this.userTagDao.saveAndFlush((Object)userTag);
    }

    public Optional<User> findByTenantIdAndUsername(Long tenantId, String useranme) {
        Objects.requireNonNull(tenantId, "tenantId not null");
        Objects.requireNonNull(useranme, "username not null");
        UserModel.Request.Query query = new UserModel.Request.Query();
        query.setTenantId(tenantId);
        query.setAccountName(useranme);
        Page<User> userPage = this.page(query, Pageable.unpaged());
        return userPage.get().findFirst();
    }

    public void saveUserPure(Tenant tenant, UserModel.Request.Create userModel, AccountModel.Request.Create accountModel, Account account) {
        if (account == null) {
            AccountModel.Request.Create newAccount = new AccountModel.Request.Create();
            newAccount.setTelPhone(accountModel.getTelPhone());
            newAccount.setEmail(accountModel.getEmail());
            newAccount.setUsername(accountModel.getUsername());
            newAccount.setPassword(accountModel.getPassword());
            newAccount.setStatus(Integer.valueOf(1));
            newAccount.setType(accountModel.getType());
            newAccount.setEnableSendMsg(false);
            newAccount.setChangePasswordFlag(accountModel.isChangePasswordFlag());
            account = this.accountService.save(tenant, newAccount, accountModel.isEnableSendMsg(), accountModel.isRandomPassword(), true, accountModel.getUpdateIgnoreProperties());
        }
        User user = new User();
        BeanUtils.copyProperties((Object)userModel, (Object)user, (String[])((String[])Stream.of("account").toArray(String[]::new)));
        user.setAccountId(account.getAccountId());
        user.setTenantId(tenant.getTenantId());
        user.setStatus(userModel.getStatus());
        user.setActiveStatus(userModel.getStatus());
        user.setContactAddr(userModel.getContactAddr());
        this.saveAndFlush(user);
    }

    public void updateUserPure(User user, Account account) {
        this.saveAndFlush(user);
        this.accountDao.saveAndFlush((Object)account);
    }

    public void deleteUserTagById(Long userTagId) {
        this.userTagDao.deleteById(userTagId);
    }

    public Optional<User> findUserById(Long userId) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (userId != null && userId > 0L) {
                predicates.add(builder.equal((Expression)root.get("id"), (Object)userId));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return this.userDao.findOne((Specification)specification);
    }

    public List<User> findAllById(Collection<Long> ids) {
        return this.userDao.findAllById(ids);
    }

    public void copyPrivilege(Long tenantId, UserModel.Request.CopyPrivilege privilege) {
        User sourceUser = this.findById(privilege.getFromUserId(), 16);
        if (!tenantId.equals(sourceUser.getTenantId())) {
            throw new IllegalArgumentException("\u79fb\u4ea4\u4eba\u53ea\u80fd\u4e3a\u5f53\u524d\u79df\u6237\uff01");
        }
        Set toUserIds = privilege.getToUserIds().stream().filter(userId -> !sourceUser.getId().equals(userId)).collect(Collectors.toSet());
        ArrayList<String> errorList = new ArrayList<String>();
        for (Long toUserId : toUserIds) {
            Optional<User> toUser = this.findUserById(toUserId);
            if (!toUser.isPresent()) {
                errorList.add("\u672a\u627e\u5230\u7528\u6237\u5b9e\u4f53(" + toUserId + ")");
            }
            if (!tenantId.equals(toUser.get().getTenantId())) {
                errorList.add("\u53d7\u8ba9\u4eba(" + toUserId + ")\u53ea\u80fd\u4e3a\u5f53\u524d\u79df\u6237");
            }
            if (1 != toUser.get().getAccount().getStatus()) {
                errorList.add("\u53d7\u8ba9\u4eba\u8d26\u53f7(" + toUserId + ")\u5df2\u505c\u7528");
            }
            if (1 != toUser.get().getStatus()) {
                errorList.add("\u53d7\u8ba9\u4eba(" + toUserId + ")\u5df2\u505c\u7528");
            }
            if (null == toUser.get().getExpiredDate() || !toUser.get().getExpiredDate().before(new Date())) continue;
            errorList.add("\u53d7\u8ba9\u4eba(" + toUserId + ")\u5df2\u8fc7\u671f");
        }
        if (!CollectionUtils.isEmpty(errorList)) {
            throw new IllegalArgumentException(StringUtils.join((Object[])errorList.toArray(), (String)";"));
        }
        for (Long toUserId : toUserIds) {
            if (privilege.isWithRole()) {
                List<Long> roleIds = sourceUser.getRoles().stream().map(r -> r.getId()).collect(Collectors.toList());
                this.bindRoles(tenantId, null, toUserId, roleIds, null, null, null, false, true, false);
            }
            if (privilege.isWithOrg()) {
                List<Long> orgIds = sourceUser.getCurrentOrgs().stream().map(org -> org.getOrgId()).collect(Collectors.toList());
                this.bindOrgs(tenantId, toUserId, orgIds, null, false, true, false);
            }
            if (!privilege.isWithBusiness()) continue;
            User destUser = this.findById(toUserId);
            HashSet<String> invoiceTypeSet = new HashSet<String>();
            HashSet<String> equipmentSet = new HashSet<String>();
            HashSet<String> terminalSet = new HashSet<String>();
            List tags = sourceUser.getUserTags();
            String sourceBusinessTagVal = null;
            for (UserTag tag : tags) {
                String[] sourceCodes = tag.getTagValue().split(",");
                if (tag.getTagName().equalsIgnoreCase("invoiceType")) {
                    invoiceTypeSet.addAll(Arrays.asList(sourceCodes));
                }
                if (tag.getTagName().equalsIgnoreCase(PRINTING_EQUIPMENT)) {
                    equipmentSet.addAll(Arrays.asList(sourceCodes));
                }
                if (tag.getTagName().equalsIgnoreCase(TICKET_TERMINAL)) {
                    terminalSet.addAll(Arrays.asList(sourceCodes));
                }
                if (!tag.getTagName().equalsIgnoreCase("businessExtensionAttribute")) continue;
                sourceBusinessTagVal = tag.getTagValue();
            }
            UserTag invoiceTypeTag = null;
            UserTag equipmentTag = null;
            UserTag terminalTag = null;
            UserTag businessTag = null;
            for (UserTag userTag : destUser.getUserTags()) {
                String[] destCodes = userTag.getTagValue().split(",");
                if (userTag.getTagName().equalsIgnoreCase("invoiceType")) {
                    invoiceTypeSet.addAll(Arrays.asList(destCodes));
                    userTag.setTagValue(invoiceTypeSet.stream().filter(t -> !t.equals("")).collect(Collectors.joining(",")));
                    invoiceTypeTag = userTag;
                    this.userTagDao.saveAndFlush((Object)userTag);
                    continue;
                }
                if (userTag.getTagName().equalsIgnoreCase(PRINTING_EQUIPMENT)) {
                    equipmentSet.addAll(Arrays.asList(destCodes));
                    userTag.setTagValue(equipmentSet.stream().filter(t -> !t.equals("")).collect(Collectors.joining(",")));
                    equipmentTag = userTag;
                    this.userTagDao.saveAndFlush((Object)userTag);
                    continue;
                }
                if (userTag.getTagName().equalsIgnoreCase(TICKET_TERMINAL)) {
                    terminalSet.addAll(Arrays.asList(destCodes));
                    userTag.setTagValue(terminalSet.stream().filter(t -> !t.equals("")).collect(Collectors.joining(",")));
                    terminalTag = userTag;
                    this.userTagDao.saveAndFlush((Object)userTag);
                    continue;
                }
                if (!userTag.getTagName().equalsIgnoreCase("businessExtensionAttribute")) continue;
                businessTag = userTag;
            }
            if (invoiceTypeTag == null) {
                invoiceTypeTag = new UserTag();
                invoiceTypeTag.setTagName("invoiceType");
                invoiceTypeTag.setTagValue(invoiceTypeSet.stream().filter(t -> !t.equals("")).collect(Collectors.joining(",")));
                invoiceTypeTag.setUserId(toUserId);
                this.userTagDao.saveAndFlush((Object)invoiceTypeTag);
            }
            if (equipmentTag == null) {
                equipmentTag = new UserTag();
                equipmentTag.setTagName(PRINTING_EQUIPMENT);
                equipmentTag.setTagValue(equipmentSet.stream().filter(t -> !t.equals("")).collect(Collectors.joining(",")));
                equipmentTag.setUserId(toUserId);
                this.userTagDao.saveAndFlush((Object)equipmentTag);
            }
            if (terminalTag == null) {
                terminalTag = new UserTag();
                terminalTag.setTagName(TICKET_TERMINAL);
                terminalTag.setTagValue(terminalSet.stream().filter(t -> !t.equals("")).collect(Collectors.joining(",")));
                terminalTag.setUserId(toUserId);
                this.userTagDao.saveAndFlush((Object)terminalTag);
            }
            if (businessTag != null || !StringUtils.isNotEmpty(sourceBusinessTagVal)) continue;
            businessTag = new UserTag();
            businessTag.setTagName("businessExtensionAttribute");
            businessTag.setTagValue(sourceBusinessTagVal);
            businessTag.setUserId(toUserId);
            this.userTagDao.saveAndFlush((Object)businessTag);
        }
        if (privilege.isDisableFromUser()) {
            sourceUser.setStatus(Integer.valueOf(0));
            this.userDao.saveAndFlush((Object)sourceUser);
        }
    }

    public List<UserModel.Response.BatchSyncResult> batchCreate(long tenantId, UserModel.Request.BatchSync batchSync) {
        ArrayList resultList = Lists.newArrayList();
        Tenant tenant = null;
        tenant = (Tenant)this.tenantDao.findById((Object)tenantId).orElseThrow(() -> new IllegalArgumentException("\u975e\u6cd5\u7684\u79df\u6237id(" + tenantId + ")"));
        if (CollectionUtils.isEmpty((Collection)batchSync.getUsers())) {
            throw new IllegalArgumentException("\u7528\u6237list\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UserModel.Request.StandardCreate userModel : batchSync.getUsers()) {
            UserModel.Response.BatchSyncResult result = new UserModel.Response.BatchSyncResult();
            Account account = null;
            User user = null;
            long accountId = 0L;
            long userId = 0L;
            try {
                Optional userOptional;
                Optional<User> userOptional2;
                Set constraintViolations = this.validator.validate((Object)userModel, new Class[]{Default.class});
                if (!CollectionUtils.isEmpty((Collection)constraintViolations)) {
                    String messages = constraintViolations.stream().map(ConstraintViolation::getMessage).collect(Collectors.joining(","));
                    result.setCode("-1");
                    result.setMessage(messages);
                    resultList.add(result);
                    continue;
                }
                if (userModel.getAccountType().equals((Object)AccountType.PHONE_EMAIL) && StringUtils.isBlank((CharSequence)userModel.getPhone()) && StringUtils.isBlank((CharSequence)userModel.getEmail())) {
                    result.setCode("-1");
                    result.setMessage("Phone Or Email \u4e0d\u80fd\u4e3a\u7a7a!");
                    resultList.add(result);
                    continue;
                }
                if (userModel.getAccountType().equals((Object)AccountType.OTHER) && StringUtils.isBlank((CharSequence)userModel.getUserCode())) {
                    result.setCode("-1");
                    result.setMessage("\u521b\u5efa\u57df\u8d26\u53f7\u8981\u6c42 UserCode \u4e0d\u80fd\u4e3a\u7a7a!");
                    resultList.add(result);
                    continue;
                }
                if (userModel.getAccountId() != null && userModel.getAccountId() > 0L && (accountId = userModel.getAccountId().longValue()) > 0L) {
                    long finalAccountId = accountId;
                    account = (Account)this.accountDao.findById((Object)accountId).orElseThrow(() -> new IllegalArgumentException("\u975e\u6cd5\u7684\u8d26\u6237id(" + finalAccountId + ")"));
                }
                if (userModel.getUserId() != null) {
                    user = (User)this.userDao.findById((Serializable)userModel.getUserId(), EntityGraphs.named((String)"User.graph.account")).orElseThrow(() -> new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684userId(" + userModel.getUserId() + ")"));
                    if (user.getTenantId() == null || tenantId != user.getTenantId()) {
                        String message = "\u7528\u6237\u6240\u5728\u7684\u79df\u6237(" + user.getTenantId() + ")\u548c\u4f20\u5165\u53c2\u6570\u7684\u79df\u6237(" + tenantId + ")\u4e0d\u4e00\u81f4";
                        logger.warn(message);
                        throw new IllegalArgumentException(message);
                    }
                    userId = user.getId();
                }
                if (StringUtils.isNotBlank((CharSequence)userModel.getUserCode()) && (userOptional2 = this.findUserByTenantIdAndUserCode(tenantId, userModel.getUserCode(), batchSync.isMergeAccount())).isPresent()) {
                    if (batchSync.isMergeAccount()) {
                        user = userOptional2.get();
                        account = user.getAccount();
                        accountId = user.getAccountId();
                    } else {
                        throw new IllegalArgumentException("\u91cd\u590d\u7684\u7528\u6237code(" + userModel.getUserCode() + ")");
                    }
                }
                if (account == null) {
                    account = this.accountService.create(tenant, userModel.getPhone(), userModel.getEmail(), userModel.getUserCode(), userModel.getPassword(), userModel.getStatus(), userModel.getAccountType(), batchSync.isEnableSendMsg(), batchSync.isRandomPassword(), batchSync.isMergeAccount(), batchSync.isChangePasswordFlag(), null);
                    accountId = account.getAccountId();
                }
                boolean isNew = false;
                if (user == null && accountId > 0L) {
                    List users = this.userDao.findByTenantIdAndAccountId(tenantId, accountId);
                    user = users.stream().findFirst().orElse(null);
                }
                if (user == null && StringUtils.isNotBlank((CharSequence)userModel.getUserCode()) && (userOptional = this.userDao.findByTenantIdAndUserCode(tenantId, userModel.getUserCode())).isPresent()) {
                    user = (User)userOptional.get();
                }
                if (user != null) {
                    if (StringUtils.isBlank((CharSequence)userModel.getUserCode())) {
                        userModel.setUserCode(null);
                    } else {
                        this.validExistsByTenantIdAndUserCode(tenantId, user.getId(), userModel.getUserCode());
                    }
                    BeanUtils.copyProperties((Object)userModel, (Object)user, (String[])((String[])Stream.of("account").toArray(String[]::new)));
                } else {
                    user = new User();
                    isNew = true;
                    BeanUtils.copyProperties((Object)userModel, (Object)user, (String[])((String[])Stream.of("account").toArray(String[]::new)));
                    user.setTenantId(Long.valueOf(tenantId));
                    user.setAccountId(Long.valueOf(accountId));
                }
                user.setUserPhone(userModel.getPhone());
                user.setUserEmailAddr(userModel.getEmail());
                if (userModel.getStatus() != null) {
                    user.setStatus(userModel.getStatus());
                    user.setActiveStatus(userModel.getStatus());
                }
                user = this.saveAndFlush(user);
                this.saveUserTags(user.getId(), userModel.getInvoiceType(), userModel.getPrintingEquipment(), userModel.getTicketOpeningTerminal(), userModel.getBusinessExtensionAttribute(), batchSync.isTagOverwrite());
                if (logger.isInfoEnabled()) {
                    logger.debug("user = " + JsonUtils.toJson((Object)user));
                }
                HashSet<Long> orgIds = new HashSet<Long>();
                if (userModel.getOrgIds() != null || userModel.getOrgCodes() != null) {
                    if (!CollectionUtils.isEmpty((Collection)userModel.getOrgIds())) {
                        List filteredOrgIds = this.orgStructDao.findOrgIdsByTenantIdAndOrgIds(tenantId, (Collection)userModel.getOrgIds());
                        orgIds.addAll(filteredOrgIds);
                    }
                    if (!CollectionUtils.isEmpty((Collection)userModel.getOrgCodes())) {
                        Set orgCodes = userModel.getOrgCodes();
                        List orgs = new ArrayList();
                        if (CollectionUtils.isEmpty((Collection)orgCodes)) {
                            if (isNew) {
                                orgs = this.orgStructDao.findRootsByTenantId(tenantId);
                            }
                        } else {
                            orgs = this.orgStructDao.findByTenantIdAndOrgCodes(tenantId, (Collection)orgCodes);
                            if (orgCodes.size() != orgs.size()) {
                                List finalOrgs = orgs;
                                Set diffOrgCodes = orgCodes.stream().filter(orgCode -> finalOrgs.stream().map(OrgStruct::getOrgCode).noneMatch(finalOrgCode -> finalOrgCode.equals(orgCode))).collect(Collectors.toSet());
                                String message = "User(" + user.getUserCode() + ")\u5305\u542b\u542b\u6709\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u7684\u7ec4\u7ec7\u4ee3\u7801(" + String.join((CharSequence)",", diffOrgCodes) + ")";
                                logger.warn(message);
                                if (batchSync.isStrict()) {
                                    throw new IllegalArgumentException(message);
                                }
                            }
                        }
                        if (!orgs.isEmpty()) {
                            Set orgIdSet = orgs.stream().map(OrgStruct::getOrgId).collect(Collectors.toSet());
                            logger.info("orgIdSet = " + orgIdSet.stream().map(Object::toString).collect(Collectors.joining(",")));
                            orgIds.addAll(orgIdSet);
                        }
                    }
                }
                HashSet<Long> roleIds = new HashSet<Long>();
                if (userModel.getRoleIds() != null || userModel.getRoleCodes() != null) {
                    Set roleCodes;
                    List roles;
                    if (!CollectionUtils.isEmpty((Collection)userModel.getRoleIds())) {
                        Set roleIdSet = userModel.getRoleIds().stream().filter(roleId -> roleId != null && roleId > 0L).collect(Collectors.toSet());
                        logger.info("roleIdSet = " + roleIdSet.stream().map(Object::toString).collect(Collectors.joining(",")));
                        roles = this.roleDao.findAllById(roleIdSet);
                        roleIdSet = roles.stream().filter(role -> role.getTenantId().equals(tenantId) || role.getTenantId() == -1L).map(Role::getId).collect(Collectors.toSet());
                        logger.debug("roleIdSet = " + roleIdSet.stream().map(Object::toString).collect(Collectors.joining(",")));
                        roleIds.addAll(roleIdSet);
                        Set<Role> copingRoleTemplates = roles.stream().filter(role -> role.getTenantId() == 0L).collect(Collectors.toSet());
                        Set<Role> copiedRoles = this.roleService.copyRoleTempates(tenantId, copingRoleTemplates);
                        if (!CollectionUtils.isEmpty(copiedRoles)) {
                            Set copiedRoleIds = copiedRoles.stream().map(Role::getId).collect(Collectors.toSet());
                            roleIds.addAll(copiedRoleIds);
                        }
                    }
                    if (!CollectionUtils.isEmpty((Collection)(roleCodes = userModel.getRoleCodes()))) {
                        roles = this.roleDao.findByTenantIdAndRoleCodes(tenantId, (Collection)roleCodes);
                        if (roleCodes.size() != roles.size()) {
                            String message = "User(" + user.getUserCode() + ")\u5305\u542b\u542b\u6709\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u7684\u89d2\u8272\u4ee3\u7801";
                            logger.warn(message);
                            if (batchSync.isStrict()) {
                                throw new IllegalArgumentException(message);
                            }
                        }
                        if (!roles.isEmpty()) {
                            Set roleIdSet = roles.stream().map(Role::getId).collect(Collectors.toSet());
                            logger.debug("roleIdSet = " + roleIdSet.stream().map(Object::toString).collect(Collectors.joining(",")));
                            roleIds.addAll(roleIdSet);
                        }
                    }
                }
                this.bindOrgs(user, orgIds, null, batchSync.isOrgOverwrite(), batchSync.isStrict(), false);
                this.bindRoles(user, null, roleIds, null, null, null, batchSync.isRoleOverwrite(), batchSync.isStrict(), false);
                user.setPrintingEquipment("");
                user.setTicketOpeningTerminal("");
                user.setBusinessExtensionAttribute("");
                result.setUserInfo((Object)JsonUtils.toJson((Object)user, View.Info.class));
            }
            catch (IllegalArgumentException e) {
                logger.error("\u7528\u6237\u540c\u6b65\u5931\u8d25", (Throwable)e);
                result.setCode("-1");
                result.setMessage(e.getMessage());
            }
            catch (Exception e) {
                logger.error("\u7528\u6237\u540c\u6b65\u5f02\u5e38", (Throwable)e);
                result.setCode("-2");
                result.setMessage(e.getMessage() + ":" + this.getAccountName(userModel));
            }
            resultList.add(result);
        }
        return resultList;
    }

    private String getAccountName(UserModel.Request.StandardCreate userModel) {
        if (StringUtils.isNotBlank((CharSequence)userModel.getEmail())) {
            return userModel.getEmail();
        }
        if (StringUtils.isNotBlank((CharSequence)userModel.getPhone())) {
            return userModel.getPhone();
        }
        if (StringUtils.isNotBlank((CharSequence)userModel.getUserCode())) {
            return userModel.getUserCode();
        }
        return "";
    }

    @Transactional
    public User changeTenantByAccount(long accountId, long tenantId) {
        UserModel.Request.Query query = new UserModel.Request.Query();
        query.setAccountId(Long.valueOf(accountId));
        query.setTenantId(Long.valueOf(tenantId));
        query.setStatus(Integer.valueOf(1));
        List users = this.userDao.findAll(UserQueryHelper.querySpecification((UserModel.Request.Query)query), EntityGraphs.named((String)"User.graph"));
        User user = (User)users.stream().findAny().orElseThrow(() -> new IllegalArgumentException("\u4e0d\u5b58\u5728\u8be5\u7528\u6237(tenantId:" + tenantId + ",accountId:" + accountId + ")"));
        user = this.fulfill(user, 0);
        Account account = user.getAccount();
        account.setLastLoginTime(Calendar.getInstance().getTime());
        account = (Account)this.accountDao.saveAndFlush((Object)account);
        user.setUsername(account.getUsername());
        user.setEmail(account.getEmail());
        user.setMobile(account.getTelPhone());
        return user;
    }

    public User changeTenant(Long userId, Long tenantId) {
        User existUser = this.findById(userId);
        UserModel.Request.Query query = new UserModel.Request.Query();
        query.setAccountId(existUser.getAccountId());
        query.setTenantId(tenantId);
        query.setStatus(Integer.valueOf(1));
        List users = this.userDao.findAll(UserQueryHelper.querySpecification((UserModel.Request.Query)query));
        return (User)users.stream().findAny().orElseThrow(() -> new IllegalArgumentException("\u4e0d\u5b58\u5728\u8be5\u7528\u6237(tenantId:" + tenantId + ",accountId:" + existUser.getAccountId() + ")"));
    }

    public void bindPrintingEquipment(User user, List<String> equipmentList) {
        this.bindTag(user, equipmentList, PRINTING_EQUIPMENT);
    }

    private void bindTag(User user, List<String> equipmentList, String tagName) {
        String value;
        Assert.notNull((Object)user, (String)"\u7528\u6236\u4e0d\u80fd\u70ba\u7a7a");
        List userTags = this.userTagDao.findByUserId(user.getId());
        UserTag userTag1 = null;
        for (UserTag userTag : userTags) {
            if (!tagName.equals(userTag.getTagName())) continue;
            userTag1 = userTag;
            break;
        }
        if (userTag1 == null) {
            userTag1 = new UserTag();
            userTag1.setUserId(user.getId());
            userTag1.setTagName(tagName);
            value = StringUtils.join(equipmentList, (String)",");
            userTag1.setTagValue(value);
            this.userTagDao.save((Object)userTag1);
            return;
        }
        if (StringUtils.isEmpty((CharSequence)userTag1.getTagValue())) {
            value = StringUtils.join(equipmentList, (String)",");
            userTag1.setTagValue(value);
            this.userTagDao.save((Object)userTag1);
            return;
        }
        String[] existValueArray = StringUtils.split((String)userTag1.getTagValue(), (String)",");
        HashSet<String> unionValues = new HashSet<String>(Arrays.asList(existValueArray));
        unionValues.addAll(equipmentList);
        String newTagValue = StringUtils.join(unionValues, (String)",");
        userTag1.setTagValue(newTagValue);
        this.userTagDao.save((Object)userTag1);
    }

    public void unbindPrintingEquipment(User user, List<String> equipmentList) {
        this.unbindTag(user, equipmentList, PRINTING_EQUIPMENT);
    }

    private void unbindTag(User user, List<String> equipmentList, String tagName) {
        Assert.notNull((Object)user, (String)"\u7528\u6236\u4e0d\u80fd\u70ba\u7a7a");
        List userTags = this.userTagDao.findByUserId(user.getId());
        UserTag userTag1 = null;
        for (UserTag userTag : userTags) {
            if (!tagName.equals(userTag.getTagName())) continue;
            userTag1 = userTag;
            break;
        }
        if (userTag1 == null) {
            userTag1 = new UserTag();
            userTag1.setUserId(user.getId());
            userTag1.setTagName(tagName);
            userTag1.setTagValue("");
            this.userTagDao.save((Object)userTag1);
            return;
        }
        if (StringUtils.isEmpty((CharSequence)userTag1.getTagValue())) {
            return;
        }
        String[] existValueArray = StringUtils.split((String)userTag1.getTagValue(), (String)",");
        List reduce1 = Arrays.asList(existValueArray).stream().filter(item -> !equipmentList.contains(item)).collect(Collectors.toList());
        String newTagValue = StringUtils.join(reduce1, (String)",");
        userTag1.setTagValue(newTagValue);
        this.userTagDao.save((Object)userTag1);
    }

    public void bindTicketTerminal(User user, List<String> terminalList) {
        this.bindTag(user, terminalList, TICKET_TERMINAL);
    }

    public void unbindTicketTerminal(User user, List<String> terminalList) {
        this.unbindTag(user, terminalList, TICKET_TERMINAL);
    }

    private Boolean needModifyPassword(Date pwdLastUpdateTime) {
        LocalDate pwdLastUpdateDate = new DateTime((Object)pwdLastUpdateTime).toLocalDate();
        return pwdLastUpdateDate.plusDays(90).compareTo((ReadablePartial)LocalDate.now()) <= 0;
    }

    public void changeTenantManager(String username, Long tenantId) {
        Tenant tenant = (Tenant)this.tenantDao.findById((Object)tenantId).orElseThrow(() -> new IllegalArgumentException("\u4e0d\u5b58\u5728\u8be5\u79df\u6237(" + tenantId + ")"));
        String tenantUsername = this.getDomainAccountName(username, tenant.getTenantCode());
        Optional<User> userOptional = this.findByTenantIdAndUsername(tenantId, tenantUsername);
        if (!userOptional.isPresent() && !(userOptional = this.findByTenantIdAndUsername(tenantId, username)).isPresent()) {
            throw new IllegalArgumentException("\u79df\u6237\uff08" + tenant.getTenantName() + "\uff09\uff0c\u4e0d\u5b58\u5728\u7528\u6237\u540d\u4e3a(" + username + ")");
        }
        User user = userOptional.get();
        if (!tenantId.equals(user.getTenantId())) {
            throw new IllegalArgumentException("\u8be5\u7528\u6237\u4e0d\u5c5e\u4e8e\u79df\u6237(" + tenantId + ")");
        }
        List rels = this.roleUserRelDao.findByRoleIdAndTenantId(1L, tenantId.longValue());
        if (!CollectionUtils.isEmpty((Collection)rels)) {
            List roleUserRels = rels.stream().filter(rel -> user.getId().equals(rel.getUserId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(roleUserRels)) {
                return;
            }
            RoleUserRel roleUserRel = (RoleUserRel)rels.stream().findFirst().get();
            this.roleUserRelDao.delete((Object)roleUserRel);
            RoleUserRel saveObj = new RoleUserRel();
            saveObj.setUserId(user.getId());
            saveObj.setTenantId(tenantId);
            saveObj.setRoleId(Long.valueOf(1L));
            this.roleUserRelDao.save((Object)saveObj);
        }
    }

    public List<TenantManagerDto> findTenantManager(List<Long> tenantIds) {
        return this.userDao.findTenantManager(tenantIds);
    }

    public String getDomainAccountName(String username, String tenantCode) {
        if ("wilmar".equalsIgnoreCase(tenantCode)) {
            return username;
        }
        if (EnvProfile.isCrcProfile) {
            return username;
        }
        if (RegExUtil.checkEmail((String)username)) {
            return username;
        }
        if (RegExUtil.checkMobile((String)username)) {
            return username;
        }
        if (!username.contains(tenantCode)) {
            username = tenantCode + username;
        }
        return username;
    }

    public User saveAndFlush(User user) {
        try {
            user = (User)this.userDao.saveAndFlush((Object)user);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
        Long accountId = user.getAccountId();
        Long tenantId = user.getTenantId();
        Account account = (Account)this.accountDao.findById((Object)user.getAccountId()).orElseThrow(() -> new IllegalArgumentException("\u65e0\u6cd5\u627e\u5230\u8be5\u8d26\u53f7(" + accountId + ")"));
        Tenant tenant = (Tenant)this.tenantDao.findById((Object)user.getTenantId()).orElseThrow(() -> new IllegalArgumentException("\u65e0\u6cd5\u627e\u5230\u8be5\u79df\u6237(" + tenantId + ")"));
        this.userPubService.pub(user, account, tenant);
        if (user.getAccount() == null) {
            user.setAccount((AccountDto)account);
        }
        if (user.getTenant() == null) {
            user.setTenant(tenant);
        }
        return user;
    }

    public void logoff(long userId, String loginId) {
        this.userRedisCacheService.cleanUserByUserIdAndLoginId(userId, loginId);
    }

    @Transactional
    public void deleteByOrgIdAndId(long orgId, long userId) {
        this.userDao.deleteByOrgIdAndId(orgId, userId);
    }

    private User findOneValidUser(List<User> users) {
        User user = null;
        for (User item : users) {
            if (1 != item.getStatus()) continue;
            user = item;
            break;
        }
        if (user == null) {
            user = users.get(0);
        }
        return user;
    }

    public static class CachedRoleOrgUserRels {
        Set<RoleUserRel> insertingRoleUserRels;
        Set<RoleUserRel> deletingRoleUserRels;
        Set<OrgUserRel> insertingOrgUserRels;
        Set<OrgUserRel> deletingOrgUserRels;

        CachedRoleOrgUserRels(Set<RoleUserRel> insertingRoleUserRels, Set<RoleUserRel> deletingRoleUserRels, Set<OrgUserRel> insertingOrgUserRels, Set<OrgUserRel> deletingOrgUserRels) {
            this.insertingRoleUserRels = insertingRoleUserRels;
            this.deletingRoleUserRels = deletingRoleUserRels;
            this.insertingOrgUserRels = insertingOrgUserRels;
            this.deletingOrgUserRels = deletingOrgUserRels;
        }

        public static CachedRoleOrgUserRelsBuilder builder() {
            return new CachedRoleOrgUserRelsBuilder();
        }

        public static class CachedRoleOrgUserRelsBuilder {
            private Set<RoleUserRel> insertingRoleUserRels;
            private Set<RoleUserRel> deletingRoleUserRels;
            private Set<OrgUserRel> insertingOrgUserRels;
            private Set<OrgUserRel> deletingOrgUserRels;

            CachedRoleOrgUserRelsBuilder() {
            }

            public CachedRoleOrgUserRelsBuilder insertingRoleUserRels(Set<RoleUserRel> insertingRoleUserRels) {
                this.insertingRoleUserRels = insertingRoleUserRels;
                return this;
            }

            public CachedRoleOrgUserRelsBuilder deletingRoleUserRels(Set<RoleUserRel> deletingRoleUserRels) {
                this.deletingRoleUserRels = deletingRoleUserRels;
                return this;
            }

            public CachedRoleOrgUserRelsBuilder insertingOrgUserRels(Set<OrgUserRel> insertingOrgUserRels) {
                this.insertingOrgUserRels = insertingOrgUserRels;
                return this;
            }

            public CachedRoleOrgUserRelsBuilder deletingOrgUserRels(Set<OrgUserRel> deletingOrgUserRels) {
                this.deletingOrgUserRels = deletingOrgUserRels;
                return this;
            }

            public CachedRoleOrgUserRels build() {
                return new CachedRoleOrgUserRels(this.insertingRoleUserRels, this.deletingRoleUserRels, this.insertingOrgUserRels, this.deletingOrgUserRels);
            }

            public String toString() {
                return "UserService.CachedRoleOrgUserRels.CachedRoleOrgUserRelsBuilder(insertingRoleUserRels=" + this.insertingRoleUserRels + ", deletingRoleUserRels=" + this.deletingRoleUserRels + ", insertingOrgUserRels=" + this.insertingOrgUserRels + ", deletingOrgUserRels=" + this.deletingOrgUserRels + ")";
            }
        }
    }
}

