/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.api.model.OrgModel;
import com.xforceplus.business.tenant.service.AsyncOrgUserService;
import com.xforceplus.business.tenant.service.OrgService;
import com.xforceplus.dao.OrgStructDao;
import com.xforceplus.dao.TenantDao;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.Tenant;
import com.xforceplus.tenant.security.core.domain.OrgType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.criteria.Expression;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WrapperOrgService {
    private static final Logger logger = LoggerFactory.getLogger(WrapperOrgService.class);
    private final OrgService orgService;
    private final AsyncOrgUserService orgUserService;
    private final TenantDao tenantDao;
    private final OrgStructDao orgStructDao;

    public WrapperOrgService(OrgService orgService, AsyncOrgUserService orgUserService, TenantDao tenantDao, OrgStructDao orgStructDao) {
        this.orgService = orgService;
        this.orgUserService = orgUserService;
        this.tenantDao = tenantDao;
        this.orgStructDao = orgStructDao;
    }

    public OrgStruct create(@Valid OrgModel.Request.Save model) {
        OrgStruct orgStruct = this.orgService.create(model);
        if (model.getIsAutoBindParentOrgUsers().booleanValue()) {
            this.orgUserService.autoBindParentUsers(orgStruct.getTenantId(), orgStruct.getOrgId());
        }
        return orgStruct;
    }

    public OrgService.OrgSaveOutput save(long tenantId, OrgModel.Request.Save model, boolean isOverwrite) {
        if (!this.tenantDao.existsById((Object)tenantId)) {
            String message = "\u4e0d\u5408\u6cd5\u7684\u79df\u6237id(" + tenantId + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        logger.info("save Org tenantId({})", (Object)tenantId);
        OrgService.OrgSaveInput orgSaveInput = new OrgService.OrgSaveInput(tenantId, 0L, null, new ArrayList<OrgStruct>());
        OrgService.OrgSaveOutput orgSaveOutput = this.save(orgSaveInput, model, isOverwrite);
        return orgSaveOutput;
    }

    public OrgService.OrgSaveOutput save(long tenantId, long parentId, OrgStruct parent, OrgModel.Request.Save model, boolean isOverwrite) {
        if (!this.tenantDao.existsById((Object)tenantId)) {
            String message = "\u4e0d\u5408\u6cd5\u7684\u79df\u6237id(" + tenantId + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        logger.info("save Org tenantId({})", (Object)tenantId);
        OrgService.OrgSaveInput orgSaveInput = new OrgService.OrgSaveInput(tenantId, parentId, parent, new ArrayList<OrgStruct>());
        OrgService.OrgSaveOutput orgSaveOutput = this.save(orgSaveInput, model, isOverwrite);
        return orgSaveOutput;
    }

    public void save(long tenantId, List<OrgModel.Request.Save> models) {
        this.save(tenantId, 0L, models);
    }

    public void save(long tenantId, long parentId, List<OrgModel.Request.Save> models) {
        if (CollectionUtils.isEmpty(models)) {
            return;
        }
        if (!this.tenantDao.existsById((Object)tenantId)) {
            String message = "\u4e0d\u5408\u6cd5\u7684\u79df\u6237id(" + tenantId + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        OrgStruct parentOrg = null;
        if (parentId > 0L) {
            String message = "\u4e0d\u5b58\u5728\u7684\u7236\u7ec4\u7ec7id(" + parentId + ")";
            parentOrg = (OrgStruct)this.orgStructDao.findOne((Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.equal((Expression)root.get("orgId"), (Object)parentId)).orElseThrow(() -> new IllegalArgumentException(message));
            if (parentOrg == null) {
                logger.warn(message);
                throw new IllegalArgumentException(message);
            }
            if (tenantId != parentOrg.getTenantId()) {
                logger.warn(message);
                throw new IllegalArgumentException(message);
            }
        }
        OrgService.OrgSaveInput orgSaveInput = new OrgService.OrgSaveInput(tenantId, parentId, parentOrg, new ArrayList<OrgStruct>());
        models.forEach(model -> this.save(orgSaveInput, (OrgModel.Request.Save)model, model.isOverwrite()));
    }

    public OrgService.OrgSaveOutput save(OrgService.OrgSaveInput orgSaveInput, OrgModel.Request.Save model, boolean isOverwrite) {
        OrgService.OrgSaveOutput orgSaveOutput = this.orgService.saveOrg(orgSaveInput, model, isOverwrite);
        if (model.getIsAutoBindParentOrgUsers().booleanValue()) {
            OrgStruct org = orgSaveOutput.findFirst();
            this.orgUserService.autoBindParentUsers(org.getTenantId(), org.getOrgId());
        }
        return orgSaveOutput;
    }

    public <C extends CompanyModel.Request.Save> Company saveCompany(Tenant tenant, C model) {
        model.setHostTenantId(tenant.getTenantId());
        Optional<Object> rootOrgIdOptional = Optional.empty();
        List rootIds = this.orgStructDao.findRootIdsByTenantId(tenant.getTenantId().longValue());
        if (!rootIds.isEmpty()) {
            rootOrgIdOptional = rootIds.stream().filter(Objects::nonNull).findFirst();
        }
        if (!rootOrgIdOptional.isPresent()) {
            OrgModel.Request.Save rootOrgModel = new OrgModel.Request.Save();
            rootOrgModel.setTenantId(tenant.getTenantId());
            rootOrgModel.setOrgName(tenant.getTenantName());
            rootOrgModel.setOrgDesc(tenant.getTenantDesc());
            rootOrgModel.setOrgType(OrgType.GROUP);
            OrgStruct rootOrg = this.create(rootOrgModel);
            if (rootOrg != null) {
                rootOrgIdOptional = Optional.of(rootOrg.getOrgId());
            } else {
                throw new IllegalArgumentException("\u79df\u6237(" + tenant.getTenantId() + ")\u521b\u5efa\u6216\u83b7\u53d6\u6839\u7ec4\u7ec7\u5931\u8d25");
            }
        }
        return this.saveCompany(tenant.getTenantId(), (Long)rootOrgIdOptional.get(), model);
    }

    public <C extends CompanyModel.Request.Save> Company saveCompany(long tenantId, Long rootOrgId, C model) {
        Page<OrgStruct> rootOrgs;
        Optional<Long> rootOrgIdOptional = Optional.ofNullable(rootOrgId);
        if (!rootOrgIdOptional.isPresent() && !(rootOrgs = this.orgService.findRoots(tenantId, Pageable.unpaged())).isEmpty()) {
            rootOrgIdOptional = rootOrgs.stream().map(OrgStruct::getOrgId).filter(Objects::nonNull).findFirst();
        }
        if (!rootOrgIdOptional.isPresent()) {
            String message = "\u79df\u6237(" + tenantId + ")\u7f3a\u5c11\u6839\u7ec4\u7ec7, \u8bf7\u4fee\u590d";
            throw new IllegalArgumentException(message);
        }
        OrgModel.Request.Save orgModel = new OrgModel.Request.Save();
        orgModel.setTenantId(Long.valueOf(tenantId));
        orgModel.setParentId(rootOrgIdOptional.get());
        orgModel.setOrgName(model.getCompanyName());
        orgModel.setOrgDesc(model.getCompanyName());
        orgModel.setOrgType(OrgType.COMPANY);
        model.setHostTenantId(Long.valueOf(tenantId));
        orgModel.setCompany(model);
        OrgStruct org = this.create(orgModel);
        return org.getCompany();
    }
}

