/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.wechat.service;

import com.xforceplus.business.account.service.AccountService;
import com.xforceplus.business.pub.service.PubsubService;
import com.xforceplus.config.PubsubConfig;
import com.xforceplus.janus.pubsub.sdk.IMessageListener;
import com.xforceplus.janus.pubsub.sdk.msg.SealedMessage;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

public class WechatMpEventListener
implements IMessageListener,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AccountService.class);
    private static final String WXMP_BIND_PREFIX = "BIND_WX_MP_";
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private PubsubService pubsubService;
    @Autowired
    private PubsubConfig pubsubConfig;

    public boolean onMessage(SealedMessage sealedMessage) {
        logger.info("wx.event:{}", sealedMessage.getPayload().getObj());
        Map map = (Map)sealedMessage.getPayload().getObj();
        String event = (String)map.get("event");
        if ("subscribe".equals(event) || "scan".equals(event)) {
            String openId = (String)map.get("fromUserName");
            String bindInfo = ((String)map.get("eventKey")).replace("qrscene_", "");
            this.redisTemplate.opsForValue().set((Object)(WXMP_BIND_PREFIX + openId), (Object)bindInfo);
        }
        this.pubsubService.acknowlege(sealedMessage);
        return true;
    }

    public void afterPropertiesSet() {
        this.pubsubService.register(this.pubsubConfig.getAppCode(), this, "*");
    }
}

