/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.wechat.service;

import com.google.common.collect.Maps;
import com.xforceplus.business.account.service.AccessTokenResp;
import com.xforceplus.business.wechat.service.TicketResp;
import io.geewit.web.utils.JsonUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class WechatMpService {
    private static final Logger log = LoggerFactory.getLogger(WechatMpService.class);
    @Autowired
    private RestTemplate restTemplate;

    public String create(String appId, String secret, String sceneStr) {
        String getTokenUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";
        String getTicketUrl = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=%s";
        String showQrcodeUrl = "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=%s";
        getTokenUrl = String.format(getTokenUrl, appId, secret);
        ResponseEntity responseEntity = this.restTemplate.getForEntity(getTokenUrl, String.class, new Object[0]);
        String response = (String)responseEntity.getBody();
        log.info("get token:{}", (Object)response);
        AccessTokenResp accessTokenResp = (AccessTokenResp)JsonUtils.fromJson((String)response, AccessTokenResp.class);
        if (!StringUtils.isBlank((CharSequence)accessTokenResp.getAccess_token())) {
            getTicketUrl = String.format(getTicketUrl, accessTokenResp.getAccess_token());
            Map<String, Object> request = this.createQrcodeRequestBody(sceneStr);
            responseEntity = this.restTemplate.postForEntity(getTicketUrl, request, String.class, (Map)Maps.newHashMap());
            response = (String)responseEntity.getBody();
            log.info("get ticket:{}", (Object)response);
            TicketResp ticketResp = (TicketResp)JsonUtils.fromJson((String)response, TicketResp.class);
            if (!StringUtils.isEmpty((CharSequence)ticketResp.getTicket())) {
                showQrcodeUrl = String.format(showQrcodeUrl, ticketResp.getTicket());
            }
        }
        return showQrcodeUrl;
    }

    private Map<String, Object> createQrcodeRequestBody(String sceneStr) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        HashMap action = new HashMap();
        HashMap<String, String> scene = new HashMap<String, String>();
        scene.put("scene_str", sceneStr);
        action.put("scene", scene);
        body.put("action_name", "QR_LIMIT_STR_SCENE");
        body.put("action_info", action);
        return body;
    }
}

