/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.config;

import com.xforceplus.config.CachingConfig;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.redis.cache.RedisCacheManager;

@AutoConfigureAfter(value={CachingConfig.class})
@Configuration
public class CacheInitConfig {
    static final Set<String> CACHE_NAMES = new HashSet<String>();
    private static final Logger logger = LoggerFactory.getLogger(CacheInitConfig.class);

    public CacheInitConfig(ApplicationContext applicationContext, CaffeineCacheManager caffeineCacheManager, RedisCacheManager.RedisCacheManagerBuilder redisCacheManagerBuilder) {
        String[] beanNames;
        for (String beanName : beanNames = applicationContext.getBeanDefinitionNames()) {
            if (StringUtils.contains((CharSequence)beanName, (CharSequence)".")) continue;
            try {
                Object bean = applicationContext.getBean(beanName);
                Class<?> clazz = bean.getClass();
                String className = clazz.getName();
                if (!StringUtils.startsWith((CharSequence)className, (CharSequence)"com.xforceplus.")) continue;
                this.setCacheNames(clazz);
            }
            catch (BeansException beansException) {
                // empty catch block
            }
        }
        caffeineCacheManager.setCacheNames(CACHE_NAMES);
        redisCacheManagerBuilder.initialCacheNames(CACHE_NAMES);
    }

    private void setCacheNames(Class<?> clazz) {
        Method[] methods;
        boolean foundAnnotation = false;
        CacheConfig cacheConfig = (CacheConfig)AnnotationUtils.getAnnotation(clazz, CacheConfig.class);
        if (cacheConfig != null) {
            CACHE_NAMES.addAll(Arrays.asList(cacheConfig.cacheNames()));
            foundAnnotation = true;
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            CacheEvict cacheEvict;
            Cacheable cacheable;
            CachePut cachePut = (CachePut)AnnotationUtils.findAnnotation((Method)method, CachePut.class);
            if (cachePut != null) {
                CACHE_NAMES.addAll(Arrays.asList(cachePut.value()));
                foundAnnotation = true;
            }
            if ((cacheable = (Cacheable)AnnotationUtils.findAnnotation((Method)method, Cacheable.class)) != null) {
                CACHE_NAMES.addAll(Arrays.asList(cacheable.value()));
                foundAnnotation = true;
            }
            if ((cacheEvict = (CacheEvict)AnnotationUtils.findAnnotation((Method)method, CacheEvict.class)) == null) continue;
            CACHE_NAMES.addAll(Arrays.asList(cacheEvict.value()));
            foundAnnotation = true;
        }
        if (foundAnnotation) {
            logger.info("beanName = {}", (Object)clazz.getName());
        }
    }
}

