/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.datatype.hibernate5.Hibernate5Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.xforceplus.config.CacheInitConfig;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@AutoConfigureBefore(value={CacheInitConfig.class})
@Configuration
@EnableCaching
public class CachingConfig
extends CachingConfigurerSupport {
    private static final Logger logger = LoggerFactory.getLogger(CachingConfig.class);
    private final LettuceConnectionFactory lettuceConnectionFactory;
    private final ObjectMapper objectMapper;
    @Value(value="${xforce.tenant.cache.redis.time-live-minutes:600}")
    private Long redisTimeLiveMinutes;
    @Value(value="${xforce.tenant.cache.caffeine.time-live-seconds:3}")
    private Long caffeineTimeLiveSeconds;
    @Value(value="${xforce.tenant.cache.caffeine.maximum-size:2000}")
    private Long caffeineMaximumSize;

    public CachingConfig(LettuceConnectionFactory lettuceConnectionFactory, ObjectMapper objectMapper) {
        this.lettuceConnectionFactory = lettuceConnectionFactory;
        this.objectMapper = objectMapper;
    }

    @Bean(value={"caffeineCacheManager"})
    public CaffeineCacheManager caffeineCacheManager() {
        CaffeineCacheManager caffeineCacheManager = new CaffeineCacheManager();
        caffeineCacheManager.setAllowNullValues(true);
        caffeineCacheManager.setCaffeine(Caffeine.newBuilder().recordStats().expireAfterWrite(Duration.ofMinutes(this.caffeineTimeLiveSeconds)).maximumSize(this.caffeineMaximumSize.longValue()));
        return caffeineCacheManager;
    }

    @Bean(value={"redisCacheManagerBuilder"})
    public RedisCacheManager.RedisCacheManagerBuilder redisCacheManagerBuilder() {
        RedisCacheConfiguration redisCacheConfiguration = RedisCacheConfiguration.defaultCacheConfig().disableCachingNullValues().entryTtl(Duration.ofMinutes(this.redisTimeLiveMinutes)).computePrefixWith(cacheName -> "uc:" + cacheName + ":").serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer(this.keySerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)this.redisSerializer()));
        redisCacheConfiguration.usePrefix();
        RedisCacheManager.RedisCacheManagerBuilder redisCacheManagerBuilder = RedisCacheManager.RedisCacheManagerBuilder.fromConnectionFactory((RedisConnectionFactory)this.lettuceConnectionFactory).cacheDefaults(redisCacheConfiguration);
        return redisCacheManagerBuilder;
    }

    private RedisSerializer<String> keySerializer() {
        return new StringRedisSerializer();
    }

    private GenericJackson2JsonRedisSerializer redisSerializer() {
        ObjectMapper objectMapper = this.objectMapper.copy();
        Hibernate5Module hibernate5Module = new Hibernate5Module();
        hibernate5Module.disable(Hibernate5Module.Feature.USE_TRANSIENT_ANNOTATION);
        hibernate5Module.enable(Hibernate5Module.Feature.REPLACE_PERSISTENT_COLLECTIONS);
        hibernate5Module.enable(Hibernate5Module.Feature.SERIALIZE_IDENTIFIER_FOR_LAZY_NOT_LOADED_OBJECTS);
        hibernate5Module.disable(Hibernate5Module.Feature.FORCE_LAZY_LOADING);
        objectMapper.registerModule((Module)hibernate5Module);
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.disable(new MapperFeature[]{MapperFeature.USE_ANNOTATIONS});
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        objectMapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_EMPTY);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        objectMapper.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature()});
        GenericJackson2JsonRedisSerializer serializer = new GenericJackson2JsonRedisSerializer(objectMapper);
        return serializer;
    }

    @Bean
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory connectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setValueSerializer((RedisSerializer)this.redisSerializer());
        template.setConnectionFactory(connectionFactory);
        return template;
    }

    @Primary
    @Bean
    public CacheManager cacheManager() {
        RedisCacheManager cacheManager = this.redisCacheManagerBuilder().build();
        return cacheManager;
    }

    public CacheErrorHandler errorHandler() {
        return new CacheErrorHandler(){

            public void handleCacheGetError(RuntimeException exception, Cache cache, Object key) {
                logger.error("Cache Get: {} failed", key, (Object)exception);
            }

            public void handleCachePutError(RuntimeException exception, Cache cache, Object key, Object value) {
                logger.error("Cache Put: {} failed", key, (Object)exception);
            }

            public void handleCacheEvictError(RuntimeException exception, Cache cache, Object key) {
                logger.error("Cache Evict: {} failed", key, (Object)exception);
            }

            public void handleCacheClearError(RuntimeException exception, Cache cache) {
                logger.error("Cache Clear failed", (Throwable)exception);
            }
        };
    }
}

