/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.config;

import com.xforceplus.utils.ThreadPoolConfig;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class GlobalThreadPoolConfig {
    private static final Logger log = LoggerFactory.getLogger(GlobalThreadPoolConfig.class);
    private static final Integer CPU_SIZE = Math.max(Runtime.getRuntime().availableProcessors(), 8);
    private static final Integer QUEUE_SIZE = 100000;
    private static final String THREAD_NAME = "async-thread-";

    @Bean(value={"threadPoolExecutor"})
    public ThreadPoolExecutor getAsyncThreadPoolExecutor() {
        log.info("global-thread-cpu-size={}", (Object)CPU_SIZE);
        return ThreadPoolConfig.config().corePoolSize(CPU_SIZE).maximumPoolSize(CPU_SIZE * 2).queueSize(QUEUE_SIZE).name(THREAD_NAME).handler(new ThreadPoolExecutor.CallerRunsPolicy()).build();
    }

    @Scheduled(fixedRate=30L, timeUnit=TimeUnit.SECONDS)
    public void threadInfo() {
        ThreadPoolExecutor executor = this.getAsyncThreadPoolExecutor();
        log.info("global thread:current active thread size={},max thread size={},current queue size={},task count={},completed task count={}", new Object[]{executor.getActiveCount(), executor.getLargestPoolSize(), executor.getQueue().size(), executor.getTaskCount(), executor.getCompletedTaskCount()});
    }
}

