/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.config;

import com.fasterxml.classmate.TypeResolver;
import com.xforceplus.tenant.security.token.domain.UserType;
import io.swagger.models.auth.In;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.autoconfigure.data.web.SpringDataWebProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RequestMapping;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.AlternateTypeBuilder;
import springfox.documentation.builders.AlternateTypePropertyBuilder;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.AlternateTypeRule;
import springfox.documentation.schema.AlternateTypeRuleConvention;
import springfox.documentation.schema.AlternateTypeRules;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.service.Tag;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.ApiSelectorBuilder;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;

@Profile(value={"!prod"})
@Configuration
@EnableConfigurationProperties(value={SpringDataWebProperties.class})
@EnableSwagger2WebMvc
public class Swagger2Config {
    private final Environment environment;
    private final SpringDataWebProperties springDataWebProperties;

    public Swagger2Config(Environment environment, SpringDataWebProperties springDataWebProperties) {
        this.environment = environment;
        this.springDataWebProperties = springDataWebProperties;
    }

    @Bean
    public Docket createTenantApi() {
        return this.apiSelectorBuilder().paths(input -> !PathSelectors.ant((String)"/api/**/${xforce.tenant.service.version:}").test(input)).paths(input -> !PathSelectors.ant((String)"/api/**/list").test(input)).paths(input -> !PathSelectors.ant((String)"/api/**/query").test(input)).paths(input -> !PathSelectors.ant((String)"/error/**").test(input)).build().groupName("v2");
    }

    private Docket docket() {
        return new Docket(DocumentationType.SWAGGER_2).tags(new Tag("resources", "\u8d44\u6e90\u670d\u52a1"), this.getTags()).tags(new Tag("client", "\u5ba2\u6237\u7aef\u670d\u52a1"), this.getTags()).directModelSubstitute(LocalDateTime.class, Date.class).directModelSubstitute(LocalDate.class, String.class).directModelSubstitute(LocalTime.class, String.class).directModelSubstitute(ZonedDateTime.class, String.class).securitySchemes(this.securitySchemes()).securityContexts(this.securityContexts());
    }

    private Tag[] getTags() {
        Tag[] tags = new Tag[]{new Tag("resource", "\u8d44\u6e90\u7801\u76f8\u5173\u63a5\u53e3"), new Tag("resourceSet", "\u529f\u80fd\u96c6\u76f8\u5173\u63a5\u53e3"), new Tag("serviceApi", "\u670d\u52a1\u63a5\u53e3\u76f8\u5173\u63a5\u53e3"), new Tag("servicePackage", "\u670d\u52a1\u5305\u76f8\u5173\u63a5\u53e3"), new Tag("client", "\u670d\u52a1\u5305\u76f8\u5173\u63a5\u53e3"), new Tag("ExcelFileSotre", "ExcelFile\u5bfc\u5165\u5bfc\u51fa")};
        return tags;
    }

    private ApiSelectorBuilder apiSelectorBuilder() {
        return this.docket().apiInfo(this.apiInfo()).select().apis(this.selector());
    }

    private Predicate<RequestHandler> selector() {
        return RequestHandlerSelectors.withMethodAnnotation(RequestMapping.class);
    }

    private List<SecurityContext> securityContexts() {
        SecurityContext build = SecurityContext.builder().securityReferences(this.defaultAuth()).forPaths(PathSelectors.any()).build();
        return Stream.of(build).collect(Collectors.toList());
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.environment.getProperty("spring.application.name", "tenant-service") + " RESTful APIs").description(this.environment.getProperty("spring.application.name", "tenant-service")).version(this.environment.getProperty("spring.application.version", "1.0.0")).build();
    }

    private List<SecurityScheme> securitySchemes() {
        return Stream.of(new ApiKey(UserType.USER.tokenKey(), UserType.USER.tokenKey(), In.HEADER.toValue()), new ApiKey(UserType.APPID.tokenKey(), UserType.APPID.tokenKey(), In.HEADER.toValue())).collect(Collectors.toList());
    }

    List<SecurityReference> defaultAuth() {
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{new AuthorizationScope("v2", "accessEverything")};
        return Stream.of(new SecurityReference(UserType.APPID.tokenKey(), authorizationScopes), new SecurityReference(UserType.USER.tokenKey(), authorizationScopes)).collect(Collectors.toList());
    }

    @Bean
    public AlternateTypeRuleConvention pageableConvention(final TypeResolver resolver) {
        return new AlternateTypeRuleConvention(){

            public int getOrder() {
                return Integer.MAX_VALUE;
            }

            public List<AlternateTypeRule> rules() {
                return Stream.of(AlternateTypeRules.newRule((Type)resolver.resolve(Pageable.class, new Type[0]), (Type)resolver.resolve(Swagger2Config.this.pageableMixin(), new Type[0]))).collect(Collectors.toList());
            }
        };
    }

    private Type pageableMixin() {
        return new AlternateTypeBuilder().fullyQualifiedClassName(String.format("%s.generated.%s", Pageable.class.getPackage().getName(), Pageable.class.getSimpleName())).withProperties(Stream.of(this.property(Integer.class, this.springDataWebProperties.getPageable().getPageParameter()), this.property(Integer.class, this.springDataWebProperties.getPageable().getSizeParameter()), this.property(String.class, "sort")).collect(Collectors.toList())).build();
    }

    private AlternateTypePropertyBuilder property(Class<?> type, String name) {
        return new AlternateTypePropertyBuilder().withName(name).withType(type).withCanRead(true).withCanWrite(true);
    }
}

