/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.config.GlobalProperties;
import com.xforceplus.domain.account.AccountType;
import com.xforceplus.domain.account.deserializer.AccountTypeDeserializer;
import com.xforceplus.jackson.databind.serializer.ResponseEntitySerializer;
import com.xforceplus.tenant.security.core.domain.OrgType;
import com.xforceplus.tenant.security.core.domain.deserializer.OrgTypeDeserializer;
import io.geewit.core.jackson.databind.serializer.BigDecimalSerializer;
import io.geewit.core.jackson.databind.serializer.EnumNameSerializer;
import io.geewit.core.jackson.databind.serializer.EnumValueSerializer;
import io.geewit.core.jackson.databind.serializer.JsonPageSerializer;
import io.geewit.web.convert.converter.DateConverter;
import io.geewit.web.convert.converter.EnumNameConverter;
import io.geewit.web.convert.converter.EnumValueConverter;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.data.web.SpringDataWebProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.data.web.SortHandlerMethodArgumentResolver;
import org.springframework.data.web.config.EnableSpringDataWebSupport;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@EnableSpringDataWebSupport
@EnableConfigurationProperties(value={GlobalProperties.class, SpringDataWebProperties.class})
@Configuration
public class WebConfig
implements WebMvcConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(WebConfig.class);
    private final GlobalProperties globalProperties;
    private final SpringDataWebProperties springDataWebProperties;

    public WebConfig(GlobalProperties globalProperties, SpringDataWebProperties springDataWebProperties) {
        logger.info("WebConfig init");
        this.globalProperties = globalProperties;
        this.springDataWebProperties = springDataWebProperties;
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOriginPatterns(new String[]{"*"}).allowedMethods(new String[]{"*"}).allowedHeaders(new String[]{"*"}).allowCredentials(Boolean.FALSE.booleanValue()).maxAge(3600L);
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter(String.class, OrgType.class, (Converter)new EnumValueConverter());
        registry.addConverter(Integer.class, OrgType.class, (Converter)new EnumValueConverter());
        registry.addConverter(Integer.TYPE, OrgType.class, (Converter)new EnumValueConverter());
        registry.addConverter(String.class, AccountType.class, (Converter)new EnumNameConverter());
        registry.addConverter(String.class, Date.class, (Converter)new DateConverter());
        super.addFormatters(registry);
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        for (HttpMessageConverter<?> converter : converters) {
            if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
            MappingJackson2HttpMessageConverter jacksonMessageConverter = (MappingJackson2HttpMessageConverter)converter;
            ObjectMapper objectMapper = jacksonMessageConverter.getObjectMapper();
            objectMapper.enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature()});
            SimpleModule simpleModule = new SimpleModule();
            simpleModule.addSerializer(OrgType.class, (JsonSerializer)EnumValueSerializer.instance);
            simpleModule.addSerializer(AccountType.class, (JsonSerializer)EnumNameSerializer.instance);
            simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
            simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
            simpleModule.addSerializer(BigDecimal.class, (JsonSerializer)BigDecimalSerializer.instance);
            simpleModule.addSerializer(Page.class, (JsonSerializer)new JsonPageSerializer(objectMapper));
            simpleModule.addSerializer(ResponseEntity.class, (JsonSerializer)new ResponseEntitySerializer(objectMapper, this.globalProperties));
            simpleModule.addDeserializer(OrgType.class, (JsonDeserializer)OrgTypeDeserializer.instance);
            simpleModule.addDeserializer(AccountType.class, (JsonDeserializer)AccountTypeDeserializer.instance);
            objectMapper.registerModule((Module)simpleModule);
            jacksonMessageConverter.setObjectMapper(objectMapper);
            break;
        }
        super.extendMessageConverters(converters);
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        SortHandlerMethodArgumentResolver sortResolver = new SortHandlerMethodArgumentResolver();
        sortResolver.setPropertyDelimiter(",");
        PageableHandlerMethodArgumentResolver pageableResolver = new PageableHandlerMethodArgumentResolver(sortResolver);
        pageableResolver.setPageParameterName(this.springDataWebProperties.getPageable().getPageParameter());
        pageableResolver.setSizeParameterName(this.springDataWebProperties.getPageable().getSizeParameter());
        pageableResolver.setMaxPageSize(this.springDataWebProperties.getPageable().getMaxPageSize());
        pageableResolver.setFallbackPageable((Pageable)PageRequest.of((int)0, (int)this.springDataWebProperties.getPageable().getDefaultPageSize()));
        pageableResolver.setOneIndexedParameters(true);
        resolvers.add((HandlerMethodArgumentResolver)sortResolver);
        resolvers.add((HandlerMethodArgumentResolver)pageableResolver);
        super.addArgumentResolvers(resolvers);
    }
}

