/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.exception;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.xforceplus.exception.AccessDeniedException;
import com.xforceplus.tenant.core.exception.CodeException;
import com.xforceplus.tenant.core.exception.response.ErrorResponse;
import io.geewit.core.exception.NotFoundException;
import io.geewit.core.exception.ProcessedException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityNotFoundException;
import org.hibernate.PropertyValueException;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.DataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.orm.jpa.JpaObjectRetrievalFailureException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice(annotations={RestController.class, Controller.class})
public class ExceptionControllerAdvice {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionControllerAdvice.class);

    @ResponseBody
    @ExceptionHandler(value={CodeException.class})
    public ResponseEntity<ErrorResponse> processException(CodeException e) {
        String message = e.getMessage();
        logger.warn("CodeException:" + message);
        int httpStatus = e.getHttpStatus();
        return ResponseEntity.status((int)httpStatus).body((Object)ErrorResponse.fail((String)e.getCode(), (String)message));
    }

    @ResponseBody
    @ExceptionHandler(value={ProcessedException.class})
    public ResponseEntity<ErrorResponse> processExcepton(ProcessedException e) {
        String message = e.getMessage();
        logger.warn("ProcessedException:" + message);
        int httpStatus = e.getHttpStatus();
        return ResponseEntity.status((int)httpStatus).body((Object)ErrorResponse.fail((String)e.getCode(), (String)message));
    }

    @ResponseBody
    @ExceptionHandler(value={NotFoundException.class})
    public ResponseEntity<ErrorResponse> processExcepton(NotFoundException e) {
        String message = e.getMessage();
        logger.warn("NotFoundException:" + message);
        int httpStatus = e.getHttpStatus();
        return ResponseEntity.status((int)httpStatus).body((Object)ErrorResponse.fail((String)e.getCode(), (String)message));
    }

    @ResponseBody
    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ResponseEntity<ErrorResponse> processException(NoHandlerFoundException e) {
        String code = "UCTSCM0007";
        String message = e.getMessage();
        logger.warn("NoHandlerFoundException:" + message);
        int httpStatus = 404;
        return ResponseEntity.status((int)httpStatus).body((Object)ErrorResponse.fail((String)code, (String)message));
    }

    @ResponseBody
    @ExceptionHandler(value={AccessDeniedException.class})
    public ResponseEntity<ErrorResponse> processException(AccessDeniedException e) {
        String code = "UCTSCM0000";
        String message = e.getMessage();
        logger.warn("AccessDeniedException:" + message);
        int httpStatus = 403;
        return ResponseEntity.status((int)httpStatus).body((Object)ErrorResponse.fail((String)code, (String)message));
    }

    @ResponseBody
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<ErrorResponse> processException(MethodArgumentNotValidException e) {
        int httpStatus;
        String message;
        String code = "UCTSCM0003";
        if (e != null) {
            BindingResult bindingResult = e.getBindingResult();
            ArrayList errors = new ArrayList(bindingResult.getFieldErrors());
            Collections.sort(errors, Comparator.comparing(DefaultMessageSourceResolvable::getDefaultMessage).thenComparing(FieldError::getField));
            StringBuilder messageBuilder = new StringBuilder();
            Iterator iterator = errors.iterator();
            while (iterator.hasNext()) {
                FieldError error = (FieldError)iterator.next();
                messageBuilder.append(error.getField()).append(error.getDefaultMessage());
                if (!iterator.hasNext()) continue;
                messageBuilder.append(",");
            }
            message = messageBuilder.length() == 0 ? "\u53c2\u6570\u683c\u5f0f\u9519\u8bef" : messageBuilder.toString();
            httpStatus = 400;
        } else {
            message = "unknown";
            httpStatus = 500;
        }
        logger.warn("message: {}, httpStatus: {}", (Object)message, (Object)httpStatus);
        return ResponseEntity.status((int)httpStatus).body((Object)ErrorResponse.fail((String)code, (String)message));
    }

    @ResponseBody
    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ResponseEntity<ErrorResponse> processExeption(MissingServletRequestParameterException e) {
        String code = "UCTSCM0003";
        String message = e.getMessage();
        logger.warn("MissingServletRequestParameterException: " + message);
        int httpStatus = 400;
        return ResponseEntity.status((int)httpStatus).body((Object)ErrorResponse.fail((String)code, (String)message));
    }

    @ResponseBody
    @ExceptionHandler(value={InvalidParameterException.class})
    public ResponseEntity<ErrorResponse> processException(InvalidParameterException e) {
        String message = e.getMessage();
        logger.warn("InvalidParameterException: " + message);
        String code = "UCTSCM0005";
        return ResponseEntity.status((int)400).body((Object)ErrorResponse.fail((String)code, (String)message));
    }

    @ResponseBody
    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<ErrorResponse> processException(IllegalArgumentException e) {
        String message = e.getMessage();
        logger.warn("IllegalArgumentException:" + message);
        String code = "UCTSCM0003";
        int httpStatus = 400;
        return ResponseEntity.status((int)httpStatus).body((Object)ErrorResponse.fail((String)code, (String)message));
    }

    @ResponseBody
    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public ResponseEntity<ErrorResponse> processException(MethodArgumentTypeMismatchException e) {
        String code = "UCTSCM0005";
        String message = "\u53c2\u6570\u9519\u8bef";
        logger.warn(message + ":" + e.getMessage());
        int httpStatus = 400;
        return ResponseEntity.status((int)httpStatus).body((Object)ErrorResponse.fail((String)code, (String)message));
    }

    @ResponseBody
    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public ResponseEntity<ErrorResponse> processException(HttpMediaTypeNotSupportedException e) {
        String code = "UCTSCM0003";
        String message = "\u4e0d\u652f\u6301\u7684MediaType";
        logger.warn(message + ":" + e.getMessage());
        int httpStatus = 400;
        return ResponseEntity.status((int)httpStatus).body((Object)ErrorResponse.fail((String)code, (String)message));
    }

    @ResponseBody
    @ExceptionHandler(value={javax.validation.ConstraintViolationException.class})
    public ResponseEntity<ErrorResponse> processException(javax.validation.ConstraintViolationException e) {
        Set constraintViolations = e.getConstraintViolations();
        String message = constraintViolations.stream().map(violation -> violation.getPropertyPath() + violation.getMessage()).collect(Collectors.joining(","));
        logger.warn("ConstraintViolationException: " + message);
        String code = "UCTSCM0003";
        int httpStatus = 400;
        return ResponseEntity.status((int)httpStatus).body((Object)ErrorResponse.fail((String)code, (String)message));
    }

    @ResponseBody
    @ExceptionHandler(value={DataIntegrityViolationException.class})
    public ResponseEntity<ErrorResponse> processException(DataIntegrityViolationException e) {
        logger.warn("\u89e6\u53d1\u6570\u636e\u5e93\u6821\u9a8c\u9519\u8bef:" + e.getMessage());
        if (e.getCause() instanceof ConstraintViolationException) {
            return this.processException((ConstraintViolationException)e.getCause());
        }
        if (e.getCause() instanceof DataException) {
            return this.processException((DataException)e.getCause());
        }
        if (e.getCause() instanceof PropertyValueException) {
            return this.processException((PropertyValueException)e.getCause());
        }
        return this.processException((Exception)e);
    }

    @ResponseBody
    @ExceptionHandler(value={PropertyValueException.class})
    public ResponseEntity<ErrorResponse> processException(PropertyValueException e) {
        String code = "UCTSCM0003";
        String message = "\u7f3a\u5c11\u5fc5\u586b\u53c2\u6570(" + e.getEntityName() + "." + e.getPropertyName() + ")\u9519\u8bef";
        logger.warn(message + ":" + e.getMessage());
        int httpStatus = 400;
        return ResponseEntity.status((int)httpStatus).body((Object)ErrorResponse.fail((String)code, (String)message));
    }

    @ResponseBody
    @ExceptionHandler(value={DataException.class})
    public ResponseEntity<ErrorResponse> processException(DataException e) {
        String code = "UCTSCM0003";
        String message = "sql\u53c2\u6570\u9519\u8bef";
        logger.warn(message + ", sql:" + e.getSQL() + e.getMessage());
        int httpStatus = 400;
        return ResponseEntity.status((int)httpStatus).body((Object)ErrorResponse.fail((String)code, (String)message));
    }

    @ResponseBody
    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<ErrorResponse> processException(ConstraintViolationException e) {
        String code = "UCTSCM0001";
        String message = e.getConstraintName() + "\u53c2\u6570\u552f\u4e00\u9519\u8bef";
        logger.warn(message + ":" + e.getMessage());
        int httpStatus = 400;
        return ResponseEntity.status((int)httpStatus).body((Object)ErrorResponse.fail((String)code, (String)message));
    }

    @ResponseBody
    @ExceptionHandler(value={EmptyResultDataAccessException.class})
    public ResponseEntity<ErrorResponse> processException(EmptyResultDataAccessException e) {
        String code = "UCTSCM0007";
        String message = "\u6570\u636e\u8fd4\u56de\u6570\u91cf0\u9519\u8bef";
        logger.warn(message + ":" + e.getMessage());
        int httpStatus = 400;
        return ResponseEntity.status((int)httpStatus).body((Object)ErrorResponse.fail((String)code, (String)message));
    }

    @ResponseBody
    @ExceptionHandler(value={IncorrectResultSizeDataAccessException.class})
    public ResponseEntity<ErrorResponse> processException(IncorrectResultSizeDataAccessException e) {
        String code = "UCTSCM0003";
        String message = "\u6570\u636e\u8fd4\u56de\u6570\u91cf>1\u9519\u8bef";
        logger.warn(message + ":" + e.getMessage());
        int httpStatus = 400;
        return ResponseEntity.status((int)httpStatus).body((Object)ErrorResponse.fail((String)code, (String)message));
    }

    @ResponseBody
    @ExceptionHandler(value={JpaObjectRetrievalFailureException.class})
    public ResponseEntity<ErrorResponse> processException(JpaObjectRetrievalFailureException e) {
        String code;
        String message;
        if (e.getCause() != null && e.getCause() instanceof EntityNotFoundException) {
            message = "\u627e\u4e0d\u5230\u5b9e\u4f53";
            code = "UCTSCM0007";
        } else {
            message = "\u53c2\u6570\u9519\u8bef";
            code = "UCTSCM0004";
        }
        logger.warn(message + ":" + e.getMessage(), (Throwable)e);
        int httpStatus = 400;
        return ResponseEntity.status((int)httpStatus).body((Object)ErrorResponse.fail((String)code, (String)message));
    }

    @ResponseBody
    @ExceptionHandler(value={DataAccessException.class})
    public ResponseEntity<ErrorResponse> processException(DataAccessException e) {
        if (e.getCause() instanceof IllegalArgumentException) {
            return this.processException((IllegalArgumentException)e.getCause());
        }
        String code = "UCTSCM0001";
        String message = "\u6570\u636e\u83b7\u53d6\u9519\u8bef";
        logger.warn(message + ":" + e.getMessage(), (Throwable)e);
        int httpStatus = 400;
        return ResponseEntity.status((int)httpStatus).body((Object)ErrorResponse.fail((String)code, (String)message));
    }

    @ResponseBody
    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<ErrorResponse> processException(HttpMessageNotReadableException e) {
        String code = "UCTSCM0003";
        String message = "\u53c2\u6570\u683c\u5f0f\u9519\u8bef!";
        logger.warn(message + ":" + e.getMessage());
        int httpStatus = 400;
        if (e.getCause() instanceof InvalidFormatException) {
            InvalidFormatException e1 = (InvalidFormatException)e.getCause();
            List path = e1.getPath();
            for (JsonMappingException.Reference reference : path) {
                message = message + "\u53c2\u6570\u540d\uff1a" + reference.getFieldName() + " \u8f93\u5165\u4e0d\u5408\u6cd5\uff0c\u9700\u8981\u7684\u662f " + e1.getTargetType().getName() + " \u7c7b\u578b\uff0c\u63d0\u4ea4\u7684\u503c\u662f\uff1a" + e1.getValue().toString();
            }
        }
        return ResponseEntity.status((int)httpStatus).body((Object)ErrorResponse.fail((String)code, (String)message));
    }

    @ResponseBody
    @ExceptionHandler(value={BindException.class})
    public ResponseEntity<ErrorResponse> processException(BindException e) {
        String code = "UCTSCM0003";
        String message = "\u53c2\u6570\u683c\u5f0f\u9519\u8bef";
        if (e != null) {
            logger.error(e.getMessage());
            BindingResult bindingResult = e.getBindingResult();
            List fieldErrors = bindingResult.getFieldErrors();
            if (!fieldErrors.isEmpty()) {
                StringBuilder messageBuilder = new StringBuilder();
                Iterator iterator = fieldErrors.iterator();
                while (iterator.hasNext()) {
                    FieldError fieldError = (FieldError)iterator.next();
                    messageBuilder.append(fieldError.getDefaultMessage());
                    if (!iterator.hasNext()) continue;
                    messageBuilder.append(",");
                }
                message = messageBuilder.toString();
            }
        }
        return ResponseEntity.status((int)400).body((Object)ErrorResponse.fail((String)code, (String)message));
    }

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ErrorResponse> processException(Exception e) {
        String message;
        String code = "UCTSCM0000";
        if (e != null) {
            logger.error(e.getMessage(), (Throwable)e);
            message = e.getMessage();
        } else {
            message = "unknown";
        }
        return ResponseEntity.status((int)500).body((Object)ErrorResponse.fail((String)code, (String)message));
    }
}

