/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import io.geewit.utils.uuid.UUIDUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class BasePathUtils {
    private static final Logger log = LoggerFactory.getLogger(BasePathUtils.class);

    public static String ensureFilePath(HttpServletRequest request) {
        String basePath = request.getServletContext().getRealPath("basepath");
        File baseFile = new File(basePath);
        if (!baseFile.exists()) {
            baseFile.mkdirs();
        }
        return basePath + "/" + UUIDUtils.randomUUID() + ".xlsx";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getTemplatePath(HttpServletRequest request, String filename) {
        String filePath = BasePathUtils.ensureFilePath(request);
        ClassPathResource resource = new ClassPathResource("template/" + filename);
        try (FileOutputStream os = new FileOutputStream(filePath);){
            InputStream is = resource.getInputStream();
            IOUtils.copy((InputStream)is, (OutputStream)os);
            String string = filePath;
            return string;
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u6a21\u677f\u6587\u4ef6\u5f02\u5e38\u3002", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getTemplatePath(HttpServletRequest request, String path, String filename) {
        String filePath = BasePathUtils.ensureFilePath(request);
        ClassPathResource resource = new ClassPathResource(path + "/" + filename);
        try (FileOutputStream os = new FileOutputStream(filePath);){
            InputStream is = resource.getInputStream();
            IOUtils.copy((InputStream)is, (OutputStream)os);
            String string = filePath;
            return string;
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u6a21\u677f\u6587\u4ef6\u5f02\u5e38\u3002", (Throwable)e);
            return null;
        }
    }
}

