/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.xforceplus.config.ImportExportThreadPool;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.commons.collections4.ListUtils;

public class BatchUtils {
    private BatchUtils() {
    }

    public static <T> CompletableFuture<Void> doBatchAsync(List<T> dataList, Consumer<List<T>> consumer) {
        ArrayList futureList = new ArrayList();
        int partitionSize = dataList.size() > ImportExportThreadPool.CORE_POOL_SIZE ? dataList.size() / ImportExportThreadPool.CORE_POOL_SIZE : 1;
        List splitList = ListUtils.partition(dataList, (int)partitionSize);
        splitList.forEach(item -> futureList.add(CompletableFuture.runAsync(() -> consumer.accept((List)item), ImportExportThreadPool.get())));
        return CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0]));
    }
}

