/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.xforceplus.tenant.core.exception.UnknownException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileUtils {
    public static final long FILE_SIZE_BYTE_UTIL = 0x100000L;
    public static final long DEFAULT_UPLOAD_MAX_FILE_SIZE = 15L;
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    public static void checkFileSize(MultipartFile file, long maxFileSize) {
        long size = file.getSize() / 0x100000L;
        if (size >= maxFileSize) {
            throw new UnknownException("\u5bfc\u5165\u6587\u4ef6\u4e0d\u80fd\u8d85\u8fc715M");
        }
    }

    public static String getResourcesFile(String path) throws IOException {
        InputStream inputStream = FileUtils.class.getResourceAsStream(path);
        return FileUtils.readFile(inputStream);
    }

    public static String getFilePath(String path) {
        URL url = FileUtils.class.getResource("/");
        return url.getPath();
    }

    public static String readFile(InputStream inputStream) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        BufferedReader bufferedReader = new BufferedReader(reader);
        String value = bufferedReader.lines().collect(Collectors.joining());
        bufferedReader.close();
        return FileUtils.filter(value);
    }

    private static String filter(String input) {
        return input.replaceAll("/\\*[\\s\\S]*?\\*/", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String readFileByLine(File file) {
        StringBuilder s;
        block12: {
            String temp;
            if (null == file) {
                return null;
            }
            s = new StringBuilder();
            BufferedReader br = null;
            br = new BufferedReader(new FileReader(file));
            while ((temp = br.readLine()) != null) {
                s.append(temp);
            }
            try {
                Objects.requireNonNull(br).close();
            }
            catch (IOException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
            break block12;
            catch (Exception e) {
                try {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        ((BufferedReader)Objects.requireNonNull(br)).close();
                    }
                    catch (IOException e2) {
                        logger.warn(e2.getMessage(), (Throwable)e2);
                    }
                    throw throwable;
                }
                try {
                    Objects.requireNonNull(br).close();
                }
                catch (IOException e3) {
                    logger.warn(e3.getMessage(), (Throwable)e3);
                }
            }
        }
        return s.toString();
    }

    public static boolean checkFileSize(Long len, int size, String unit) {
        double fileSize = 0.0;
        switch (unit.toUpperCase()) {
            case "B": {
                fileSize = len.longValue();
                break;
            }
            case "K": {
                fileSize = (double)len.longValue() / 1024.0;
                break;
            }
            case "M": {
                fileSize = (double)len.longValue() / 1048576.0;
                break;
            }
            case "G": {
                fileSize = (double)len.longValue() / 1.073741824E9;
                break;
            }
        }
        return fileSize <= (double)size;
    }
}

