/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import javax.servlet.http.HttpServletRequest;

public class IpUtils {
    private static final String UNKNOWN = "unknown";

    private IpUtils() {
    }

    public static String getIp(HttpServletRequest request) {
        String ip = request.getHeader("X-Original-Forwarded-For");
        if (ip != null && ip.length() != 0 && !UNKNOWN.equalsIgnoreCase(ip) && ip.contains(",")) {
            ip = ip.split(",")[0];
        }
        if (IpUtils.isUnknownIp(ip)) {
            ip = request.getHeader("RemoteIp");
        }
        if (IpUtils.isUnknownIp(ip) && (ip = request.getHeader("X-Forwarded-For")) != null && ip.length() != 0 && !UNKNOWN.equalsIgnoreCase(ip) && ip.contains(",")) {
            ip = ip.split(",")[0];
        }
        if (IpUtils.isUnknownIp(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (IpUtils.isUnknownIp(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (IpUtils.isUnknownIp(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (IpUtils.isUnknownIp(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (IpUtils.isUnknownIp(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (IpUtils.isUnknownIp(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip == null) {
            ip = UNKNOWN;
        }
        return ip.replaceAll(":", ".");
    }

    private static boolean isUnknownIp(String ip) {
        return ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip);
    }
}

