/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.xforceplus.tenant.security.core.domain.OrgType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrgVirtualNodeUtils {
    private static final Logger logger = LoggerFactory.getLogger(OrgVirtualNodeUtils.class);

    public static Set<Long> findNodeIdInParentIds(String parentIds) {
        logger.info("parentIds = " + parentIds);
        String pattern = "(\\d+)" + Arrays.stream(OrgType.values()).map(OrgType::separator).collect(Collectors.joining("|", "[", "]"));
        logger.debug("pattern = " + pattern);
        Matcher matcher = Pattern.compile(pattern).matcher(parentIds);
        HashSet<Long> parentOrgIds = new HashSet<Long>();
        while (matcher.find()) {
            String group = matcher.group(1);
            try {
                Long orgId = Long.parseLong(group);
                parentOrgIds.add(orgId);
            }
            catch (NumberFormatException e) {
                String message = e.getMessage() + ", value: " + group;
                logger.warn(message);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("parentOrgVirtualNodeIds = " + parentOrgIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
        }
        return parentOrgIds;
    }
}

