/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.xforceplus.domain.resource.RequestUri;
import com.xforceplus.domain.resource.RequestUriAuthz;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.AntPathMatcher;

public class RequestMappingHelper {
    private static final Logger logger = LoggerFactory.getLogger(RequestMappingHelper.class);
    private static final AntPathMatcher PATH_MATCHER = new AntPathMatcher();

    @Nullable
    public static RequestUriAuthz lookupRequestUri(RequestUri requestUri, Map<RequestUri, RequestUriAuthz> requestMappings, boolean useTrailingSlashMatch) {
        RequestUriAuthz matchResult = requestMappings.get(requestUri);
        if (matchResult != null && !PATH_MATCHER.isPattern(requestUri.getRequestPath())) {
            return matchResult;
        }
        ArrayList<String> matchingPatterns = new ArrayList<String>();
        for (RequestUri registeredRequestUri : requestMappings.keySet()) {
            String registeredPattern = registeredRequestUri.getRequestPath();
            if (!requestUri.getRequestMethod().equals((Object)registeredRequestUri.getRequestMethod())) continue;
            if (PATH_MATCHER.match(registeredPattern, requestUri.getRequestPath())) {
                matchingPatterns.add(registeredPattern);
                continue;
            }
            if (!useTrailingSlashMatch || registeredPattern.endsWith("/") || !PATH_MATCHER.match(registeredPattern + "/", requestUri.getRequestPath())) continue;
            matchingPatterns.add(registeredPattern + "/");
        }
        String bestMatch = null;
        Comparator patternComparator = PATH_MATCHER.getPatternComparator(requestUri.getRequestPath());
        if (!matchingPatterns.isEmpty()) {
            matchingPatterns.sort(patternComparator);
            if (logger.isTraceEnabled() && matchingPatterns.size() > 1) {
                logger.trace("Matching patterns " + matchingPatterns);
            }
            bestMatch = (String)matchingPatterns.get(0);
        }
        if (bestMatch != null && (matchResult = requestMappings.get(new RequestUri(bestMatch, requestUri.getRequestMethod()))) == null) {
            if (bestMatch.endsWith("/")) {
                matchResult = requestMappings.get(new RequestUri(bestMatch.substring(0, bestMatch.length() - 1), requestUri.getRequestMethod()));
            }
            if (matchResult == null) {
                throw new IllegalArgumentException("Could not find best pattern match [" + bestMatch + "]");
            }
        }
        logger.debug("No match result found...");
        return null;
    }
}

