/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;

public final class ThreadPoolConfig {
    public static Config config() {
        return new Config();
    }

    public static class Config {
        public static final int DEFAULT_CORE_POOL_SIZE = 8;
        public static final int DEFAULT_QUEUE_SIZE = 20000;
        public static final int DEFAULT_MAXIMUM_POOL_SIZE = 40;
        public static final long DEFAULT_KEEPALIVE_TIME = 60000L;
        private ThreadFactory threadFactory;
        private RejectedExecutionHandler handler;
        private String name;
        private TimeUnit timeUnit;
        private Integer corePoolSize;
        private Integer maximumPoolSize;
        private Long keepAliveTime;
        private Integer queueSize;
        private BlockingQueue<Runnable> queue;

        public Config threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Config handler(RejectedExecutionHandler handler) {
            this.handler = handler;
            return this;
        }

        public Config timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public Config corePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
            return this;
        }

        public Config maximumPoolSize(int maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
            return this;
        }

        public Config keepAliveTime(long keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
            return this;
        }

        public Config name(String name) {
            this.name = name;
            return this;
        }

        public Config queue(BlockingQueue<Runnable> queue) {
            this.queue = queue;
            return this;
        }

        public Config queueSize(int queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        protected ThreadFactory getThreadFactory(String name) {
            this.name = StringUtils.isBlank((CharSequence)name) ? String.format("%1$06d", RandomUtils.nextInt((int)0, (int)100000)) : name;
            return new ThreadFactoryBuilder().setNameFormat(this.name).build();
        }

        protected BlockingQueue<Runnable> createQueue(Integer size) {
            return new LinkedBlockingQueue<Runnable>(size);
        }

        protected ThreadPoolExecutor newThreadPool() {
            if (this.handler == null) {
                return new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, this.timeUnit, this.queue, this.threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
            }
            return new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, this.timeUnit, this.queue, this.threadFactory, this.handler);
        }

        protected void checkArgument() {
            if (this.corePoolSize < 0 || this.maximumPoolSize <= 0 || this.maximumPoolSize < this.corePoolSize || this.keepAliveTime < 0L) {
                throw new IllegalArgumentException();
            }
        }

        public ThreadPoolExecutor build() {
            if (this.threadFactory == null) {
                this.threadFactory = this.getThreadFactory(this.name);
            }
            if (this.maximumPoolSize == null) {
                this.maximumPoolSize = 40;
            }
            if (this.corePoolSize == null) {
                this.corePoolSize = 8;
            }
            if (this.keepAliveTime == null) {
                this.keepAliveTime = 60000L;
            }
            this.checkArgument();
            if (this.queueSize == null) {
                this.queueSize = 20000;
            }
            if (this.timeUnit == null) {
                this.timeUnit = TimeUnit.MILLISECONDS;
            }
            if (this.queue == null || this.queue.size() == 0) {
                this.queue = this.createQueue(this.queueSize);
            }
            return this.newThreadPool();
        }
    }
}

