/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.excel;

import com.alibaba.excel.support.ExcelTypeEnum;
import com.xforceplus.utils.FileUtils;
import com.xforceplus.utils.excel.ExcelConvertUtil;
import com.xforceplus.utils.excel.exception.ImportException;
import com.xforceplus.utils.excel.model.ExcelToJsonProperty;
import com.xforceplus.utils.excel.model.JsonToExcelProperty;
import io.geewit.core.exception.ProcessedException;
import io.geewit.web.utils.JsonUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtils {
    public static final String FILE_SIZE_M = "M";
    private static final String DATE = "Date";
    private static final int MAX_FILE_SIZE = 20;
    private static final Logger logger = LoggerFactory.getLogger(ExcelUtils.class);

    public static <T> List<T> list(MultipartFile file, String templateName, Class<T> clazz) {
        String result;
        if (null == file) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u5b58\u5728");
            throw new IllegalArgumentException("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        String filename = file.getOriginalFilename();
        if (!StringUtils.endsWith((CharSequence)filename, (CharSequence)ExcelTypeEnum.XLS.getValue()) && !StringUtils.endsWith((CharSequence)filename, (CharSequence)ExcelTypeEnum.XLSX.getValue())) {
            throw new IllegalArgumentException("\u8bf7\u4e0a\u4f20 .xls\u6587\u4ef6\u6216 .xlsx\u6587\u4ef6");
        }
        boolean sizeFlag = FileUtils.checkFileSize(file.getSize(), 20, FILE_SIZE_M);
        if (!sizeFlag) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u5f97\u5927\u4e8e20M");
        }
        String templateJson = null;
        try {
            templateJson = FileUtils.getResourcesFile("/templates/" + templateName);
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        if (null == templateJson) {
            logger.error("\u6ca1\u6709\u627e\u5230json\u6a21\u677f={},", (Object)templateName);
            throw new ProcessedException("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        ExcelToJsonProperty property = new ExcelToJsonProperty();
        property.setFile(file);
        property.setJson(templateJson);
        try {
            result = ExcelConvertUtil.excelToJson(property);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528excel\u8f6cjson\u5f02\u5e38templateName={},Exception={}", (Object)templateName, (Object)e);
            throw new IllegalArgumentException("Excel\u89e3\u6790\u5f02\u5e38\uff0c\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)result)) {
            logger.error("result\u4e3a\u7a7atemplateName={}", (Object)templateName);
            throw new IllegalArgumentException("\u5bfc\u5165\u5931\u8d25,excel\u5185\u5bb9\u4e3a\u7a7a");
        }
        List list = new ArrayList();
        try {
            list = JsonUtils.toList((String)result, clazz);
        }
        catch (RuntimeException e) {
            logger.error("json\u8f6clist<T>templateJson={},Exception={}", (Object)templateJson, (Object)e);
            if (e.getMessage().contains(DATE)) {
                throw new ProcessedException("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            if (e.getMessage().contains("InvalidFormatException")) {
                throw new ProcessedException("\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
        catch (Exception e) {
            logger.error("json\u8f6clist<T>templateJson={},Exception={}", (Object)templateJson, (Object)e);
            throw new ProcessedException("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return list;
    }

    public static <T> List<String> checkField(T t, Validator validator) {
        Set constraintViolations = validator.validate(t, new Class[0]);
        List msgError = constraintViolations.stream().map(ConstraintViolation::getMessage).collect(Collectors.toCollection(() -> new ArrayList(constraintViolations.size())));
        return msgError;
    }

    public static <T> void validField(T t, Validator validator) throws ImportException {
        Set constraintViolations = validator.validate(t, new Class[0]);
        List msgError = constraintViolations.stream().map(ConstraintViolation::getMessage).collect(Collectors.toCollection(() -> new ArrayList(constraintViolations.size())));
        if (msgError.size() > 0) {
            throw new ImportException(msgError);
        }
    }

    private static String createTempExcelFile() {
        return System.getProperties().getProperty("java.io.tmpdir") + File.separator + System.currentTimeMillis() + ".xlsx";
    }

    public static String buildExcelFile(String json, Map<String, String> rules, String sheetName) {
        if (StringUtils.isBlank((CharSequence)json) || CollectionUtils.isEmpty(rules)) {
            return "";
        }
        ArrayList<JsonToExcelProperty> properties = new ArrayList<JsonToExcelProperty>();
        JsonToExcelProperty jsonToExcelProperty = new JsonToExcelProperty();
        jsonToExcelProperty.setJson(json);
        jsonToExcelProperty.setRules(rules);
        jsonToExcelProperty.setSheetName(sheetName);
        properties.add(jsonToExcelProperty);
        String fileName = ExcelUtils.createTempExcelFile();
        ExcelConvertUtil.jsonToExcel(properties, fileName);
        return fileName;
    }
}

