/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.xforceplus.domain.resource.ResourceExtendDto;
import com.xforceplus.domain.resource.ServiceApiExtendDto;
import com.xforceplus.tenant.core.exception.UnknownException;
import com.xforceplus.utils.excel.ResourceEnum;
import com.xforceplus.utils.excel.ResourceListener;
import com.xforceplus.utils.excel.ResourceWrapper;
import com.xforceplus.utils.excel.ServiceApiEnum;
import com.xforceplus.utils.excel.ServiceApiListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceExcelUtils {
    private static Logger logger = LoggerFactory.getLogger(ResourceExcelUtils.class);

    public static ResourceWrapper extract(String filePath) {
        ResourceWrapper result = new ResourceWrapper();
        ResourceListener excelListener = new ResourceListener();
        ServiceApiListener serviceApiListener = new ServiceApiListener();
        try {
            ExcelReader excelReader = EasyExcel.read((String)filePath).build();
            ReadSheet readSheet1 = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).headRowNumber(Integer.valueOf(0))).registerReadListener((ReadListener)excelListener)).build();
            ReadSheet readSheet2 = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)1).headRowNumber(Integer.valueOf(0))).registerReadListener((ReadListener)serviceApiListener)).build();
            excelReader.read(new ReadSheet[]{readSheet1, readSheet2});
            excelReader.finish();
        }
        catch (ExcelAnalysisException e) {
            if (e.getCause() != null && e.getCause() instanceof UnknownException) {
                throw (UnknownException)e.getCause();
            }
            throw e;
        }
        List<ResourceExtendDto> list = excelListener.getData();
        List<ServiceApiExtendDto> serviceApiList = serviceApiListener.getData();
        result.setResources(list);
        result.setServiceApis(serviceApiList);
        return result;
    }

    public static void writeV2007(String errorPath, ResourceWrapper wrapper) {
        try {
            ExcelWriter writer = EasyExcel.write((String)errorPath).build();
            if (CollectionUtils.isNotEmpty(wrapper.getResources())) {
                WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)1, (String)"\u8d44\u6e90\u7801\u5bfc\u51fa\u6587\u4ef6").head(ResourceExcelUtils.createListStringHead(wrapper.isSkipReason()))).build();
                writer.write(ResourceExcelUtils.createListObject(wrapper.getResources(), wrapper.isSkipReason()), writeSheet);
            }
            if (CollectionUtils.isNotEmpty(wrapper.getServiceApis())) {
                WriteSheet writeSheet2 = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)2, (String)"\u670d\u52a1api").head(ResourceExcelUtils.createServiceApiHead(wrapper.isSkipReason()))).build();
                writer.write(ResourceExcelUtils.createServiceApiData(wrapper.getServiceApis(), wrapper.isSkipReason()), writeSheet2);
            }
            writer.finish();
        }
        catch (Exception e) {
            throw new UnknownException("\u751f\u6210\u6587\u4ef6\u5931\u8d25\u3002");
        }
    }

    private static List<List<String>> createListStringHead(boolean skipReason) {
        ResourceEnum[] enums;
        ArrayList<List<String>> head = new ArrayList<List<String>>();
        ArrayList<String> titleHeadColumn = new ArrayList<String>();
        titleHeadColumn.add("\u5e8f\u53f7");
        head.add(titleHeadColumn);
        for (ResourceEnum item : enums = ResourceEnum.values()) {
            if (skipReason && item == ResourceEnum.reason) continue;
            ArrayList<String> headColumn = new ArrayList<String>();
            headColumn.add(item.getTitle());
            head.add(headColumn);
        }
        return head;
    }

    private static List<List<String>> createServiceApiHead(boolean skipReason) {
        ServiceApiEnum[] enums;
        ArrayList<List<String>> head = new ArrayList<List<String>>();
        for (ServiceApiEnum item : enums = ServiceApiEnum.values()) {
            if (skipReason && item == ServiceApiEnum.reason) continue;
            ArrayList<String> headColumn = new ArrayList<String>();
            headColumn.add(item.getTitle());
            head.add(headColumn);
        }
        return head;
    }

    private static List<List<Object>> createListObject(List<ResourceExtendDto> list, boolean skipReason) {
        ArrayList<List<Object>> object = new ArrayList<List<Object>>();
        for (int i = 0; i < list.size(); ++i) {
            ResourceExtendDto resourceExtendDto = list.get(i);
            ResourceEnum[] enums = ResourceEnum.values();
            ArrayList<String> da = new ArrayList<String>();
            da.add(String.valueOf(i + 1));
            for (ResourceEnum item : enums) {
                if (skipReason && item == ResourceEnum.reason) continue;
                Class<?> classObj = resourceExtendDto.getClass();
                try {
                    Method method = classObj.getMethod("get" + item.getFieldName().substring(0, 1).toUpperCase() + item.getFieldName().substring(1), new Class[0]);
                    Object value = method.invoke((Object)resourceExtendDto, new Object[0]);
                    if (value == null) {
                        value = "";
                    }
                    da.add(String.valueOf(value));
                }
                catch (Exception e) {
                    logger.error("\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
                }
            }
            object.add(da);
        }
        return object;
    }

    private static List<List<Object>> createServiceApiData(List<ServiceApiExtendDto> list, boolean skipReason) {
        ArrayList<List<Object>> object = new ArrayList<List<Object>>();
        for (int i = 0; i < list.size(); ++i) {
            ServiceApiExtendDto serviceApiExtendDto = list.get(i);
            ServiceApiEnum[] enums = ServiceApiEnum.values();
            ArrayList<String> da = new ArrayList<String>();
            for (ServiceApiEnum item : enums) {
                if (skipReason && item == ServiceApiEnum.reason) continue;
                Class<?> classObj = serviceApiExtendDto.getClass();
                try {
                    Method method = classObj.getMethod("get" + item.getFieldName().substring(0, 1).toUpperCase() + item.getFieldName().substring(1), new Class[0]);
                    Object value = method.invoke((Object)serviceApiExtendDto, new Object[0]);
                    if (value == null) {
                        value = "";
                    }
                    da.add(String.valueOf(value));
                }
                catch (Exception e) {
                    logger.error("\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
                }
            }
            object.add(da);
        }
        return object;
    }
}

