/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.xforceplus.domain.resource.ResourcesetExtendDto;
import com.xforceplus.domain.resource.ServicePackageExtendDto;
import com.xforceplus.tenant.core.exception.UnknownException;
import com.xforceplus.utils.excel.ServicePackageEnum;
import com.xforceplus.utils.excel.ServicePackageListListener;
import com.xforceplus.utils.excel.ServicePackageWrapper;
import com.xforceplus.utils.excel.SimpleResourcesetEnum;
import com.xforceplus.utils.excel.SimpleResourcesetListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicePackageExcelUtils {
    private static Logger logger = LoggerFactory.getLogger(ServicePackageExcelUtils.class);

    public static ServicePackageWrapper extract(String filePath) {
        ServicePackageWrapper result = new ServicePackageWrapper();
        ServicePackageListListener servicePackageListListener = new ServicePackageListListener();
        SimpleResourcesetListener simpleResourcesetListener = new SimpleResourcesetListener();
        try {
            ExcelReader excelReader = EasyExcel.read((String)filePath).build();
            ReadSheet readSheet1 = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).headRowNumber(Integer.valueOf(0))).registerReadListener((ReadListener)servicePackageListListener)).build();
            ReadSheet readSheet2 = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)1).headRowNumber(Integer.valueOf(0))).registerReadListener((ReadListener)simpleResourcesetListener)).build();
            excelReader.read(new ReadSheet[]{readSheet1, readSheet2});
            excelReader.finish();
        }
        catch (ExcelAnalysisException e) {
            if (e.getCause() != null && e.getCause() instanceof UnknownException) {
                throw (UnknownException)e.getCause();
            }
            throw e;
        }
        List<ServicePackageExtendDto> servicePackageExtendDtoList = servicePackageListListener.getData();
        List<ResourcesetExtendDto> resourcesetExtendDtoList = simpleResourcesetListener.getData();
        result.setServicePackages(servicePackageExtendDtoList);
        result.setResourcesets(resourcesetExtendDtoList);
        return result;
    }

    public static void writeV2007(String errorPath, ServicePackageWrapper wrapper) {
        try {
            ExcelWriter writer = EasyExcel.write((String)errorPath).build();
            WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)1, (String)"\u670d\u52a1\u5305\u6570\u636e").head(ServicePackageExcelUtils.createServicePackageHead(wrapper.isSkipReason()))).build();
            writer.write(ServicePackageExcelUtils.createServicePackageData(wrapper.getServicePackages(), wrapper.isSkipReason()), writeSheet);
            if (CollectionUtils.isNotEmpty(wrapper.getResourcesets())) {
                WriteSheet writeSheet2 = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)2, (String)"\u5173\u8054\u529f\u80fd\u96c6\u6570\u636e").head(ServicePackageExcelUtils.createResourcesetHead(wrapper.isSkipReason()))).build();
                writer.write(ServicePackageExcelUtils.createResourcesetData(wrapper.getResourcesets(), wrapper.isSkipReason()), writeSheet2);
            }
            writer.finish();
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u6587\u4ef6\u5931\u8d25\u3002", (Throwable)e);
            throw new UnknownException("\u751f\u6210\u6587\u4ef6\u5931\u8d25\u3002");
        }
    }

    private static List<List<String>> createServicePackageHead(boolean skipReason) {
        ServicePackageEnum[] enums;
        ArrayList<List<String>> head = new ArrayList<List<String>>();
        ArrayList<String> titleHeadColumn = new ArrayList<String>();
        titleHeadColumn.add("\u5e8f\u53f7");
        head.add(titleHeadColumn);
        for (ServicePackageEnum item : enums = ServicePackageEnum.values()) {
            if (skipReason && item == ServicePackageEnum.reason) continue;
            ArrayList<String> headColumn = new ArrayList<String>();
            headColumn.add(item.getTitle());
            head.add(headColumn);
        }
        return head;
    }

    private static List<List<String>> createResourcesetHead(boolean skipReason) {
        SimpleResourcesetEnum[] enums;
        ArrayList<List<String>> head = new ArrayList<List<String>>();
        ArrayList<String> titleHeadColumn = new ArrayList<String>();
        titleHeadColumn.add("\u5e8f\u53f7");
        head.add(titleHeadColumn);
        for (SimpleResourcesetEnum item : enums = SimpleResourcesetEnum.values()) {
            if (skipReason && item == SimpleResourcesetEnum.reason) continue;
            ArrayList<String> headColumn = new ArrayList<String>();
            headColumn.add(item.getTitle());
            head.add(headColumn);
        }
        return head;
    }

    private static List<List<Object>> createServicePackageData(List<ServicePackageExtendDto> list, boolean skipReason) {
        ArrayList<List<Object>> object = new ArrayList<List<Object>>();
        for (int i = 0; i < list.size(); ++i) {
            ServicePackageExtendDto servicePackageExtendDto = list.get(i);
            ServicePackageEnum[] enums = ServicePackageEnum.values();
            ArrayList<String> da = new ArrayList<String>();
            da.add(String.valueOf(i + 1));
            for (ServicePackageEnum item : enums) {
                if (skipReason && item == ServicePackageEnum.reason) continue;
                Class<?> classObj = servicePackageExtendDto.getClass();
                try {
                    Method method = classObj.getMethod("get" + item.getFieldName().substring(0, 1).toUpperCase() + item.getFieldName().substring(1), new Class[0]);
                    Object value = method.invoke((Object)servicePackageExtendDto, new Object[0]);
                    if (value == null) {
                        value = "";
                    }
                    da.add(String.valueOf(value));
                }
                catch (Exception e) {
                    logger.error("\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
                }
            }
            object.add(da);
        }
        return object;
    }

    private static List<List<Object>> createResourcesetData(List<ResourcesetExtendDto> list, boolean skipReason) {
        ArrayList<List<Object>> object = new ArrayList<List<Object>>();
        for (int i = 0; i < list.size(); ++i) {
            ResourcesetExtendDto resourcesetExtendDto = list.get(i);
            SimpleResourcesetEnum[] enums = SimpleResourcesetEnum.values();
            ArrayList<String> da = new ArrayList<String>();
            da.add(String.valueOf(i + 1));
            for (SimpleResourcesetEnum item : enums) {
                if (skipReason && item == SimpleResourcesetEnum.reason) continue;
                Class<?> classObj = resourcesetExtendDto.getClass();
                try {
                    Method method = classObj.getMethod("get" + item.getFieldName().substring(0, 1).toUpperCase() + item.getFieldName().substring(1), new Class[0]);
                    Object value = method.invoke((Object)resourcesetExtendDto, new Object[0]);
                    if (value == null) {
                        value = "";
                    }
                    da.add(String.valueOf(value));
                }
                catch (Exception e) {
                    logger.error("\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
                }
            }
            object.add(da);
        }
        return object;
    }
}

