/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus;

import com.xforceplus.tower.storage.config.EnableFileService;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.PropertySource;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableCaching
@EnableScheduling
@EnableFeignClients
@SpringBootApplication
@PropertySource(value={"classpath:env/${spring.profiles.active}/application.properties"}, encoding="UTF-8", ignoreResourceNotFound=true)
@EnableFileService
public class Bootstrap {
    public static void main(String[] args) {
        String profile = System.getProperty("spring.profiles.active", "unknown");
        System.setProperty("log4j2.formatMsgNoLookups", "true");
        Properties properties = new Properties();
        if ("default".equals(profile)) {
            System.setProperty("log4j.skipJansi", "false");
            properties.put("logging.config", "classpath:env/default/log4j2.xml");
        } else if (StringUtils.containsAny((CharSequence)profile, (CharSequence[])new CharSequence[]{"dev", "fat", "sit", "uat", "demo"})) {
            properties.put("logging.config", "classpath:env/test/log4j2.xml");
        } else if (StringUtils.contains((CharSequence)profile, (CharSequence)"prod")) {
            properties.put("logging.config", "classpath:env/prod/log4j2.xml");
        } else {
            properties.put("logging.config", "classpath:env/test/log4j2.xml");
        }
        SpringApplication application = new SpringApplication(new Class[]{Bootstrap.class});
        application.setDefaultProperties(properties);
        application.run(args);
    }
}

