/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.account.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.account.AccountPlatformRelApi;
import com.xforceplus.api.model.AccountPlatformRelModel;
import com.xforceplus.business.account.service.AccountPlatformRelService;
import com.xforceplus.entity.AccountPlatformRel;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;

@Api(value="\u5e10\u53f7\u5e73\u53f0\u76f8\u5173\u63a5\u53e3", description="\u5e10\u53f7\u5e73\u53f0\u76f8\u5173\u63a5\u53e3")
@Controller
public class AccountPlatformRelController
implements AccountPlatformRelApi {
    private static final Logger logger = LoggerFactory.getLogger(AccountPlatformRelController.class);
    private final AccountPlatformRelService accountPlatformRelService;

    public AccountPlatformRelController(AccountPlatformRelService accountPlatformRelService) {
        this.accountPlatformRelService = accountPlatformRelService;
    }

    @ApiOperation(value="\u7ed1\u5b9a\u5173\u7cfb\u67e5\u8be2\u63a5\u53e3")
    public ResponseEntity<Page<AccountPlatformRel>> page(@ApiParam(value="request") AccountPlatformRelModel.Request.Query query, @ApiParam(value="pageable") Pageable pageable) {
        Page<AccountPlatformRel> result = this.accountPlatformRelService.page(query, pageable);
        return ResponseEntity.ok(result);
    }

    public ResponseEntity<AccountPlatformRel> create(AccountPlatformRelModel.Request.Save model) {
        AccountPlatformRel result = this.accountPlatformRelService.save(model);
        return ResponseEntity.okWithCode((Object)result);
    }

    @ApiOperation(value="\u6839\u636e\u5e73\u53f0\u7c7b\u578b\u548c\u5e73\u53f0id\u67e5\u8be2\u8d26\u6237\u5173\u8054")
    public ResponseEntity<AccountPlatformRel> info(int platformType, String platformId) {
        AccountPlatformRel result = this.accountPlatformRelService.getInfoByPlatformId(platformType, platformId);
        return ResponseEntity.okWithCode((Object)result);
    }

    @ApiOperation(value="\u6839\u636euserId\u67e5\u8be2\u8d26\u6237\u5173\u8054")
    public ResponseEntity<List<AccountPlatformRel>> queryByUserId(Long userId, AccountPlatformRelModel.Request.QueryByUserId queryByUserId) {
        List<AccountPlatformRel> result = this.accountPlatformRelService.list(userId, queryByUserId.getPlatformType());
        return ResponseEntity.okWithCode(result);
    }

    public ResponseEntity<String> updateState(AccountPlatformRelModel.Request.ChangeState request) {
        this.accountPlatformRelService.updateState(request);
        return ResponseEntity.okWithCode((Object)"\u6210\u529f\u3002");
    }

    @ApiOperation(value="\u6839\u636e\u5e73\u53f0\u7c7b\u578b\u67e5\u8be2\u5f53\u524d\u8d26\u6237\u5173\u8054")
    public ResponseEntity<List<AccountPlatformRel>> currentQuery(int platformType) {
        Long userId = UserInfoHolder.currentUser().getId();
        List<AccountPlatformRel> result = this.accountPlatformRelService.list(userId, platformType);
        return ResponseEntity.okWithCode(result);
    }
}

