/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.account.service;

import com.xforceplus.business.account.service.AccessTokenResp;
import com.xforceplus.business.wechat.service.WechatConfigProperties;
import io.geewit.web.utils.JsonUtils;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AccessTokenService {
    private static final Logger log = LoggerFactory.getLogger(AccessTokenService.class);
    private static final Logger logger = LoggerFactory.getLogger(AccessTokenService.class);
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private WechatConfigProperties wechatConfigProperties;

    public AccessTokenResp accessToken() {
        String routesUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";
        routesUrl = String.format(routesUrl, this.wechatConfigProperties.getAppId(), this.wechatConfigProperties.getAppSecret());
        logger.info("routesUrl=={}", (Object)routesUrl);
        ResponseEntity responseEntity = this.restTemplate.getForEntity(routesUrl, String.class, new Object[0]);
        String response = (String)responseEntity.getBody();
        logger.info("response = {}", (Object)response);
        return (AccessTokenResp)JsonUtils.fromJson((String)response, AccessTokenResp.class);
    }
}

