/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.account.service;

import com.xforceplus.api.model.AccountModel;
import com.xforceplus.dao.AccountDao;
import com.xforceplus.dao.AccountPrivacyDao;
import com.xforceplus.entity.AccountPrivacy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AccountPrivacyService {
    private final AccountPrivacyDao accountPrivacyDao;
    private final AccountDao accountDao;

    public AccountPrivacyService(AccountPrivacyDao accountPrivacyDao, AccountDao accountDao) {
        this.accountPrivacyDao = accountPrivacyDao;
        this.accountDao = accountDao;
    }

    public boolean checkAccountPrivacy(AccountModel.AccountPrivacyInfo queryInfo) {
        List<AccountPrivacy> accountPrivacies = this.findAllByQuery(queryInfo);
        return !CollectionUtils.isEmpty(accountPrivacies);
    }

    public List<AccountPrivacy> findAllByQuery(AccountModel.AccountPrivacyInfo queryInfo) {
        Specification<AccountPrivacy> specification = this.buildSpecificationByQuery(queryInfo);
        return this.accountPrivacyDao.findAll(specification);
    }

    @Transactional(rollbackFor={Exception.class})
    public void addAccountPrivacy(AccountModel.AccountPrivacyInfo privacyInfo) {
        this.accountDao.findById((Object)privacyInfo.getAccountId()).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u8d26\u53f7\uff1a" + privacyInfo.getAccountId()));
        List<AccountPrivacy> accountPrivacies = this.findAllByQuery(privacyInfo);
        if (CollectionUtils.isEmpty(accountPrivacies)) {
            AccountPrivacy accountPrivacy = new AccountPrivacy();
            accountPrivacy.setAccountId(privacyInfo.getAccountId());
            accountPrivacy.setWebSite(privacyInfo.getWebSite());
            accountPrivacy.setVersion(privacyInfo.getVersion());
            this.accountPrivacyDao.saveAndFlush((Object)accountPrivacy);
        }
    }

    private Specification<AccountPrivacy> buildSpecificationByQuery(AccountModel.AccountPrivacyInfo queryInfo) {
        return (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (queryInfo.getAccountId() != null) {
                predicates.add(builder.equal((Expression)root.get("accountId"), (Object)queryInfo.getAccountId()));
            }
            if (StringUtils.isNotEmpty((CharSequence)queryInfo.getWebSite())) {
                predicates.add(builder.equal((Expression)root.get("webSite"), (Object)queryInfo.getWebSite()));
            }
            if (StringUtils.isNotEmpty((CharSequence)queryInfo.getVersion())) {
                predicates.add(builder.equal((Expression)root.get("version"), (Object)queryInfo.getVersion()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.toArray(new Predicate[0]));
            }
            return criteriaQuery.getRestriction();
        };
    }
}

