/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.account.service;

import com.xforceplus.api.model.AccountModel;
import com.xforceplus.business.account.dto.PasswordCheckResultDto;
import com.xforceplus.business.message.service.MessageService;
import com.xforceplus.business.messagebus.AccountPubSubService;
import com.xforceplus.dao.AccountDao;
import com.xforceplus.dao.user.AccountUserExtendDao;
import com.xforceplus.domain.account.AccountType;
import com.xforceplus.dto.user.AccountUserDTO;
import com.xforceplus.entity.Account;
import com.xforceplus.entity.Tenant;
import com.xforceplus.feign.tenant.message.EmailContentFeignClient;
import com.xforceplus.feign.tenant.message.SmsMessageFeignClient;
import com.xforceplus.query.AccountQueryHelper;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.utils.CryptUtils;
import com.xforceplus.utils.AESHelp;
import com.xforceplus.utils.PropertiesUtils;
import com.xforceplus.utils.RegExUtil;
import com.xforceplus.utils.password.MD5PwdUtil;
import com.xforececlound.message.model.EmailContentReq;
import com.xforececlound.message.model.SmsMessageReq;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.web.utils.JsonUtils;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AccountService {
    private static final Logger logger = LoggerFactory.getLogger(AccountService.class);
    private final AccountDao accountDao;
    private final EmailContentFeignClient emailContentFeignClient;
    private final SmsMessageFeignClient smsMessageFeignClient;
    private final MessageService messageService;
    private final RedisTemplate redisTemplate;
    private final AccountUserExtendDao accountUserExtendDao;
    private final AccountPubSubService accountPubSubService;
    private static final String WILMAR = "wilmar";
    @Value(value="${tenant.security.password.salt:}")
    private String salt;
    @Value(value="${tenant.center.user.create.old:true}")
    private boolean oldModelCreateUser;

    public AccountService(AccountDao accountDao, EmailContentFeignClient emailContentFeignClient, SmsMessageFeignClient smsMessageFeignClient, MessageService messageService, RedisTemplate redisTemplate, AccountUserExtendDao accountUserExtendDao, AccountPubSubService accountPubSubService) {
        this.accountDao = accountDao;
        this.emailContentFeignClient = emailContentFeignClient;
        this.smsMessageFeignClient = smsMessageFeignClient;
        this.messageService = messageService;
        this.redisTemplate = redisTemplate;
        this.accountUserExtendDao = accountUserExtendDao;
        this.accountPubSubService = accountPubSubService;
    }

    public Account findOneByLogin(AccountModel.Request.Login login) {
        if (StringUtils.isBlank((CharSequence)login.getEmail()) && StringUtils.isBlank((CharSequence)login.getTelPhone()) && StringUtils.isBlank((CharSequence)login.getUsername())) {
            throw new IllegalArgumentException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Account account = null;
        if (StringUtils.isNotBlank((CharSequence)login.getEmail())) {
            account = this.findAccountByUserName(login.getEmail());
        }
        if (account == null && StringUtils.isNotBlank((CharSequence)login.getTelPhone())) {
            account = this.findAccountByUserName(login.getTelPhone());
        }
        if (account == null && StringUtils.isNotBlank((CharSequence)login.getUsername())) {
            account = this.findAccountByUserName(login.getUsername());
        }
        if (account == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u627e\u5230\u8d26\u6237");
        }
        return account;
    }

    public Account findOneByUsername(String username) {
        Specification specification = AccountQueryHelper.queryOneSpecification(null, (String)username, (boolean)false);
        List accounts = this.accountDao.findAll(specification);
        if (CollectionUtils.isEmpty((Collection)accounts)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u8d26\u6237\u5b9e\u4f53(" + username + ")");
        }
        if (accounts.size() > 1) {
            logger.warn("\u7528\u6237\u540d\u4e0d\u552f\u4e00 username:{}", (Object)username);
        }
        return (Account)accounts.get(0);
    }

    public Account findOneByUsername(String tenantCode, String username) {
        Specification specification = AccountQueryHelper.queryOneSpecification((String)tenantCode, (String)username, (boolean)false);
        List accounts = this.accountDao.findAll(specification);
        if (CollectionUtils.isEmpty((Collection)accounts)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u8d26\u6237\u5b9e\u4f53(" + tenantCode + "," + username + ")");
        }
        if (accounts.size() > 1) {
            logger.warn("\u7528\u6237\u540d\u4e0d\u552f\u4e00 tenantCode:{},username:{}", (Object)tenantCode, (Object)username);
        }
        return (Account)accounts.get(0);
    }

    public Account findOneByUsernameV2(String tenantCode, String username) {
        if (WILMAR.equalsIgnoreCase(tenantCode) && StringUtils.isNotEmpty((CharSequence)username)) {
            return this.findOneByUsername(tenantCode, username);
        }
        if (RegExUtil.checkEmail((String)username) || RegExUtil.checkMobile((String)username)) {
            return this.findOneByUsername(tenantCode, username);
        }
        return this.findOneByUsername(tenantCode + username);
    }

    public Account findOneByQuery(AccountModel.Request.Login query) {
        Specification specification = AccountQueryHelper.queryOneSpecification((AccountModel.Request.Login)query);
        List accountList = this.accountDao.findAll(specification);
        if (CollectionUtils.isEmpty((Collection)accountList)) {
            return null;
        }
        if (accountList.size() > 1) {
            logger.warn("\u7528\u6237\u540d\u4e0d\u552f\u4e00\uff1a{}", (Object)query.toString());
        }
        return (Account)accountList.get(0);
    }

    public List<Account> findAllByQuery(AccountModel.Request.Login query) {
        Specification specification = AccountQueryHelper.queryOneSpecification((AccountModel.Request.Login)query);
        List accountList = this.accountDao.findAll(specification);
        return accountList;
    }

    public List<Long> findTenantIdsByLogin(AccountModel.Request.Login login) {
        login.setAttributes(Stream.of("tenantId").collect(Collectors.toSet()));
        return this.accountDao.findAttributes(login, Sort.unsorted());
    }

    @Transactional(rollbackFor={Exception.class})
    public void resetPassword(AccountModel.Request.ChangePassword request) {
        String oldEncryptedPassword;
        String username = request.getUsername();
        Specification specification = AccountQueryHelper.queryOneSpecification(null, (String)username, (boolean)false);
        Account account = (Account)this.accountDao.findOne(specification).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u8d26\u53f7\u5b9e\u4f53"));
        logger.info("username = " + username + ", salt = " + this.salt);
        String accountSalt = account.getSalt();
        boolean match = false;
        String rawPassword = this.safeDesPassword(request.getOriginalPassword());
        account.setRawPassword(rawPassword);
        String originalEncryptedPassword = CryptUtils.encryptPassword((String)accountSalt, (String)rawPassword, (String)this.salt);
        logger.debug("accountSalt = {}, originalEncryptedPassword = {}", (Object)accountSalt, (Object)originalEncryptedPassword);
        if (originalEncryptedPassword.equals(account.getPassword())) {
            match = true;
        }
        if (!match) {
            accountSalt = account.getUsername();
            originalEncryptedPassword = CryptUtils.encryptPassword((String)accountSalt, (String)rawPassword, (String)this.salt);
            logger.debug("accountSalt = {}, originalEncryptedPassword = {}", (Object)accountSalt, (Object)originalEncryptedPassword);
            if (originalEncryptedPassword.equals(account.getPassword())) {
                match = true;
                account.setSalt(account.getUsername());
            }
        }
        if (!match) {
            accountSalt = account.getEmail();
            originalEncryptedPassword = CryptUtils.encryptPassword((String)accountSalt, (String)rawPassword, (String)this.salt);
            logger.debug("accountSalt = {}, originalEncryptedPassword = {}", (Object)accountSalt, (Object)originalEncryptedPassword);
            if (originalEncryptedPassword.equals(account.getPassword())) {
                match = true;
                account.setSalt(account.getEmail());
            }
        }
        if (!match) {
            accountSalt = account.getTelPhone();
            originalEncryptedPassword = CryptUtils.encryptPassword((String)accountSalt, (String)rawPassword, (String)this.salt);
            logger.debug("accountSalt = {}, originalEncryptedPassword = {}", (Object)accountSalt, (Object)originalEncryptedPassword);
            if (originalEncryptedPassword.equals(account.getPassword())) {
                match = true;
                account.setSalt(account.getTelPhone());
            }
        }
        if (!match && !(oldEncryptedPassword = CryptUtils.encode((String)rawPassword)).equals(account.getPassword())) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u8d26\u53f7:" + request.getUsername());
        }
        String encryptedPassword = CryptUtils.encryptPassword((String)account.getSalt(), (String)this.safeDesPassword(request.getPassword()), (String)this.salt);
        if (encryptedPassword.equals(account.getPassword())) {
            throw new IllegalArgumentException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u539f\u5bc6\u7801\u4e00\u6837");
        }
        account.setPassword(encryptedPassword);
        account.setChangePasswordFlag(Boolean.valueOf(false));
        this.saveAndFlush(account);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updatePasswordCiphertext(AccountModel.Request.UpdatePasswordCiphertext request) {
        Account account = this.findById(request.getAccountId());
        if (request.getPassword().equals(account.getPassword())) {
            return;
        }
        logger.info("\u4fee\u6539\u660e\u6587\u5bc6\u7801\u6210\u529f\uff0caccountId = {}" + request.getAccountId());
        account.setPassword(request.getPassword());
        account.setChangePasswordFlag(Boolean.valueOf(false));
        this.saveAndFlush(account);
    }

    @Transactional(rollbackFor={Exception.class})
    public void resetCurrentUserPassword(AccountModel.Request.ChangeCurrentPassword request) {
        String encryptedPassword;
        String at = "@";
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        boolean resp = request.getAccount().contains("@") ? this.messageService.checkAuthEmailCode(request.getValidCode(), request.getAccount(), request.getMsgId()) : this.messageService.checkAuthSmsCode(request.getValidCode(), request.getAccount(), request.getMsgId());
        if (!resp) {
            throw new IllegalArgumentException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        String decryptedPassword = this.desPassword(request.getPassword());
        Account account = (Account)this.accountDao.findById((Object)authorizedUser.getAccountId()).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u8d26\u53f7\u5b9e\u4f53(" + authorizedUser.getAccountId() + ")"));
        String dynamicSalt = account.getSalt();
        if (StringUtils.isBlank((CharSequence)dynamicSalt)) {
            if (StringUtils.isNotBlank((CharSequence)account.getUsername())) {
                dynamicSalt = account.getUsername();
            } else if (StringUtils.isNotBlank((CharSequence)account.getTelPhone())) {
                dynamicSalt = account.getTelPhone();
            } else if (StringUtils.isNotBlank((CharSequence)account.getEmail())) {
                dynamicSalt = account.getEmail();
            }
        }
        if ((encryptedPassword = CryptUtils.encryptPassword((String)dynamicSalt, (String)decryptedPassword, (String)this.salt)).equals(account.getPassword())) {
            throw new IllegalArgumentException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u539f\u5bc6\u7801\u4e00\u6837");
        }
        account.setRawPassword(decryptedPassword);
        account.setPassword(encryptedPassword);
        account.setSalt(dynamicSalt);
        this.saveAndFlush(account);
    }

    public Page<Account> page(AccountModel.Request.Query query, Pageable pageable) {
        Specification specification = AccountQueryHelper.querySpecification((AccountModel.Request.Query)query);
        return this.accountDao.findAll(specification, pageable);
    }

    public Page<Account> page(Specification<Account> specification, Pageable pageable) {
        return this.accountDao.findAll(specification, pageable);
    }

    public List<Account> list(AccountModel.Request.Query query, Sort sort) {
        Specification specification = AccountQueryHelper.querySpecification((AccountModel.Request.Query)query);
        List iterable = this.accountDao.findAll(specification, sort);
        List<Account> list = StreamSupport.stream(iterable.spliterator(), true).collect(Collectors.toList());
        return list;
    }

    public List<Account> list(Specification<Account> specification, Sort sort) {
        return this.accountDao.findAll(specification, sort);
    }

    @Transactional(rollbackFor={Exception.class})
    public Account create(AccountModel.Request.Create model) {
        return this.save(null, model, model.isEnableSendMsg(), model.isRandomPassword(), false, model.getUpdateIgnoreProperties());
    }

    @Transactional(rollbackFor={Exception.class})
    public <S extends AccountModel.Request.Save> Account saveOriginPassword(S model) {
        Account entity = null;
        long accountId = 0L;
        if (model instanceof AccountModel.Request.Update) {
            accountId = ((AccountModel.Request.Update)model).getAccountId();
        }
        if (accountId > 0L) {
            entity = this.findById(accountId);
        } else {
            if (StringUtils.isNotBlank((CharSequence)model.getTelPhone())) {
                entity = this.accountDao.findByTelPhone(model.getTelPhone());
            }
            if (entity == null && StringUtils.isNotBlank((CharSequence)model.getEmail())) {
                entity = this.accountDao.findByEmail(model.getEmail());
            }
            if (entity == null) {
                entity = new Account();
            }
        }
        BeanUtils.copyProperties(model, (Object)entity);
        return (Account)this.accountDao.saveAndFlush((Object)entity);
    }

    public boolean validPassword(AccountModel.Request.Login login, Account existAccount) {
        PasswordCheckResultDto passwordCheckResultDto = this.checkPassword(login.getPassword(), existAccount);
        if (passwordCheckResultDto.isPwdCorrect()) {
            return true;
        }
        String message = "\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef";
        logger.info(message);
        throw new IllegalArgumentException(message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <S extends AccountModel.Request.Save> Account save(Tenant tenant, S model, boolean isEnableSendMsg, boolean isRandomPassword, boolean isMergeAccount, List<String> updateIgnoreProperties) {
        boolean isNew;
        Account entity;
        String tenantCode;
        logger.info("isEnableSendMsg = {}, isRandomPassword = {}, isMergeAccount = {}", new Object[]{isEnableSendMsg, isRandomPassword, isMergeAccount});
        long accountId = 0L;
        model.fillSalt();
        if (model instanceof AccountModel.Request.Update) {
            accountId = ((AccountModel.Request.Update)model).getAccountId();
        }
        String username = model.getUsername();
        boolean updateTelphone = true;
        boolean updateEmail = true;
        boolean updateUsername = true;
        boolean updatePassword = true;
        boolean updateSalt = true;
        String string = tenantCode = tenant != null ? StringUtils.defaultString((String)tenant.getTenantCode()) : "";
        if (AccountType.OTHER.equals((Object)model.getType()) && !WILMAR.equalsIgnoreCase(tenantCode) && StringUtils.isNotEmpty((CharSequence)model.getUsername()) && model.getUsername() != null && !model.getUsername().startsWith(tenantCode)) {
            username = tenantCode + model.getUsername();
        }
        if (accountId > 0L) {
            entity = this.findById(accountId);
            isNew = false;
        } else {
            AccountModel.Request.Login query = new AccountModel.Request.Login();
            query.setEmail(model.getEmail());
            query.setTelPhone(model.getTelPhone());
            query.setUsername(username);
            entity = this.findOneByQuery(query);
            if (entity == null) {
                entity = new Account();
                isNew = true;
            } else {
                if (!isMergeAccount) {
                    String message = "\u5df2\u5b58\u5728\u8be5\u8d26\u53f7(email:" + model.getEmail() + ",telPhone:" + model.getTelPhone() + ",username:" + model.getUsername() + ")";
                    throw new IllegalArgumentException(message);
                }
                isNew = false;
            }
        }
        if (tenant != null) {
            entity.setTenantId(tenant.getTenantId());
        }
        if (StringUtils.isBlank((CharSequence)model.getEmail())) {
            model.setEmail(null);
        }
        if (StringUtils.isBlank((CharSequence)model.getTelPhone())) {
            model.setTelPhone(null);
        }
        if (StringUtils.isBlank((CharSequence)model.getUsername())) {
            model.setUsername(null);
        }
        if (isNew) {
            BeanUtils.copyProperties(model, (Object)entity, (String[])((String[])Stream.of("username").toArray(String[]::new)));
        } else {
            if (!CollectionUtils.isEmpty(updateIgnoreProperties)) {
                updateIgnoreProperties.add("username");
            } else {
                updateIgnoreProperties = Stream.of("username").collect(Collectors.toList());
            }
            BeanUtils.copyProperties(model, (Object)entity, (String[])((String[])updateIgnoreProperties.stream().distinct().toArray(String[]::new)));
            if (!CollectionUtils.isEmpty(updateIgnoreProperties)) {
                for (String updateIgnoreProperty : updateIgnoreProperties) {
                    if ("telphone".equalsIgnoreCase(updateIgnoreProperty)) {
                        updateTelphone = false;
                        continue;
                    }
                    if ("email".equalsIgnoreCase(updateIgnoreProperty)) {
                        updateEmail = false;
                        continue;
                    }
                    if ("username".equalsIgnoreCase(updateIgnoreProperty)) {
                        updateUsername = false;
                        continue;
                    }
                    if ("password".equalsIgnoreCase(updateIgnoreProperty)) {
                        updatePassword = false;
                        continue;
                    }
                    if (!"salt".equalsIgnoreCase(updateIgnoreProperty)) continue;
                    updateSalt = false;
                }
            }
        }
        if (AccountType.OTHER.equals((Object)model.getType())) {
            if (updateUsername) {
                entity.setUsername(username);
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)model.getTelPhone()) && updateTelphone) {
                entity.setTelPhone(model.getTelPhone());
            }
            if (StringUtils.isNotBlank((CharSequence)model.getEmail()) && updateEmail) {
                entity.setEmail(model.getEmail());
            }
            if (StringUtils.isBlank((CharSequence)model.getTelPhone()) && StringUtils.isBlank((CharSequence)model.getEmail())) {
                if (!StringUtils.isNotBlank((CharSequence)model.getUsername())) throw new IllegalArgumentException("\u6ca1\u6709\u5b9a\u4e49\u5408\u6cd5\u7528\u6237\u540d");
                if (StringUtils.contains((CharSequence)model.getUsername(), (CharSequence)"@")) {
                    if (StringUtils.isBlank((CharSequence)entity.getEmail()) && updateEmail) {
                        entity.setEmail(model.getUsername());
                    }
                } else if (RegExUtil.checkMobile((String)model.getUsername()) && StringUtils.isBlank((CharSequence)entity.getTelPhone()) && updateTelphone) {
                    entity.setTelPhone(model.getUsername());
                }
                if (username == null) {
                    username = model.getUsername();
                }
            }
        }
        Long tenantId = null;
        String tenantName = null;
        if (tenant != null) {
            tenantId = tenant.getTenantId();
            tenantName = tenant.getTenantName();
            tenantCode = tenant.getTenantCode();
        } else {
            IAuthorizedUser authorizedUser = UserInfoHolder.get();
            if (authorizedUser != null) {
                tenantId = authorizedUser.getTenantId();
                tenantName = authorizedUser.getTenantName();
                tenantCode = authorizedUser.getTenantCode();
            }
        }
        if (model instanceof AccountModel.Request.Create) {
            String password;
            if (StringUtils.isBlank((CharSequence)((AccountModel.Request.Create)model).getPassword())) {
                if (!isRandomPassword && !((AccountModel.Request.Create)model).isRandomPassword()) throw new IllegalArgumentException("\u6ca1\u6709\u5b9a\u4e49\u5bc6\u7801");
                password = RandomStringUtils.randomAlphabetic((int)8);
                logger.info("\u7528\u6237(username:{}, telphone:{}, email:{})\u7684\u968f\u673a\u5bc6\u7801:{}", new Object[]{model.getUsername(), model.getTelPhone(), model.getEmail(), password});
            } else {
                password = ((AccountModel.Request.Create)model).getPassword();
                entity.setRawPassword(password);
            }
            if (model.getSalt() != null && updatePassword) {
                String encryptedPassword = CryptUtils.encryptPassword((String)model.getSalt(), (String)password, (String)this.salt);
                entity.setPassword(encryptedPassword);
            }
            if (updateSalt) {
                entity.setSalt(model.getSalt());
            }
            if (isEnableSendMsg) {
                try {
                    logger.info("isEnableSendMsg, this.sendMessage(tenantId:{}, email:{}, telphone:{}, password:*, tenantName:{}, username:{})", new Object[]{tenantId, entity.getEmail(), entity.getTelPhone(), tenantName, username});
                    this.sendMessage(tenantId, entity.getEmail(), entity.getTelPhone(), password, tenantName, username);
                }
                catch (Exception e) {
                    logger.warn("\u4fe1\u606f\u53d1\u9001\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        if (tenantId != null) {
            if (isNew && WILMAR.equalsIgnoreCase(tenantCode) && this.oldModelCreateUser) {
                entity.setUsername(model.getUsername());
            }
            entity.setTenantId(tenantId);
            entity.setDoubleAuthFlag(Boolean.valueOf(false));
        }
        if (AccountType.OTHER.equals((Object)model.getType())) {
            if (model.getUsername() == null || !updateUsername) return this.saveAndFlush(entity);
            entity.setUsername(username);
            return this.saveAndFlush(entity);
        } else {
            boolean isNotEmail;
            if (model.getUsername() == null) return this.saveAndFlush(entity);
            boolean isNotPhone = !model.getUsername().equalsIgnoreCase(entity.getTelPhone());
            boolean bl = isNotEmail = !model.getUsername().equalsIgnoreCase(entity.getEmail());
            if (!isNotPhone || !isNotEmail) return this.saveAndFlush(entity);
            entity.setUsername(username);
        }
        return this.saveAndFlush(entity);
    }

    @Transactional(rollbackFor={Exception.class})
    public Account update(long accountId, AccountModel.Request.Update model) {
        Account existEntity = this.findById(accountId);
        BeanUtils.copyProperties((Object)model, (Object)existEntity, (String[])((String[])Stream.of("accountId", "password", "salt").toArray(String[]::new)));
        AccountModel.Request.Login query = new AccountModel.Request.Login();
        query.setEmail(model.getEmail());
        query.setTelPhone(model.getTelPhone());
        query.setUsername(model.getUsername());
        List<Account> accountList = this.findAllByQuery(query);
        if (accountList != null) {
            for (int i = 0; i < accountList.size(); ++i) {
                Account account = accountList.get(i);
                if (account.getAccountId().equals(existEntity.getAccountId())) continue;
                throw new IllegalArgumentException(" \u8d26\u53f7\u5df2\u7ecf\u5b58\u5728: (" + model.getEmail() + "," + model.getTelPhone() + "," + model.getUsername() + ")");
            }
        }
        return this.saveAndFlush(existEntity);
    }

    public Account create(Tenant tenant, String telphone, String email, String username, String password, Integer status, AccountType type, boolean isEnableSendMsg, boolean isRandomPassword, boolean isMergeAccount, boolean changePasswordFlag, List<String> updateIgnoreProperties) {
        logger.info("telphone = {}, email = {}, username = {}, status = {}, isMergeAccount = {}, isEnableSendMsg = {}, changePasswordFlag = {}", new Object[]{telphone, email, username, status, isMergeAccount, isEnableSendMsg, changePasswordFlag});
        if (StringUtils.isBlank((CharSequence)telphone) && StringUtils.isBlank((CharSequence)email) && StringUtils.isBlank((CharSequence)username)) {
            return null;
        }
        AccountModel.Request.Login query = new AccountModel.Request.Login();
        if (StringUtils.isNotBlank((CharSequence)telphone)) {
            query.setTelPhone(telphone);
        }
        if (StringUtils.isNotBlank((CharSequence)email)) {
            query.setEmail(email);
        }
        if (StringUtils.isNotBlank((CharSequence)username)) {
            query.setUsername(username);
            if (!(WILMAR.equalsIgnoreCase(tenant.getTenantCode()) || username.startsWith(tenant.getTenantCode()) || RegExUtil.checkEmail((String)username) || RegExUtil.checkMobile((String)username))) {
                query.setUsername(tenant.getTenantCode() + username);
            }
        }
        List<Account> accountList = this.findAllByQuery(query);
        Account account = null;
        if (CollectionUtils.isEmpty(accountList)) {
            AccountModel.Request.Create newAccount = new AccountModel.Request.Create();
            newAccount.setTelPhone(telphone);
            newAccount.setEmail(email);
            newAccount.setUsername(username);
            newAccount.setPassword(password);
            newAccount.setStatus(status);
            newAccount.setType(type);
            newAccount.setEnableSendMsg(isEnableSendMsg);
            newAccount.setChangePasswordFlag(changePasswordFlag);
            account = this.save(tenant, newAccount, isEnableSendMsg, isRandomPassword, isMergeAccount, updateIgnoreProperties);
        } else {
            String message = "\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728: (" + email + "," + telphone + "," + username + ")";
            logger.warn(message);
            if (accountList.size() > 1) {
                throw new IllegalArgumentException(message);
            }
            if (!isMergeAccount) {
                throw new IllegalArgumentException(message);
            }
            account = accountList.get(0);
            if (RegExUtil.checkEmail((String)username)) {
                email = username;
            } else if (RegExUtil.checkMobile((String)username)) {
                telphone = username;
            } else if (tenant != null && StringUtils.isNotBlank((CharSequence)username)) {
                if (username.contains(tenant.getTenantCode())) {
                    account.setUsername(username);
                } else if (WILMAR.equalsIgnoreCase(tenant.getTenantCode())) {
                    account.setUsername(username);
                } else {
                    account.setUsername(tenant.getTenantCode() + username);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)telphone)) {
                account.setTelPhone(telphone);
            }
            if (StringUtils.isNotEmpty((CharSequence)email)) {
                account.setEmail(email);
            }
            account = this.saveAndFlush(account);
        }
        return account;
    }

    public Account findById(long accountId) {
        return (Account)this.accountDao.findById((Object)accountId).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u5b9e\u4f53"));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteById(long accountId) {
        Account account = (Account)this.accountDao.findById((Object)accountId).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u5b9e\u4f53"));
        this.accountDao.deleteById(Long.valueOf(accountId));
    }

    @Transactional(rollbackFor={Exception.class})
    public Account updateStatus(long accountId, int status) {
        IAuthorizedUser currentUser = UserInfoHolder.get();
        if (currentUser != null && accountId == currentUser.getAccountId()) {
            throw new IllegalArgumentException("\u64cd\u4f5c\u5931\u8d25\uff01\u4e0d\u80fd\u9501\u5b9a/\u7981\u7528\u81ea\u5df1\u7684\u8d26\u53f7!");
        }
        Account account = (Account)this.accountDao.findById((Object)accountId).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u5b9e\u4f53"));
        account.setStatus(Integer.valueOf(status));
        if (1 == status) {
            try {
                String username = "ACCOUNT_LOGIN_FAILS_" + account.getUsername();
                String mobile = "ACCOUNT_LOGIN_FAILS_" + account.getTelPhone();
                String email = "ACCOUNT_LOGIN_FAILS_" + account.getEmail();
                String[] keys = new String[]{username, mobile, email};
                this.redisTemplate.delete(Arrays.asList(keys));
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
        }
        return this.saveAndFlush(account);
    }

    public void sendMessage(Long tenantId, String email, String telPhone, String plantPassword, String tenantName, String username) {
        logger.info("email = {}, telPhone = {}, username = {}", new Object[]{email, telPhone, username});
        if (StringUtils.isBlank((CharSequence)email) && StringUtils.isBlank((CharSequence)telPhone) && StringUtils.isBlank((CharSequence)username)) {
            logger.info("StringUtils.isBlank(email) && StringUtils.isBlank(telPhone) && StringUtils.isBlank(username), return");
            return;
        }
        if (tenantId == null) {
            tenantId = 0L;
        }
        if (RegExUtil.checkEmail((String)email)) {
            HashMap<String, String> emailParam = new HashMap<String, String>();
            emailParam.put("account", email);
            emailParam.put("password", plantPassword);
            emailParam.put("tenantName", tenantName);
            emailParam.put("userName", username);
            EmailContentReq emailContentReq = new EmailContentReq();
            emailContentReq.setEmail(email);
            emailContentReq.setTemplateCode(PropertiesUtils.EMAIL_USER_CREATE);
            emailContentReq.setTenantId(tenantId);
            emailContentReq.setProps(emailParam);
            emailContentReq.setAppId(Long.valueOf(1L));
            logger.info("send message to email = {}", (Object)email);
            this.emailContentFeignClient.send(String.valueOf(tenantId), emailContentReq);
        } else if (RegExUtil.checkMobile((String)telPhone)) {
            HashMap<String, String> smsParams = new HashMap<String, String>();
            smsParams.put("password", plantPassword);
            smsParams.put("tenant", tenantName);
            smsParams.put("username", telPhone);
            SmsMessageReq smsMessageReq = new SmsMessageReq();
            smsMessageReq.setMobile(telPhone);
            smsMessageReq.setTemplateCode(PropertiesUtils.SMS_USER_CREATE);
            smsMessageReq.setTemplateParamJson(JsonUtils.toJson(smsParams));
            smsMessageReq.setTenantId(tenantId);
            smsMessageReq.setSignName("\u7968\u7a0e\u52a9\u624b");
            logger.info("send message to telphone = {}", (Object)telPhone);
            this.smsMessageFeignClient.send(String.valueOf(tenantId), smsMessageReq);
        } else {
            logger.warn("do not send any message, because of none email or telphone");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Account checkPasswordByAccountId(Long accountId, String password) {
        Optional optionalAccount = this.accountDao.findById((Object)accountId);
        if (!optionalAccount.isPresent()) {
            throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684\u7528\u6237");
        }
        Account account = (Account)optionalAccount.get();
        PasswordCheckResultDto passwordCheckResultDto = this.checkPassword(password, account);
        if (passwordCheckResultDto.isPwdCorrect()) {
            account = passwordCheckResultDto.getAccount();
            return account;
        }
        throw new IllegalArgumentException("\u5bc6\u7801\u9519\u8bef");
    }

    private Account findAccountByUserName(String username) {
        List accountList = this.accountDao.findAllByLoginName(username);
        if (accountList == null || accountList.isEmpty()) {
            return null;
        }
        if (accountList.size() > 1) {
            throw new IllegalArgumentException("\u7528\u6237\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6838\u5bf9\u8d26\u53f7\u4fe1\u606f\uff01");
        }
        return (Account)accountList.get(0);
    }

    private PasswordCheckResultDto checkPassword(String inputPassword, Account existAccount) {
        String encodePwd;
        String encryptPassword;
        String decryptedPassword;
        PasswordCheckResultDto passwordCheckResultDto = new PasswordCheckResultDto();
        passwordCheckResultDto.setAccount(existAccount);
        try {
            decryptedPassword = this.desPassword(inputPassword);
        }
        catch (Exception e) {
            decryptedPassword = inputPassword;
        }
        if (StringUtils.isNotBlank((CharSequence)existAccount.getSalt()) && (encryptPassword = CryptUtils.encryptPassword((String)existAccount.getSalt(), (String)decryptedPassword, (String)this.salt)).equals(existAccount.getPassword())) {
            passwordCheckResultDto.setPwdCorrect(true);
            return passwordCheckResultDto;
        }
        if (StringUtils.isNotBlank((CharSequence)existAccount.getEmail()) && !StringUtils.equals((CharSequence)existAccount.getEmail(), (CharSequence)existAccount.getSalt()) && (encodePwd = CryptUtils.encryptPassword((String)existAccount.getEmail(), (String)decryptedPassword, (String)this.salt)).equals(existAccount.getPassword())) {
            passwordCheckResultDto.setPwdCorrect(true);
            existAccount.setPassword(encodePwd);
            existAccount.setSalt(existAccount.getEmail());
            return passwordCheckResultDto;
        }
        if (StringUtils.isNotBlank((CharSequence)existAccount.getTelPhone()) && !StringUtils.equals((CharSequence)existAccount.getTelPhone(), (CharSequence)existAccount.getSalt()) && (encodePwd = CryptUtils.encryptPassword((String)existAccount.getTelPhone(), (String)decryptedPassword, (String)this.salt)).equals(existAccount.getPassword())) {
            passwordCheckResultDto.setPwdCorrect(true);
            existAccount.setPassword(encodePwd);
            existAccount.setSalt(existAccount.getTelPhone());
            return passwordCheckResultDto;
        }
        if (StringUtils.isNotBlank((CharSequence)existAccount.getUsername()) && !StringUtils.equals((CharSequence)existAccount.getUsername(), (CharSequence)existAccount.getSalt()) && (encodePwd = CryptUtils.encryptPassword((String)existAccount.getUsername(), (String)decryptedPassword, (String)this.salt)).equals(existAccount.getPassword())) {
            passwordCheckResultDto.setPwdCorrect(true);
            existAccount.setPassword(encodePwd);
            existAccount.setSalt(existAccount.getUsername());
            return passwordCheckResultDto;
        }
        try {
            String md5SecretPassWord = MD5PwdUtil.encode((String)decryptedPassword);
            this.loginResetPassword(passwordCheckResultDto, existAccount, decryptedPassword);
            if (passwordCheckResultDto.isPwdCorrect()) {
                return passwordCheckResultDto;
            }
        }
        catch (Exception e) {
            logger.warn("md5\u52a0\u5bc6\u5f02\u5e38");
        }
        passwordCheckResultDto.setPwdCorrect(false);
        return passwordCheckResultDto;
    }

    private PasswordCheckResultDto loginResetPassword(PasswordCheckResultDto passwordCheckResultDto, Account existAccount, String decryptedPassword) {
        String usesername = existAccount.getUsername();
        if (StringUtils.isBlank((CharSequence)usesername)) {
            usesername = StringUtils.isNotBlank((CharSequence)existAccount.getTelPhone()) ? existAccount.getTelPhone() : existAccount.getEmail();
        }
        if (StringUtils.equals((CharSequence)existAccount.getPassword(), (CharSequence)MD5PwdUtil.encode((String)decryptedPassword))) {
            String encryptedPassword = CryptUtils.encryptPassword((String)usesername, (String)decryptedPassword, (String)this.salt);
            existAccount.setSalt(usesername);
            existAccount.setPassword(encryptedPassword);
            passwordCheckResultDto.setPwdCorrect(true);
        } else {
            passwordCheckResultDto.setPwdCorrect(false);
        }
        return passwordCheckResultDto;
    }

    @Transactional(rollbackFor={Exception.class})
    public Account checkPasswordByUserName(String username, String password) {
        Account account = this.findAccountByUserName(username);
        if (account == null) {
            throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684\u7528\u6237");
        }
        PasswordCheckResultDto passwordCheckResultDto = this.checkPassword(password, account);
        if (passwordCheckResultDto.isPwdCorrect()) {
            account = passwordCheckResultDto.getAccount();
            return account;
        }
        throw new IllegalArgumentException("\u5bc6\u7801\u9519\u8bef");
    }

    @Transactional(rollbackFor={Exception.class})
    public void changePhone(AccountModel.Request.ChangePhone request) {
        String password;
        if (!RegExUtil.checkMobile((String)request.getPhone())) {
            throw new IllegalArgumentException("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (logger.isDebugEnabled()) {
            logger.info("\u4e0a\u4e0b\u6587\u4fe1\u606f\uff1a{}", (Object)UserInfoHolder.currentUser());
        }
        Long accountId = UserInfoHolder.currentUser().getAccountId();
        boolean resp = this.messageService.checkAuthSmsCode(request.getCaptcha(), request.getPhone(), request.getMsgId());
        if (!resp) {
            throw new IllegalArgumentException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        try {
            password = this.desPassword(request.getPassword());
        }
        catch (Exception e) {
            password = request.getPassword();
        }
        Account account = this.checkPasswordByAccountId(accountId, request.getPassword());
        String encryptPassword = CryptUtils.encryptPassword((String)request.getPhone(), (String)password, (String)this.salt);
        account.setPassword(encryptPassword);
        account.setSalt(request.getPhone());
        account.setTelPhone(request.getPhone());
        account.setBindAuthFlag(Boolean.FALSE);
        this.saveAndFlush(account);
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindPhone(AccountModel.Request.BindPhone request) {
        if (!RegExUtil.checkMobile((String)request.getPhone())) {
            throw new IllegalArgumentException("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        boolean resp = this.messageService.checkAuthSmsCode(request.getCaptcha(), request.getPhone(), request.getMsgId());
        if (!resp) {
            throw new IllegalArgumentException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        Account account = this.checkPasswordByUserName(request.getUsername(), request.getPassword());
        String password = request.getPassword();
        try {
            password = this.desPassword(request.getPassword());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String encryptPassword = CryptUtils.encryptPassword((String)request.getPhone(), (String)password, (String)this.salt);
        account.setPassword(encryptPassword);
        account.setTelPhone(request.getPhone());
        account.setSalt(request.getPhone());
        account.setBindAuthFlag(Boolean.FALSE);
        this.saveAndFlush(account);
    }

    @Transactional(rollbackFor={Exception.class})
    public void changeEmail(AccountModel.Request.ChangeEmail request) {
        if (!RegExUtil.checkEmail((String)request.getEmail())) {
            throw new IllegalArgumentException("\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        Long accountId = UserInfoHolder.currentUser().getAccountId();
        boolean resp = this.messageService.checkAuthEmailCode(request.getCaptcha(), request.getEmail(), request.getMsgId());
        if (!resp) {
            throw new IllegalArgumentException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        String password = request.getPassword();
        try {
            password = this.desPassword(request.getPassword());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Account account = this.checkPasswordByAccountId(accountId, request.getPassword());
        String encryptPassword = CryptUtils.encryptPassword((String)request.getEmail(), (String)password, (String)this.salt);
        account.setPassword(encryptPassword);
        account.setEmail(request.getEmail());
        account.setSalt(account.getEmail());
        account.setBindAuthFlag(Boolean.FALSE);
        this.saveAndFlush(account);
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindEmail(AccountModel.Request.BindEmail request) {
        if (!RegExUtil.checkEmail((String)request.getEmail())) {
            throw new IllegalArgumentException("\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        boolean resp = this.messageService.checkAuthEmailCode(request.getCaptcha(), request.getEmail(), request.getMsgId());
        if (!resp) {
            throw new IllegalArgumentException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        String password = request.getPassword();
        try {
            password = this.desPassword(request.getPassword());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Account account = this.checkPasswordByUserName(request.getUsername(), request.getPassword());
        String encryptPassword = CryptUtils.encryptPassword((String)request.getEmail(), (String)password, (String)this.salt);
        account.setPassword(encryptPassword);
        account.setEmail(request.getEmail());
        account.setSalt(account.getEmail());
        account.setBindAuthFlag(Boolean.FALSE);
        this.saveAndFlush(account);
    }

    private String desPassword(String password) {
        try {
            return AESHelp.desEncrypt((String)"Key#password%Key", (String)password);
        }
        catch (Exception e) {
            logger.debug("\u5bc6\u7801\u89e3\u6790\u9519\u8bef:{}", (Object)e.getMessage());
            throw new IllegalArgumentException("\u5bc6\u7801\u89e3\u6790\u9519\u8bef");
        }
    }

    private String safeDesPassword(String password) {
        try {
            return AESHelp.desEncrypt((String)"Key#password%Key", (String)password);
        }
        catch (Exception e) {
            return password;
        }
    }

    public String sendChangePhoneCode(String phone) {
        if (!RegExUtil.checkMobile((String)phone)) {
            throw new IllegalArgumentException("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        Account account = this.accountDao.findByTelPhone(phone);
        if (null != account) {
            throw new IllegalArgumentException("\u8be5\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        return this.messageService.sendAuthSmsCode(phone);
    }

    public String sendChangeEmailCode(String email) {
        if (!RegExUtil.checkEmail((String)email)) {
            throw new IllegalArgumentException("\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        Account account = this.accountDao.findByEmail(email);
        if (null != account) {
            throw new IllegalArgumentException("\u8be5\u90ae\u7bb1\u5df2\u5b58\u5728");
        }
        return this.messageService.sendAuthEmailCode(email);
    }

    public String sendValidCode(String username) {
        Account account = this.findAccountByUserName(username);
        if (account == null) {
            throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684\u7528\u6237");
        }
        boolean isEmail = false;
        boolean isPhone = false;
        String email = null;
        String phone = null;
        if (RegExUtil.checkEmail((String)username)) {
            isEmail = true;
            email = username;
        } else if (RegExUtil.checkMobile((String)username)) {
            isPhone = true;
            phone = username;
        } else if (account.getTelPhone() != null && RegExUtil.checkMobile((String)account.getTelPhone())) {
            isPhone = true;
            phone = account.getTelPhone();
        } else if (account.getEmail() != null && RegExUtil.checkEmail((String)account.getEmail())) {
            isEmail = true;
            email = account.getEmail();
        }
        if (isEmail) {
            return this.messageService.sendAuthEmailCode(email);
        }
        if (isPhone) {
            return this.messageService.sendAuthSmsCode(phone);
        }
        throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684\u8d26\u53f7");
    }

    @Transactional(rollbackFor={Exception.class})
    public void updatePwd(AccountModel.ChangePwd request) {
        boolean resp;
        Account account = this.findAccountByUserName(request.getUsername());
        if (account == null) {
            throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684\u7528\u6237");
        }
        boolean isEmail = false;
        boolean isPhone = false;
        String email = null;
        String phone = null;
        if (RegExUtil.checkEmail((String)request.getUsername())) {
            isEmail = true;
            email = request.getUsername();
        } else if (RegExUtil.checkMobile((String)request.getUsername())) {
            isPhone = true;
            phone = request.getUsername();
        } else if (account.getTelPhone() != null && RegExUtil.checkMobile((String)account.getTelPhone())) {
            isPhone = true;
            phone = account.getTelPhone();
        } else if (account.getEmail() != null && RegExUtil.checkEmail((String)account.getEmail())) {
            isEmail = true;
            email = account.getEmail();
        }
        if (isEmail) {
            resp = this.messageService.checkAuthEmailCode(request.getValidCode(), email, request.getMsgId());
        } else if (isPhone) {
            resp = this.messageService.checkAuthSmsCode(request.getValidCode(), phone, request.getMsgId());
        } else {
            throw new IllegalArgumentException("\u624b\u673a\u53f7/\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (!resp) {
            throw new IllegalArgumentException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        String rawPassword = this.safeDesPassword(request.getPassword());
        String password = CryptUtils.encryptPassword((String)request.getUsername(), (String)rawPassword, (String)this.salt);
        if (password.equals(account.getPassword())) {
            return;
        }
        account.setRawPassword(rawPassword);
        account.setPassword(password);
        if (isEmail) {
            account.setEmail(email);
        } else if (isPhone) {
            account.setTelPhone(phone);
        } else {
            account.setUsername(request.getUsername());
        }
        account.setSalt(request.getUsername());
        this.saveAndFlush(account);
    }

    public List<Account> findByTenantCodeAndUsername(String tenantCode, String username) {
        Specification specification = AccountQueryHelper.queryOneSpecification((String)tenantCode, (String)username, (boolean)false);
        List accounts = this.accountDao.findAll(specification);
        if (accounts == null || accounts.isEmpty()) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u8d26\u6237\u5b9e\u4f53(tenantCode:" + tenantCode + ",username:" + username);
        }
        return accounts;
    }

    @Transactional(rollbackFor={Exception.class})
    public void unBindPhone(AccountModel.Request.UnBindPhone request) {
        Long accountId = UserInfoHolder.currentUser().getAccountId();
        Account account = this.findById(accountId);
        String password = request.getPassword();
        try {
            password = this.desPassword(request.getPassword());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String validPassword = CryptUtils.encryptPassword((String)account.getSalt(), (String)password, (String)this.salt);
        if (StringUtils.isBlank((CharSequence)account.getTelPhone())) {
            throw new IllegalArgumentException("\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\uff0c\u4e0d\u80fd\u89e3\u7ed1");
        }
        if (!account.getPassword().equalsIgnoreCase(validPassword)) {
            throw new IllegalArgumentException("\u5bc6\u7801\u9519\u8bef");
        }
        if (StringUtils.isBlank((CharSequence)account.getUsername()) && StringUtils.isBlank((CharSequence)account.getEmail())) {
            throw new IllegalArgumentException("\u6ca1\u6709\u57df\u8d26\u53f7\u4e0e\u90ae\u7bb1\uff0c\u624b\u673a\u53f7\u4e0d\u80fd\u89e3\u7ed1");
        }
        String accountSalt = account.getSalt();
        if (account.getTelPhone().equals(account.getSalt())) {
            accountSalt = StringUtils.isNotBlank((CharSequence)account.getUsername()) ? account.getUsername() : account.getEmail();
        }
        String encryptPassword = CryptUtils.encryptPassword((String)accountSalt, (String)password, (String)this.salt);
        account.setPassword(encryptPassword);
        account.setTelPhone("");
        account.setSalt(accountSalt);
        this.saveAndFlush(account);
    }

    @Transactional(rollbackFor={Exception.class})
    public void unBindEmail(AccountModel.Request.UnBindEmail request) {
        Long accountId = UserInfoHolder.currentUser().getAccountId();
        Account account = this.findById(accountId);
        String password = request.getPassword();
        try {
            password = this.desPassword(request.getPassword());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String validPassword = CryptUtils.encryptPassword((String)account.getSalt(), (String)password, (String)this.salt);
        if (!account.getPassword().equalsIgnoreCase(validPassword)) {
            throw new IllegalArgumentException("\u5bc6\u7801\u9519\u8bef");
        }
        if (StringUtils.isBlank((CharSequence)account.getEmail())) {
            throw new IllegalArgumentException("\u672a\u7ed1\u5b9a\u90ae\u7bb1\uff0c\u4e0d\u80fd\u89e3\u7ed1");
        }
        if (StringUtils.isBlank((CharSequence)account.getUsername()) && StringUtils.isBlank((CharSequence)account.getTelPhone())) {
            throw new IllegalArgumentException("\u6ca1\u6709\u57df\u8d26\u53f7\u4e0e\u90ae\u7bb1\uff0c\u624b\u673a\u53f7\u4e0d\u80fd\u89e3\u7ed1");
        }
        String accountSalt = account.getSalt();
        if (account.getEmail().equals(account.getSalt())) {
            accountSalt = StringUtils.isNotBlank((CharSequence)account.getUsername()) ? account.getUsername() : account.getTelPhone();
        }
        String encryptPassword = CryptUtils.encryptPassword((String)accountSalt, (String)password, (String)this.salt);
        account.setPassword(encryptPassword);
        account.setEmail("");
        account.setSalt(accountSalt);
        this.saveAndFlush(account);
    }

    @Transactional(rollbackFor={Exception.class})
    public void changePassword(long accountId, String password) {
        Account existAccount = (Account)this.accountDao.findById((Object)accountId).orElseThrow(() -> new IllegalArgumentException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8d26\u6237(" + accountId + ")"));
        String accountSalt = existAccount.getSalt();
        if (StringUtils.isEmpty((CharSequence)accountSalt)) {
            if (StringUtils.isNotEmpty((CharSequence)existAccount.getEmail())) {
                accountSalt = existAccount.getEmail();
            } else if (StringUtils.isNotEmpty((CharSequence)existAccount.getTelPhone())) {
                accountSalt = existAccount.getTelPhone();
            } else if (StringUtils.isNotEmpty((CharSequence)existAccount.getUsername())) {
                accountSalt = existAccount.getUsername();
            }
        }
        String rawPassword = this.desPassword(password);
        existAccount.setRawPassword(rawPassword);
        String encryptPassword = CryptUtils.encryptPassword((String)accountSalt, (String)rawPassword, (String)this.salt);
        if (encryptPassword.equals(existAccount.getPassword())) {
            throw new IllegalArgumentException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u539f\u5bc6\u7801\u4e00\u6837");
        }
        existAccount.setSalt(accountSalt);
        existAccount.setPassword(encryptPassword);
        this.accountDao.saveAndFlush((Object)existAccount);
    }

    public List<AccountUserDTO> accountUserList(long accountId) {
        return this.accountUserExtendDao.findUserByAccountId(Long.valueOf(accountId));
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateLastLoginTime(Long accountId) {
        Optional optionalAccount = this.accountDao.findById((Object)accountId);
        if (!optionalAccount.isPresent()) {
            logger.warn("\u66f4\u65b0\u767b\u5f55\u65f6\u95f4\u5931\u8d25\uff0caccountId:{}", (Object)accountId);
            return;
        }
        Account account = (Account)optionalAccount.get();
        account.setLastLoginTime(Calendar.getInstance().getTime());
        this.accountDao.saveAndFlush((Object)account);
    }

    public Account saveAndFlush(Account account) {
        account = (Account)this.accountDao.saveAndFlush((Object)account);
        this.accountPubSubService.publish(account);
        return account;
    }

    public String getEncryptedPwd(Long accountId) {
        Optional account = this.accountDao.findById((Object)accountId);
        if (account.isPresent()) {
            return ((Account)account.get()).getPassword();
        }
        return null;
    }

    public void updateDoubleAuth(long accountId, boolean status) {
        Optional accountOptional = this.accountDao.findById((Object)accountId);
        if (!accountOptional.isPresent()) {
            throw new IllegalArgumentException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        Account account = (Account)accountOptional.get();
        account.setDoubleAuthFlag(Boolean.valueOf(status));
        this.accountDao.saveAndFlush((Object)account);
    }

    public void updateBindAuth(long accountId, boolean status) {
        Optional accountOptional = this.accountDao.findById((Object)accountId);
        if (!accountOptional.isPresent()) {
            throw new IllegalArgumentException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        Account account = (Account)accountOptional.get();
        account.setBindAuthFlag(Boolean.valueOf(status));
        this.accountDao.saveAndFlush((Object)account);
    }
}

