/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.account.service;

import com.xforceplus.business.account.service.AccountPlatformRelService;
import com.xforceplus.business.enums.AccountPlatformTypeEnum;
import com.xforceplus.business.enums.DidiAccountEnum;
import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.domain.account.DidiAccountDataDto;
import com.xforceplus.entity.AccountPlatformRel;
import com.xforceplus.entity.User;
import com.xforceplus.utils.DidiSignUtils;
import io.geewit.web.utils.JsonUtils;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DidiAccounService {
    private static final Logger log = LoggerFactory.getLogger(DidiAccounService.class);
    @Resource
    private AccountPlatformRelService accountPlatformRelService;
    @Resource
    private UserService userService;

    public DidiAccountEnum.Status saveNotifyResult(String data, Long appId, String timestamp, String sign) throws NoSuchAlgorithmException {
        if (StringUtils.isBlank((CharSequence)data)) {
            return DidiAccountEnum.Status.CHECK_FAIL;
        }
        if (appId == null) {
            return DidiAccountEnum.Status.CHECK_FAIL;
        }
        if (StringUtils.isBlank((CharSequence)timestamp)) {
            return DidiAccountEnum.Status.CHECK_FAIL;
        }
        if (StringUtils.isBlank((CharSequence)sign)) {
            return DidiAccountEnum.Status.CHECK_FAIL;
        }
        HashMap<String, String> dataMap = new HashMap<String, String>(4);
        dataMap.put("appId", String.valueOf(appId));
        dataMap.put("data", data);
        dataMap.put("timestamp", timestamp);
        if (!DidiSignUtils.isRegal(dataMap, sign)) {
            return DidiAccountEnum.Status.SIGN_ILLEGAL;
        }
        DidiAccountDataDto didiAccountDataDto = (DidiAccountDataDto)JsonUtils.fromJson((String)data, DidiAccountDataDto.class);
        this.saveWithUserId(didiAccountDataDto.getThirdUserId(), AccountPlatformTypeEnum.DIDI.getValue(), didiAccountDataDto.getOperate(), new Date(Long.valueOf(didiAccountDataDto.getUpdateTime())));
        return DidiAccountEnum.Status.SUCCESS;
    }

    public <T extends AccountPlatformRel> T saveWithUserId(String userId, int platformType, int status, Date enableTime) {
        Optional<User> optionalUser = this.userService.findUserById(Long.valueOf(userId));
        User user = optionalUser.orElseThrow(() -> new IllegalArgumentException("\u6240\u4f20userId\u6709\u8bef\u3002"));
        AccountPlatformRel accountPlatformRel = this.accountPlatformRelService.getAccountPlatformRel(platformType, userId);
        if (accountPlatformRel == null) {
            accountPlatformRel = new AccountPlatformRel();
            accountPlatformRel.setAccountId(user.getAccountId());
            accountPlatformRel.setCreateTime(new Date());
        }
        accountPlatformRel.setStatus(Integer.valueOf(status));
        accountPlatformRel.setEnableTime(enableTime);
        accountPlatformRel.setUpdateTime(new Date());
        return (T)this.accountPlatformRelService.saveAccountPlatformRel(accountPlatformRel);
    }
}

