/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.account.service;

import com.xforceplus.api.model.LoginLogModel;
import com.xforceplus.dao.LoginLogDao;
import com.xforceplus.entity.LoginLog;
import io.geewit.core.utils.reflection.BeanUtils;
import java.io.Serializable;
import java.util.Optional;
import javax.persistence.criteria.Expression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LoginLogService {
    private static final Logger log = LoggerFactory.getLogger(LoginLogService.class);
    private final LoginLogDao loginLogDao;

    public LoginLogService(LoginLogDao loginLogDao) {
        this.loginLogDao = loginLogDao;
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(LoginLogModel.Request.Save save) {
        log.info("\u7528\u6237\u767b\u5f55:{},accountId:{},userId:{},loginTime:{}", new Object[]{save.getLoginName(), save.getAccountId(), save.getUserId(), save.getLoginTime()});
        Page page = this.loginLogDao.findAll((Specification & Serializable)(root, query, builder) -> builder.equal((Expression)root.get("accountId"), (Object)save.getAccountId()), Pageable.ofSize((int)1));
        Optional loginLogOptional = page.stream().findFirst();
        if (loginLogOptional.isPresent()) {
            this.loginLogDao.updateLoginTime(save.getAccountId(), save.getLoginName(), save.getUserId(), save.getLoginTime());
        } else {
            LoginLog entity = new LoginLog();
            BeanUtils.copyProperties((Object)save, (Object)entity);
            this.loginLogDao.saveAndFlush((Object)entity);
        }
    }
}

