/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.account.service;

import com.xforceplus.api.model.PasswordHistoryModel;
import com.xforceplus.dao.PasswordHistoryDao;
import com.xforceplus.entity.PasswordHistory;
import com.xforceplus.query.PasswordHistoryQueryHelper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PasswordHistoryService {
    private static final Logger log = LoggerFactory.getLogger(PasswordHistoryService.class);
    private final PasswordHistoryDao passwordHistoryDao;

    public PasswordHistoryService(PasswordHistoryDao passwordHistoryDao) {
        this.passwordHistoryDao = passwordHistoryDao;
    }

    public boolean existPasswordInHistory(long accountId, String password, int maxRows) {
        PasswordHistoryModel.Request.Query query = new PasswordHistoryModel.Request.Query();
        query.setAccountId(Long.valueOf(accountId));
        query.setPassword(password);
        Page page = this.passwordHistoryDao.findAll(PasswordHistoryQueryHelper.querySpecification((PasswordHistoryModel.Request.Query)query), Pageable.ofSize((int)maxRows));
        return !page.isEmpty();
    }

    @Transactional(rollbackFor={Exception.class})
    public void savePassword(long accountId, String password, int maxRows) {
        List histories;
        int size;
        if (maxRows <= 0) {
            log.info("maxRows <= 0, do nothing");
        }
        if ((size = (histories = this.passwordHistoryDao.findByAccountId(accountId)).size()) >= maxRows) {
            for (int i = 0; i < maxRows - size; ++i) {
                PasswordHistory deletingPasswordHistory = (PasswordHistory)histories.get(i);
                if (i == 0) {
                    deletingPasswordHistory.setPassword(password);
                    this.passwordHistoryDao.save((Object)deletingPasswordHistory);
                    continue;
                }
                this.passwordHistoryDao.deleteById(deletingPasswordHistory.getId());
            }
        } else {
            PasswordHistory passwordHistory = new PasswordHistory();
            passwordHistory.setAccountId(Long.valueOf(accountId));
            passwordHistory.setPassword(password);
            this.passwordHistoryDao.save((Object)passwordHistory);
        }
    }
}

