/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.account.service;

import com.xforceplus.api.model.SsoAccountModel;
import com.xforceplus.business.account.service.AccountService;
import com.xforceplus.dao.AccountDao;
import com.xforceplus.dao.TenantDao;
import com.xforceplus.dao.UserDao;
import com.xforceplus.entity.Account;
import com.xforceplus.entity.User;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SsoAccountService {
    private static final Logger log = LoggerFactory.getLogger(SsoAccountService.class);
    private final AccountDao accountDao;
    private final UserDao userDao;
    private final TenantDao tenantDao;
    private final AccountService accountService;

    public SsoAccountService(TenantDao tenantDao, AccountService accountService, AccountDao accountDao, UserDao userDao) {
        this.tenantDao = tenantDao;
        this.accountService = accountService;
        this.accountDao = accountDao;
        this.userDao = userDao;
    }

    @Transactional(rollbackFor={Exception.class})
    public Account save(SsoAccountModel.Request.Save model) {
        Long tenantId = this.tenantDao.findTenantIdByTenantCode(model.getTenantCode());
        if (tenantId == null) {
            throw new IllegalArgumentException("\u4f20\u5165\u7684\u79df\u6237\u7f16\u53f7(" + model.getTenantCode() + ")\u6709\u8bef");
        }
        Account account = this.saveAccount(model);
        List users = this.userDao.findByTenantIdAndAccountId(tenantId.longValue(), account.getAccountId().longValue());
        User user = users.stream().findFirst().orElseGet(() -> {
            User newUser = new User();
            newUser.setTenantId(tenantId);
            newUser.setAccountId(account.getAccountId());
            return newUser;
        });
        user.setUserPhone(model.getTelPhone());
        user.setUserEmailAddr(model.getEmail());
        user.setUserName(model.getUsername());
        this.userDao.saveAndFlush((Object)user);
        return account;
    }

    private Account saveAccount(SsoAccountModel.Request.Save save) {
        Account account = null;
        String username = null;
        if (StringUtils.isNotBlank((CharSequence)save.getUsername())) {
            username = save.getTenantCode() + save.getUsername();
        }
        if (StringUtils.isNotBlank((CharSequence)save.getTelPhone())) {
            account = this.accountDao.findByTelPhone(save.getTelPhone());
        }
        if (account == null && StringUtils.isNotBlank((CharSequence)save.getEmail())) {
            account = this.accountDao.findByEmail(save.getEmail());
        }
        if (account == null && StringUtils.isNotBlank(username)) {
            account = this.accountDao.findByUsername(username);
        }
        if (account == null) {
            account = new Account();
            account.setTelPhone(save.getTelPhone());
            account.setEmail(save.getEmail());
            account.setUsername(username);
            account.setPassword("no_password");
        }
        if (save.getStatus() != null) {
            account.setStatus(save.getStatus());
        }
        return this.accountService.saveAndFlush(account);
    }
}

