/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.app.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.app.AppApi;
import com.xforceplus.api.model.AppModel;
import com.xforceplus.business.app.service.AppService;
import com.xforceplus.entity.App;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import io.geewit.data.jpa.essential.search.DynamicSpecifications;
import io.geewit.data.jpa.essential.search.SearchFilter;
import io.geewit.data.jpa.essential.web.servlet.Servlets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u5e94\u7528\u76f8\u5173\u63a5\u53e3", description="\u5e94\u7528\u76f8\u5173\u63a5\u53e3")
@Validated
@Controller
public class AppController
implements AppApi {
    private static final Logger logger = LoggerFactory.getLogger(AppController.class);
    private final AppService appService;

    public AppController(AppService appService) {
        this.appService = appService;
    }

    @AuthorizedDefinition(resources={"xforce:business:app:read"})
    @ApiIgnore
    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u5e94\u7528\u5206\u9875")
    @ResponseBody
    @RequestMapping(name="\u5e94\u7528\u5206\u9875\u5217\u8868\u67e5\u8be2", value={"/api/global/apps/query"}, method={RequestMethod.GET})
    public Page<App> page(WebRequest request, @ApiParam(value="pageable") Pageable pageable) {
        Map searchParams = Servlets.getParametersStartingWith((WebRequest)request, (String)"search_");
        Collection filters = SearchFilter.parse((Map)searchParams);
        Specification specification = DynamicSpecifications.bySearchFilter((Collection)filters);
        Page<App> page = this.appService.page((Specification<App>)specification, pageable);
        return page;
    }

    @AuthorizedDefinition(resources={"xforce:business:app:read"})
    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u5e94\u7528\u5206\u9875")
    public ResponseEntity<Page<App>> page(@ApiParam(value="request") AppModel.Request.Query query, @ApiParam(value="pageable") Pageable pageable) {
        Page<App> result = this.appService.page(query, pageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:business:app:read"})
    @ApiIgnore
    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u5217\u8868", notes="\u901a\u8fc7\u53c2\u6570\uff0c\u83b7\u53d6\u5e94\u7528\u5217\u8868")
    @ResponseBody
    @RequestMapping(name="\u5e94\u7528\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/apps/list"}, method={RequestMethod.GET})
    public ResponseEntity<List<App>> list() {
        List<App> result = this.appService.list();
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:business:app:save"})
    @ApiOperation(value="\u65b0\u589e\u5e94\u7528")
    public ResponseEntity<App> create(@ApiParam(value="app", required=true) AppModel.Request.Create model) {
        App result = this.appService.create(model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:business:app:save"})
    @ApiOperation(value="\u4fee\u6539\u5e94\u7528")
    public ResponseEntity<App> update(@ApiParam(value="appId", required=true) long appId, @ApiParam(value="app", required=true) AppModel.Request.Save model) {
        App result = this.appService.update(appId, model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:business:app:save"})
    @ApiOperation(value="\u4fee\u6539\u5e94\u7528\u72b6\u6001")
    public ResponseEntity<String> updateStatus(@ApiParam(value="appId", required=true) long appId, @ApiParam(value="status", required=true) int status) {
        this.appService.updateStatus(appId, status);
        return ResponseEntity.ok((Object)"\u4fee\u6539\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:business:app:read"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u5e94\u7528\u4fe1\u606f")
    public ResponseEntity<App> info(long appId) {
        App result = this.appService.findById(appId);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:business:app:save"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u5e10\u53f7")
    public ResponseEntity<String> delete(@ApiParam(value="appId", required=true) long appId) {
        this.appService.deleteById(appId);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u53ef\u7ba1\u7406app\u96c6\u5408")
    @ResponseBody
    @RequestMapping(name="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u53ef\u7ba1\u7406app\u96c6\u5408", value={"${xforce.tenant.service.url.prefix:/api}/current${xforce.tenant.service.version:}/apps"}, method={RequestMethod.GET})
    public ResponseEntity<Set<Long>> currentApps() {
        Set<Long> appIds = this.appService.currentAppIds();
        return ResponseEntity.ok(appIds);
    }
}

