/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.client.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.client.ClientApi;
import com.xforceplus.api.model.ClientModel;
import com.xforceplus.business.client.service.ClientSecretService;
import com.xforceplus.domain.client.ClientDto;
import com.xforceplus.entity.Client;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import io.geewit.core.utils.reflection.BeanUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.constraints.Min;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="client\u76f8\u5173\u63a5\u53e3", tags={"client"})
@Controller
public class ClientController
implements ClientApi {
    private final ClientSecretService clientService;

    public ClientController(ClientSecretService clientService) {
        this.clientService = clientService;
    }

    @ResponseBody
    @GetMapping(name="client\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/clients"})
    public ResponseEntity<Page<Client>> page(@SpringQueryMap ClientModel.Request.Query query, Pageable pageable) {
        Page<Client> result = this.clientService.findByQuery(query, pageable);
        return ResponseEntity.ok(result);
    }

    @ResponseBody
    @GetMapping(name="client\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/clients/list"})
    @Deprecated
    public List<Client> list() {
        return this.clientService.findAll();
    }

    @ResponseBody
    @GetMapping(name="client\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/clients/v2/list"})
    public ResponseEntity<List<Client>> listV2() {
        return ResponseEntity.ok(this.clientService.findAll());
    }

    @ResponseBody
    @GetMapping(name="\u83b7\u53d6client", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/clients/{clientId}"})
    @Deprecated
    public ClientDto get(@PathVariable(value="clientId") String clientId) {
        return this.clientService.findById(clientId);
    }

    public ResponseEntity<Client> getV2(@PathVariable(value="clientId") String clientId) {
        return ResponseEntity.ok((Object)this.clientService.findById(clientId));
    }

    public ResponseEntity<Client> check(String clientId, String secret) {
        Client result = this.clientService.findByClientIdAndSecret(clientId, secret);
        return ResponseEntity.ok((Object)result);
    }

    @ResponseBody
    @PostMapping(name="\u65b0\u589eclient", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/clients"})
    @Deprecated
    public Client create(@RequestBody ClientDto clientForm) {
        Client client = new Client();
        BeanUtils.copyProperties((Object)clientForm, (Object)client);
        client = this.clientService.create(client);
        return client;
    }

    @AuthorizedDefinition(resources={"xforce:operation:client:save"})
    @ResponseBody
    @PostMapping(name="\u65b0\u589eclient", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/clients/v2"})
    public ResponseEntity<Client> createV2(@RequestBody ClientDto clientForm) {
        Client client = new Client();
        BeanUtils.copyProperties((Object)clientForm, (Object)client);
        client = this.clientService.create(client);
        return ResponseEntity.ok((Object)client);
    }

    @ResponseBody
    @PutMapping(name="\u66f4\u65b0client", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/clients/{clientId}"})
    @Deprecated
    public Client update(@PathVariable(value="clientId") String clientId, @RequestBody ClientDto clientForm) {
        Client client = new Client();
        BeanUtils.copyProperties((Object)clientForm, (Object)client, (String[])new String[]{"clientId"});
        return this.clientService.update(clientId, client);
    }

    @AuthorizedDefinition(resources={"xforce:operation:client:save"})
    @ResponseBody
    @PutMapping(name="\u66f4\u65b0client", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/clients/v2/{clientId}"})
    public ResponseEntity<Client> updateV2(@PathVariable(value="clientId") String clientId, @RequestBody ClientDto clientForm) {
        Client client = new Client();
        BeanUtils.copyProperties((Object)clientForm, (Object)client, (String[])new String[]{"clientId"});
        return ResponseEntity.ok((Object)this.clientService.update(clientId, client));
    }

    @ResponseBody
    @DeleteMapping(name="\u5220\u9664client", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/clients/{clientId}"})
    public ResponseEntity<String> delete(@PathVariable(value="clientId") String clientId) {
        this.clientService.delete(clientId);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:operation:client:save"})
    @ApiOperation(value="client\u7ed1\u5b9a\u7528\u6237\u4fe1\u606f")
    @ResponseBody
    @PostMapping(name="clientId\u7ed1\u5b9a\u7528\u6237ID", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/clients/{clientId}/bind"})
    public ResponseEntity<Client> bindUserId(@PathVariable(value="clientId") String clientId, @RequestParam(value="userId", required=true) @Min(value=1L, message="\u7528\u6237ID\u5fc5\u987b\u5927\u4e8e0") @Min(value=1L, message="\u7528\u6237ID\u5fc5\u987b\u5927\u4e8e0") Long userId) {
        return ResponseEntity.ok((Object)this.clientService.bindUserId(clientId, userId));
    }

    @AuthorizedDefinition(resources={"xforce:operation:client:save"})
    @ApiOperation(value="client\u89e3\u7ed1\u7528\u6237\u4fe1\u606f")
    @ResponseBody
    @PostMapping(name="clientId\u89e3\u7ed1\u7528\u6237", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/clients/{clientId}/unbind"})
    public ResponseEntity<Client> unbindUserId(@PathVariable(value="clientId") String clientId) {
        return ResponseEntity.ok((Object)this.clientService.unbindUserId(clientId));
    }

    @AuthorizedDefinition(resources={"xforce:operation:client:secret"})
    @ApiOperation(value="\u67e5\u8be2client\u5bc6\u94a5")
    public ResponseEntity<String> getSecret(String clientId) {
        Client client = this.clientService.findById(clientId);
        return ResponseEntity.ok((Object)client.getSecret());
    }
}

