/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.client.service;

import com.google.common.collect.Lists;
import com.xforceplus.business.resource.service.ResourceService;
import com.xforceplus.dao.ClientResourcesetRelDao;
import com.xforceplus.entity.ClientResourcesetRel;
import com.xforceplus.entity.Resource;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ClientResourcesetRelService {
    @Autowired
    private ClientResourcesetRelDao clientResourcesetRelDao;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private RedisTemplate redisTemplate;

    @Transactional(rollbackFor={Exception.class})
    public ClientResourcesetRel create(ClientResourcesetRel rel) {
        return (ClientResourcesetRel)this.clientResourcesetRelDao.saveAndFlush((Object)rel);
    }

    @Transactional(rollbackFor={Exception.class})
    public void createBatch(String clientId, List<Long> resourcesetIds) {
        this.clientResourcesetRelDao.deleteByClientId(clientId);
        IAuthorizedUser user = UserInfoHolder.get();
        if (!CollectionUtils.isEmpty(resourcesetIds)) {
            ArrayList<ClientResourcesetRel> rels = new ArrayList<ClientResourcesetRel>();
            for (Long resourcesetId : resourcesetIds) {
                ClientResourcesetRel rel = new ClientResourcesetRel();
                rel.setClientId(clientId);
                rel.setResourcesetId(resourcesetId);
                rel.setCreateTime(new Date());
                if (null != user) {
                    rel.setCreateUserId(String.valueOf(user.getId()));
                    rel.setCreateUserName(user.getUserName());
                }
                rels.add(rel);
            }
            this.clientResourcesetRelDao.saveAllAndFlush(rels);
            String clientResourcesKey = String.format("uc:clientResource:clientId:%s:resources", clientId);
            this.redisTemplate.delete((Object)clientResourcesKey);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteById(Long relId) {
        this.clientResourcesetRelDao.deleteById(relId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByClientId(String clientId) {
        this.clientResourcesetRelDao.deleteByClientId(clientId);
    }

    public List<ClientResourcesetRel> findByClientId(String clientId) {
        return this.clientResourcesetRelDao.findByClientId(clientId);
    }

    public List<Long> findResourcesetIdsByClientId(String clientId) {
        List<ClientResourcesetRel> list = this.findByClientId(clientId);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.EMPTY_LIST;
        }
        List<Long> ids = list.stream().map(t -> t.getResourcesetId()).collect(Collectors.toList());
        return ids;
    }

    public List<ClientResourcesetRel> findAll() {
        return Lists.newArrayList((Iterable)this.clientResourcesetRelDao.findAll());
    }

    public Set<String> getClientResource(String clientId) {
        String clientResourcesKey = String.format("uc:clientResource:clientId:%s:resources", clientId);
        if (Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)clientResourcesKey))) {
            return this.redisTemplate.opsForSet().members((Object)clientResourcesKey);
        }
        List<Long> resourcesetIds = this.findResourcesetIdsByClientId(clientId);
        if (CollectionUtils.isEmpty(resourcesetIds)) {
            return Collections.EMPTY_SET;
        }
        List<Resource> resources = this.resourceService.listByResourcesetIds(resourcesetIds);
        if (CollectionUtils.isEmpty(resources)) {
            return Collections.EMPTY_SET;
        }
        Set<String> resourcecodes = resources.stream().map(Resource::getResourceCode).collect(Collectors.toSet());
        this.redisTemplate.opsForSet().add((Object)clientResourcesKey, new Object[]{resourcecodes});
        return resourcecodes;
    }

    public void evictClientResourceCache(String clientId) {
        String clientResourcesKey = String.format("uc:clientResource:clientId:%s:resources", clientId);
        this.redisTemplate.delete((Object)clientResourcesKey);
    }
}

