/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.client.service;

import com.google.common.collect.Lists;
import com.xforceplus.api.model.ClientModel;
import com.xforceplus.business.client.service.ClientTenantRelService;
import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.dao.ClientDao;
import com.xforceplus.entity.Client;
import io.geewit.core.exception.ProcessedException;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.utils.uuid.UUID;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@CacheConfig(cacheNames={"clientInfo"})
public class ClientSecretService {
    private static final Logger logger = LoggerFactory.getLogger(ClientSecretService.class);
    @Resource
    private ClientDao clientDao;
    @Resource
    private ClientTenantRelService clientTenantRelService;
    @Resource
    UserService userService;

    @Transactional(rollbackFor={Exception.class})
    public Client create(Client client) {
        if (this.existsByClientId(client.getClientId())) {
            throw new IllegalArgumentException("\u91cd\u590d\u7684clientId");
        }
        if (client.getUserId() != null) {
            this.userService.findById(client.getUserId(), 0);
        }
        client.setSecret(UUID.randomUUID().toString());
        client = (Client)this.clientDao.saveAndFlush((Object)client);
        logger.info(client.toString());
        if (!CollectionUtils.isEmpty((Collection)client.getTenantIds())) {
            this.clientTenantRelService.createBatch(client.getClientId(), client.getTenantIds());
        }
        return client;
    }

    private boolean existsByClientId(String clientId) {
        List clients = this.clientDao.findByClientId(clientId);
        return clients != null && !clients.isEmpty();
    }

    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(cacheNames={"clientInfo"}, key="#clientId")
    public Client update(String clientId, Client client) {
        Client existClient = this.findById(clientId);
        if (client.getUserId() != null) {
            this.userService.findById(client.getUserId());
        }
        BeanUtils.copyProperties((Object)client, (Object)existClient, (String[])new String[]{"id"});
        if (!CollectionUtils.isEmpty((Collection)client.getTenantIds())) {
            this.clientTenantRelService.createBatch(clientId, client.getTenantIds());
        }
        return (Client)this.clientDao.saveAndFlush((Object)existClient);
    }

    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(cacheNames={"clientInfo"}, key="#clientId")
    public void delete(String clientId) {
        this.clientDao.deleteByClientId(clientId);
        this.clientTenantRelService.deleteByClientId(clientId);
    }

    @Cacheable(cacheNames={"clientInfo"}, key="#clientId")
    public Client findById(String clientId) {
        List clients = this.clientDao.findByClientId(clientId);
        if (clients == null || clients.isEmpty()) {
            throw new ProcessedException("\u672a\u627e\u5230\u5408\u6cd5\u7684client", HttpStatus.NOT_FOUND.value());
        }
        Client client = (Client)clients.stream().findFirst().get();
        List<Long> tenantIds = this.clientTenantRelService.findTenantIdByClientId(clientId);
        client.setTenantIds(tenantIds);
        return client;
    }

    public Client findOne(String clientId) {
        return this.findById(clientId);
    }

    public boolean existsByClientIdAndSecret(String clientId, String secret) {
        Client client = this.getByClientIdAndSecret(clientId, secret);
        return client != null;
    }

    public Client getByClientIdAndSecret(String clientId, String secret) {
        Client client = this.findById(clientId);
        if (client == null) {
            logger.warn("clientId not found");
            return null;
        }
        if (secret == null || !secret.equals(client.getSecret())) {
            logger.warn("wrong secret");
            return null;
        }
        if (client.getStatus() != null && client.getStatus().booleanValue()) {
            return client;
        }
        return null;
    }

    public Client findByClientIdAndSecret(String clientId, String secret) {
        Client client = this.getByClientIdAndSecret(clientId, secret);
        if (client == null) {
            throw new ProcessedException("client\u4e0d\u5408\u6cd5\u3002", HttpStatus.NOT_FOUND.value());
        }
        return client;
    }

    public List<Client> findAll() {
        return Lists.newArrayList((Iterable)this.clientDao.findAll());
    }

    public Page<Client> findAll(Pageable pageable) {
        return this.clientDao.findAll(pageable);
    }

    public List<Client> findBySecret(String secret) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get("secret"), (Object)secret)});
        return this.clientDao.findAll((Specification)specification);
    }

    public Page<Client> findByQuery(ClientModel.Request.Query query, Pageable pageable) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (query.getAppId() != null && query.getAppId() > 0) {
                predicates.add(builder.equal((Expression)root.get("appId"), (Object)query.getAppId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getClientId())) {
                predicates.add(builder.like((Expression)root.get("clientId"), "%" + query.getClientId() + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getClientName())) {
                predicates.add(builder.like((Expression)root.get("clientName"), "%" + query.getClientName() + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getUserId())) {
                predicates.add(builder.equal((Expression)root.get("userId"), (Object)query.getUserId()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return this.clientDao.findAll((Specification)specification, pageable);
    }

    public boolean existsBySecret(String secret) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get("secret"), (Object)secret)});
        return this.clientDao.count((Specification)specification) > 0L;
    }

    @CacheEvict(cacheNames={"clientInfo"}, key="#clientId")
    public Client bindUserId(String clientId, Long userId) {
        Client client = this.findById(clientId);
        if (client.getUserId() != null) {
            throw new ProcessedException("client\u5df2\u7ecf\u7ed1\u5b9a\u8fc7\u7528\u6237", "UCTSCM0003", HttpStatus.BAD_REQUEST.value());
        }
        this.userService.findById(userId, 0);
        client.setUserId(userId);
        return (Client)this.clientDao.save((Object)client);
    }

    @CacheEvict(cacheNames={"clientInfo"}, key="#clientId")
    public Client unbindUserId(String clientId) {
        Client client = this.findById(clientId);
        if (client.getUserId() == null) {
            throw new ProcessedException("client\u672a\u7ed1\u5b9a\u7528\u6237", "UCTSCM0003", HttpStatus.BAD_REQUEST.value());
        }
        client.setUserId(null);
        return (Client)this.clientDao.save((Object)client);
    }
}

