/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.client.service;

import com.google.common.collect.Lists;
import com.xforceplus.dao.ClientTenantRelDao;
import com.xforceplus.entity.ClientTenantRel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ClientTenantRelService {
    @Autowired
    private ClientTenantRelDao clientTenantRelDao;

    @Transactional(rollbackFor={Exception.class})
    public ClientTenantRel create(ClientTenantRel rel) {
        return (ClientTenantRel)this.clientTenantRelDao.saveAndFlush((Object)rel);
    }

    @Transactional(rollbackFor={Exception.class})
    public void createBatch(String clientId, List<Long> tenantIds) {
        this.clientTenantRelDao.deleteByClientId(clientId);
        if (!CollectionUtils.isEmpty(tenantIds)) {
            ArrayList<ClientTenantRel> rels = new ArrayList<ClientTenantRel>();
            for (Long tenantId : tenantIds) {
                ClientTenantRel rel = new ClientTenantRel();
                rel.setClientId(clientId);
                rel.setTenantId(tenantId);
                rels.add(rel);
            }
            this.clientTenantRelDao.saveAllAndFlush(rels);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteById(Long relId) {
        this.clientTenantRelDao.deleteById(relId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByClientId(String clientId) {
        this.clientTenantRelDao.deleteByClientId(clientId);
    }

    public List<ClientTenantRel> findByClientId(String clientId) {
        return this.clientTenantRelDao.findByClientId(clientId);
    }

    public List<Long> findTenantIdByClientId(String clientId) {
        return this.findByClientId(clientId).stream().map(t -> t.getTenantId()).collect(Collectors.toList());
    }

    public List<ClientTenantRel> findAll() {
        return Lists.newArrayList((Iterable)this.clientTenantRelDao.findAll());
    }
}

