/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.common.controller;

import com.xforceplus.business.company.service.CompanyService;
import com.xforceplus.business.tenant.service.OrgService;
import com.xforceplus.business.tenant.service.PreRoleService;
import com.xforceplus.business.tenant.service.RoleService;
import com.xforceplus.business.tenant.service.TenantService;
import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.User;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractController {
    private static final Logger logger = LoggerFactory.getLogger(AbstractController.class);
    @Autowired
    protected TenantService tenantService;
    @Autowired
    protected UserService userService;
    @Autowired
    protected OrgService orgService;
    @Autowired
    protected RoleService roleService;
    @Autowired
    protected PreRoleService preRoleService;
    @Autowired
    protected CompanyService companyService;

    public long toTenantId(String tenantKey, Boolean byCode) {
        if (StringUtils.isBlank((CharSequence)tenantKey)) {
            String message = "\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a(" + tenantKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        Long tenantId = null;
        String tenantCode = null;
        if (byCode != null && byCode.booleanValue()) {
            tenantCode = tenantKey;
        } else {
            try {
                tenantId = Long.parseLong(tenantKey);
            }
            catch (NumberFormatException e) {
                if (byCode != null) {
                    String message = "\u975e\u6cd5\u7684\u79df\u6237id(" + tenantKey + ")";
                    logger.warn(message);
                    throw new IllegalArgumentException(message);
                }
                logger.info(e.getMessage() + ", tenantKey: " + tenantKey);
                tenantCode = tenantKey;
            }
        }
        if (tenantId != null && !String.valueOf(tenantId).equals(tenantKey)) {
            tenantCode = tenantKey;
        }
        if (StringUtils.isNotBlank((CharSequence)tenantCode)) {
            tenantId = this.tenantService.findTenantByCode(tenantCode);
        }
        if (tenantId == null || tenantId <= 0L) {
            String message = "\u975e\u6cd5\u7684\u79df\u6237id(" + tenantId + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        return tenantId;
    }

    public Tenant toTenant(String tenantKey) {
        Tenant tenant;
        if (StringUtils.isBlank((CharSequence)tenantKey)) {
            String message = "\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a(" + tenantKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        try {
            tenant = this.tenantService.findById(Long.parseLong(tenantKey));
        }
        catch (NumberFormatException e) {
            String message = e.getMessage() + ", tenantKey: " + tenantKey;
            logger.warn(message);
            tenant = this.tenantService.findByCode(tenantKey);
        }
        if (tenant == null) {
            String message = "\u975e\u6cd5\u7684\u79df\u6237id(" + tenantKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        return tenant;
    }

    public long toUserId(long tenantId, String userKey, Boolean byCode) {
        Optional<User> userOptional;
        if (StringUtils.isBlank((CharSequence)userKey)) {
            String message = "\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a(" + userKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        Long userId = null;
        String userCode = null;
        if (byCode != null && byCode.booleanValue()) {
            userCode = userKey;
        } else {
            try {
                userId = Long.parseLong(userKey);
            }
            catch (NumberFormatException e) {
                if (byCode != null) {
                    String message = "\u975e\u6cd5\u7684\u7528\u6237id(" + userKey + ")";
                    logger.warn(message);
                    throw new IllegalArgumentException(message);
                }
                logger.info(e.getMessage() + ", userKey: " + userKey);
                userCode = userKey;
            }
        }
        if (userId != null && !String.valueOf(userId).equals(userKey)) {
            userCode = userKey;
        }
        if (StringUtils.isNotBlank((CharSequence)userCode) && (userOptional = this.userService.findUserByTenantIdAndUserCode(tenantId, userCode, false, null)).isPresent()) {
            userId = userOptional.get().getId();
        }
        if (userId == null || userId <= 0L) {
            String message = "\u975e\u6cd5\u7684\u7528\u6237id(" + userKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        return userId;
    }

    public long toOrgId(long tenantId, String orgKey, Boolean byCode) {
        boolean existOrg;
        if (StringUtils.isBlank((CharSequence)orgKey)) {
            String message = "\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a(" + orgKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        Long orgId = null;
        String orgCode = null;
        if (byCode != null && byCode.booleanValue()) {
            orgCode = orgKey;
        } else {
            try {
                orgId = Long.parseLong(orgKey);
            }
            catch (NumberFormatException e) {
                if (byCode != null) {
                    String message = "\u975e\u6cd5\u7684\u7ec4\u7ec7code(" + orgKey + ")";
                    logger.warn(message);
                    throw new IllegalArgumentException(message);
                }
                logger.info(e.getMessage() + ", orgKey: " + orgKey);
                orgCode = orgKey;
            }
        }
        if (orgId != null && !String.valueOf(orgId).equals(orgKey)) {
            orgCode = orgKey;
        }
        if (StringUtils.isNotBlank((CharSequence)orgCode)) {
            orgId = this.orgService.findIdByTenantIdAndCode(tenantId, orgCode);
        }
        if (orgId == null || orgId <= 0L) {
            String message = "\u975e\u6cd5\u7684\u7ec4\u7ec7code(" + orgKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        if (!(byCode != null && byCode.booleanValue() || (existOrg = this.orgService.existByTenantIdAndOrgId(tenantId, orgId)))) {
            String message = "\u975e\u6cd5\u7684\u7ec4\u7ec7id(" + orgKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        return orgId;
    }

    public OrgStruct toOrg(long tenantId, String orgKey, Boolean byCode) {
        String message;
        List<OrgStruct> orgs;
        if (StringUtils.isBlank((CharSequence)orgKey)) {
            String message2 = "\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a(" + orgKey + ")";
            logger.warn(message2);
            throw new IllegalArgumentException(message2);
        }
        Long orgId = null;
        String orgCode = null;
        if (byCode != null && byCode.booleanValue()) {
            orgCode = orgKey;
        } else {
            try {
                orgId = Long.parseLong(orgKey);
            }
            catch (NumberFormatException e) {
                if (byCode != null) {
                    String message3 = "\u975e\u6cd5\u7684\u7ec4\u7ec7code(" + orgKey + ")";
                    logger.warn(message3);
                    throw new IllegalArgumentException(message3);
                }
                logger.info(e.getMessage() + ", orgKey: " + orgKey);
                orgCode = orgKey;
            }
        }
        if (orgId != null && !String.valueOf(orgId).equals(orgKey)) {
            orgCode = orgKey;
        }
        if (StringUtils.isNotBlank((CharSequence)orgCode)) {
            orgs = this.orgService.findByTenantIdAndOrgCode(tenantId, orgCode);
            if (orgs.isEmpty()) {
                String message4 = "\u4e0d\u5b58\u5728\u7684\u7ec4\u7ec7code(" + orgKey + ")";
                logger.warn(message4);
                throw new IllegalArgumentException(message4);
            }
            if (orgs.size() > 1) {
                String message5 = "\u7ec4\u7ec7code(" + orgKey + ")\u5b58\u5728\u91cd\u590d";
                logger.warn(message5);
            }
        } else {
            String message6 = "\u7ec4\u7ec7code\u4e0d\u80fd\u4e3a\u7a7a";
            logger.warn(message6);
            throw new IllegalArgumentException(message6);
        }
        OrgStruct org = (OrgStruct)orgs.stream().findFirst().get();
        if (org == null) {
            message = "\u975e\u6cd5\u7684\u7ec4\u7ec7code(" + orgKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        if (!(byCode != null && byCode.booleanValue() || (org = this.orgService.findByTenantIdAndId(tenantId, orgId)) != null)) {
            message = "\u975e\u6cd5\u7684\u7ec4\u7ec7id(" + orgKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        return org;
    }

    public long toRoleId(long tenantId, String roleKey, Boolean byCode) {
        if (StringUtils.isBlank((CharSequence)roleKey)) {
            String message = "\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a(" + roleKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        Long roleId = null;
        String roleCode = null;
        if (byCode != null && byCode.booleanValue()) {
            roleCode = roleKey;
        } else {
            try {
                roleId = Long.parseLong(roleKey);
            }
            catch (NumberFormatException e) {
                if (byCode != null) {
                    String message = "\u975e\u6cd5\u7684\u89d2\u8272id(" + roleKey + ")";
                    logger.warn(message);
                    throw new IllegalArgumentException(message);
                }
                logger.info(e.getMessage() + ", roleKey: " + roleKey);
                roleCode = roleKey;
            }
        }
        if (roleId != null && !String.valueOf(roleId).equals(roleKey)) {
            roleCode = roleKey;
        }
        if (StringUtils.isNotBlank((CharSequence)roleCode)) {
            roleId = this.roleService.findIdByTenantIdAndCode(tenantId, roleCode);
        }
        if (roleId == null || roleId <= 0L) {
            String message = "\u975e\u6cd5\u7684\u89d2\u8272id(" + roleKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        return roleId;
    }

    public long toCompanyId(String companyKey, boolean byTaxNum) {
        Long companyId;
        if (StringUtils.isBlank((CharSequence)companyKey)) {
            String message = "\u516c\u53f8Key\u4e0d\u80fd\u4e3a\u7a7a(" + companyKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        if (!byTaxNum) {
            try {
                companyId = Long.parseLong(companyKey);
            }
            catch (NumberFormatException e) {
                String message = e.getMessage() + ", companyKey: " + companyKey;
                logger.info(message);
                Optional<Long> optional = this.companyService.findIdByTaxNum(companyKey);
                if (optional.isPresent()) {
                    companyId = optional.get();
                }
                message = "\u975e\u6cd5\u7684\u516c\u53f8\u7a0e\u53f7(" + companyKey + ")";
                logger.warn(message);
                throw new IllegalArgumentException(message);
            }
        } else {
            Optional<Long> optional = this.companyService.findIdByTaxNum(companyKey);
            if (optional.isPresent()) {
                companyId = optional.get();
            } else {
                String message = "\u975e\u6cd5\u7684\u516c\u53f8\u7a0e\u53f7(" + companyKey + ")";
                logger.warn(message);
                throw new IllegalArgumentException(message);
            }
        }
        return companyId;
    }
}

