/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.company.CompanyApplyApi;
import com.xforceplus.api.model.CompanyApplyModel;
import com.xforceplus.business.company.service.CompanyApplyService;
import com.xforceplus.entity.CompanyApply;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.swagger.annotations.Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;

@Api(value="\u516c\u53f8\u76f8\u5173\u63a5\u53e3", description="\u516c\u53f8\u76f8\u5173\u63a5\u53e3")
@Validated
@Controller
public class CompanyApplyController
implements CompanyApplyApi {
    private static final Logger logger = LoggerFactory.getLogger(CompanyApplyController.class);
    private final CompanyApplyService companyApplyService;

    public CompanyApplyController(CompanyApplyService companyApplyService) {
        this.companyApplyService = companyApplyService;
    }

    @AuthorizedDefinition(resources={"xforce:business:company-apply:read"})
    public ResponseEntity<Page<CompanyApply>> page(CompanyApplyModel.Request.Query query, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Page<CompanyApply> page = this.companyApplyService.page(query, currentPageable);
        return ResponseEntity.ok(page);
    }

    @AuthorizedDefinition(resources={"xforce:business:company-apply:read"})
    public ResponseEntity<CompanyApply> info(long applicationId) {
        CompanyApply result = this.companyApplyService.findById(applicationId);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:business:company-apply:save"})
    public ResponseEntity<String> approve(long applicationId, String reason) {
        this.companyApplyService.approve(applicationId, reason);
        return ResponseEntity.ok((Object)"\u5ba1\u6838\u901a\u8fc7\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:business:company-apply:save"})
    public ResponseEntity<String> decline(long applicationId, String reason) {
        this.companyApplyService.decline(applicationId, reason);
        return ResponseEntity.ok((Object)"\u5ba1\u6838\u9a73\u56de\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:business:company-apply:save"})
    public ResponseEntity<CompanyApplyModel.Response.ApplicationProcessResult> batchApprove(CompanyApplyModel.Request.ApplicationProcess applicationProcess) {
        CompanyApplyModel.Response.ApplicationProcessResult result = this.companyApplyService.approve(applicationProcess);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:business:company-apply:save"})
    public ResponseEntity<CompanyApplyModel.Response.ApplicationProcessResult> batchDecline(CompanyApplyModel.Request.ApplicationProcess applicationProcess) {
        CompanyApplyModel.Response.ApplicationProcessResult result = this.companyApplyService.decline(applicationProcess);
        return ResponseEntity.ok((Object)result);
    }
}

