/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.controller;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.current.company.CompanyApi;
import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.business.common.controller.AbstractController;
import com.xforceplus.business.company.controller.vo.CompanyImportExcelRespVo;
import com.xforceplus.business.company.dto.CompanyTaxwareDto;
import com.xforceplus.business.company.service.CompanyExtensionService;
import com.xforceplus.business.company.service.CompanyProcess;
import com.xforceplus.business.excel.ExcelService;
import com.xforceplus.business.excel.QueryParam;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.file.controller.vo.ImportFileRespVo;
import com.xforceplus.business.file.service.ExportFileService;
import com.xforceplus.business.file.service.ImportFileService;
import com.xforceplus.business.tenant.service.TenantService;
import com.xforceplus.business.tenant.service.WrapperOrgService;
import com.xforceplus.domain.company.CompanyPackage;
import com.xforceplus.domain.validation.ValidationGroup;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.ExcelFileStore;
import com.xforceplus.entity.Tenant;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.utils.DateUtils;
import io.geewit.core.jackson.view.View;
import io.geewit.data.jpa.envers.domain.ComparedRevision;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.geewit.data.jpa.essential.domain.SortFactory;
import io.geewit.data.jpa.essential.search.DynamicSpecifications;
import io.geewit.data.jpa.essential.search.SearchFilter;
import io.geewit.data.jpa.essential.web.servlet.Servlets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u516c\u53f8\u76f8\u5173\u63a5\u53e3", description="\u516c\u53f8\u76f8\u5173\u63a5\u53e3")
@Validated
@Controller
public class CompanyController
extends AbstractController
implements com.xforceplus.api.global.company.CompanyApi,
com.xforceplus.api.tenant.company.CompanyApi,
CompanyApi {
    private static final Logger logger = LoggerFactory.getLogger(CompanyController.class);
    private final WrapperOrgService orgService;
    private final TenantService tenantService;
    private final ExcelService excelService;
    private final CompanyExtensionService companyExtensionService;
    private final CompanyProcess companyProcess;
    private final ImportFileService importFileService;
    private final ExportFileService exportFileService;
    @Value(value="${company.move.hour:19}")
    private Integer companyMoveHour;
    @Value(value="${xforce.it.callback.enabled:false}")
    private boolean callbackEnabled;

    public CompanyController(WrapperOrgService orgService, TenantService tenantService, ExcelService excelService, CompanyExtensionService companyExtensionService, ImportFileService importFileService, ExportFileService exportFileService, CompanyProcess companyProcess) {
        this.orgService = orgService;
        this.tenantService = tenantService;
        this.excelService = excelService;
        this.importFileService = importFileService;
        this.companyExtensionService = companyExtensionService;
        this.exportFileService = exportFileService;
        this.companyProcess = companyProcess;
    }

    @AuthorizedDefinition(resources={"xforce:business:company:read"})
    @ApiIgnore
    @JsonView(value={View.Page.class})
    @ApiOperation(value="\u83b7\u53d6\u516c\u53f8\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u516c\u53f8\u5206\u9875")
    @ResponseBody
    @RequestMapping(name="\u516c\u53f8\u5206\u9875\u5217\u8868\u67e5\u8be2", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/query"}, method={RequestMethod.GET})
    public Page<Company> page(WebRequest request, @ApiParam(value="pageable") Pageable pageable) {
        Map searchParams = Servlets.getParametersStartingWith((WebRequest)request, (String)"search_");
        Collection filters = SearchFilter.parse((Map)searchParams);
        Specification specification = DynamicSpecifications.bySearchFilter((Collection)filters);
        Page<Company> page = this.companyService.page((Specification<Company>)specification, pageable);
        return page;
    }

    @AuthorizedDefinition(resources={"xforce:business:company:read"})
    @JsonView(value={View.Page.class})
    @ApiOperation(value="\u83b7\u53d6\u516c\u53f8\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u516c\u53f8\u5206\u9875")
    public ResponseEntity<Page<Company>> page(@ApiParam(value="request") CompanyModel.Request.Query query, @ApiParam(value="pageable") Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Page<Company> result = this.companyService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @ResponseBody
    @ApiOperation(value="\u516c\u53f8\u4fe1\u606f\u6279\u91cf\u5bfc\u51fa\uff08\u5f02\u6b65\uff09", notes="\u516c\u53f8\u4fe1\u606f\u6279\u91cf\u5bfc\u51fa\uff08\u5f02\u6b65\uff09")
    @RequestMapping(name="\u516c\u53f8\u4fe1\u606f\u6279\u91cf\u5bfc\u51fa\uff08\u5f02\u6b65\uff09", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/export"}, method={RequestMethod.POST})
    public ResponseEntity<ImportFileRespVo> exportCompany(@ApiParam(value="request") @RequestBody CompanyModel.Request.Query query, @ApiParam(value="sort") Sort sort) {
        if (ArrayUtils.isEmpty((Object[])query.getSheets())) {
            throw new IllegalArgumentException("\u8bf7\u9009\u62e9SheetName");
        }
        QueryParam queryParam = QueryParam.builder().param("P_QUERY", query).param("P_SORT", sort).build();
        ExcelFileStore excelFileStore = this.exportFileService.asyncExcelExport(queryParam.params(), ExcelConfigBusinessType.COMPANY_EXCEL_FILE);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setId(excelFileStore.getId());
        respVo.setBusinessType(ExcelConfigBusinessType.COMPANY_EXCEL_FILE.getBusinessName());
        return ResponseEntity.ok((Object)respVo);
    }

    @ResponseBody
    @ApiOperation(value="\u6279\u91cf\u670d\u52a1\u914d\u7f6e\u5f02\u6b65\u5bfc\u51fa", notes="\u6279\u91cf\u670d\u52a1\u914d\u7f6e\u5f02\u6b65\u5bfc\u51fa")
    @RequestMapping(name="\u6279\u91cf\u670d\u52a1\u914d\u7f6e\u5f02\u6b65\u5bfc\u51fa", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/configuration/export"}, method={RequestMethod.POST})
    public ResponseEntity<ImportFileRespVo> exportCompanyConfig(@ApiParam(value="request") @RequestBody CompanyModel.Request.Query query, @ApiParam(value="sort") Sort sort) {
        if (ArrayUtils.isEmpty((Object[])query.getSheets())) {
            throw new IllegalArgumentException("\u8bf7\u9009\u62e9SheetName");
        }
        QueryParam queryParam = QueryParam.builder().param("P_QUERY", query).param("P_SORT", sort).build();
        ExcelFileStore excelFileStore = this.exportFileService.asyncExcelExport(queryParam.params(), ExcelConfigBusinessType.COMPANY_CONFIG_EXCEL_FILE);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setId(excelFileStore.getId());
        respVo.setBusinessType(ExcelConfigBusinessType.COMPANY_EXCEL_FILE.getBusinessName());
        return ResponseEntity.ok((Object)respVo);
    }

    @AuthorizedDefinition(resources={"xforce:business:company:read"})
    @ApiIgnore
    @JsonView(value={View.List.class})
    @ApiOperation(value="\u83b7\u53d6\u516c\u53f8\u5217\u8868", notes="\u901a\u8fc7\u53c2\u6570\uff0c\u83b7\u53d6\u516c\u53f8\u5217\u8868")
    @ResponseBody
    @RequestMapping(name="\u516c\u53f8\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/list"}, method={RequestMethod.GET})
    public ResponseEntity<List<Company>> list(CompanyModel.Request.Query query, Sort sort) {
        List<Company> result = this.companyService.list(query, sort);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:business:company:read"})
    @JsonView(value={View.Info.class})
    @ApiOperation(value="\u83b7\u53d6\u516c\u53f8\u8be6\u60c5", notes="\u901a\u8fc7id\uff0c\u83b7\u53d6\u516c\u53f8\u8be6\u60c5")
    public ResponseEntity<Company> info(@ApiParam(value="companyKey", required=true) String companyKey, @ApiParam(value="byTaxNum", defaultValue="false") boolean byTaxNum, @ApiParam(value="revisionDate") Date revisionDate, @ApiParam(value="withExtendParams") String withExtendParams) {
        long companyId = super.toCompanyId(companyKey, byTaxNum);
        Object[] withExtendParamArray = StringUtils.split((String)withExtendParams, (String)",");
        Set<String> withExtendParamSet = ArrayUtils.isEmpty((Object[])withExtendParamArray) ? Collections.emptySet() : Arrays.stream(withExtendParamArray).filter(Objects::nonNull).map(String::trim).collect(Collectors.toSet());
        Company result = this.companyService.findByIdAndStatusAndRevisionDate(companyId, 1, revisionDate, withExtendParamSet);
        return ResponseEntity.ok((Object)result);
    }

    @ApiOperation(value="\u516c\u53f8\u5ba1\u8ba1\u8868\u66f4\u65b0\u662f\u5426\u6709\u6548")
    public ResponseEntity<String> updateRevisionEffective(@ApiParam(value="companyKey", required=true) String companyKey, @ApiParam(value="byTaxNum", required=false, defaultValue="false") boolean byTaxNum, long revision, Boolean effective) {
        long companyId = super.toCompanyId(companyKey, byTaxNum);
        boolean result = this.companyService.updateAuditEffective(companyId, revision, effective);
        if (result) {
            return ResponseEntity.ok((Object)"\u66f4\u65b0\u6210\u529f");
        }
        return ResponseEntity.ok((Object)"\u66f4\u65b0\u5931\u8d25");
    }

    public ResponseEntity<Page<ComparedRevision<Company, String>>> histories(@ApiParam(value="companyKey", required=true) String companyKey, @ApiParam(value="byTaxNum", required=false, defaultValue="false") boolean byTaxNum, Pageable pageable) {
        long companyId = super.toCompanyId(companyKey, byTaxNum);
        Page<ComparedRevision<Company, String>> page = this.companyService.findCompanyHistories(companyId, pageable);
        return ResponseEntity.ok(page);
    }

    @AuthorizedDefinition(resources={"xforce:business:company:save"})
    @JsonView(value={View.Info.class})
    @ApiOperation(value="\u66f4\u65b0\u516c\u53f8\u4fe1\u606f", notes="\u901a\u8fc7\u53c2\u6570\uff0c\u66f4\u65b0\u516c\u53f8\u4fe1\u606f")
    public ResponseEntity<Company> update(@ApiParam(value="companyKey", required=true) String companyKey, @ApiParam(value="byTaxNum", required=false, defaultValue="false") boolean byTaxNum, @ApiParam(value="model", required=true) CompanyModel.Request.Save model) {
        long companyId = super.toCompanyId(companyKey, byTaxNum);
        Company result = this.companyService.update(companyId, model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:business:company:save"})
    @JsonView(value={View.Info.class})
    @ApiOperation(value="\u66f4\u65b0\u516c\u53f8\u72b6\u6001", notes="\u901a\u8fc7\u53c2\u6570\uff0c\u66f4\u65b0\u516c\u53f8\u4fe1\u606f")
    public ResponseEntity<String> updateStatus(@ApiParam(value="companyKey", required=true) String companyKey, @ApiParam(value="byTaxNum", required=false, defaultValue="false") boolean byTaxNum, @ApiParam(value="status", required=true) int status) {
        long companyId = super.toCompanyId(companyKey, byTaxNum);
        this.companyService.updateStatus(companyId, status);
        return ResponseEntity.ok((Object)"\u66f4\u65b0\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:business:company:read"})
    @JsonView(value={View.Page.class})
    @ApiOperation(value="\u83b7\u53d6\u516c\u53f8\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u516c\u53f8\u5206\u9875")
    public ResponseEntity<Page<Company>> page(@ApiParam(value="tenantKey", required=true) String tenantKey, @ApiParam(value="request") CompanyModel.Request.Query query, @ApiParam(value="pageable") Pageable pageable) {
        long tenantId = super.toTenantId(tenantKey, query.getByTenantCode());
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Page<Company> result = this.companyService.page(tenantId, query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:business:company:read"})
    @ApiIgnore
    @JsonView(value={View.List.class})
    @ApiOperation(value="\u83b7\u53d6\u516c\u53f8\u5217\u8868", notes="\u901a\u8fc7\u53c2\u6570\uff0c\u83b7\u53d6\u516c\u53f8\u5217\u8868")
    @ResponseBody
    @RequestMapping(name="\u516c\u53f8\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/{tenantKey}${xforce.tenant.service.version:}/companies/list"}, method={RequestMethod.GET})
    public ResponseEntity<List<Company>> list(@PathVariable(value="tenantKey") String tenantKey, CompanyModel.Request.Query query, Sort sort) {
        long tenantId = super.toTenantId(tenantKey, query.getByTenantCode());
        Sort currentSort = SortFactory.ofDefaultSort((Sort)sort, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        List<Company> result = this.companyService.list(tenantId, query, currentSort);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:business:company:read"})
    @JsonView(value={View.Info.class})
    @ApiOperation(value="\u83b7\u53d6\u516c\u53f8\u8be6\u60c5")
    public ResponseEntity<Company> info(@ApiParam(value="tenantKey", required=true) String tenantKey, @ApiParam(value="companyKey", required=true) String companyKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byTaxNum", required=false, defaultValue="false") boolean byTaxNum, @ApiParam(value="revisionDate", required=false) Date revisionDate, @ApiParam(value="withExtendParams") String withExtendParams) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long companyId = super.toCompanyId(companyKey, byTaxNum);
        Object[] withExtendParamArray = StringUtils.split((String)withExtendParams, (String)",");
        Set<String> withExtendParamSet = ArrayUtils.isEmpty((Object[])withExtendParamArray) ? Collections.emptySet() : Arrays.stream(withExtendParamArray).filter(Objects::nonNull).map(String::trim).collect(Collectors.toSet());
        Company result = this.companyService.revisionInfo(tenantId, companyId, revisionDate, withExtendParamSet);
        return ResponseEntity.ok((Object)result);
    }

    public ResponseEntity<Page<ComparedRevision<Company, String>>> histories(@ApiParam(value="tenantKey", required=true) String tenantKey, @ApiParam(value="companyKey", required=true) String companyKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byTaxNum", required=false, defaultValue="false") boolean byTaxNum, Pageable pageable) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long companyId = super.toCompanyId(companyKey, byTaxNum);
        Company company = this.companyService.findByTenantIdAndId(tenantId, companyId);
        Page<ComparedRevision<Company, String>> page = this.companyService.findCompanyHistories(companyId, pageable);
        return ResponseEntity.ok(page);
    }

    @AuthorizedDefinition(resources={"xforce:business:company:save"})
    @JsonView(value={View.Info.class})
    @ApiOperation(value="\u5728\u79df\u6237\u4e0b\u521b\u5efa\u516c\u53f8")
    public ResponseEntity<Company> create(String tenantKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, CompanyModel.Request.Save model) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        Tenant tenant = this.tenantService.findById(tenantId);
        Optional<Company> optionalCompany = this.companyService.findOneByTaxNum(model.getTaxNum());
        if (optionalCompany.isPresent()) {
            throw new IllegalArgumentException("\u7a0e\u53f7\u4e3a\uff1a" + model.getTaxNum() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u516c\u53f8\u7a0e\u53f7");
        }
        Company result = this.orgService.saveCompany(tenant, model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:business:company:save"})
    @JsonView(value={View.Info.class})
    @ApiOperation(value="\u4fee\u6539\u516c\u53f8\u8be6\u60c5")
    public ResponseEntity<Company> update(@ApiParam(value="tenantKey", required=true) String tenantKey, @ApiParam(value="companyKey", required=true) String companyKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byTaxNum", required=false, defaultValue="false") boolean byTaxNum, @ApiParam(value="model", required=true) @Validated(value={ValidationGroup.OnUpdate.class}) CompanyModel.Request.Save model) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long companyId = super.toCompanyId(companyKey, byTaxNum);
        Company result = this.companyService.update(tenantId, companyId, model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:business:company-service-package:read"})
    @ApiOperation(value="\u516c\u53f8\u670d\u52a1\u5305\u5206\u9875\u67e5\u8be2")
    public ResponseEntity<Page<CompanyPackage>> packages(CompanyModel.Request.CompanyPackageQuery query, Pageable pageable) {
        Page<CompanyPackage> result = this.companyService.packagesByQuery(query, pageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:business:company:read"})
    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u5386\u53f2\u4e0a\u5b58\u5728\u8be5\u516c\u53f8\u540d\u53ca\u7a0e\u53f7")
    public ResponseEntity<Boolean> existInHistory(String taxNum, String companyName, Date effectiveDate) {
        boolean exist = this.companyService.existInHistory(taxNum, companyName, effectiveDate);
        return ResponseEntity.ok((Object)exist);
    }

    @AuthorizedDefinition(resources={"xforce:business:company-service-package:save"})
    @ApiOperation(value="\u516c\u53f8\u7ed1\u5b9a\u670d\u52a1\u5305")
    public ResponseEntity<String> bindPackages(String tenantKey, String companyKey, @ApiParam(value="byTenantCode", required=false) Boolean byTenantCode, @ApiParam(value="byTaxNum", required=false, defaultValue="false") boolean byTaxNum, CompanyModel.Request.BindPackages bindPackage) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long companyId = super.toCompanyId(companyKey, byTaxNum);
        this.companyService.bindPackages(tenantId, companyId, bindPackage);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @Deprecated
    @AuthorizedDefinition(resources={"xforce:business:company:save"})
    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165\u4f01\u4e1aexcel")
    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u5bfc\u5165\u4f01\u4e1aexcel", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/import"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity batchImport(@RequestParam(value="file") MultipartFile file) {
        return this.excelService.batchImportCompanies(file);
    }

    @AuthorizedDefinition(resources={"xforce:business:company:save"})
    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165\u4f01\u4e1a\u670d\u52a1\u914d\u7f6eexcel")
    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u5bfc\u5165\u4f01\u4e1a\u670d\u52a1\u914d\u7f6eexcel", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/configuration/import"}, produces={"application/json"}, method={RequestMethod.POST})
    @Deprecated
    public ResponseEntity<Long> batchImportConfiguration(@RequestParam(value="file") MultipartFile file) {
        return this.companyService.batchImportConfiguration(file);
    }

    @AuthorizedDefinition(resources={"xforce:business:company:save"})
    @ApiOperation(value="\u4fee\u590d\u79df\u6237\u516c\u53f8\u5173\u7cfb")
    @ResponseBody
    @RequestMapping(name="\u4fee\u590d\u79df\u6237\u516c\u53f8\u5173\u7cfb", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/fix"}, method={RequestMethod.POST})
    public ResponseEntity<String> fixTenantCompanies() {
        this.companyService.fixTenantCompanies();
        return ResponseEntity.ok((Object)"\u4fee\u590d\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:business:company:save"})
    @ApiOperation(value="\u5f02\u6b65\u6279\u91cf\u5bfc\u5165\u4f01\u4e1aexcel")
    @ResponseBody
    @RequestMapping(name="\u5f02\u6b65\u5bfc\u5165\u4f01\u4e1aexcel", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/asnyc/import"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<CompanyImportExcelRespVo> batchAsnycImport(@RequestParam(value="file") MultipartFile file) {
        Long tenantId = 0L;
        Long userId = 0L;
        if (null != UserInfoHolder.get()) {
            tenantId = UserInfoHolder.get().getTenantId();
            userId = UserInfoHolder.get().getId();
        }
        ExcelFileStore excelFileStore = this.importFileService.create(file, ExcelConfigBusinessType.COMPANY_EXCEL_FILE, userId, tenantId);
        CompanyImportExcelRespVo respVo = new CompanyImportExcelRespVo();
        respVo.setBusinessType(ExcelConfigBusinessType.COMPANY_EXCEL_FILE.getName());
        respVo.setFileId(excelFileStore.getSourceFileId());
        respVo.setId(excelFileStore.getId());
        return ResponseEntity.ok((Object)respVo);
    }

    @ApiOperation(value="\u5f53\u524d\u767b\u5f55\u7528\u6237\u516c\u53f8\u4fe1\u606f")
    public ResponseEntity<Company> currentInfo(String companyKey, @ApiParam(value="byTaxNum", required=false, defaultValue="false") boolean byTaxNum, Date revisionDate, String withExtendParams) {
        long companyId = super.toCompanyId(companyKey, byTaxNum);
        Object[] withExtendParamArray = StringUtils.split((String)withExtendParams, (String)",");
        Set<String> withExtendParamSet = ArrayUtils.isEmpty((Object[])withExtendParamArray) ? Collections.emptySet() : Arrays.stream(withExtendParamArray).filter(Objects::nonNull).map(String::trim).collect(Collectors.toSet());
        Company result = this.companyService.currentInfo(companyId, 1, revisionDate, withExtendParamSet);
        return ResponseEntity.ok((Object)result);
    }

    public ResponseEntity<Page<ComparedRevision<Company, String>>> currentHistories(@ApiParam(value="companyKey", required=true) String companyKey, @ApiParam(value="byTaxNum", required=false, defaultValue="false") boolean byTaxNum, Pageable pageable) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        return this.histories(String.valueOf(tenantId), companyKey, false, byTaxNum, pageable);
    }

    public ResponseEntity<Page<CompanyPackage>> currentPackages(CompanyModel.Request.CompanyPackageQuery query, Pageable pageable) {
        Page<CompanyPackage> result = this.companyService.currentPackagesByQuery(query, pageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:business:company:save"})
    @ApiOperation(value="\u516c\u53f8\u670d\u52a1\u914d\u7f6e\u6587\u4ef6\u5bfc\u5165\u4e0a\u4f20")
    @ResponseBody
    @RequestMapping(name="\u516c\u53f8\u670d\u52a1\u914d\u7f6e\u6587\u4ef6\u5bfc\u5165\u4e0a\u4f20", value={"/api/global/company/file/excel"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<ImportFileRespVo> uploadExcelFile(@RequestParam(value="file") MultipartFile file) {
        Long tenantId = 0L;
        Long userId = 0L;
        if (null != UserInfoHolder.get()) {
            tenantId = UserInfoHolder.get().getTenantId();
            userId = UserInfoHolder.get().getId();
        }
        ExcelFileStore excelFileStore = this.importFileService.createAndSaveFile(file, ExcelConfigBusinessType.COMPANY_CONFIG_EXCEL_FILE.name(), userId, tenantId);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setBusinessType(ExcelConfigBusinessType.COMPANY_CONFIG_EXCEL_FILE.name());
        respVo.setFileId(excelFileStore.getSourceFileId());
        respVo.setId(excelFileStore.getId());
        return ResponseEntity.ok((Object)respVo);
    }

    @AuthorizedDefinition(resources={"xforce:business:company:save"})
    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u516c\u53f8\uff08\u540d\u79f0\u548c\u7a0e\u53f7\uff09excel")
    @ResponseBody
    @RequestMapping(name="\u6279\u91cf\u4fee\u6539\u516c\u53f8\uff08\u540d\u79f0\u548c\u7a0e\u53f7\uff09excel", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/name-tax-num/import"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<ImportFileRespVo> batchImportUpdate(@RequestParam(value="file") MultipartFile file) {
        IAuthorizedUser currentUser = UserInfoHolder.currentUser();
        Long tenantId = currentUser.getTenantId();
        Long userId = currentUser.getId();
        String businessType = ExcelConfigBusinessType.COMPANY_NAME_TAX_NUM_IMPORT.name();
        ExcelFileStore excelFileStore = this.importFileService.createAndSaveFile(file, businessType, userId, tenantId);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setBusinessType(businessType);
        respVo.setFileId(excelFileStore.getSourceFileId());
        respVo.setId(excelFileStore.getId());
        return ResponseEntity.ok((Object)respVo);
    }

    @ApiOperation(value="\u7ec4\u7ec7\u516c\u53f8\u7f16\u53f7\u5bfc\u5165excel")
    @ResponseBody
    @RequestMapping(name="\u7ec4\u7ec7\u516c\u53f8\u7f16\u53f7\u6279\u91cf\u5bfc\u5165excel", value={"${xforce.tenant.service.url.prefix:/api}/current${xforce.tenant.service.version:}/companies/org-company-number/import"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<ImportFileRespVo> batchImportOrgCompanyNumber(@RequestParam(value="file") MultipartFile file) {
        Long tenantId = 0L;
        Long userId = 0L;
        if (null != UserInfoHolder.get()) {
            tenantId = UserInfoHolder.get().getTenantId();
            userId = UserInfoHolder.get().getId();
        }
        String businessType = ExcelConfigBusinessType.ORG_COMPANY_NUM_IMPORT.name();
        ExcelFileStore excelFileStore = this.importFileService.createAndSaveFile(file, businessType, userId, tenantId);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setBusinessType(businessType);
        respVo.setFileId(excelFileStore.getSourceFileId());
        respVo.setId(excelFileStore.getId());
        return ResponseEntity.ok((Object)respVo);
    }

    @AuthorizedDefinition(resources={"xforce:business:company:move"})
    public ResponseEntity<Map<String, Object>> move(String companyKey, CompanyModel.Request.Move move) {
        long companyId = super.toCompanyId(companyKey, move.getByTaxNum());
        move.setCompanyId(Long.valueOf(companyId));
        long startTime = DateUtils.getCustomTime((int)this.companyMoveHour, (int)0, (int)0);
        long currentTime = System.currentTimeMillis();
        if (currentTime < startTime) {
            throw new IllegalArgumentException("\u8bf7\u5728" + this.companyMoveHour + ":00:00\u81f323:59:59\u53d1\u8d77\u8bf7\u6c42\uff01");
        }
        Map<String, Object> result = this.companyService.move(move);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:business:company:move"})
    public ResponseEntity<Map<String, Object>> moveAll(String companyKey, CompanyModel.Request.Move move) {
        long companyId = super.toCompanyId(companyKey, move.getByTaxNum());
        move.setCompanyId(Long.valueOf(companyId));
        long startTime = DateUtils.getCustomTime((int)this.companyMoveHour, (int)0, (int)0);
        long currentTime = System.currentTimeMillis();
        if (currentTime < startTime) {
            throw new IllegalArgumentException("\u8bf7\u5728" + this.companyMoveHour + ":00:00\u81f323:59:59\u53d1\u8d77\u8bf7\u6c42\uff01");
        }
        Map<String, Object> result = this.companyService.moveAll(move);
        return ResponseEntity.ok(result);
    }

    @ApiOperation(value="\u516c\u53f8\u5173\u8054\u79df\u6237\u8be6\u60c5\u5217\u8868")
    public ResponseEntity<CompanyModel.Response.CompanyInfo> tenantRels(String companyKey, @ApiParam(value="byTaxNum", required=false, defaultValue="false") boolean byTaxNum) {
        long companyId = super.toCompanyId(companyKey, byTaxNum);
        CompanyModel.Response.CompanyInfo result = this.companyService.findCompanyInfoByCompanyId(companyId);
        return ResponseEntity.ok((Object)result);
    }

    @ApiOperation(value="\u4fee\u6539\u516c\u53f8\u540d\u79f0")
    public ResponseEntity<String> updateCompanyName(String tenantKey, Boolean byTenantCode, CompanyModel.Request.CompanyName companyName) {
        Long currentTenantId;
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        if (null != UserInfoHolder.get() && ((currentTenantId = UserInfoHolder.get().getTenantId()) == null || currentTenantId != tenantId)) {
            throw new IllegalArgumentException("\u79df\u6237\u4fe1\u606f\u4e0e\u5f53\u524d\u7528\u6237\u4e0d\u5339\u914d\uff01");
        }
        this.companyService.updateCompanyName(tenantId, companyName);
        return ResponseEntity.ok((Object)"Success");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org:terminal"})
    @ApiOperation(value="\u8bbe\u7f6e\u6216\u8005\u66f4\u65b0\u516c\u53f8\u7ec8\u7aef\u9274\u6743")
    public ResponseEntity<Boolean> setCompanyTerminalAuthSwitch(@ApiParam(name="tenantKey", value="\u79df\u6237ID(tenantId)") String tenantKey, @ApiParam(name="companyKey", value="\u516c\u53f8ID\u6216\u8005\u7a0e\u53f7") String companyKey, @ApiParam(name="byTenantCode", value="\u662f\u5426\u6309\u79df\u6237Code\u67e5", required=false, defaultValue="false") Boolean byTenantCode, @ApiParam(name="byTaxNum", value="\u6839\u636e\u7a0e\u53f7\u8fd8\u662f\u516c\u53f8ID\u64cd\u4f5c\uff0ctrue\u6309\u7a0e\u53f7\uff0cfalse\u6309\u516c\u53f8ID", defaultValue="false") Boolean byTaxNum, @ApiParam(name="terminalSwitch", value="\u7ec8\u7aef\u9274\u6743\u5f00\u5173\uff0c1\u8868\u793a\u6253\u5f00\uff0c0\u5173\u95ed") int terminalSwitch) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long companyId = super.toCompanyId(companyKey, byTaxNum);
        boolean result = this.companyExtensionService.setTerminalSwitch(tenantId, companyId, terminalSwitch);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org:terminal"})
    @ApiOperation(value="\u67e5\u8be2\u516c\u53f8\u7ec8\u7aef\u9274\u6743\u5f00\u5173\u72b6\u6001")
    public ResponseEntity<Integer> getCompanyTerminalAuthSwitch(@ApiParam(name="tenantKey", value="\u79df\u6237ID(tenantId)") String tenantKey, @ApiParam(name="companyKey", value="\u516c\u53f8ID\u6216\u8005\u7a0e\u53f7") String companyKey, @ApiParam(name="byTenantCode", value="\u662f\u5426\u6309\u79df\u6237Code\u67e5", required=false, defaultValue="false") Boolean byTenantCode, @ApiParam(name="byTaxNum", value="\u6839\u636e\u7a0e\u53f7\u8fd8\u662f\u516c\u53f8ID\u64cd\u4f5c\uff0ctrue\u6309\u7a0e\u53f7\uff0cfalse\u6309\u516c\u53f8ID", defaultValue="false") Boolean byTaxNum) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long companyId = super.toCompanyId(companyKey, byTaxNum);
        Integer termanalSwitch = this.companyExtensionService.getCompanyTerminalSwitch(tenantId, companyId);
        return ResponseEntity.ok((Object)termanalSwitch);
    }

    @ApiOperation(value="\u9a8c\u8bc1\u79df\u6237\u4e0b\u516c\u6307\u5b9a\u516c\u53f8\u7684\u591a\u4e2a\u670d\u52a1\u5305\u662f\u5426\u88ab\u89d2\u8272\u7ed1\u5b9a")
    public ResponseEntity<Map<Long, Boolean>> validCompaniesPackagesBound(@ApiParam(name="tenantKey", value="\u79df\u6237ID(tenantId)") String tenantKey, @ApiParam(name="companyKey", value="\u516c\u53f8ID\u6216\u8005\u7a0e\u53f7") String companyKey, @ApiParam(name="byTenantCode", value="\u662f\u5426\u6309\u79df\u6237Code\u67e5", required=false, defaultValue="false") Boolean byTenantCode, @ApiParam(name="byTaxNum", value="\u6839\u636e\u7a0e\u53f7\u8fd8\u662f\u516c\u53f8ID\u64cd\u4f5c, true\u6309\u7a0e\u53f7, false\u6309\u516c\u53f8ID", defaultValue="false") Boolean byTaxNum, @ApiParam(name="packageIds", value="\u670d\u52a1\u5305id\u96c6\u5408, \u2018,\u2019\u5206\u5272") String packageIds) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        long companyId = super.toCompanyId(companyKey, byTaxNum);
        HashSet<Long> packageIdSet = new HashSet<Long>();
        for (String packageIdStr : StringUtils.split((String)packageIds, (String)",")) {
            try {
                Long packageId = Long.parseLong(packageIdStr);
                packageIdSet.add(packageId);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Map<Long, Boolean> result = this.companyService.validateCompanyPackagesWereBoundByRole(tenantId, companyId, packageIdSet);
        return ResponseEntity.ok(result);
    }

    public ResponseEntity<String> changeHostTenant(Long companyId, Long tenantId) {
        this.companyService.changeHostTenant(companyId, tenantId);
        return ResponseEntity.ok();
    }

    @ResponseBody
    @PostMapping(name="\u96c6\u6210\u5e73\u53f0\u56de\u8c03\u7a0e\u4ef6\u63a8\u9001\u6d88\u606f\u63a5\u53e3", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/callback"})
    @ApiOperation(value="\u96c6\u6210\u5e73\u53f0\u56de\u8c03\u7a0e\u4ef6\u63a8\u9001\u6d88\u606f\u63a5\u53e3")
    public ResponseEntity<Boolean> taxwareMsgCallBack(@RequestBody CompanyTaxwareDto companyTaxwareDto) {
        if (this.callbackEnabled) {
            boolean result = this.companyService.handleTaxwareMessage(companyTaxwareDto);
            return ResponseEntity.ok((Object)result);
        }
        logger.warn("callback not enabled would not handle this request");
        return ResponseEntity.ok((Object)true);
    }

    public ResponseEntity<String> removeTenant(Long companyId, Long tenantId) {
        this.companyProcess.removeTenant(companyId, tenantId);
        return ResponseEntity.ok();
    }
}

