/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.company.CompanyHistoryApi;
import com.xforceplus.business.company.service.CompanyHistoryService;
import com.xforceplus.domain.company.CompanyHisDTO;
import com.xforceplus.entity.Company;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="\u516c\u53f8\u5c65\u5386\u63a5\u53e3")
public class CompanyHistoryController
implements CompanyHistoryApi {
    private final CompanyHistoryService companyHisService;

    public CompanyHistoryController(CompanyHistoryService companyHisService) {
        this.companyHisService = companyHisService;
    }

    @ApiOperation(value="\u6839\u636e\u516c\u53f8\u5c65\u5386\u7684\u7a0e\u53f7\u67e5\u8be2\u5f53\u524d\u516c\u53f8\u4fe1\u606f", notes="\u6839\u636e\u516c\u53f8\u5c65\u5386\u7684\u7a0e\u53f7\u67e5\u8be2\u5f53\u524d\u516c\u53f8\u4fe1\u606f")
    public ResponseEntity<Company> get(String taxNum) {
        Optional<Company> optionalCompany = this.companyHisService.findByHisTaxNum(taxNum);
        return optionalCompany.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.fail((String)"0", (String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u6570\u636e"));
    }

    @ApiOperation(value="\u6839\u636e\u516c\u53f8\u7a0e\u53f7\u67e5\u8be2\u516c\u53f8\u516c\u53f8\u5c65\u5386\u5217\u8868", notes="\u6839\u636e\u516c\u53f8\u7a0e\u53f7\u67e5\u8be2\u516c\u53f8\u516c\u53f8\u5c65\u5386\u5217\u8868")
    public ResponseEntity<Page<CompanyHisDTO>> hisPage(String taxNum, Pageable pageable) {
        Page<CompanyHisDTO> companyHisDTOS = this.companyHisService.pageHistory(taxNum, pageable);
        return ResponseEntity.ok(companyHisDTOS);
    }
}

